/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.output.SDMSOutputContainer;
import de.independit.scheduler.server.parser.FolderLister;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.parser.SeSeFormatter;
import de.independit.scheduler.server.parser.ShowCommented;
import de.independit.scheduler.server.repository.SDMSEnvironment;
import de.independit.scheduler.server.repository.SDMSEnvironmentTable;
import de.independit.scheduler.server.repository.SDMSFolder;
import de.independit.scheduler.server.repository.SDMSFolderProxyGeneric;
import de.independit.scheduler.server.repository.SDMSFolderTable;
import de.independit.scheduler.server.repository.SDMSNamedEnvironment;
import de.independit.scheduler.server.repository.SDMSNamedResource;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityProxyGeneric;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.repository.SDMSUserTable;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Vector;

public class ShowEnvironment
extends ShowCommented {
    public static final String __version = "@(#) $Id: ShowEnvironment.java,v 2.13.2.2 2013/06/18 09:49:35 ronald Exp $";
    private ObjectURL url;
    private HashSet expandIds;

    public ShowEnvironment(ObjectURL objectURL, HashSet hashSet) {
        this.url = objectURL;
        this.expandIds = hashSet;
        this.txMode = 1;
        this.auditFlag = false;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSOutputContainer sDMSOutputContainer = null;
        Vector<String> vector = new Vector<String>();
        SDMSNamedEnvironment sDMSNamedEnvironment = (SDMSNamedEnvironment)this.url.resolve(systemEnvironment);
        if (!sDMSNamedEnvironment.checkPrivileges(systemEnvironment, 0x10000000L)) {
            throw new AccessViolationException(new SDMSMessage(systemEnvironment, "03402041659", "Insufficient privileges"));
        }
        Long l = sDMSNamedEnvironment.getId(systemEnvironment);
        vector.add("ID");
        vector.add("NAME");
        vector.add("COMMENT");
        vector.add("COMMENTTYPE");
        vector.add("CREATOR");
        vector.add("CREATE_TIME");
        vector.add("CHANGER");
        vector.add("CHANGE_TIME");
        vector.add("PRIVS");
        vector.add("RESOURCES");
        vector.add("JOB_DEFINITIONS");
        Vector<Object> vector2 = new Vector<Object>();
        vector2.add(l);
        vector2.add(sDMSNamedEnvironment.getName(systemEnvironment));
        vector2.add(this.getCommentContainer(systemEnvironment, l));
        vector2.add(this.getCommentInfoType(systemEnvironment, l));
        Date date = new Date();
        try {
            vector2.add(SDMSUserTable.getObject(systemEnvironment, sDMSNamedEnvironment.getCreatorUId(systemEnvironment)).getName(systemEnvironment));
        }
        catch (NotFoundException notFoundException) {
            vector2.add("unknown");
        }
        date.setTime(sDMSNamedEnvironment.getCreateTs(systemEnvironment));
        vector2.add(systemEnvironment.systemDateFormat.format(date));
        try {
            vector2.add(SDMSUserTable.getObject(systemEnvironment, sDMSNamedEnvironment.getChangerUId(systemEnvironment)).getName(systemEnvironment));
        }
        catch (NotFoundException notFoundException) {
            vector2.add("unknown");
        }
        date.setTime(sDMSNamedEnvironment.getChangeTs(systemEnvironment));
        vector2.add(systemEnvironment.systemDateFormat.format(date));
        vector2.add(sDMSNamedEnvironment.getPrivileges(systemEnvironment).toString());
        Vector<String> vector3 = new Vector<String>();
        vector3.add("ID");
        vector3.add("NR_NAME");
        vector3.add("CONDITION");
        vector3.add("PRIVS");
        SDMSOutputContainer sDMSOutputContainer2 = new SDMSOutputContainer(systemEnvironment, null, vector3);
        Vector vector4 = SDMSEnvironmentTable.idx_neId.getVector(systemEnvironment, l);
        for (int i = 0; i < vector4.size(); ++i) {
            SDMSEnvironment sDMSEnvironment = (SDMSEnvironment)vector4.get(i);
            SDMSNamedResource sDMSNamedResource = SDMSNamedResourceTable.getObject(systemEnvironment, sDMSEnvironment.getNrId(systemEnvironment));
            Vector<Object> vector5 = new Vector<Object>();
            vector5.add(sDMSNamedResource.getId(systemEnvironment));
            vector5.add(sDMSNamedResource.pathVector(systemEnvironment));
            vector5.add(sDMSEnvironment.getCondition(systemEnvironment));
            vector5.add(sDMSNamedResource.getPrivileges(systemEnvironment).toString());
            sDMSOutputContainer2.addData(systemEnvironment, vector5);
        }
        Collections.sort(sDMSOutputContainer2.dataset, sDMSOutputContainer2.getComparator(systemEnvironment, 1));
        vector2.add(sDMSOutputContainer2);
        vector2.add(this.jobDefContainer(systemEnvironment, l));
        sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, "Environment", vector, vector2);
        this.result.setOutputContainer(sDMSOutputContainer);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03201232124", "Environment shown"));
    }

    private SDMSOutputContainer jobDefContainer(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        SDMSProxy sDMSProxy;
        int n;
        FolderLister folderLister = new FolderLister(null, this.expandIds);
        folderLister.setTitle(null);
        folderLister.setFormatter(new SeSeFormatter(l));
        int[] nArray = new int[]{1};
        folderLister.setSortColumns(nArray);
        Vector vector = SDMSSchedulingEntityTable.idx_neId.getVector(systemEnvironment, l);
        Vector vector2 = SDMSFolderTable.idx_envId.getVector(systemEnvironment, l);
        Vector<SDMSProxy> vector3 = new Vector<SDMSProxy>();
        for (n = 0; n < vector.size(); ++n) {
            sDMSProxy = (SDMSSchedulingEntity)vector.get(n);
            if (!((SDMSSchedulingEntityProxyGeneric)sDMSProxy).checkPrivileges(systemEnvironment, 0x10000000L)) continue;
            vector3.add(sDMSProxy);
        }
        for (n = 0; n < vector2.size(); ++n) {
            sDMSProxy = (SDMSFolder)vector2.get(n);
            if (!((SDMSFolderProxyGeneric)sDMSProxy).checkPrivileges(systemEnvironment, 0x10000000L)) continue;
            vector3.add(sDMSProxy);
        }
        folderLister.setObjectsToList(vector3);
        SDMSOutputContainer sDMSOutputContainer = folderLister.list(systemEnvironment);
        return sDMSOutputContainer;
    }
}

