/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSParameterDefinition;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSResource;
import de.independit.scheduler.server.repository.SDMSResourceAllocation;
import de.independit.scheduler.server.repository.SDMSResourceAllocationTable;
import de.independit.scheduler.server.repository.SDMSResourceStateDefinition;
import de.independit.scheduler.server.repository.SDMSResourceStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSResourceTable;
import de.independit.scheduler.server.repository.SDMSResourceVariable;
import de.independit.scheduler.server.repository.SDMSResourceVariableTable;
import de.independit.scheduler.server.repository.SDMSScope;
import de.independit.scheduler.server.repository.SDMSSubmittedEntity;
import de.independit.scheduler.server.repository.VariableResolver;
import java.util.HashSet;
import java.util.Stack;
import java.util.Vector;

public class ResourceVariableResolver
extends VariableResolver {
    public static final String __version = "@(#) $Id: ResourceVariableResolver.java,v 2.7.4.1 2013/03/14 10:25:17 ronald Exp $";
    public static final String S_STATE = "STATE";
    public static final String S_AMOUNT = "AMOUNT";
    public static final String S_FREE_AMOUNT = "FREE_AMOUNT";
    public static final String S_REQUESTABLE_AMOUNT = "REQUESTABLE_AMOUNT";
    public static final String S_REQUESTED_AMOUNT = "REQUESTED_AMOUNT";
    public static final String S_TIMESTAMP = "TIMESTAMP";
    private static final HashSet internalVars = new HashSet();
    private SDMSSubmittedEntity sme = null;

    @Override
    protected String getVariableValue(SystemEnvironment systemEnvironment, SDMSProxy sDMSProxy, String string, boolean bl, String string2, boolean bl2, long l, SDMSScope sDMSScope, boolean bl3) throws SDMSException {
        this.sme = null;
        String string3 = this.getInternalVariableValue(systemEnvironment, (SDMSResource)sDMSProxy, string, bl, string2, bl2, new Stack(), l, null, bl3);
        return string3;
    }

    @Override
    protected String getVariableValue(SystemEnvironment systemEnvironment, SDMSProxy sDMSProxy, String string, boolean bl, String string2, boolean bl2, long l, SDMSScope sDMSScope, SDMSSubmittedEntity sDMSSubmittedEntity, boolean bl3) throws SDMSException {
        this.sme = sDMSSubmittedEntity;
        String string3 = this.getInternalVariableValue(systemEnvironment, (SDMSResource)sDMSProxy, string, bl, string2, bl2, new Stack(), l, null, bl3);
        return string3;
    }

    protected String getStandardVariable(SystemEnvironment systemEnvironment, SDMSResource sDMSResource, String string) throws SDMSException {
        String string2 = "";
        if (string.equals(S_STATE)) {
            Long l = sDMSResource.getRsdId(systemEnvironment);
            if (l == null) {
                return string2;
            }
            SDMSResourceStateDefinition sDMSResourceStateDefinition = SDMSResourceStateDefinitionTable.getObject(systemEnvironment, sDMSResource.getRsdId(systemEnvironment));
            string2 = sDMSResourceStateDefinition.getName(systemEnvironment);
        } else if (string.equals(S_AMOUNT)) {
            Integer n = sDMSResource.getAmount(systemEnvironment);
            string2 = n == null ? "" : n.toString();
        } else if (string.equals(S_FREE_AMOUNT)) {
            Integer n = sDMSResource.getFreeAmount(systemEnvironment);
            string2 = n == null ? "" : n.toString();
        } else if (string.equals(S_REQUESTABLE_AMOUNT)) {
            Integer n = sDMSResource.getRequestableAmount(systemEnvironment);
            string2 = n == null ? "" : n.toString();
        } else if (string.equals(S_REQUESTED_AMOUNT)) {
            Vector vector;
            Integer n = null;
            if (this.sme != null && (vector = SDMSResourceAllocationTable.idx_smeId_nrId.getVector(systemEnvironment, new SDMSKey(this.sme.getId(systemEnvironment), sDMSResource.getNrId(systemEnvironment)))).size() > 0) {
                SDMSResourceAllocation sDMSResourceAllocation = (SDMSResourceAllocation)vector.get(0);
                n = sDMSResourceAllocation.getAmount(systemEnvironment);
            }
            string2 = n == null ? "" : n.toString();
        } else if (string.equals(S_TIMESTAMP)) {
            Long l = sDMSResource.getRsdTime(systemEnvironment);
            string2 = l == null ? "" : "" + l / 1000L;
        }
        return string2;
    }

    @Override
    protected String getInternalVariableValue(SystemEnvironment systemEnvironment, SDMSProxy sDMSProxy, String string, boolean bl, String string2, boolean bl2, Stack stack, long l, SDMSScope sDMSScope, boolean bl3) throws SDMSException {
        String string3;
        SDMSResource sDMSResource = (SDMSResource)sDMSProxy;
        Long l2 = sDMSResource.getLinkId(systemEnvironment);
        while (l2 != null) {
            sDMSResource = SDMSResourceTable.getObject(systemEnvironment, l2);
            l2 = sDMSResource.getLinkId(systemEnvironment);
        }
        Long l3 = sDMSResource.getId(systemEnvironment);
        if (internalVars.contains(string)) {
            return this.getStandardVariable(systemEnvironment, sDMSResource, string);
        }
        SDMSParameterDefinition sDMSParameterDefinition = sDMSResource.getParameterDefinition(systemEnvironment, string);
        Long l4 = sDMSParameterDefinition.getId(systemEnvironment);
        String string4 = sDMSParameterDefinition.getDefaultValue(systemEnvironment);
        string4 = string4 != null ? string4.substring(1) : new String("");
        if (sDMSParameterDefinition.getType(systemEnvironment) == 30) {
            string3 = string4;
        } else {
            try {
                SDMSResourceVariable sDMSResourceVariable = SDMSResourceVariableTable.idx_pdId_rId_getUnique(systemEnvironment, new SDMSKey(l4, l3));
                string3 = sDMSResourceVariable.getValue(systemEnvironment).substring(1);
            }
            catch (NotFoundException notFoundException) {
                string3 = string4;
            }
        }
        if (bl3) {
            return this.parseAndSubstitute(systemEnvironment, sDMSResource, string, string3, bl, string2, bl2, stack, l);
        }
        return string3;
    }

    static {
        internalVars.add(S_STATE);
        internalVars.add(S_AMOUNT);
        internalVars.add(S_FREE_AMOUNT);
        internalVars.add(S_REQUESTABLE_AMOUNT);
        internalVars.add(S_REQUESTED_AMOUNT);
        internalVars.add(S_TIMESTAMP);
    }
}

