/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.exception.SDMSSQLException;
import de.independit.scheduler.server.repository.SDMSCalendar;
import de.independit.scheduler.server.repository.SDMSCalendarTableGeneric;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class SDMSCalendarGeneric
extends SDMSObject
implements Cloneable {
    public static final int nr_id = 1;
    public static final int nr_scevId = 2;
    public static final int nr_starttime = 3;
    public static final int nr_creatorUId = 4;
    public static final int nr_createTs = 5;
    public static final int nr_changerUId = 6;
    public static final int nr_changeTs = 7;
    public static String tableName = "CALENDAR";
    protected Long scevId;
    protected Long starttime;
    protected Long creatorUId;
    protected Long createTs;
    protected Long changerUId;
    protected Long changeTs;
    private static PreparedStatement[] pUpdate = new PreparedStatement[128];
    private static PreparedStatement[] pDelete = new PreparedStatement[128];
    private static PreparedStatement[] pInsert = new PreparedStatement[128];

    public SDMSCalendarGeneric(SystemEnvironment systemEnvironment, Long l, Long l2, Long l3, Long l4, Long l5, Long l6) throws SDMSException {
        super(systemEnvironment, SDMSCalendarTableGeneric.table);
        this.scevId = l;
        this.starttime = l2;
        this.creatorUId = l3;
        this.createTs = l4;
        this.changerUId = l5;
        this.changeTs = l6;
    }

    public Long getScevId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.scevId;
    }

    public void setScevId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.scevId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Calendar) Change of system object not allowed"));
            }
            SDMSCalendarGeneric sDMSCalendarGeneric = (SDMSCalendarGeneric)this.change(systemEnvironment);
            sDMSCalendarGeneric.scevId = l;
            sDMSCalendarGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSCalendarGeneric.changeTs = systemEnvironment.txTime();
            sDMSCalendarGeneric.versions.table.index(systemEnvironment, sDMSCalendarGeneric, 3L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getStarttime(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.starttime;
    }

    public void setStarttime(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.starttime.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Calendar) Change of system object not allowed"));
            }
            SDMSCalendarGeneric sDMSCalendarGeneric = (SDMSCalendarGeneric)this.change(systemEnvironment);
            sDMSCalendarGeneric.starttime = l;
            sDMSCalendarGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSCalendarGeneric.changeTs = systemEnvironment.txTime();
            sDMSCalendarGeneric.versions.table.index(systemEnvironment, sDMSCalendarGeneric, 2L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getCreatorUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.creatorUId;
    }

    void setCreatorUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.creatorUId.equals(l)) {
            return;
        }
        SDMSCalendarGeneric sDMSCalendarGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Calendar) Change of system object not allowed"));
        }
        if (sDMSCalendarGeneric.versions.o_v == null || sDMSCalendarGeneric.versions.o_v.size() == 0 || sDMSCalendarGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSCalendarGeneric = (SDMSCalendarGeneric)this.change(systemEnvironment);
        }
        sDMSCalendarGeneric.creatorUId = l;
        sDMSCalendarGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSCalendarGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSCalendarGeneric != this) {
            sDMSCalendarGeneric.versions.table.index(systemEnvironment, sDMSCalendarGeneric, 0L);
        }
    }

    public Long getCreateTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.createTs;
    }

    void setCreateTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.createTs.equals(l)) {
            return;
        }
        SDMSCalendarGeneric sDMSCalendarGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Calendar) Change of system object not allowed"));
        }
        if (sDMSCalendarGeneric.versions.o_v == null || sDMSCalendarGeneric.versions.o_v.size() == 0 || sDMSCalendarGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSCalendarGeneric = (SDMSCalendarGeneric)this.change(systemEnvironment);
        }
        sDMSCalendarGeneric.createTs = l;
        sDMSCalendarGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSCalendarGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSCalendarGeneric != this) {
            sDMSCalendarGeneric.versions.table.index(systemEnvironment, sDMSCalendarGeneric, 0L);
        }
    }

    public Long getChangerUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changerUId;
    }

    public void setChangerUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        SDMSCalendarGeneric sDMSCalendarGeneric = this;
        if (sDMSCalendarGeneric.versions.o_v == null || sDMSCalendarGeneric.versions.o_v.size() == 0 || sDMSCalendarGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSCalendarGeneric = (SDMSCalendarGeneric)this.change(systemEnvironment);
        }
        sDMSCalendarGeneric.changerUId = l;
        sDMSCalendarGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSCalendarGeneric != this) {
            sDMSCalendarGeneric.versions.table.index(systemEnvironment, sDMSCalendarGeneric, 0L);
        }
    }

    public Long getChangeTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changeTs;
    }

    void setChangeTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.changeTs.equals(l)) {
            return;
        }
        SDMSCalendarGeneric sDMSCalendarGeneric = this;
        if (sDMSCalendarGeneric.versions.o_v == null || sDMSCalendarGeneric.versions.o_v.size() == 0 || sDMSCalendarGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSCalendarGeneric = (SDMSCalendarGeneric)this.change(systemEnvironment);
        }
        sDMSCalendarGeneric.changeTs = l;
        sDMSCalendarGeneric.changerUId = systemEnvironment.cEnv.uid();
        if (sDMSCalendarGeneric != this) {
            sDMSCalendarGeneric.versions.table.index(systemEnvironment, sDMSCalendarGeneric, 0L);
        }
    }

    public SDMSCalendarGeneric set_ScevIdStarttime(SystemEnvironment systemEnvironment, Long l, Long l2) throws SDMSException {
        SDMSCalendarGeneric sDMSCalendarGeneric;
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141637", "(Calendar) Change of system object not allowed"));
            }
            sDMSCalendarGeneric = (SDMSCalendarGeneric)this.change(systemEnvironment);
            sDMSCalendarGeneric.scevId = l;
            sDMSCalendarGeneric.starttime = l2;
            sDMSCalendarGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSCalendarGeneric.changeTs = systemEnvironment.txTime();
            sDMSCalendarGeneric.versions.table.index(systemEnvironment, sDMSCalendarGeneric);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        return sDMSCalendarGeneric;
    }

    @Override
    protected SDMSProxy toProxy(SystemEnvironment systemEnvironment) {
        return new SDMSCalendar(this);
    }

    protected SDMSCalendarGeneric(Long l, Long l2, Long l3, Long l4, Long l5, Long l6, Long l7, long l8, long l9) {
        this.id = l;
        this.scevId = l2;
        this.starttime = l3;
        this.creatorUId = l4;
        this.createTs = l5;
        this.changerUId = l6;
        this.changeTs = l7;
        this.validFrom = l8;
        this.validTo = l9;
    }

    protected String tableName() {
        return tableName;
    }

    @Override
    protected void insertDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pInsert[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "INSERT INTO " + string2 + "CALENDAR" + string3 + " (ID, " + string2 + "SCEV_ID" + string3 + ", " + string2 + "STARTTIME" + string3 + ", " + string2 + "CREATOR_U_ID" + string3 + ", " + string2 + "CREATE_TS" + string3 + ", " + string2 + "CHANGER_U_ID" + string3 + ", " + string2 + "CHANGE_TS" + string3 + ") VALUES (?, ?, ?, ?, ?, ?, ?)";
                SDMSCalendarGeneric.pInsert[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110181952", "Calendar: $1\n$2", string, sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pInsert[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.setLong(2, this.scevId);
            preparedStatement.setLong(3, this.starttime);
            preparedStatement.setLong(4, this.creatorUId);
            preparedStatement.setLong(5, this.createTs);
            preparedStatement.setLong(6, this.changerUId);
            preparedStatement.setLong(7, this.changeTs);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110181954", "Calendar: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
    }

    @Override
    protected void deleteDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pDelete[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "DELETE FROM " + string2 + "CALENDAR" + string3 + " WHERE ID = ?";
                SDMSCalendarGeneric.pDelete[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110182001", "Calendar: $1\n$2", string, sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pDelete[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110182002", "Calendar: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
    }

    @Override
    protected void updateDBObject(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        if (pUpdate[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "UPDATE " + string2 + "CALENDAR" + string3 + " SET " + string2 + "SCEV_ID" + string3 + " = ? , " + string2 + "STARTTIME" + string3 + " = ? , " + string2 + "CREATOR_U_ID" + string3 + " = ? , " + string2 + "CREATE_TS" + string3 + " = ? , " + string2 + "CHANGER_U_ID" + string3 + " = ? , " + string2 + "CHANGE_TS" + string3 + " = ? WHERE ID = ?";
                SDMSCalendarGeneric.pUpdate[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110182005", "Calendar: $1\n$2", string, sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pUpdate[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.scevId);
            preparedStatement.setLong(2, this.starttime);
            preparedStatement.setLong(3, this.creatorUId);
            preparedStatement.setLong(4, this.createTs);
            preparedStatement.setLong(5, this.changerUId);
            preparedStatement.setLong(6, this.changeTs);
            preparedStatement.setLong(7, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110182006", "Calendar: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
    }

    @Override
    public void print() {
        SDMSThread.doTrace(null, "Type : Calendar", 2);
        SDMSThread.doTrace(null, "id : " + this.id, 2);
        SDMSThread.doTrace(null, "scevId : " + this.scevId, 2);
        SDMSThread.doTrace(null, "starttime : " + this.starttime, 2);
        SDMSThread.doTrace(null, "creatorUId : " + this.creatorUId, 2);
        SDMSThread.doTrace(null, "createTs : " + this.createTs, 2);
        SDMSThread.doTrace(null, "changerUId : " + this.changerUId, 2);
        SDMSThread.doTrace(null, "changeTs : " + this.changeTs, 2);
        SDMSThread.doTrace(null, "validFrom : " + this.validFrom, 2);
        SDMSThread.doTrace(null, "validTo : " + this.validTo, 2);
        this.dumpVersions(2);
    }

    @Override
    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer(n + 1);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        String string = new String(stringBuffer);
        String string2 = string + "id : " + this.id + "\n" + string + "scevId     : " + this.scevId + "\n" + string + "starttime  : " + this.starttime + "\n" + string + "creatorUId : " + this.creatorUId + "\n" + string + "createTs   : " + this.createTs + "\n" + string + "changerUId : " + this.changerUId + "\n" + string + "changeTs   : " + this.changeTs + "\n" + string + "validFrom : " + this.validFrom + "\n" + string + "validTo : " + this.validTo + "\n";
        return string2;
    }

    public String toString() {
        String string = this.toString(0);
        return string;
    }
}

