/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.DuplicateKeyException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.exception.SerializationException;
import de.independit.scheduler.server.locking.LockingSystem;
import de.independit.scheduler.server.repository.ObjectIdComparator;
import de.independit.scheduler.server.repository.SDMSIndexBucket;
import de.independit.scheduler.server.repository.SDMSIndexMap;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSProxyComparator;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.repository.SDMSVersions;
import de.independit.scheduler.server.util.SDMSFilter;
import de.independit.scheduler.server.util.SDMSThread;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class SDMSIndex {
    public static final String __version = "@(#) $Id: SDMSIndex.java,v 2.7.2.3 2013/06/07 18:48:36 dieter Exp $";
    public static final int ORDINARY = 0;
    public static final int UNIQUE = 1;
    public static final int IDUNIQUE = 3;
    private SDMSIndexMap hashMap;
    private int type;
    private boolean isVersioned;
    public SDMSTable table;
    public String indexName;
    private static final Comparator objectIdComparator = new ObjectIdComparator();

    public SDMSIndex(SystemEnvironment systemEnvironment, int n, boolean bl, SDMSTable sDMSTable, String string) throws SDMSException {
        if (n != 0 && n != 1 && n != 3) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "03110181526", "Invalid Indextype $1", n));
        }
        this.table = sDMSTable;
        this.indexName = string;
        this.hashMap = new SDMSIndexMap(this);
        this.type = n;
        this.isVersioned = bl;
    }

    public void put(SystemEnvironment systemEnvironment, Object object, SDMSObject sDMSObject) throws SDMSException {
        this.put(systemEnvironment, object, sDMSObject, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void put(SystemEnvironment systemEnvironment, Object object, SDMSObject sDMSObject, boolean bl) throws SDMSException {
        Object object2;
        Object[] objectArray = null;
        SDMSIndexMap sDMSIndexMap = this.hashMap;
        // MONITORENTER : sDMSIndexMap
        objectArray = (Object[])this.hashMap.get(object);
        if (objectArray == null) {
            objectArray = new SDMSIndexBucket(this, object);
            object2 = objectArray;
            // MONITORENTER : objectArray
            ++objectArray.modCnt;
            // MONITOREXIT : object2
            this.hashMap.put(object, objectArray);
        } else {
            object2 = objectArray;
            // MONITORENTER : objectArray
            ++objectArray.modCnt;
            // MONITOREXIT : object2
        }
        // MONITOREXIT : sDMSIndexMap
        if (SystemEnvironment.maxWriter > 1 && bl) {
            try {
                LockingSystem.lock(systemEnvironment, objectArray, 1);
            }
            catch (Exception exception) {
                object2 = objectArray;
                // MONITORENTER : objectArray
                --objectArray.modCnt;
                // MONITOREXIT : object2
                throw exception;
            }
        }
        boolean bl2 = false;
        object2 = objectArray;
        // MONITORENTER : objectArray
        if (objectArray.size() == 0) {
            objectArray.add(sDMSObject);
            --objectArray.modCnt;
            bl2 = true;
        }
        // MONITOREXIT : object2
        if (bl2) {
            if (SystemEnvironment.maxWriter <= 1) return;
            LockingSystem.release(systemEnvironment, objectArray);
            return;
        }
        if (bl && (this.type & 1) > 0) {
            object2 = null;
            if (SystemEnvironment.maxWriter > 1) {
                object2 = (SDMSThread)Thread.currentThread();
                if (((SDMSThread)object2).lockThread != null) {
                    object2 = ((SDMSThread)object2).lockThread;
                }
            }
            long l = systemEnvironment.newLockCp();
            Object object3 = objectArray;
            // MONITORENTER : objectArray
            Object[] objectArray2 = objectArray.toArray();
            // MONITOREXIT : object3
            object3 = new HashSet();
            for (int i = 0; i < objectArray2.length; ++i) {
                Object[] objectArray3;
                SDMSObject sDMSObject2 = (SDMSObject)objectArray2[i];
                SDMSVersions sDMSVersions = sDMSObject2.versions;
                if (SystemEnvironment.maxWriter > 1) {
                    LockingSystem.lock(systemEnvironment, sDMSVersions, ((SDMSThread)Thread.currentThread()).readLock);
                }
                if (!sDMSObject2.isCurrent) {
                    if (SystemEnvironment.maxWriter > 1 && (sDMSObject2 = sDMSVersions.getRaw(systemEnvironment, true)) != null) {
                        objectArray3 = objectArray;
                        // MONITORENTER : objectArray
                        if (!objectArray.contains(sDMSObject2)) {
                            sDMSObject2 = null;
                        }
                        // MONITOREXIT : objectArray3
                    }
                }
                if (sDMSObject2 != null && sDMSObject2.isCurrent && sDMSObject.isCurrent) {
                    objectArray3 = objectArray;
                    // MONITORENTER : objectArray
                    --objectArray.modCnt;
                    // MONITOREXIT : objectArray3
                    throw new DuplicateKeyException(new SDMSMessage(systemEnvironment, "03110181528", "Duplicate Key $1: Second object exists", object));
                }
                if (SystemEnvironment.maxWriter > 1) {
                    LockingSystem.releaseToCheckPoint(systemEnvironment, sDMSVersions, l);
                }
                if (sDMSObject2 == null || sDMSObject.validFrom >= sDMSObject2.validTo || sDMSObject2.validFrom >= sDMSObject.validTo) continue;
                objectArray3 = new Object[]{object, sDMSObject2.id, sDMSObject2.validFrom, sDMSObject2.validTo, sDMSObject.id, sDMSObject.validFrom, sDMSObject.validTo};
                --objectArray.modCnt;
                throw new FatalException(new SDMSMessage(systemEnvironment, "03110181529", "Duplicate Key $1: Overlapping versionrange with same id: o[$2:$3,$4], old[$5:$6,$7]", objectArray3));
            }
        }
        object2 = objectArray;
        // MONITORENTER : objectArray
        objectArray.add(sDMSObject);
        --objectArray.modCnt;
        // MONITOREXIT : object2
        if (SystemEnvironment.maxWriter <= 1) return;
        if (!bl) return;
        LockingSystem.release(systemEnvironment, objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(SystemEnvironment systemEnvironment, Object object, SDMSObject sDMSObject) throws SDMSException {
        boolean bl = false;
        SDMSIndexMap sDMSIndexMap = this.hashMap;
        synchronized (sDMSIndexMap) {
            SDMSIndexBucket sDMSIndexBucket = (SDMSIndexBucket)this.hashMap.get(object);
            if (sDMSIndexBucket == null) {
                return false;
            }
            SDMSIndexBucket sDMSIndexBucket2 = sDMSIndexBucket;
            synchronized (sDMSIndexBucket2) {
                bl = sDMSIndexBucket.remove(sDMSObject);
                if (sDMSIndexBucket.size() == 0 && sDMSIndexBucket.modCnt == 0) {
                    this.hashMap.remove(object);
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean check(Object object, SDMSObject sDMSObject) {
        SDMSIndexBucket sDMSIndexBucket = (SDMSIndexBucket)this.hashMap.get(object);
        if (sDMSIndexBucket == null) {
            return false;
        }
        SDMSIndexBucket sDMSIndexBucket2 = sDMSIndexBucket;
        synchronized (sDMSIndexBucket2) {
            return sDMSIndexBucket.contains(sDMSObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SDMSIndexBucket getOrCreateBucket(SystemEnvironment systemEnvironment, Object object, int n) throws SerializationException {
        SDMSIndexBucket sDMSIndexBucket;
        SDMSIndexMap sDMSIndexMap = this.hashMap;
        synchronized (sDMSIndexMap) {
            sDMSIndexBucket = (SDMSIndexBucket)this.hashMap.get(object);
            if (SystemEnvironment.maxWriter > 1 && systemEnvironment.tx.mode == 2 && sDMSIndexBucket == null) {
                sDMSIndexBucket = new SDMSIndexBucket(this, object);
                this.hashMap.put(object, sDMSIndexBucket);
            }
        }
        if (sDMSIndexBucket != null) {
            if (SystemEnvironment.maxWriter > 1 && systemEnvironment.tx.mode == 2) {
                LockingSystem.lock(systemEnvironment, sDMSIndexBucket, n);
            }
        }
        return sDMSIndexBucket;
    }

    public boolean containsKeyForUpdate(SystemEnvironment systemEnvironment, Object object) throws SerializationException, SDMSException {
        systemEnvironment.thread.readLock = 1;
        return this.containsKey(systemEnvironment, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(SystemEnvironment systemEnvironment, Object object) throws SerializationException, SDMSException {
        int n = systemEnvironment.thread.readLock;
        systemEnvironment.thread.readLock = 0;
        SDMSIndexBucket sDMSIndexBucket = this.getOrCreateBucket(systemEnvironment, object, n);
        if (sDMSIndexBucket == null || sDMSIndexBucket.size() == 0) {
            return false;
        }
        if (systemEnvironment.tx.mode == 2) {
            Object[] objectArray;
            long l = systemEnvironment.newLockCp();
            Object object2 = sDMSIndexBucket;
            synchronized (object2) {
                objectArray = sDMSIndexBucket.toArray();
            }
            object2 = new HashSet();
            for (int i = 0; i < objectArray.length; ++i) {
                SDMSObject sDMSObject = (SDMSObject)objectArray[i];
                SDMSVersions sDMSVersions = sDMSObject.versions;
                if (((HashSet)object2).contains(sDMSVersions)) continue;
                ((HashSet)object2).add(sDMSVersions);
                if (SystemEnvironment.maxWriter > 1) {
                    LockingSystem.lock(systemEnvironment, sDMSVersions, n);
                }
                if (!sDMSObject.isCurrent && (sDMSObject = sDMSVersions.getRaw(systemEnvironment, true)) != null) {
                    SDMSIndexBucket sDMSIndexBucket2 = sDMSIndexBucket;
                    synchronized (sDMSIndexBucket2) {
                        if (!sDMSIndexBucket.contains(sDMSObject)) {
                            sDMSObject = null;
                        }
                    }
                }
                if (sDMSObject == null) {
                    if (SystemEnvironment.maxWriter <= 1) continue;
                    LockingSystem.releaseToCheckPoint(systemEnvironment, sDMSVersions, l);
                    continue;
                }
                return true;
            }
            return false;
        }
        return this.containsKey(systemEnvironment, object, systemEnvironment.tx.versionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(SystemEnvironment systemEnvironment, Object object, long l) {
        SDMSIndexBucket sDMSIndexBucket;
        Object object2 = this.hashMap;
        synchronized (object2) {
            sDMSIndexBucket = (SDMSIndexBucket)this.hashMap.get(object);
        }
        if (sDMSIndexBucket == null) {
            return false;
        }
        object2 = sDMSIndexBucket;
        synchronized (object2) {
            Iterator iterator = sDMSIndexBucket.iterator();
            block6: while (iterator.hasNext()) {
                SDMSObject sDMSObject = (SDMSObject)iterator.next();
                if (sDMSObject.validFrom > l || l >= sDMSObject.validTo) continue;
                if (SystemEnvironment.maxWriter > 1 && systemEnvironment.tx.mode == 1) {
                    for (int i = 0; i < systemEnvironment.tx.commitingTx.length; ++i) {
                        if (systemEnvironment.tx.commitingTx[i] > sDMSObject.validFrom) {
                            return true;
                        }
                        if (systemEnvironment.tx.commitingTx[i] == sDMSObject.validFrom) continue block6;
                    }
                    continue;
                }
                return true;
            }
        }
        return false;
    }

    public Vector getVector(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return this.getVector(systemEnvironment, object, null, 0);
    }

    public Vector getVectorForUpdate(SystemEnvironment systemEnvironment, Object object) throws SerializationException, SDMSException {
        systemEnvironment.thread.readLock = 1;
        return this.getVector(systemEnvironment, object, null, 0);
    }

    public Vector getVector(SystemEnvironment systemEnvironment, Object object, SDMSFilter sDMSFilter) throws SDMSException {
        return this.getVector(systemEnvironment, object, sDMSFilter, 0);
    }

    public Vector getVectorForUpdate(SystemEnvironment systemEnvironment, Object object, SDMSFilter sDMSFilter) throws SDMSException {
        systemEnvironment.thread.readLock = 1;
        return this.getVector(systemEnvironment, object, sDMSFilter, 0);
    }

    public Vector getVector(SystemEnvironment systemEnvironment, Object object, int n) throws SDMSException {
        return this.getVector(systemEnvironment, object, null, n);
    }

    public Vector getVectorForUpdate(SystemEnvironment systemEnvironment, Object object, int n) throws SDMSException {
        systemEnvironment.thread.readLock = 1;
        return this.getVector(systemEnvironment, object, null, n);
    }

    public Vector getVectorForUpdate(SystemEnvironment systemEnvironment, Object object, SDMSFilter sDMSFilter, int n) throws SDMSException {
        systemEnvironment.thread.readLock = 1;
        return this.getVector(systemEnvironment, object, sDMSFilter, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getVector(SystemEnvironment systemEnvironment, Object object, SDMSFilter sDMSFilter, int n) throws SDMSException {
        int n2 = systemEnvironment.thread.readLock;
        systemEnvironment.thread.readLock = 0;
        long l = systemEnvironment.newLockCp();
        Vector<SDMSProxy> vector = new Vector<SDMSProxy>();
        int n3 = 0;
        if (systemEnvironment.tx.mode == 2) {
            Object[] objectArray;
            SDMSIndexBucket sDMSIndexBucket = this.getOrCreateBucket(systemEnvironment, object, n2);
            if (sDMSIndexBucket == null || sDMSIndexBucket.size() == 0) {
                return vector;
            }
            SDMSIndexBucket sDMSIndexBucket2 = sDMSIndexBucket;
            synchronized (sDMSIndexBucket2) {
                objectArray = sDMSIndexBucket.toArray();
            }
            if (SystemEnvironment.maxWriter > 1) {
                Arrays.sort(objectArray, objectIdComparator);
            }
            sDMSIndexBucket2 = null;
            SDMSProxy sDMSProxy = null;
            HashSet<SDMSVersions> hashSet = new HashSet<SDMSVersions>();
            for (int i = 0; i < objectArray.length; ++i) {
                SDMSObject sDMSObject = (SDMSObject)objectArray[i];
                SDMSVersions sDMSVersions = sDMSObject.versions;
                if (hashSet.contains(sDMSVersions)) continue;
                hashSet.add(sDMSVersions);
                if (SystemEnvironment.maxWriter > 1) {
                    LockingSystem.lock(systemEnvironment, sDMSVersions, n2);
                }
                if (!sDMSObject.isCurrent && (sDMSObject = sDMSVersions.getRaw(systemEnvironment, true)) != null) {
                    SDMSIndexBucket sDMSIndexBucket3 = sDMSIndexBucket;
                    synchronized (sDMSIndexBucket3) {
                        if (!sDMSIndexBucket.contains(sDMSObject)) {
                            sDMSObject = null;
                        }
                    }
                }
                if (sDMSObject != null) {
                    if (sDMSProxy == null) {
                        sDMSProxy = sDMSObject.toProxy(systemEnvironment);
                        sDMSProxy.current = true;
                    } else {
                        sDMSProxy.object = sDMSObject;
                    }
                    if (sDMSFilter == null || sDMSFilter.isValid(systemEnvironment, sDMSProxy)) {
                        vector.add(sDMSProxy);
                        sDMSProxy = null;
                        if (n > 0 && ++n3 >= n) {
                            break;
                        }
                    } else {
                        sDMSObject = null;
                    }
                }
                if (sDMSObject != null) continue;
                if (SystemEnvironment.maxWriter <= 1) continue;
                LockingSystem.releaseToCheckPoint(systemEnvironment, sDMSVersions, l);
            }
            if (SystemEnvironment.maxWriter > 1) {
                LockingSystem.release(systemEnvironment, sDMSIndexBucket);
            }
            return vector;
        }
        return this.getVector(systemEnvironment, object, systemEnvironment.tx.versionId, sDMSFilter);
    }

    public Vector getSortedVectorForUpdate(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        Vector vector = this.getVectorForUpdate(systemEnvironment, object);
        Collections.sort(vector, new SDMSProxyComparator(systemEnvironment));
        return vector;
    }

    public Vector getSortedVector(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        Vector vector = this.getVector(systemEnvironment, object);
        Collections.sort(vector, new SDMSProxyComparator(systemEnvironment));
        return vector;
    }

    public Vector getVector(SystemEnvironment systemEnvironment, Object object, long l) throws SDMSException {
        return this.getVector(systemEnvironment, object, l, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector getVector(SystemEnvironment systemEnvironment, Object object, long l, SDMSFilter sDMSFilter) throws SDMSException {
        Object[] objectArray;
        SDMSIndexBucket sDMSIndexBucket;
        Vector<SDMSProxy> vector = new Vector<SDMSProxy>();
        Object object2 = this.hashMap;
        synchronized (object2) {
            sDMSIndexBucket = (SDMSIndexBucket)this.hashMap.get(object);
        }
        if (sDMSIndexBucket != null) {
            object2 = sDMSIndexBucket;
            synchronized (object2) {
                objectArray = sDMSIndexBucket.toArray();
            }
        } else {
            return vector;
        }
        SDMSProxy sDMSProxy = null;
        for (int i = 0; i < objectArray.length; ++i) {
            object2 = (SDMSObject)objectArray[i];
            if (((SDMSObject)object2).validFrom > l || l >= ((SDMSObject)object2).validTo) continue;
            if (SystemEnvironment.maxWriter > 1 && systemEnvironment.tx.mode == 1) {
                for (int j = 0; j < systemEnvironment.tx.commitingTx.length && systemEnvironment.tx.commitingTx[j] <= ((SDMSObject)object2).validFrom; ++j) {
                    if (systemEnvironment.tx.commitingTx[j] != ((SDMSObject)object2).validFrom) continue;
                    object2 = null;
                    break;
                }
            }
            if (object2 == null) continue;
            if (sDMSProxy == null) {
                sDMSProxy = ((SDMSObject)object2).toProxy(systemEnvironment);
            } else {
                sDMSProxy.object = object2;
            }
            if (sDMSFilter != null && !sDMSFilter.isValid(systemEnvironment, sDMSProxy)) continue;
            vector.add(sDMSProxy);
            sDMSProxy = null;
        }
        return vector;
    }

    public Vector getSortedVector(SystemEnvironment systemEnvironment, Object object, long l) throws SDMSException {
        Vector vector = this.getVector(systemEnvironment, object, l);
        Collections.sort(vector);
        return vector;
    }

    public SDMSProxy getUniqueForUpdate(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        systemEnvironment.thread.readLock = 1;
        return this.getUnique(systemEnvironment, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SDMSProxy getUnique(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        int n = systemEnvironment.thread.readLock;
        systemEnvironment.thread.readLock = 0;
        long l = systemEnvironment.newLockCp();
        if ((this.type & 1) == 0) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "03110181530", "Attempt to retrieve unique value from nonunique index"));
        }
        if (systemEnvironment.tx.mode == 2) {
            Object[] objectArray;
            SDMSIndexBucket sDMSIndexBucket = this.getOrCreateBucket(systemEnvironment, object, n);
            if (sDMSIndexBucket == null || sDMSIndexBucket.size() == 0) {
                throw new NotFoundException(new SDMSMessage(systemEnvironment, "03110181532", "$1 not found", object));
            }
            Object var9_6 = null;
            SDMSIndexBucket sDMSIndexBucket2 = sDMSIndexBucket;
            synchronized (sDMSIndexBucket2) {
                objectArray = sDMSIndexBucket.toArray();
            }
            for (int i = 0; i < objectArray.length; ++i) {
                SDMSObject sDMSObject = (SDMSObject)objectArray[i];
                SDMSVersions sDMSVersions = sDMSObject.versions;
                if (SystemEnvironment.maxWriter > 1) {
                    LockingSystem.lock(systemEnvironment, sDMSVersions, n);
                }
                if (!sDMSObject.isCurrent) {
                    if (SystemEnvironment.maxWriter > 1) {
                        sDMSObject = sDMSVersions.getRaw(systemEnvironment, true);
                        if (sDMSObject != null) {
                            SDMSIndexBucket sDMSIndexBucket3 = sDMSIndexBucket;
                            synchronized (sDMSIndexBucket3) {
                                if (!sDMSIndexBucket.contains(sDMSObject)) {
                                    sDMSObject = null;
                                }
                            }
                        }
                    } else {
                        sDMSObject = null;
                    }
                }
                if (sDMSObject == null) {
                    if (SystemEnvironment.maxWriter <= 1) continue;
                    LockingSystem.releaseToCheckPoint(systemEnvironment, sDMSVersions, l);
                    continue;
                }
                SDMSProxy sDMSProxy = sDMSObject.toProxy(systemEnvironment);
                sDMSProxy.current = true;
                return sDMSProxy;
            }
            throw new NotFoundException(new SDMSMessage(systemEnvironment, "03110181533", "$1 not found", object));
        }
        return this.getUnique(systemEnvironment, object, systemEnvironment.tx.versionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SDMSProxy getUnique(SystemEnvironment systemEnvironment, Object object, long l) throws SDMSException {
        SDMSIndexBucket sDMSIndexBucket;
        if ((this.type & 1) == 0) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "03110181531", "Attempt to retrieve unique value from nonunique index"));
        }
        Object object2 = this.hashMap;
        synchronized (object2) {
            sDMSIndexBucket = (SDMSIndexBucket)this.hashMap.get(object);
        }
        if (sDMSIndexBucket == null) {
            throw new NotFoundException(new SDMSMessage(systemEnvironment, "03201292040", "$1 not found", object));
        }
        object2 = sDMSIndexBucket;
        synchronized (object2) {
            Iterator iterator = sDMSIndexBucket.iterator();
            while (iterator.hasNext()) {
                SDMSObject sDMSObject = (SDMSObject)iterator.next();
                if (sDMSObject.validFrom > l || l >= sDMSObject.validTo) continue;
                if (SystemEnvironment.maxWriter > 1 && systemEnvironment.tx.mode == 1) {
                    for (int i = 0; i < systemEnvironment.tx.commitingTx.length && systemEnvironment.tx.commitingTx[i] <= sDMSObject.validFrom; ++i) {
                        if (systemEnvironment.tx.commitingTx[i] != sDMSObject.validFrom) continue;
                        sDMSObject = null;
                        break;
                    }
                }
                if (sDMSObject == null) continue;
                return sDMSObject.toProxy(systemEnvironment);
            }
        }
        throw new NotFoundException(new SDMSMessage(systemEnvironment, "03201292041", "$1 not found", object));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpIndex(SystemEnvironment systemEnvironment) {
        Object[] objectArray = this.hashMap;
        synchronized (this.hashMap) {
            Set set = this.hashMap.keySet();
            // ** MonitorExit[var3_2] (shouldn't be in output)
            String string = "";
            Set set2 = set;
            synchronized (set2) {
                Iterator iterator = set.iterator();
                objectArray = new String[set.size()];
                int n = 0;
                while (iterator.hasNext()) {
                    SDMSIndexBucket sDMSIndexBucket;
                    Object e = iterator.next();
                    Object object = this.hashMap;
                    synchronized (object) {
                        sDMSIndexBucket = (SDMSIndexBucket)this.hashMap.get(e);
                    }
                    objectArray[n] = e.toString() + ": ";
                    string = string + "$" + (n + 1) + "\n";
                    object = sDMSIndexBucket;
                    synchronized (object) {
                        Iterator iterator2 = sDMSIndexBucket.iterator();
                        while (iterator2.hasNext()) {
                            SDMSObject sDMSObject = (SDMSObject)iterator2.next();
                            objectArray[n] = (String)objectArray[n] + sDMSObject.id.toString() + "[" + sDMSObject.validFrom + "," + sDMSObject.validTo + "] ";
                        }
                    }
                    ++n;
                }
            }
            SDMSThread.doTrace(systemEnvironment.cEnv, "----------- Index Dump ------------", objectArray, 3);
            return;
        }
    }
}

