/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SDMSConstants;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.ManipParameters;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.repository.SDMSEnvironmentTable;
import de.independit.scheduler.server.repository.SDMSNamedResourceProxyGeneric;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSOwnedObject;
import de.independit.scheduler.server.repository.SDMSParameterDefinition;
import de.independit.scheduler.server.repository.SDMSParameterDefinitionTable;
import de.independit.scheduler.server.repository.SDMSPoolTable;
import de.independit.scheduler.server.repository.SDMSResourceRequirementTable;
import de.independit.scheduler.server.repository.SDMSResourceTable;
import de.independit.scheduler.server.repository.SDMSResourceTemplateTable;
import de.independit.scheduler.server.repository.SDMSResourceVariable;
import de.independit.scheduler.server.repository.SDMSResourceVariableTable;
import de.independit.scheduler.server.repository.SDMSTrigger;
import de.independit.scheduler.server.repository.SDMSTriggerTable;
import de.independit.scheduler.server.repository.SDMSUserTable;
import java.util.Set;
import java.util.Vector;

public class SDMSNamedResource
extends SDMSNamedResourceProxyGeneric
implements SDMSOwnedObject {
    public static final String __version = "@(#) $Id: SDMSNamedResource.java,v 2.16.2.7 2013/03/22 14:48:03 ronald Exp $";

    protected SDMSNamedResource(SDMSObject sDMSObject) {
        super(sDMSObject);
    }

    @Override
    public void delete(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.getId(systemEnvironment);
        Vector vector = SDMSNamedResourceTable.idx_parentId.getVector(systemEnvironment, l);
        if (vector.size() != 0) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03207041711", "Cannot drop, category is not empty"));
        }
        vector = SDMSResourceTable.idx_nrId.getVector(systemEnvironment, l);
        if (vector.size() > 0) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03206242216", "Cannot drop, depending resources still exist"));
        }
        vector = SDMSResourceTemplateTable.idx_nrId.getVector(systemEnvironment, l);
        if (vector.size() > 0) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03501171034", "Cannot drop, depending job resources still exist"));
        }
        vector = SDMSEnvironmentTable.idx_nrId.getVector(systemEnvironment, l);
        if (vector.size() > 0) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03301050057", "Cannot drop, depending Environments still exist"));
        }
        vector = SDMSResourceRequirementTable.idx_nrId.getVector(systemEnvironment, l);
        if (vector.size() > 0) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03301050157", "Cannot drop, depending Resource Requirements still exist"));
        }
        vector = SDMSPoolTable.idx_nrId.getVector(systemEnvironment, l);
        if (vector.size() > 0) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03603181134", "Cannot drop, depending Pools still exist"));
        }
        vector = SDMSTriggerTable.idx_fireId.getVector(systemEnvironment, l);
        for (int i = 0; i < vector.size(); ++i) {
            SDMSTrigger sDMSTrigger = (SDMSTrigger)vector.get(i);
            sDMSTrigger.delete(systemEnvironment);
        }
        super.delete(systemEnvironment);
    }

    public SDMSNamedResource copy(SystemEnvironment systemEnvironment, Long l, String string) throws SDMSException {
        return this.copy(systemEnvironment, l, string, null);
    }

    private SDMSNamedResource copy(SystemEnvironment systemEnvironment, Long l, String string, Long l2) throws SDMSException {
        Long l3 = this.getId(systemEnvironment);
        Long l4 = l2 == null ? SDMSUserTable.getObject(systemEnvironment, systemEnvironment.cEnv.uid()).getDefaultGId(systemEnvironment) : l2;
        if (!this.checkPrivileges(systemEnvironment, 0x10000000L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "03402291219"));
        }
        SDMSNamedResource sDMSNamedResource = SDMSNamedResourceTable.table.create(systemEnvironment, string, l4, l, this.getUsage(systemEnvironment), this.getRspId(systemEnvironment), this.getFactor(systemEnvironment), this.getInheritPrivs(systemEnvironment));
        ManipParameters.copy(systemEnvironment, l3, sDMSNamedResource.getId(systemEnvironment));
        Vector vector = SDMSNamedResourceTable.idx_parentId.getVector(systemEnvironment, l3);
        for (int i = 0; i < vector.size(); ++i) {
            SDMSNamedResource sDMSNamedResource2 = (SDMSNamedResource)vector.get(i);
            sDMSNamedResource2.copy(systemEnvironment, sDMSNamedResource.getId(systemEnvironment), sDMSNamedResource2.getName(systemEnvironment), l4);
        }
        return sDMSNamedResource;
    }

    @Override
    public long getPrivileges(SystemEnvironment systemEnvironment, long l, boolean bl, Vector vector) throws SDMSException {
        long l2 = super.getPrivileges(systemEnvironment, l, bl, vector);
        if (systemEnvironment.cEnv.isJob() || systemEnvironment.cEnv.isJobServer()) {
            l2 |= 8L;
        }
        if (systemEnvironment.cEnv.isUser() && this.getParentId(systemEnvironment) == null) {
            l2 |= 0x10000000L;
        }
        return l2 & l;
    }

    @Override
    public String getURLName(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.pathString(systemEnvironment);
    }

    @Override
    public String getURL(SystemEnvironment systemEnvironment) throws SDMSException {
        return "named resource " + this.getURLName(systemEnvironment);
    }

    @Override
    public String getSubtypeName(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.getUsageAsString(systemEnvironment);
    }

    public final void createParameters(SystemEnvironment systemEnvironment, WithHash withHash, boolean bl) throws SDMSException {
        if (withHash == null) {
            return;
        }
        Long l = this.getId(systemEnvironment);
        Vector vector = new Vector(withHash.keySet());
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            String string = (String)vector.get(i);
            Vector vector2 = (Vector)withHash.get(string);
            Integer n2 = (Integer)vector2.get(0);
            String string2 = (String)vector2.get(1);
            if (!bl && n2 == 50) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03409281200", "Parameters are not allowed for this type of named resource"));
            }
            if (n2 == 30 && string2 == null) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03409281158", "A constant or local constant must have a value"));
            }
            String string3 = string2 == null ? string2 : '=' + string2;
            SDMSParameterDefinitionTable.table.create(systemEnvironment, l, string, n2, SDMSConstants.PD_NONE, string3, Boolean.FALSE, null, null);
        }
    }

    public final void alterParameters(SystemEnvironment systemEnvironment, WithHash withHash, boolean bl) throws SDMSException {
        Long l = this.getId(systemEnvironment);
        Integer n = SDMSConstants.PD_NONE;
        Long l2 = null;
        Vector vector = SDMSParameterDefinitionTable.idx_seId.getVector(systemEnvironment, l);
        if (withHash != null) {
            if (this.getUsage(systemEnvironment) == 8 && withHash.size() != 0) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03409281330", "Parameters not allowed for categories"));
            }
            Set set = withHash.keySet();
            for (String string : set) {
                int n2;
                String string2;
                Vector vector2 = (Vector)withHash.get(string);
                Integer n3 = (Integer)vector2.get(0);
                String string3 = (String)vector2.get(1);
                if (!bl && n3 == 50) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03409281218", "Parameter are not allowed for this type of named resource"));
                }
                String string4 = string2 = string3 == null ? null : "=" + string3;
                if (n3 == 30 && string2 == null) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03409281221", "Constants must have a value"));
                }
                for (n2 = 0; n2 < vector.size(); ++n2) {
                    SDMSParameterDefinition sDMSParameterDefinition = (SDMSParameterDefinition)vector.get(n2);
                    String string5 = sDMSParameterDefinition.getName(systemEnvironment);
                    if (!string5.equals(string)) continue;
                    vector.removeElementAt(n2);
                    n2 = -1;
                    sDMSParameterDefinition.setType(systemEnvironment, n3);
                    sDMSParameterDefinition.setDefaultValue(systemEnvironment, string2);
                    break;
                }
                if (n2 < vector.size()) continue;
                SDMSParameterDefinitionTable.table.create(systemEnvironment, l, string, n3, n, string2, Boolean.FALSE, l2, null);
            }
        }
        this.killParameters(systemEnvironment, vector);
    }

    public final void killParameters(SystemEnvironment systemEnvironment) throws SDMSException {
        Vector vector = SDMSParameterDefinitionTable.idx_seId.getVector(systemEnvironment, this.getId(systemEnvironment));
        this.killParameters(systemEnvironment, vector);
    }

    private void killParameters(SystemEnvironment systemEnvironment, Vector vector) throws SDMSException {
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            SDMSParameterDefinition sDMSParameterDefinition = (SDMSParameterDefinition)vector.get(i);
            this.checkReferences(systemEnvironment, sDMSParameterDefinition.getId(systemEnvironment));
            Vector vector2 = SDMSResourceVariableTable.idx_pdId.getVector(systemEnvironment, sDMSParameterDefinition.getId(systemEnvironment));
            for (int j = 0; j < vector2.size(); ++j) {
                SDMSResourceVariable sDMSResourceVariable = (SDMSResourceVariable)vector2.get(j);
                sDMSResourceVariable.delete(systemEnvironment);
            }
            sDMSParameterDefinition.delete(systemEnvironment);
        }
    }

    private final void checkReferences(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (SDMSParameterDefinitionTable.idx_linkPdId.containsKey(systemEnvironment, l)) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03409281349", "You cannot delete a referenced parameter"));
        }
    }
}

