/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.CommentComparator;
import de.independit.scheduler.server.repository.SDMSObjectComment;
import de.independit.scheduler.server.repository.SDMSObjectCommentTableGeneric;
import java.util.Collections;
import java.util.Vector;

public class SDMSObjectCommentTable
extends SDMSObjectCommentTableGeneric {
    public static final String __version = "@(#) $Id: SDMSObjectCommentTable.java,v 2.0.20.1 2013/03/14 10:25:20 ronald Exp $";
    private static CommentComparator commentComparator = new CommentComparator();

    public SDMSObjectCommentTable(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
    }

    public static int dropComment(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        Vector vector = idx_objectId.getVector(systemEnvironment, l);
        for (int i = 0; i < vector.size(); ++i) {
            SDMSObjectComment sDMSObjectComment = (SDMSObjectComment)vector.get(i);
            sDMSObjectComment.delete(systemEnvironment);
        }
        return vector.size();
    }

    public static SDMSObjectComment idx_objectId_getFirst(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        SDMSObjectComment sDMSObjectComment = null;
        int n = Integer.MAX_VALUE;
        Vector vector = idx_objectId.getVector(systemEnvironment, l);
        for (int i = 0; i < vector.size(); ++i) {
            SDMSObjectComment sDMSObjectComment2 = (SDMSObjectComment)vector.get(i);
            int n2 = sDMSObjectComment2.getSequenceNumber(systemEnvironment);
            if (n2 >= n) continue;
            sDMSObjectComment = sDMSObjectComment2;
            n = n2;
        }
        if (sDMSObjectComment == null) {
            throw new NotFoundException(new SDMSMessage(systemEnvironment, "03510121305", "No comment found for id $1", l));
        }
        return sDMSObjectComment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector idx_objectId_getSortedVector(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        Vector vector = idx_objectId.getVector(systemEnvironment, l);
        if (vector.size() > 0) {
            CommentComparator commentComparator = SDMSObjectCommentTable.commentComparator;
            synchronized (commentComparator) {
                SDMSObjectCommentTable.commentComparator.setEnv(systemEnvironment);
                Collections.sort(vector, SDMSObjectCommentTable.commentComparator);
            }
        }
        return vector;
    }
}

