/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSIndex;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSPersistentValue;
import de.independit.scheduler.server.repository.SDMSPersistentValueGeneric;
import de.independit.scheduler.server.repository.SDMSPersistentValueTable;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SDMSPersistentValueTableGeneric
extends SDMSTable {
    public static final String tableName = "PERSISTENT_VALUE";
    public static SDMSPersistentValueTable table = null;
    public static final String[] columnNames = new String[]{"ID", "NAME", "INT_VALUE", "CREATOR_U_ID", "CREATE_TS", "CHANGER_U_ID", "CHANGE_TS"};
    public static SDMSIndex idx_name;

    public SDMSPersistentValueTableGeneric(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
        if (table != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182009", "PersistentValue"));
        }
        table = (SDMSPersistentValueTable)this;
        table = (SDMSPersistentValueTable)this;
        this.isVersioned = false;
        idx_name = new SDMSIndex(systemEnvironment, 1, this.isVersioned, table, "name");
    }

    public SDMSPersistentValue create(SystemEnvironment systemEnvironment, String string, Integer n) throws SDMSException {
        SDMSPersistentValue sDMSPersistentValue;
        Long l = systemEnvironment.cEnv.uid();
        Long l2 = systemEnvironment.txTime();
        Long l3 = systemEnvironment.cEnv.uid();
        Long l4 = systemEnvironment.txTime();
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182049", "PersistentValue"));
        }
        this.validate(systemEnvironment, string, n, l, l2, l3, l4);
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSPersistentValueGeneric sDMSPersistentValueGeneric = new SDMSPersistentValueGeneric(systemEnvironment, string, n, l, l2, l3, l4);
        try {
            systemEnvironment.tx.addToTouchSet(systemEnvironment, sDMSPersistentValueGeneric.versions, true);
            table.put(systemEnvironment, sDMSPersistentValueGeneric.id, sDMSPersistentValueGeneric.versions);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            sDMSPersistentValue = (SDMSPersistentValue)sDMSPersistentValueGeneric.toProxy(systemEnvironment);
            sDMSPersistentValue.current = true;
        }
        catch (SDMSException sDMSException) {
            SDMSPersistentValue sDMSPersistentValue2 = (SDMSPersistentValue)sDMSPersistentValueGeneric.toProxy(systemEnvironment);
            sDMSPersistentValue2.current = true;
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        if (!this.checkCreatePrivs(systemEnvironment, sDMSPersistentValue)) {
            throw new AccessViolationException(sDMSPersistentValue.accessViolationMessage(systemEnvironment, "01402270738"));
        }
        return sDMSPersistentValue;
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSPersistentValue sDMSPersistentValue) throws SDMSException {
        return true;
    }

    protected void validate(SystemEnvironment systemEnvironment, String string, Integer n, Long l, Long l2, Long l3, Long l4) throws SDMSException {
    }

    @Override
    protected SDMSObject rowToObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        long l2;
        Long l3;
        Long l4;
        Long l5;
        Long l6;
        Integer n;
        String string;
        Long l7;
        try {
            l7 = resultSet.getLong(1);
            string = resultSet.getString(2);
            n = resultSet.getInt(3);
            if (resultSet.wasNull()) {
                n = null;
            }
            l6 = resultSet.getLong(4);
            l5 = resultSet.getLong(5);
            l4 = resultSet.getLong(6);
            l3 = resultSet.getLong(7);
            l2 = 0L;
            l = Long.MAX_VALUE;
        }
        catch (SQLException sQLException) {
            SDMSThread.doTrace(null, "SQL Error : " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182045", "PersistentValue: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
        if (l < systemEnvironment.lowestActiveVersion) {
            return null;
        }
        return new SDMSPersistentValueGeneric(l7, string, n, l6, l5, l4, l3, l2, l);
    }

    @Override
    protected void loadTable(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        int n = 0;
        int n2 = 0;
        boolean bl = SystemEnvironment.isPostgreSQL;
        String string = SystemEnvironment.SQUOTE;
        String string2 = SystemEnvironment.EQUOTE;
        Statement statement = systemEnvironment.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + this.tableName() + string2 + ".ID, " + string + "NAME" + string2 + ", " + string + "INT_VALUE" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + " FROM " + string + this.tableName() + string2 + "");
        while (resultSet.next()) {
            try {
                if (this.loadObject(systemEnvironment, resultSet)) {
                    ++n2;
                }
                ++n;
            }
            catch (Exception exception) {
                SDMSThread.doTrace(null, "Exception caught while loading table " + this.tableName() + ", ID = " + Long.valueOf(resultSet.getLong(1)), -1);
                throw exception;
            }
        }
        statement.close();
        SDMSThread.doTrace(null, "Read " + n + ", Loaded " + n2 + " rows for " + this.tableName(), 0);
    }

    @Override
    public String checkIndex(SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        boolean bl = idx_name.check(((SDMSPersistentValueGeneric)sDMSObject).name, sDMSObject);
        string = string + "idx_name: " + (bl ? "ok" : "missing") + "\n";
        return string;
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.index(systemEnvironment, sDMSObject, -1L);
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject, long l) throws SDMSException {
        idx_name.put(systemEnvironment, ((SDMSPersistentValueGeneric)sDMSObject).name, sDMSObject, (1L & l) != 0L);
    }

    @Override
    protected void unIndex(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        idx_name.remove(systemEnvironment, ((SDMSPersistentValueGeneric)sDMSObject).name, sDMSObject);
    }

    public static SDMSPersistentValue getObject(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSPersistentValue)table.get(systemEnvironment, l);
    }

    public static SDMSPersistentValue getObjectForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSPersistentValue)table.getForUpdate(systemEnvironment, l);
    }

    public static SDMSPersistentValue getObject(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        return (SDMSPersistentValue)table.get(systemEnvironment, l, l2);
    }

    public static SDMSPersistentValue idx_name_getUnique(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSPersistentValue)idx_name.getUnique(systemEnvironment, object);
    }

    public static SDMSPersistentValue idx_name_getUniqueForUpdate(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSPersistentValue)idx_name.getUniqueForUpdate(systemEnvironment, object);
    }

    public static SDMSPersistentValue idx_name_getUnique(SystemEnvironment systemEnvironment, Object object, long l) throws SDMSException {
        return (SDMSPersistentValue)idx_name.getUnique(systemEnvironment, object, l);
    }

    @Override
    public String tableName() {
        return tableName;
    }

    @Override
    public String[] columnNames() {
        return columnNames;
    }
}

