/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SDMSConstants;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import java.util.HashMap;
import java.util.Vector;

public class SDMSPrivilege {
    public static final String __version = "@(#) $Id: SDMSPrivilege.java,v 2.8.4.1 2013/03/14 10:25:22 ronald Exp $";
    public static final String S_CREATE_CONTENT = "C";
    public static final String S_DROP = "D";
    public static final String S_EDIT = "E";
    public static final String S_GRANT = "G";
    public static final String S_CREATE = "K";
    public static final String S_MONITOR = "M";
    public static final String S_OPERATE = "O";
    public static final String S_CREATE_PARENT_CONTENT = "P";
    public static final String S_RESOURCE = "R";
    public static final String S_SUBMIT = "S";
    public static final String S_USE = "U";
    public static final String S_VIEW = "V";
    public static final String S_EXECUTE = "X";
    public static final String S_CANCEL = "C";
    public static final String S_RERUN = "R";
    public static final String S_ENABLE = "E";
    public static final String S_SET_STATE = "S";
    public static final String S_IGN_DEPENDENCY = "D";
    public static final String S_IGN_RESOURCE = "I";
    public static final String S_CLONE = "L";
    public static final String S_SUSPEND = "U";
    public static final String S_CLEAR_WARNING = "W";
    public static final String S_PRIORITY = "P";
    public static final String S_MODIFY_PARAMETER = "M";
    public static final String S_KILL = "K";
    public static final String S_APPROVE = "A";
    public static final String S_SET_JOB_STATE = "J";
    public static final long CREATE = 1L;
    public static final long CREATE_CONTENT = 2L;
    public static final long CREATE_PARENT_CONTENT = 4L;
    public static final long RESOURCE = 8L;
    public static final long DROP = 16L;
    public static final long EDIT = 256L;
    public static final long APPROVE = 512L;
    public static final long MONITOR = 4096L;
    public static final long OPERATE = 65536L;
    public static final long CANCEL = 131072L;
    public static final long RERUN = 262144L;
    public static final long ENABLE = 524288L;
    public static final long SUBMIT = 0x100000L;
    public static final long SET_STATE = 0x200000L;
    public static final long IGN_DEPENDENCY = 0x400000L;
    public static final long IGN_RESOURCE = 0x800000L;
    public static final long USE = 0x1000000L;
    public static final long CLONE = 0x2000000L;
    public static final long SUSPEND = 0x4000000L;
    public static final long CLEAR_WARNING = 0x8000000L;
    public static final long VIEW = 0x10000000L;
    public static final long PRIORITY = 0x20000000L;
    public static final long MODIFY_PARAMETER = 0x40000000L;
    public static final long KILL = 0x80000000L;
    public static final long EXECUTE = 0x100000000L;
    public static final long GRANT = 0x200000000L;
    public static final long SET_JOB_STATE = 0x2000000000000L;
    public static final long MANAGE_USER = 0x400000000L;
    public static final long MANAGE_GROUP = 0x800000000L;
    public static final long MANAGE_ESD = 0x1000000000L;
    public static final long MANAGE_ESP = 0x2000000000L;
    public static final long MANAGE_ESM = 0x4000000000L;
    public static final long MANAGE_EST = 0x8000000000L;
    public static final long MANAGE_RSD = 0x10000000000L;
    public static final long MANAGE_RSP = 0x20000000000L;
    public static final long MANAGE_RSM = 0x40000000000L;
    public static final long MANAGE_FP = 0x80000000000L;
    public static final long MANAGE_ENV = 0x100000000000L;
    public static final long MANAGE_SYS = 0x200000000000L;
    public static final long MANAGE_SEL = 0x400000000000L;
    public static final long MANAGE_NP = 0x800000000000L;
    public static final long MANAGE_WT = 0x1000000000000L;
    private static final long VALID_BITS = 0x3FFFFFFFF131FL;
    private static final long INVALID_BITS = -1125899906781984L;
    public static final long ALL = 0x31111111BL;
    public static final long OPERATE_PRIVS = 0x20000EEEE0200L;
    public static final long MANAGE_ALL = 562932773552128L;
    public static final long[] MANAGE_PRIVS = new long[]{0x400000000L, 0x800000000L, 0x1000000000L, 0x2000000000L, 0x4000000000L, 0x8000000000L, 0x10000000000L, 0x20000000000L, 0x40000000000L, 0x80000000000L, 0x100000000000L, 0x200000000000L, 0x400000000000L, 0x800000000000L, 0x1000000000000L};
    public static final long NOPRIVS = 0L;
    public static final Long SYSPRIVOBJID = SDMSConstants.lZERO;
    private long priv;
    private static final HashMap mapper = new HashMap();

    public SDMSPrivilege() {
        this.priv = 0L;
    }

    public SDMSPrivilege(SystemEnvironment systemEnvironment, long l) throws SDMSException {
        if ((l & 0xFFFC00000000ECE0L) != 0L) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "03708061541", "Trying to use invalid privileges"));
        }
        this.priv = l;
    }

    public static Long map(Integer n) {
        return (Long)mapper.get(n);
    }

    public void addPriv(SystemEnvironment systemEnvironment, long l) throws SDMSException {
        if ((l & 0xFFFC00000000ECE0L) != 0L) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "03402101453", "Trying to use invalid privileges"));
        }
        this.priv |= l;
    }

    public void addPriv(SystemEnvironment systemEnvironment, SDMSPrivilege sDMSPrivilege) throws SDMSException {
        this.priv |= sDMSPrivilege.priv;
    }

    public void delPriv(SystemEnvironment systemEnvironment, long l) throws SDMSException {
        if ((l & 0xFFFC00000000ECE0L) != 0L) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "03402101459", "Trying to use invalid privileges"));
        }
        this.priv &= l ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public void setPriv(SystemEnvironment systemEnvironment, long l) throws SDMSException {
        if ((l & 0xFFFC00000000ECE0L) != 0L) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "03402111239", "Trying to use invalid privileges"));
        }
        this.priv = l;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        if ((this.priv & 1L) == 1L) {
            stringBuffer.append("K");
        }
        if ((this.priv & 2L) == 2L) {
            stringBuffer.append("C");
        }
        if ((this.priv & 4L) == 4L) {
            stringBuffer.append("P");
        }
        if ((this.priv & 0x10L) == 16L) {
            stringBuffer.append("D");
        }
        if ((this.priv & 0x100L) == 256L) {
            stringBuffer.append("E");
        }
        if ((this.priv & 0x1000L) == 4096L) {
            stringBuffer.append("M");
        }
        if ((this.priv & 0x20000EEEF0200L) != 0L) {
            stringBuffer.append(S_OPERATE);
            if ((this.priv & 0x10000L) != 0L) {
                bl = (this.priv & 0x20000EEEE0200L) != 0L;
            }
            if (bl) {
                stringBuffer.append("(");
                if ((this.priv & 0x10000L) == 65536L) {
                    stringBuffer.append(S_OPERATE);
                }
                if ((this.priv & 0x20000L) == 131072L) {
                    stringBuffer.append("C");
                }
                if ((this.priv & 0x40000L) == 262144L) {
                    stringBuffer.append("R");
                }
                if ((this.priv & 0x80000L) == 524288L) {
                    stringBuffer.append("E");
                }
                if ((this.priv & 0x200000L) == 0x200000L) {
                    stringBuffer.append("S");
                }
                if ((this.priv & 0x400000L) == 0x400000L) {
                    stringBuffer.append("D");
                }
                if ((this.priv & 0x800000L) == 0x800000L) {
                    stringBuffer.append(S_IGN_RESOURCE);
                }
                if ((this.priv & 0x2000000L) == 0x2000000L) {
                    stringBuffer.append(S_CLONE);
                }
                if ((this.priv & 0x4000000L) == 0x4000000L) {
                    stringBuffer.append("U");
                }
                if ((this.priv & 0x8000000L) == 0x8000000L) {
                    stringBuffer.append(S_CLEAR_WARNING);
                }
                if ((this.priv & 0x20000000L) == 0x20000000L) {
                    stringBuffer.append("P");
                }
                if ((this.priv & 0x40000000L) == 0x40000000L) {
                    stringBuffer.append("M");
                }
                if ((this.priv & 0x80000000L) == 0x80000000L) {
                    stringBuffer.append("K");
                }
                if ((this.priv & 0x200L) == 512L) {
                    stringBuffer.append(S_APPROVE);
                }
                if ((this.priv & 0x2000000000000L) == 0x2000000000000L) {
                    stringBuffer.append(S_SET_JOB_STATE);
                }
                stringBuffer.append(")");
            }
        }
        if ((this.priv & 0x100000L) == 0x100000L) {
            stringBuffer.append("S");
        }
        if ((this.priv & 0x1000000L) == 0x1000000L) {
            stringBuffer.append("U");
        }
        if ((this.priv & 0x10000000L) == 0x10000000L) {
            stringBuffer.append(S_VIEW);
        }
        if ((this.priv & 0x200000000L) == 0x200000000L) {
            stringBuffer.append(S_GRANT);
        }
        if ((this.priv & 8L) == 8L) {
            stringBuffer.append("R");
        }
        if ((this.priv & 0x100000000L) == 0x100000000L) {
            stringBuffer.append(S_EXECUTE);
        }
        return new String(stringBuffer);
    }

    public String[] asString(int n) {
        Vector<String> vector = new Vector<String>();
        if ((this.priv & 1L) == 1L) {
            vector.add("CREATE");
        }
        if ((this.priv & 2L) == 2L) {
            vector.add("CREATE CONTENT");
        }
        if ((this.priv & 4L) == 4L) {
            vector.add("CREATE PARENT CONTENT");
        }
        if ((this.priv & 0x10L) == 16L) {
            vector.add("DROP");
        }
        if ((this.priv & 0x100L) == 256L) {
            vector.add("EDIT");
        }
        if ((this.priv & 0x1000L) == 4096L) {
            vector.add("MONITOR");
        }
        if ((this.priv & 0x10000L) == 65536L) {
            vector.add("OPERATE");
        }
        if (n >= 5) {
            if ((this.priv & 0x20000L) == 131072L) {
                vector.add("CANCEL");
            }
            if ((this.priv & 0x40000L) == 262144L) {
                vector.add("RERUN");
            }
            if ((this.priv & 0x80000L) == 524288L) {
                vector.add("ENABLE");
            }
            if ((this.priv & 0x200000L) == 0x200000L) {
                vector.add("SET STATE");
            }
            if ((this.priv & 0x400000L) == 0x400000L) {
                vector.add("IGNORE DEPENDENCY");
            }
            if ((this.priv & 0x800000L) == 0x800000L) {
                vector.add("IGNORE RESOURCE");
            }
            if ((this.priv & 0x2000000L) == 0x2000000L) {
                vector.add("CLONE");
            }
            if ((this.priv & 0x4000000L) == 0x4000000L) {
                vector.add("SUSPEND");
            }
            if ((this.priv & 0x8000000L) == 0x8000000L) {
                vector.add("CLEAR WARNING");
            }
            if ((this.priv & 0x20000000L) == 0x20000000L) {
                vector.add("PRIORITY");
            }
            if ((this.priv & 0x40000000L) == 0x40000000L) {
                vector.add("EDIT PARAMETER");
            }
            if ((this.priv & 0x80000000L) == 0x80000000L) {
                vector.add("KILL");
            }
            if ((this.priv & 0x200L) == 512L) {
                vector.add("APPROVE");
            }
            if ((this.priv & 0x2000000000000L) == 0x2000000000000L) {
                vector.add("SET JOB STATE");
            }
        }
        if ((this.priv & 0x100000L) == 0x100000L) {
            vector.add("SUBMIT");
        }
        if ((this.priv & 0x1000000L) == 0x1000000L) {
            vector.add("USE");
        }
        if ((this.priv & 0x10000000L) == 0x10000000L) {
            vector.add("VIEW");
        }
        if ((this.priv & 8L) == 8L) {
            vector.add("RESOURCE");
        }
        if ((this.priv & 0x100000000L) == 0x100000000L) {
            vector.add("EXECUTE");
        }
        if ((this.priv & 0x400000000L) == 0x400000000L) {
            vector.add("MANAGE USER");
        }
        if ((this.priv & 0x800000000L) == 0x800000000L) {
            vector.add("MANAGE GROUP");
        }
        if ((this.priv & 0x1000000000L) == 0x1000000000L) {
            vector.add("MANAGE EXIT STATE DEFINITION");
        }
        if ((this.priv & 0x2000000000L) == 0x2000000000L) {
            vector.add("MANAGE EXIT STATE PROFILE");
        }
        if ((this.priv & 0x4000000000L) == 0x4000000000L) {
            vector.add("MANAGE EXIT STATE MAPPING");
        }
        if ((this.priv & 0x8000000000L) == 0x8000000000L) {
            vector.add("MANAGE EXIT STATE DEFINITION");
        }
        if ((this.priv & 0x10000000000L) == 0x10000000000L) {
            vector.add("MANAGE RESOURCE STATE DEFINITION");
        }
        if ((this.priv & 0x20000000000L) == 0x20000000000L) {
            vector.add("MANAGE RESOURCE STATE PROFILE");
        }
        if ((this.priv & 0x40000000000L) == 0x40000000000L) {
            vector.add("MANAGE RESOURCE STATE MAPPING");
        }
        if ((this.priv & 0x80000000000L) == 0x80000000000L) {
            vector.add("MANAGE FOOTPRINT");
        }
        if ((this.priv & 0x100000000000L) == 0x100000000000L) {
            vector.add("MANAGE ENVIRONMENT");
        }
        if ((this.priv & 0x200000000000L) == 0x200000000000L) {
            vector.add("MANAGE SYSTEM");
        }
        if ((this.priv & 0x400000000000L) == 0x400000000000L) {
            vector.add("MANAGE SELECT");
        }
        if ((this.priv & 0x800000000000L) == 0x800000000000L) {
            vector.add("MANAGE NICE PROFILE");
        }
        if ((this.priv & 0x1000000000000L) == 0x1000000000000L) {
            vector.add("MANAGE WATCH TYPE");
        }
        return vector.toArray(new String[vector.size()]);
    }

    public Long toLong() {
        return this.priv;
    }

    public void merge(SDMSPrivilege sDMSPrivilege) {
        this.priv &= sDMSPrivilege.priv;
    }

    public void merge(long l) {
        this.priv &= l;
    }

    public boolean can(long l) {
        if ((this.priv & 0x10000L) != 0L) {
            return ((this.priv | 0x20000EEEE0200L) & l) == l;
        }
        return (this.priv & l) == l;
    }

    public boolean canAny(long l) {
        return (this.priv & l) != 0L;
    }

    public boolean isEmpty() {
        return this.priv == 0L;
    }

    static {
        mapper.put(633, 0x10000000L);
        mapper.put(629, 0x1000000L);
        mapper.put(346, 256L);
        mapper.put(342, 16L);
        mapper.put(591, 0x100000L);
        mapper.put(320, 2L);
        mapper.put(471, 4096L);
        mapper.put(503, 65536L);
        mapper.put(540, 8L);
        mapper.put(358, 0x100000000L);
        mapper.put(294, 131072L);
        mapper.put(537, 262144L);
        mapper.put(349, 524288L);
        mapper.put(584, 0x200000L);
        mapper.put(330, 0x400000L);
        mapper.put(402, 0x800000L);
        mapper.put(307, 0x2000000L);
        mapper.put(597, 0x4000000L);
        mapper.put(635, 0x8000000L);
        mapper.put(516, 0x20000000L);
        mapper.put(508, 0x40000000L);
        mapper.put(430, 0x80000000L);
        mapper.put(275, 512L);
        mapper.put(426, 0x2000000000000L);
    }
}

