/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.exception.SDMSSQLException;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSResourceRequirement;
import de.independit.scheduler.server.repository.SDMSResourceRequirementTableGeneric;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class SDMSResourceRequirementGeneric
extends SDMSObject
implements Cloneable {
    public static final int N = 255;
    public static final int X = 0;
    public static final int SX = 2;
    public static final int S = 4;
    public static final int SC = 6;
    public static final int NOKEEP = 0;
    public static final int KEEP = 1;
    public static final int KEEP_FINAL = 2;
    public static final int MINUTE = 0;
    public static final int HOUR = 1;
    public static final int DAY = 2;
    public static final int WEEK = 3;
    public static final int MONTH = 4;
    public static final int YEAR = 5;
    public static final int nr_id = 1;
    public static final int nr_nrId = 2;
    public static final int nr_seId = 3;
    public static final int nr_amount = 4;
    public static final int nr_keepMode = 5;
    public static final int nr_isSticky = 6;
    public static final int nr_stickyName = 7;
    public static final int nr_stickyParent = 8;
    public static final int nr_rsmpId = 9;
    public static final int nr_expiredAmount = 10;
    public static final int nr_expiredBase = 11;
    public static final int nr_ignoreOnRerun = 12;
    public static final int nr_lockmode = 13;
    public static final int nr_condition = 14;
    public static final int nr_creatorUId = 15;
    public static final int nr_createTs = 16;
    public static final int nr_changerUId = 17;
    public static final int nr_changeTs = 18;
    public static String tableName = "RESOURCE_REQUIREMENT";
    protected Long nrId;
    protected Long seId;
    protected Integer amount;
    protected Integer keepMode;
    protected Boolean isSticky;
    protected String stickyName;
    protected Long stickyParent;
    protected Long rsmpId;
    protected Integer expiredAmount;
    protected Integer expiredBase;
    protected Boolean ignoreOnRerun;
    protected Integer lockmode;
    protected String condition;
    protected Long creatorUId;
    protected Long createTs;
    protected Long changerUId;
    protected Long changeTs;
    private static PreparedStatement[] pUpdate = new PreparedStatement[128];
    private static PreparedStatement[] pDelete = new PreparedStatement[128];
    private static PreparedStatement[] pInsert = new PreparedStatement[128];

    public SDMSResourceRequirementGeneric(SystemEnvironment systemEnvironment, Long l, Long l2, Integer n, Integer n2, Boolean bl, String string, Long l3, Long l4, Integer n3, Integer n4, Boolean bl2, Integer n5, String string2, Long l5, Long l6, Long l7, Long l8) throws SDMSException {
        super(systemEnvironment, SDMSResourceRequirementTableGeneric.table);
        this.nrId = l;
        this.seId = l2;
        this.amount = n;
        this.keepMode = n2;
        this.isSticky = bl;
        if (string != null && string.length() > 64) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(ResourceRequirement) Length of $1 exceeds maximum length $2", "stickyName", "64"));
        }
        this.stickyName = string;
        this.stickyParent = l3;
        this.rsmpId = l4;
        this.expiredAmount = n3;
        this.expiredBase = n4;
        this.ignoreOnRerun = bl2;
        this.lockmode = n5;
        if (string2 != null && string2.length() > 1024) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(ResourceRequirement) Length of $1 exceeds maximum length $2", "condition", "1024"));
        }
        this.condition = string2;
        this.creatorUId = l5;
        this.createTs = l6;
        this.changerUId = l7;
        this.changeTs = l8;
    }

    public Long getNrId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.nrId;
    }

    public void setNrId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.nrId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ResourceRequirement) Change of system object not allowed"));
            }
            SDMSResourceRequirementGeneric sDMSResourceRequirementGeneric = (SDMSResourceRequirementGeneric)this.change(systemEnvironment);
            sDMSResourceRequirementGeneric.nrId = l;
            sDMSResourceRequirementGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSResourceRequirementGeneric.changeTs = systemEnvironment.txTime();
            sDMSResourceRequirementGeneric.versions.table.index(systemEnvironment, sDMSResourceRequirementGeneric, 9L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getSeId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.seId;
    }

    public void setSeId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.seId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ResourceRequirement) Change of system object not allowed"));
            }
            SDMSResourceRequirementGeneric sDMSResourceRequirementGeneric = (SDMSResourceRequirementGeneric)this.change(systemEnvironment);
            sDMSResourceRequirementGeneric.seId = l;
            sDMSResourceRequirementGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSResourceRequirementGeneric.changeTs = systemEnvironment.txTime();
            sDMSResourceRequirementGeneric.versions.table.index(systemEnvironment, sDMSResourceRequirementGeneric, 10L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Integer getAmount(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.amount;
    }

    public void setAmount(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.amount)) {
            return;
        }
        if (n == null && this.amount == null) {
            return;
        }
        SDMSResourceRequirementGeneric sDMSResourceRequirementGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ResourceRequirement) Change of system object not allowed"));
        }
        if (sDMSResourceRequirementGeneric.versions.o_v == null || sDMSResourceRequirementGeneric.versions.o_v.size() == 0 || sDMSResourceRequirementGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSResourceRequirementGeneric = (SDMSResourceRequirementGeneric)this.change(systemEnvironment);
        }
        sDMSResourceRequirementGeneric.amount = n;
        sDMSResourceRequirementGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSResourceRequirementGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSResourceRequirementGeneric != this) {
            sDMSResourceRequirementGeneric.versions.table.index(systemEnvironment, sDMSResourceRequirementGeneric, 0L);
        }
    }

    public Integer getKeepMode(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.keepMode;
    }

    public String getKeepModeAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getKeepMode(systemEnvironment);
        switch (n) {
            case 0: {
                return "NOKEEP";
            }
            case 1: {
                return "KEEP";
            }
            case 2: {
                return "KEEP_FINAL";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown ResourceRequirement.keepMode: $1", this.getKeepMode(systemEnvironment)));
    }

    public void setKeepMode(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.keepMode.equals(n)) {
            return;
        }
        SDMSResourceRequirementGeneric sDMSResourceRequirementGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ResourceRequirement) Change of system object not allowed"));
        }
        if (sDMSResourceRequirementGeneric.versions.o_v == null || sDMSResourceRequirementGeneric.versions.o_v.size() == 0 || sDMSResourceRequirementGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSResourceRequirementGeneric = (SDMSResourceRequirementGeneric)this.change(systemEnvironment);
        }
        sDMSResourceRequirementGeneric.keepMode = n;
        sDMSResourceRequirementGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSResourceRequirementGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSResourceRequirementGeneric != this) {
            sDMSResourceRequirementGeneric.versions.table.index(systemEnvironment, sDMSResourceRequirementGeneric, 0L);
        }
    }

    public Boolean getIsSticky(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.isSticky;
    }

    public void setIsSticky(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (this.isSticky.equals(bl)) {
            return;
        }
        SDMSResourceRequirementGeneric sDMSResourceRequirementGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ResourceRequirement) Change of system object not allowed"));
        }
        if (sDMSResourceRequirementGeneric.versions.o_v == null || sDMSResourceRequirementGeneric.versions.o_v.size() == 0 || sDMSResourceRequirementGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSResourceRequirementGeneric = (SDMSResourceRequirementGeneric)this.change(systemEnvironment);
        }
        sDMSResourceRequirementGeneric.isSticky = bl;
        sDMSResourceRequirementGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSResourceRequirementGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSResourceRequirementGeneric != this) {
            sDMSResourceRequirementGeneric.versions.table.index(systemEnvironment, sDMSResourceRequirementGeneric, 0L);
        }
    }

    public String getStickyName(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.stickyName;
    }

    public void setStickyName(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string != null && string.equals(this.stickyName)) {
            return;
        }
        if (string == null && this.stickyName == null) {
            return;
        }
        SDMSResourceRequirementGeneric sDMSResourceRequirementGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ResourceRequirement) Change of system object not allowed"));
        }
        if (sDMSResourceRequirementGeneric.versions.o_v == null || sDMSResourceRequirementGeneric.versions.o_v.size() == 0 || sDMSResourceRequirementGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSResourceRequirementGeneric = (SDMSResourceRequirementGeneric)this.change(systemEnvironment);
        }
        if (string != null && string.length() > 64) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(ResourceRequirement) Length of $1 exceeds maximum length $2", "stickyName", "64"));
        }
        sDMSResourceRequirementGeneric.stickyName = string;
        sDMSResourceRequirementGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSResourceRequirementGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSResourceRequirementGeneric != this) {
            sDMSResourceRequirementGeneric.versions.table.index(systemEnvironment, sDMSResourceRequirementGeneric, 0L);
        }
    }

    public Long getStickyParent(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.stickyParent;
    }

    public void setStickyParent(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.stickyParent)) {
            return;
        }
        if (l == null && this.stickyParent == null) {
            return;
        }
        SDMSResourceRequirementGeneric sDMSResourceRequirementGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ResourceRequirement) Change of system object not allowed"));
        }
        if (sDMSResourceRequirementGeneric.versions.o_v == null || sDMSResourceRequirementGeneric.versions.o_v.size() == 0 || sDMSResourceRequirementGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSResourceRequirementGeneric = (SDMSResourceRequirementGeneric)this.change(systemEnvironment);
        }
        sDMSResourceRequirementGeneric.stickyParent = l;
        sDMSResourceRequirementGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSResourceRequirementGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSResourceRequirementGeneric != this) {
            sDMSResourceRequirementGeneric.versions.table.index(systemEnvironment, sDMSResourceRequirementGeneric, 0L);
        }
    }

    public Long getRsmpId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.rsmpId;
    }

    public void setRsmpId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.rsmpId)) {
            return;
        }
        if (l == null && this.rsmpId == null) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ResourceRequirement) Change of system object not allowed"));
            }
            SDMSResourceRequirementGeneric sDMSResourceRequirementGeneric = (SDMSResourceRequirementGeneric)this.change(systemEnvironment);
            sDMSResourceRequirementGeneric.rsmpId = l;
            sDMSResourceRequirementGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSResourceRequirementGeneric.changeTs = systemEnvironment.txTime();
            sDMSResourceRequirementGeneric.versions.table.index(systemEnvironment, sDMSResourceRequirementGeneric, 4L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Integer getExpiredAmount(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.expiredAmount;
    }

    public void setExpiredAmount(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.expiredAmount)) {
            return;
        }
        if (n == null && this.expiredAmount == null) {
            return;
        }
        SDMSResourceRequirementGeneric sDMSResourceRequirementGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ResourceRequirement) Change of system object not allowed"));
        }
        if (sDMSResourceRequirementGeneric.versions.o_v == null || sDMSResourceRequirementGeneric.versions.o_v.size() == 0 || sDMSResourceRequirementGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSResourceRequirementGeneric = (SDMSResourceRequirementGeneric)this.change(systemEnvironment);
        }
        sDMSResourceRequirementGeneric.expiredAmount = n;
        sDMSResourceRequirementGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSResourceRequirementGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSResourceRequirementGeneric != this) {
            sDMSResourceRequirementGeneric.versions.table.index(systemEnvironment, sDMSResourceRequirementGeneric, 0L);
        }
    }

    public Integer getExpiredBase(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.expiredBase;
    }

    public String getExpiredBaseAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getExpiredBase(systemEnvironment);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "MINUTE";
            }
            case 1: {
                return "HOUR";
            }
            case 2: {
                return "DAY";
            }
            case 3: {
                return "WEEK";
            }
            case 4: {
                return "MONTH";
            }
            case 5: {
                return "YEAR";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown ResourceRequirement.expiredBase: $1", this.getExpiredBase(systemEnvironment)));
    }

    public void setExpiredBase(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.expiredBase)) {
            return;
        }
        if (n == null && this.expiredBase == null) {
            return;
        }
        SDMSResourceRequirementGeneric sDMSResourceRequirementGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ResourceRequirement) Change of system object not allowed"));
        }
        if (sDMSResourceRequirementGeneric.versions.o_v == null || sDMSResourceRequirementGeneric.versions.o_v.size() == 0 || sDMSResourceRequirementGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSResourceRequirementGeneric = (SDMSResourceRequirementGeneric)this.change(systemEnvironment);
        }
        sDMSResourceRequirementGeneric.expiredBase = n;
        sDMSResourceRequirementGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSResourceRequirementGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSResourceRequirementGeneric != this) {
            sDMSResourceRequirementGeneric.versions.table.index(systemEnvironment, sDMSResourceRequirementGeneric, 0L);
        }
    }

    public Boolean getIgnoreOnRerun(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.ignoreOnRerun;
    }

    public void setIgnoreOnRerun(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (this.ignoreOnRerun.equals(bl)) {
            return;
        }
        SDMSResourceRequirementGeneric sDMSResourceRequirementGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ResourceRequirement) Change of system object not allowed"));
        }
        if (sDMSResourceRequirementGeneric.versions.o_v == null || sDMSResourceRequirementGeneric.versions.o_v.size() == 0 || sDMSResourceRequirementGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSResourceRequirementGeneric = (SDMSResourceRequirementGeneric)this.change(systemEnvironment);
        }
        sDMSResourceRequirementGeneric.ignoreOnRerun = bl;
        sDMSResourceRequirementGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSResourceRequirementGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSResourceRequirementGeneric != this) {
            sDMSResourceRequirementGeneric.versions.table.index(systemEnvironment, sDMSResourceRequirementGeneric, 0L);
        }
    }

    public Integer getLockmode(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.lockmode;
    }

    public String getLockmodeAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getLockmode(systemEnvironment);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 255: {
                return "N";
            }
            case 0: {
                return "X";
            }
            case 2: {
                return "SX";
            }
            case 4: {
                return "S";
            }
            case 6: {
                return "SC";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown ResourceRequirement.lockmode: $1", this.getLockmode(systemEnvironment)));
    }

    public void setLockmode(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.lockmode)) {
            return;
        }
        if (n == null && this.lockmode == null) {
            return;
        }
        SDMSResourceRequirementGeneric sDMSResourceRequirementGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ResourceRequirement) Change of system object not allowed"));
        }
        if (sDMSResourceRequirementGeneric.versions.o_v == null || sDMSResourceRequirementGeneric.versions.o_v.size() == 0 || sDMSResourceRequirementGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSResourceRequirementGeneric = (SDMSResourceRequirementGeneric)this.change(systemEnvironment);
        }
        sDMSResourceRequirementGeneric.lockmode = n;
        sDMSResourceRequirementGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSResourceRequirementGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSResourceRequirementGeneric != this) {
            sDMSResourceRequirementGeneric.versions.table.index(systemEnvironment, sDMSResourceRequirementGeneric, 0L);
        }
    }

    public String getCondition(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.condition;
    }

    public void setCondition(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string != null && string.equals(this.condition)) {
            return;
        }
        if (string == null && this.condition == null) {
            return;
        }
        SDMSResourceRequirementGeneric sDMSResourceRequirementGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ResourceRequirement) Change of system object not allowed"));
        }
        if (sDMSResourceRequirementGeneric.versions.o_v == null || sDMSResourceRequirementGeneric.versions.o_v.size() == 0 || sDMSResourceRequirementGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSResourceRequirementGeneric = (SDMSResourceRequirementGeneric)this.change(systemEnvironment);
        }
        if (string != null && string.length() > 1024) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(ResourceRequirement) Length of $1 exceeds maximum length $2", "condition", "1024"));
        }
        sDMSResourceRequirementGeneric.condition = string;
        sDMSResourceRequirementGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSResourceRequirementGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSResourceRequirementGeneric != this) {
            sDMSResourceRequirementGeneric.versions.table.index(systemEnvironment, sDMSResourceRequirementGeneric, 0L);
        }
    }

    public Long getCreatorUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.creatorUId;
    }

    void setCreatorUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.creatorUId.equals(l)) {
            return;
        }
        SDMSResourceRequirementGeneric sDMSResourceRequirementGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ResourceRequirement) Change of system object not allowed"));
        }
        if (sDMSResourceRequirementGeneric.versions.o_v == null || sDMSResourceRequirementGeneric.versions.o_v.size() == 0 || sDMSResourceRequirementGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSResourceRequirementGeneric = (SDMSResourceRequirementGeneric)this.change(systemEnvironment);
        }
        sDMSResourceRequirementGeneric.creatorUId = l;
        sDMSResourceRequirementGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSResourceRequirementGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSResourceRequirementGeneric != this) {
            sDMSResourceRequirementGeneric.versions.table.index(systemEnvironment, sDMSResourceRequirementGeneric, 0L);
        }
    }

    public Long getCreateTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.createTs;
    }

    void setCreateTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.createTs.equals(l)) {
            return;
        }
        SDMSResourceRequirementGeneric sDMSResourceRequirementGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ResourceRequirement) Change of system object not allowed"));
        }
        if (sDMSResourceRequirementGeneric.versions.o_v == null || sDMSResourceRequirementGeneric.versions.o_v.size() == 0 || sDMSResourceRequirementGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSResourceRequirementGeneric = (SDMSResourceRequirementGeneric)this.change(systemEnvironment);
        }
        sDMSResourceRequirementGeneric.createTs = l;
        sDMSResourceRequirementGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSResourceRequirementGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSResourceRequirementGeneric != this) {
            sDMSResourceRequirementGeneric.versions.table.index(systemEnvironment, sDMSResourceRequirementGeneric, 0L);
        }
    }

    public Long getChangerUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changerUId;
    }

    public void setChangerUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        SDMSResourceRequirementGeneric sDMSResourceRequirementGeneric = this;
        if (sDMSResourceRequirementGeneric.versions.o_v == null || sDMSResourceRequirementGeneric.versions.o_v.size() == 0 || sDMSResourceRequirementGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSResourceRequirementGeneric = (SDMSResourceRequirementGeneric)this.change(systemEnvironment);
        }
        sDMSResourceRequirementGeneric.changerUId = l;
        sDMSResourceRequirementGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSResourceRequirementGeneric != this) {
            sDMSResourceRequirementGeneric.versions.table.index(systemEnvironment, sDMSResourceRequirementGeneric, 0L);
        }
    }

    public Long getChangeTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changeTs;
    }

    void setChangeTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.changeTs.equals(l)) {
            return;
        }
        SDMSResourceRequirementGeneric sDMSResourceRequirementGeneric = this;
        if (sDMSResourceRequirementGeneric.versions.o_v == null || sDMSResourceRequirementGeneric.versions.o_v.size() == 0 || sDMSResourceRequirementGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSResourceRequirementGeneric = (SDMSResourceRequirementGeneric)this.change(systemEnvironment);
        }
        sDMSResourceRequirementGeneric.changeTs = l;
        sDMSResourceRequirementGeneric.changerUId = systemEnvironment.cEnv.uid();
        if (sDMSResourceRequirementGeneric != this) {
            sDMSResourceRequirementGeneric.versions.table.index(systemEnvironment, sDMSResourceRequirementGeneric, 0L);
        }
    }

    public SDMSResourceRequirementGeneric set_SeIdNrId(SystemEnvironment systemEnvironment, Long l, Long l2) throws SDMSException {
        SDMSResourceRequirementGeneric sDMSResourceRequirementGeneric;
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141637", "(ResourceRequirement) Change of system object not allowed"));
            }
            sDMSResourceRequirementGeneric = (SDMSResourceRequirementGeneric)this.change(systemEnvironment);
            sDMSResourceRequirementGeneric.seId = l;
            sDMSResourceRequirementGeneric.nrId = l2;
            sDMSResourceRequirementGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSResourceRequirementGeneric.changeTs = systemEnvironment.txTime();
            sDMSResourceRequirementGeneric.versions.table.index(systemEnvironment, sDMSResourceRequirementGeneric);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        return sDMSResourceRequirementGeneric;
    }

    @Override
    protected SDMSProxy toProxy(SystemEnvironment systemEnvironment) {
        return new SDMSResourceRequirement(this);
    }

    protected SDMSResourceRequirementGeneric(Long l, Long l2, Long l3, Integer n, Integer n2, Boolean bl, String string, Long l4, Long l5, Integer n3, Integer n4, Boolean bl2, Integer n5, String string2, Long l6, Long l7, Long l8, Long l9, long l10, long l11) {
        this.id = l;
        this.nrId = l2;
        this.seId = l3;
        this.amount = n;
        this.keepMode = n2;
        this.isSticky = bl;
        this.stickyName = string;
        this.stickyParent = l4;
        this.rsmpId = l5;
        this.expiredAmount = n3;
        this.expiredBase = n4;
        this.ignoreOnRerun = bl2;
        this.lockmode = n5;
        this.condition = string2;
        this.creatorUId = l6;
        this.createTs = l7;
        this.changerUId = l8;
        this.changeTs = l9;
        this.validFrom = l10;
        this.validTo = l11;
    }

    protected String tableName() {
        return tableName;
    }

    @Override
    protected void insertDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pInsert[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "INSERT INTO " + string2 + "RESOURCE_REQUIREMENT" + string3 + " (ID, " + string2 + "NR_ID" + string3 + ", " + string2 + "SE_ID" + string3 + ", " + string2 + "AMOUNT" + string3 + ", " + string2 + "KEEP_MODE" + string3 + ", " + string2 + "IS_STICKY" + string3 + ", " + string2 + "STICKY_NAME" + string3 + ", " + string2 + "STICKY_PARENT" + string3 + ", " + string2 + "RSMP_ID" + string3 + ", " + string2 + "EXPIRED_AMOUNT" + string3 + ", " + string2 + "EXPIRED_BASE" + string3 + ", " + string2 + "IGNORE_ON_RERUN" + string3 + ", " + string2 + "LOCKMODE" + string3 + ", " + string2 + "CONDITION" + string3 + ", " + string2 + "CREATOR_U_ID" + string3 + ", " + string2 + "CREATE_TS" + string3 + ", " + string2 + "CHANGER_U_ID" + string3 + ", " + string2 + "CHANGE_TS" + string3 + ", VALID_FROM, VALID_TO) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                SDMSResourceRequirementGeneric.pInsert[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110181952", "ResourceRequirement: $1\n$2", string, sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pInsert[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.setLong(2, this.nrId);
            preparedStatement.setLong(3, this.seId);
            if (this.amount == null) {
                preparedStatement.setNull(4, 4);
            } else {
                preparedStatement.setInt(4, this.amount);
            }
            preparedStatement.setInt(5, this.keepMode);
            preparedStatement.setInt(6, this.isSticky != false ? 1 : 0);
            if (this.stickyName == null) {
                preparedStatement.setNull(7, 12);
            } else {
                preparedStatement.setString(7, this.stickyName);
            }
            if (this.stickyParent == null) {
                preparedStatement.setNull(8, 4);
            } else {
                preparedStatement.setLong(8, this.stickyParent);
            }
            if (this.rsmpId == null) {
                preparedStatement.setNull(9, 4);
            } else {
                preparedStatement.setLong(9, this.rsmpId);
            }
            if (this.expiredAmount == null) {
                preparedStatement.setNull(10, 4);
            } else {
                preparedStatement.setInt(10, this.expiredAmount);
            }
            if (this.expiredBase == null) {
                preparedStatement.setNull(11, 4);
            } else {
                preparedStatement.setInt(11, this.expiredBase);
            }
            preparedStatement.setInt(12, this.ignoreOnRerun != false ? 1 : 0);
            if (this.lockmode == null) {
                preparedStatement.setNull(13, 4);
            } else {
                preparedStatement.setInt(13, this.lockmode);
            }
            if (this.condition == null) {
                preparedStatement.setNull(14, 12);
            } else {
                preparedStatement.setString(14, this.condition);
            }
            preparedStatement.setLong(15, this.creatorUId);
            preparedStatement.setLong(16, this.createTs);
            preparedStatement.setLong(17, this.changerUId);
            preparedStatement.setLong(18, this.changeTs);
            preparedStatement.setLong(19, systemEnvironment.tx.versionId);
            preparedStatement.setLong(20, Long.MAX_VALUE);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110181954", "ResourceRequirement: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
    }

    @Override
    protected void updateDBObject(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.closeDBObject(systemEnvironment);
        this.insertDBObject(systemEnvironment);
    }

    @Override
    protected void deleteDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        this.closeDBObject(systemEnvironment);
    }

    private void closeDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pUpdate[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = systemEnvironment.dbConnection.getMetaData().getDriverName();
                boolean bl = string2.startsWith("PostgreSQL");
                String string3 = SystemEnvironment.SQUOTE;
                String string4 = SystemEnvironment.EQUOTE;
                string = "UPDATE " + string3 + "RESOURCE_REQUIREMENT" + string4 + " SET VALID_TO = ?,     CHANGE_TS = ?,     CHANGER_U_ID = ? WHERE ID = ?  AND VALID_TO = " + (bl ? "CAST ('9223372036854775807' AS DECIMAL)" : "9223372036854775807");
                SDMSResourceRequirementGeneric.pUpdate[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110181955", "ResourceRequirement : $1\n$2", string, sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pUpdate[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, systemEnvironment.tx.versionId);
            preparedStatement.setLong(2, this.changeTs);
            preparedStatement.setLong(3, this.changerUId);
            preparedStatement.setLong(4, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110181956", "ResourceRequirement: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
    }

    public static boolean checkKeepMode(Integer n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    public static boolean checkExpiredBase(Integer n) {
        if (n == null) {
            return true;
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public static boolean checkLockmode(Integer n) {
        if (n == null) {
            return true;
        }
        switch (n) {
            case 0: 
            case 2: 
            case 4: 
            case 6: 
            case 255: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void print() {
        SDMSThread.doTrace(null, "Type : ResourceRequirement", 2);
        SDMSThread.doTrace(null, "id : " + this.id, 2);
        SDMSThread.doTrace(null, "nrId : " + this.nrId, 2);
        SDMSThread.doTrace(null, "seId : " + this.seId, 2);
        SDMSThread.doTrace(null, "amount : " + this.amount, 2);
        SDMSThread.doTrace(null, "keepMode : " + this.keepMode, 2);
        SDMSThread.doTrace(null, "isSticky : " + this.isSticky, 2);
        SDMSThread.doTrace(null, "stickyName : " + this.stickyName, 2);
        SDMSThread.doTrace(null, "stickyParent : " + this.stickyParent, 2);
        SDMSThread.doTrace(null, "rsmpId : " + this.rsmpId, 2);
        SDMSThread.doTrace(null, "expiredAmount : " + this.expiredAmount, 2);
        SDMSThread.doTrace(null, "expiredBase : " + this.expiredBase, 2);
        SDMSThread.doTrace(null, "ignoreOnRerun : " + this.ignoreOnRerun, 2);
        SDMSThread.doTrace(null, "lockmode : " + this.lockmode, 2);
        SDMSThread.doTrace(null, "condition : " + this.condition, 2);
        SDMSThread.doTrace(null, "creatorUId : " + this.creatorUId, 2);
        SDMSThread.doTrace(null, "createTs : " + this.createTs, 2);
        SDMSThread.doTrace(null, "changerUId : " + this.changerUId, 2);
        SDMSThread.doTrace(null, "changeTs : " + this.changeTs, 2);
        SDMSThread.doTrace(null, "validFrom : " + this.validFrom, 2);
        SDMSThread.doTrace(null, "validTo : " + this.validTo, 2);
        this.dumpVersions(2);
    }

    @Override
    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer(n + 1);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        String string = new String(stringBuffer);
        String string2 = string + "id : " + this.id + "\n" + string + "nrId          : " + this.nrId + "\n" + string + "seId          : " + this.seId + "\n" + string + "amount        : " + this.amount + "\n" + string + "keepMode      : " + this.keepMode + "\n" + string + "isSticky      : " + this.isSticky + "\n" + string + "stickyName    : " + this.stickyName + "\n" + string + "stickyParent  : " + this.stickyParent + "\n" + string + "rsmpId        : " + this.rsmpId + "\n" + string + "expiredAmount : " + this.expiredAmount + "\n" + string + "expiredBase   : " + this.expiredBase + "\n" + string + "ignoreOnRerun : " + this.ignoreOnRerun + "\n" + string + "lockmode      : " + this.lockmode + "\n" + string + "condition     : " + this.condition + "\n" + string + "creatorUId    : " + this.creatorUId + "\n" + string + "createTs      : " + this.createTs + "\n" + string + "changerUId    : " + this.changerUId + "\n" + string + "changeTs      : " + this.changeTs + "\n" + string + "validFrom : " + this.validFrom + "\n" + string + "validTo : " + this.validTo + "\n";
        return string2;
    }

    public String toString() {
        String string = this.toString(0);
        return string;
    }
}

