/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.exception.SDMSSQLException;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTableGeneric;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class SDMSSchedulingEntityGeneric
extends SDMSObject
implements Cloneable {
    public static final int JOB = 1;
    public static final int BATCH = 2;
    public static final int MILESTONE = 3;
    public static final int AND = 1;
    public static final int OR = 2;
    public static final boolean SUSPEND = true;
    public static final boolean NOSUSPEND = false;
    public static final boolean MASTER = true;
    public static final boolean NOMASTER = false;
    public static final boolean SAME_NODE = true;
    public static final boolean NOSAME_NODE = false;
    public static final boolean GANG = true;
    public static final boolean NOGANG = false;
    public static final boolean TRUNC = true;
    public static final boolean NOTRUNC = false;
    public static final int MINUTE = 0;
    public static final int HOUR = 1;
    public static final int DAY = 2;
    public static final int WEEK = 3;
    public static final int MONTH = 4;
    public static final int YEAR = 5;
    public static final int DEFAULT = 0;
    public static final int PARENT = 1;
    public static final int NO = 2;
    public static final int REVIEW = 4;
    public static final int APPROVE = 5;
    public static final int nr_id = 1;
    public static final int nr_name = 2;
    public static final int nr_folderId = 3;
    public static final int nr_ownerId = 4;
    public static final int nr_type = 5;
    public static final int nr_runProgram = 6;
    public static final int nr_rerunProgram = 7;
    public static final int nr_killProgram = 8;
    public static final int nr_workdir = 9;
    public static final int nr_logfile = 10;
    public static final int nr_truncLog = 11;
    public static final int nr_errlogfile = 12;
    public static final int nr_truncErrlog = 13;
    public static final int nr_expectedRuntime = 14;
    public static final int nr_expectedFinaltime = 15;
    public static final int nr_getExpectedRuntime = 16;
    public static final int nr_priority = 17;
    public static final int nr_minPriority = 18;
    public static final int nr_agingAmount = 19;
    public static final int nr_agingBase = 20;
    public static final int nr_submitSuspended = 21;
    public static final int nr_resumeAt = 22;
    public static final int nr_resumeIn = 23;
    public static final int nr_resumeBase = 24;
    public static final int nr_masterSubmittable = 25;
    public static final int nr_timeoutAmount = 26;
    public static final int nr_timeoutBase = 27;
    public static final int nr_timeoutStateId = 28;
    public static final int nr_sameNode = 29;
    public static final int nr_gangSchedule = 30;
    public static final int nr_dependencyOperation = 31;
    public static final int nr_esmpId = 32;
    public static final int nr_espId = 33;
    public static final int nr_qaId = 34;
    public static final int nr_neId = 35;
    public static final int nr_fpId = 36;
    public static final int nr_cancelLeadFlag = 37;
    public static final int nr_cancelApproval = 38;
    public static final int nr_rerunLeadFlag = 39;
    public static final int nr_rerunApproval = 40;
    public static final int nr_enableLeadFlag = 41;
    public static final int nr_enableApproval = 42;
    public static final int nr_setStateLeadFlag = 43;
    public static final int nr_setStateApproval = 44;
    public static final int nr_ignDepLeadFlag = 45;
    public static final int nr_ignDepApproval = 46;
    public static final int nr_ignRssLeadFlag = 47;
    public static final int nr_ignRssApproval = 48;
    public static final int nr_cloneLeadFlag = 49;
    public static final int nr_cloneApproval = 50;
    public static final int nr_editParmLeadFlag = 51;
    public static final int nr_editParmApproval = 52;
    public static final int nr_killLeadFlag = 53;
    public static final int nr_killApproval = 54;
    public static final int nr_setJobStateLeadFlag = 55;
    public static final int nr_setJobStateApproval = 56;
    public static final int nr_inheritPrivs = 57;
    public static final int nr_creatorUId = 58;
    public static final int nr_createTs = 59;
    public static final int nr_changerUId = 60;
    public static final int nr_changeTs = 61;
    public static String tableName = "SCHEDULING_ENTITY";
    protected String name;
    protected Long folderId;
    protected Long ownerId;
    protected Integer type;
    protected String runProgram;
    protected String rerunProgram;
    protected String killProgram;
    protected String workdir;
    protected String logfile;
    protected Boolean truncLog;
    protected String errlogfile;
    protected Boolean truncErrlog;
    protected Integer expectedRuntime;
    protected Integer expectedFinaltime;
    protected String getExpectedRuntime;
    protected Integer priority;
    protected Integer minPriority;
    protected Integer agingAmount;
    protected Integer agingBase;
    protected Boolean submitSuspended;
    protected String resumeAt;
    protected Integer resumeIn;
    protected Integer resumeBase;
    protected Boolean masterSubmittable;
    protected Integer timeoutAmount;
    protected Integer timeoutBase;
    protected Long timeoutStateId;
    protected Boolean sameNode;
    protected Boolean gangSchedule;
    protected Integer dependencyOperation;
    protected Long esmpId;
    protected Long espId;
    protected Long qaId;
    protected Long neId;
    protected Long fpId;
    protected Boolean cancelLeadFlag;
    protected Integer cancelApproval;
    protected Boolean rerunLeadFlag;
    protected Integer rerunApproval;
    protected Boolean enableLeadFlag;
    protected Integer enableApproval;
    protected Boolean setStateLeadFlag;
    protected Integer setStateApproval;
    protected Boolean ignDepLeadFlag;
    protected Integer ignDepApproval;
    protected Boolean ignRssLeadFlag;
    protected Integer ignRssApproval;
    protected Boolean cloneLeadFlag;
    protected Integer cloneApproval;
    protected Boolean editParmLeadFlag;
    protected Integer editParmApproval;
    protected Boolean killLeadFlag;
    protected Integer killApproval;
    protected Boolean setJobStateLeadFlag;
    protected Integer setJobStateApproval;
    protected Long inheritPrivs;
    protected Long creatorUId;
    protected Long createTs;
    protected Long changerUId;
    protected Long changeTs;
    private static PreparedStatement[] pUpdate = new PreparedStatement[128];
    private static PreparedStatement[] pDelete = new PreparedStatement[128];
    private static PreparedStatement[] pInsert = new PreparedStatement[128];

    public SDMSSchedulingEntityGeneric(SystemEnvironment systemEnvironment, String string, Long l, Long l2, Integer n, String string2, String string3, String string4, String string5, String string6, Boolean bl, String string7, Boolean bl2, Integer n2, Integer n3, String string8, Integer n4, Integer n5, Integer n6, Integer n7, Boolean bl3, String string9, Integer n8, Integer n9, Boolean bl4, Integer n10, Integer n11, Long l3, Boolean bl5, Boolean bl6, Integer n12, Long l4, Long l5, Long l6, Long l7, Long l8, Boolean bl7, Integer n13, Boolean bl8, Integer n14, Boolean bl9, Integer n15, Boolean bl10, Integer n16, Boolean bl11, Integer n17, Boolean bl12, Integer n18, Boolean bl13, Integer n19, Boolean bl14, Integer n20, Boolean bl15, Integer n21, Boolean bl16, Integer n22, Long l9, Long l10, Long l11, Long l12, Long l13) throws SDMSException {
        super(systemEnvironment, SDMSSchedulingEntityTableGeneric.table);
        if (string != null && string.length() > 64) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(SchedulingEntity) Length of $1 exceeds maximum length $2", "name", "64"));
        }
        this.name = string;
        this.folderId = l;
        this.ownerId = l2;
        this.type = n;
        if (string2 != null && string2.length() > 512) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(SchedulingEntity) Length of $1 exceeds maximum length $2", "runProgram", "512"));
        }
        this.runProgram = string2;
        if (string3 != null && string3.length() > 512) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(SchedulingEntity) Length of $1 exceeds maximum length $2", "rerunProgram", "512"));
        }
        this.rerunProgram = string3;
        if (string4 != null && string4.length() > 512) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(SchedulingEntity) Length of $1 exceeds maximum length $2", "killProgram", "512"));
        }
        this.killProgram = string4;
        if (string5 != null && string5.length() > 512) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(SchedulingEntity) Length of $1 exceeds maximum length $2", "workdir", "512"));
        }
        this.workdir = string5;
        if (string6 != null && string6.length() > 512) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(SchedulingEntity) Length of $1 exceeds maximum length $2", "logfile", "512"));
        }
        this.logfile = string6;
        this.truncLog = bl;
        if (string7 != null && string7.length() > 512) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(SchedulingEntity) Length of $1 exceeds maximum length $2", "errlogfile", "512"));
        }
        this.errlogfile = string7;
        this.truncErrlog = bl2;
        this.expectedRuntime = n2;
        this.expectedFinaltime = n3;
        if (string8 != null && string8.length() > 32) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(SchedulingEntity) Length of $1 exceeds maximum length $2", "getExpectedRuntime", "32"));
        }
        this.getExpectedRuntime = string8;
        this.priority = n4;
        this.minPriority = n5;
        this.agingAmount = n6;
        this.agingBase = n7;
        this.submitSuspended = bl3;
        if (string9 != null && string9.length() > 20) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(SchedulingEntity) Length of $1 exceeds maximum length $2", "resumeAt", "20"));
        }
        this.resumeAt = string9;
        this.resumeIn = n8;
        this.resumeBase = n9;
        this.masterSubmittable = bl4;
        this.timeoutAmount = n10;
        this.timeoutBase = n11;
        this.timeoutStateId = l3;
        this.sameNode = bl5;
        this.gangSchedule = bl6;
        this.dependencyOperation = n12;
        this.esmpId = l4;
        this.espId = l5;
        this.qaId = l6;
        this.neId = l7;
        this.fpId = l8;
        this.cancelLeadFlag = bl7;
        this.cancelApproval = n13;
        this.rerunLeadFlag = bl8;
        this.rerunApproval = n14;
        this.enableLeadFlag = bl9;
        this.enableApproval = n15;
        this.setStateLeadFlag = bl10;
        this.setStateApproval = n16;
        this.ignDepLeadFlag = bl11;
        this.ignDepApproval = n17;
        this.ignRssLeadFlag = bl12;
        this.ignRssApproval = n18;
        this.cloneLeadFlag = bl13;
        this.cloneApproval = n19;
        this.editParmLeadFlag = bl14;
        this.editParmApproval = n20;
        this.killLeadFlag = bl15;
        this.killApproval = n21;
        this.setJobStateLeadFlag = bl16;
        this.setJobStateApproval = n22;
        this.inheritPrivs = l9;
        this.creatorUId = l10;
        this.createTs = l11;
        this.changerUId = l12;
        this.changeTs = l13;
    }

    public String getName(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.name;
    }

    public void setName(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (this.name.equals(string)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingEntity) Change of system object not allowed"));
            }
            SDMSSchedulingEntityGeneric sDMSSchedulingEntityGeneric = (SDMSSchedulingEntityGeneric)this.change(systemEnvironment);
            if (string != null && string.length() > 64) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(SchedulingEntity) Length of $1 exceeds maximum length $2", "name", "64"));
            }
            sDMSSchedulingEntityGeneric.name = string;
            sDMSSchedulingEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSSchedulingEntityGeneric.changeTs = systemEnvironment.txTime();
            sDMSSchedulingEntityGeneric.versions.table.index(systemEnvironment, sDMSSchedulingEntityGeneric, 64L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getFolderId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.folderId;
    }

    public void setFolderId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.folderId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingEntity) Change of system object not allowed"));
            }
            SDMSSchedulingEntityGeneric sDMSSchedulingEntityGeneric = (SDMSSchedulingEntityGeneric)this.change(systemEnvironment);
            sDMSSchedulingEntityGeneric.folderId = l;
            sDMSSchedulingEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSSchedulingEntityGeneric.changeTs = systemEnvironment.txTime();
            sDMSSchedulingEntityGeneric.versions.table.index(systemEnvironment, sDMSSchedulingEntityGeneric, 193L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getOwnerId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.ownerId;
    }

    public void setOwnerId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.ownerId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingEntity) Change of system object not allowed"));
            }
            SDMSSchedulingEntityGeneric sDMSSchedulingEntityGeneric = (SDMSSchedulingEntityGeneric)this.change(systemEnvironment);
            sDMSSchedulingEntityGeneric.ownerId = l;
            sDMSSchedulingEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSSchedulingEntityGeneric.changeTs = systemEnvironment.txTime();
            sDMSSchedulingEntityGeneric.versions.table.index(systemEnvironment, sDMSSchedulingEntityGeneric, 2L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Integer getType(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.type;
    }

    public String getTypeAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getType(systemEnvironment);
        switch (n) {
            case 1: {
                return "JOB";
            }
            case 2: {
                return "BATCH";
            }
            case 3: {
                return "MILESTONE";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown SchedulingEntity.type: $1", this.getType(systemEnvironment)));
    }

    public void setType(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.type.equals(n)) {
            return;
        }
        SDMSSchedulingEntityGeneric sDMSSchedulingEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingEntity) Change of system object not allowed"));
        }
        if (sDMSSchedulingEntityGeneric.versions.o_v == null || sDMSSchedulingEntityGeneric.versions.o_v.size() == 0 || sDMSSchedulingEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingEntityGeneric = (SDMSSchedulingEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSchedulingEntityGeneric.type = n;
        sDMSSchedulingEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSchedulingEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingEntityGeneric != this) {
            sDMSSchedulingEntityGeneric.versions.table.index(systemEnvironment, sDMSSchedulingEntityGeneric, 0L);
        }
    }

    public String getRunProgram(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.runProgram;
    }

    public void setRunProgram(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string != null && string.equals(this.runProgram)) {
            return;
        }
        if (string == null && this.runProgram == null) {
            return;
        }
        SDMSSchedulingEntityGeneric sDMSSchedulingEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingEntity) Change of system object not allowed"));
        }
        if (sDMSSchedulingEntityGeneric.versions.o_v == null || sDMSSchedulingEntityGeneric.versions.o_v.size() == 0 || sDMSSchedulingEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingEntityGeneric = (SDMSSchedulingEntityGeneric)this.change(systemEnvironment);
        }
        if (string != null && string.length() > 512) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(SchedulingEntity) Length of $1 exceeds maximum length $2", "runProgram", "512"));
        }
        sDMSSchedulingEntityGeneric.runProgram = string;
        sDMSSchedulingEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSchedulingEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingEntityGeneric != this) {
            sDMSSchedulingEntityGeneric.versions.table.index(systemEnvironment, sDMSSchedulingEntityGeneric, 0L);
        }
    }

    public String getRerunProgram(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.rerunProgram;
    }

    public void setRerunProgram(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string != null && string.equals(this.rerunProgram)) {
            return;
        }
        if (string == null && this.rerunProgram == null) {
            return;
        }
        SDMSSchedulingEntityGeneric sDMSSchedulingEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingEntity) Change of system object not allowed"));
        }
        if (sDMSSchedulingEntityGeneric.versions.o_v == null || sDMSSchedulingEntityGeneric.versions.o_v.size() == 0 || sDMSSchedulingEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingEntityGeneric = (SDMSSchedulingEntityGeneric)this.change(systemEnvironment);
        }
        if (string != null && string.length() > 512) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(SchedulingEntity) Length of $1 exceeds maximum length $2", "rerunProgram", "512"));
        }
        sDMSSchedulingEntityGeneric.rerunProgram = string;
        sDMSSchedulingEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSchedulingEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingEntityGeneric != this) {
            sDMSSchedulingEntityGeneric.versions.table.index(systemEnvironment, sDMSSchedulingEntityGeneric, 0L);
        }
    }

    public String getKillProgram(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.killProgram;
    }

    public void setKillProgram(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string != null && string.equals(this.killProgram)) {
            return;
        }
        if (string == null && this.killProgram == null) {
            return;
        }
        SDMSSchedulingEntityGeneric sDMSSchedulingEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingEntity) Change of system object not allowed"));
        }
        if (sDMSSchedulingEntityGeneric.versions.o_v == null || sDMSSchedulingEntityGeneric.versions.o_v.size() == 0 || sDMSSchedulingEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingEntityGeneric = (SDMSSchedulingEntityGeneric)this.change(systemEnvironment);
        }
        if (string != null && string.length() > 512) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(SchedulingEntity) Length of $1 exceeds maximum length $2", "killProgram", "512"));
        }
        sDMSSchedulingEntityGeneric.killProgram = string;
        sDMSSchedulingEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSchedulingEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingEntityGeneric != this) {
            sDMSSchedulingEntityGeneric.versions.table.index(systemEnvironment, sDMSSchedulingEntityGeneric, 0L);
        }
    }

    public String getWorkdir(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.workdir;
    }

    public void setWorkdir(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string != null && string.equals(this.workdir)) {
            return;
        }
        if (string == null && this.workdir == null) {
            return;
        }
        SDMSSchedulingEntityGeneric sDMSSchedulingEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingEntity) Change of system object not allowed"));
        }
        if (sDMSSchedulingEntityGeneric.versions.o_v == null || sDMSSchedulingEntityGeneric.versions.o_v.size() == 0 || sDMSSchedulingEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingEntityGeneric = (SDMSSchedulingEntityGeneric)this.change(systemEnvironment);
        }
        if (string != null && string.length() > 512) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(SchedulingEntity) Length of $1 exceeds maximum length $2", "workdir", "512"));
        }
        sDMSSchedulingEntityGeneric.workdir = string;
        sDMSSchedulingEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSchedulingEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingEntityGeneric != this) {
            sDMSSchedulingEntityGeneric.versions.table.index(systemEnvironment, sDMSSchedulingEntityGeneric, 0L);
        }
    }

    public String getLogfile(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.logfile;
    }

    public void setLogfile(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string != null && string.equals(this.logfile)) {
            return;
        }
        if (string == null && this.logfile == null) {
            return;
        }
        SDMSSchedulingEntityGeneric sDMSSchedulingEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingEntity) Change of system object not allowed"));
        }
        if (sDMSSchedulingEntityGeneric.versions.o_v == null || sDMSSchedulingEntityGeneric.versions.o_v.size() == 0 || sDMSSchedulingEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingEntityGeneric = (SDMSSchedulingEntityGeneric)this.change(systemEnvironment);
        }
        if (string != null && string.length() > 512) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(SchedulingEntity) Length of $1 exceeds maximum length $2", "logfile", "512"));
        }
        sDMSSchedulingEntityGeneric.logfile = string;
        sDMSSchedulingEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSchedulingEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingEntityGeneric != this) {
            sDMSSchedulingEntityGeneric.versions.table.index(systemEnvironment, sDMSSchedulingEntityGeneric, 0L);
        }
    }

    public Boolean getTruncLog(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.truncLog;
    }

    public String getTruncLogAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Boolean bl = this.getTruncLog(systemEnvironment);
        if (bl == null) {
            return null;
        }
        boolean bl2 = bl;
        if (!bl2) {
            return "NOTRUNC";
        }
        if (bl2) {
            return "TRUNC";
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown SchedulingEntity.truncLog: $1", this.getTruncLog(systemEnvironment)));
    }

    public void setTruncLog(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (bl != null && bl.equals(this.truncLog)) {
            return;
        }
        if (bl == null && this.truncLog == null) {
            return;
        }
        SDMSSchedulingEntityGeneric sDMSSchedulingEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingEntity) Change of system object not allowed"));
        }
        if (sDMSSchedulingEntityGeneric.versions.o_v == null || sDMSSchedulingEntityGeneric.versions.o_v.size() == 0 || sDMSSchedulingEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingEntityGeneric = (SDMSSchedulingEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSchedulingEntityGeneric.truncLog = bl;
        sDMSSchedulingEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSchedulingEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingEntityGeneric != this) {
            sDMSSchedulingEntityGeneric.versions.table.index(systemEnvironment, sDMSSchedulingEntityGeneric, 0L);
        }
    }

    public String getErrlogfile(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.errlogfile;
    }

    public void setErrlogfile(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string != null && string.equals(this.errlogfile)) {
            return;
        }
        if (string == null && this.errlogfile == null) {
            return;
        }
        SDMSSchedulingEntityGeneric sDMSSchedulingEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingEntity) Change of system object not allowed"));
        }
        if (sDMSSchedulingEntityGeneric.versions.o_v == null || sDMSSchedulingEntityGeneric.versions.o_v.size() == 0 || sDMSSchedulingEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingEntityGeneric = (SDMSSchedulingEntityGeneric)this.change(systemEnvironment);
        }
        if (string != null && string.length() > 512) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(SchedulingEntity) Length of $1 exceeds maximum length $2", "errlogfile", "512"));
        }
        sDMSSchedulingEntityGeneric.errlogfile = string;
        sDMSSchedulingEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSchedulingEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingEntityGeneric != this) {
            sDMSSchedulingEntityGeneric.versions.table.index(systemEnvironment, sDMSSchedulingEntityGeneric, 0L);
        }
    }

    public Boolean getTruncErrlog(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.truncErrlog;
    }

    public String getTruncErrlogAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Boolean bl = this.getTruncErrlog(systemEnvironment);
        if (bl == null) {
            return null;
        }
        boolean bl2 = bl;
        if (!bl2) {
            return "NOTRUNC";
        }
        if (bl2) {
            return "TRUNC";
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown SchedulingEntity.truncErrlog: $1", this.getTruncErrlog(systemEnvironment)));
    }

    public void setTruncErrlog(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (bl != null && bl.equals(this.truncErrlog)) {
            return;
        }
        if (bl == null && this.truncErrlog == null) {
            return;
        }
        SDMSSchedulingEntityGeneric sDMSSchedulingEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingEntity) Change of system object not allowed"));
        }
        if (sDMSSchedulingEntityGeneric.versions.o_v == null || sDMSSchedulingEntityGeneric.versions.o_v.size() == 0 || sDMSSchedulingEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingEntityGeneric = (SDMSSchedulingEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSchedulingEntityGeneric.truncErrlog = bl;
        sDMSSchedulingEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSchedulingEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingEntityGeneric != this) {
            sDMSSchedulingEntityGeneric.versions.table.index(systemEnvironment, sDMSSchedulingEntityGeneric, 0L);
        }
    }

    public Integer getExpectedRuntime(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.expectedRuntime;
    }

    public void setExpectedRuntime(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.expectedRuntime)) {
            return;
        }
        if (n == null && this.expectedRuntime == null) {
            return;
        }
        SDMSSchedulingEntityGeneric sDMSSchedulingEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingEntity) Change of system object not allowed"));
        }
        if (sDMSSchedulingEntityGeneric.versions.o_v == null || sDMSSchedulingEntityGeneric.versions.o_v.size() == 0 || sDMSSchedulingEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingEntityGeneric = (SDMSSchedulingEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSchedulingEntityGeneric.expectedRuntime = n;
        sDMSSchedulingEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSchedulingEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingEntityGeneric != this) {
            sDMSSchedulingEntityGeneric.versions.table.index(systemEnvironment, sDMSSchedulingEntityGeneric, 0L);
        }
    }

    public Integer getExpectedFinaltime(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.expectedFinaltime;
    }

    public void setExpectedFinaltime(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.expectedFinaltime)) {
            return;
        }
        if (n == null && this.expectedFinaltime == null) {
            return;
        }
        SDMSSchedulingEntityGeneric sDMSSchedulingEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingEntity) Change of system object not allowed"));
        }
        if (sDMSSchedulingEntityGeneric.versions.o_v == null || sDMSSchedulingEntityGeneric.versions.o_v.size() == 0 || sDMSSchedulingEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingEntityGeneric = (SDMSSchedulingEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSchedulingEntityGeneric.expectedFinaltime = n;
        sDMSSchedulingEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSchedulingEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingEntityGeneric != this) {
            sDMSSchedulingEntityGeneric.versions.table.index(systemEnvironment, sDMSSchedulingEntityGeneric, 0L);
        }
    }

    public String getGetExpectedRuntime(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.getExpectedRuntime;
    }

    public void setGetExpectedRuntime(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string != null && string.equals(this.getExpectedRuntime)) {
            return;
        }
        if (string == null && this.getExpectedRuntime == null) {
            return;
        }
        SDMSSchedulingEntityGeneric sDMSSchedulingEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingEntity) Change of system object not allowed"));
        }
        if (sDMSSchedulingEntityGeneric.versions.o_v == null || sDMSSchedulingEntityGeneric.versions.o_v.size() == 0 || sDMSSchedulingEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingEntityGeneric = (SDMSSchedulingEntityGeneric)this.change(systemEnvironment);
        }
        if (string != null && string.length() > 32) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(SchedulingEntity) Length of $1 exceeds maximum length $2", "getExpectedRuntime", "32"));
        }
        sDMSSchedulingEntityGeneric.getExpectedRuntime = string;
        sDMSSchedulingEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSchedulingEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingEntityGeneric != this) {
            sDMSSchedulingEntityGeneric.versions.table.index(systemEnvironment, sDMSSchedulingEntityGeneric, 0L);
        }
    }

    public Integer getPriority(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.priority;
    }

    public void setPriority(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.priority.equals(n)) {
            return;
        }
        SDMSSchedulingEntityGeneric sDMSSchedulingEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingEntity) Change of system object not allowed"));
        }
        if (sDMSSchedulingEntityGeneric.versions.o_v == null || sDMSSchedulingEntityGeneric.versions.o_v.size() == 0 || sDMSSchedulingEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingEntityGeneric = (SDMSSchedulingEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSchedulingEntityGeneric.priority = n;
        sDMSSchedulingEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSchedulingEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingEntityGeneric != this) {
            sDMSSchedulingEntityGeneric.versions.table.index(systemEnvironment, sDMSSchedulingEntityGeneric, 0L);
        }
    }

    public Integer getMinPriority(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.minPriority;
    }

    public void setMinPriority(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.minPriority)) {
            return;
        }
        if (n == null && this.minPriority == null) {
            return;
        }
        SDMSSchedulingEntityGeneric sDMSSchedulingEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingEntity) Change of system object not allowed"));
        }
        if (sDMSSchedulingEntityGeneric.versions.o_v == null || sDMSSchedulingEntityGeneric.versions.o_v.size() == 0 || sDMSSchedulingEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingEntityGeneric = (SDMSSchedulingEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSchedulingEntityGeneric.minPriority = n;
        sDMSSchedulingEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSchedulingEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingEntityGeneric != this) {
            sDMSSchedulingEntityGeneric.versions.table.index(systemEnvironment, sDMSSchedulingEntityGeneric, 0L);
        }
    }

    public Integer getAgingAmount(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.agingAmount;
    }

    public void setAgingAmount(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.agingAmount)) {
            return;
        }
        if (n == null && this.agingAmount == null) {
            return;
        }
        SDMSSchedulingEntityGeneric sDMSSchedulingEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingEntity) Change of system object not allowed"));
        }
        if (sDMSSchedulingEntityGeneric.versions.o_v == null || sDMSSchedulingEntityGeneric.versions.o_v.size() == 0 || sDMSSchedulingEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingEntityGeneric = (SDMSSchedulingEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSchedulingEntityGeneric.agingAmount = n;
        sDMSSchedulingEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSchedulingEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingEntityGeneric != this) {
            sDMSSchedulingEntityGeneric.versions.table.index(systemEnvironment, sDMSSchedulingEntityGeneric, 0L);
        }
    }

    public Integer getAgingBase(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.agingBase;
    }

    public String getAgingBaseAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getAgingBase(systemEnvironment);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "MINUTE";
            }
            case 1: {
                return "HOUR";
            }
            case 2: {
                return "DAY";
            }
            case 3: {
                return "WEEK";
            }
            case 4: {
                return "MONTH";
            }
            case 5: {
                return "YEAR";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown SchedulingEntity.agingBase: $1", this.getAgingBase(systemEnvironment)));
    }

    public void setAgingBase(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.agingBase)) {
            return;
        }
        if (n == null && this.agingBase == null) {
            return;
        }
        SDMSSchedulingEntityGeneric sDMSSchedulingEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingEntity) Change of system object not allowed"));
        }
        if (sDMSSchedulingEntityGeneric.versions.o_v == null || sDMSSchedulingEntityGeneric.versions.o_v.size() == 0 || sDMSSchedulingEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingEntityGeneric = (SDMSSchedulingEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSchedulingEntityGeneric.agingBase = n;
        sDMSSchedulingEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSchedulingEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingEntityGeneric != this) {
            sDMSSchedulingEntityGeneric.versions.table.index(systemEnvironment, sDMSSchedulingEntityGeneric, 0L);
        }
    }

    public Boolean getSubmitSuspended(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.submitSuspended;
    }

    public String getSubmitSuspendedAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Boolean bl = this.getSubmitSuspended(systemEnvironment);
        boolean bl2 = bl;
        if (bl2) {
            return "SUSPEND";
        }
        if (!bl2) {
            return "NOSUSPEND";
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown SchedulingEntity.submitSuspended: $1", this.getSubmitSuspended(systemEnvironment)));
    }

    public void setSubmitSuspended(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (this.submitSuspended.equals(bl)) {
            return;
        }
        SDMSSchedulingEntityGeneric sDMSSchedulingEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingEntity) Change of system object not allowed"));
        }
        if (sDMSSchedulingEntityGeneric.versions.o_v == null || sDMSSchedulingEntityGeneric.versions.o_v.size() == 0 || sDMSSchedulingEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingEntityGeneric = (SDMSSchedulingEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSchedulingEntityGeneric.submitSuspended = bl;
        sDMSSchedulingEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSchedulingEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingEntityGeneric != this) {
            sDMSSchedulingEntityGeneric.versions.table.index(systemEnvironment, sDMSSchedulingEntityGeneric, 0L);
        }
    }

    public String getResumeAt(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.resumeAt;
    }

    public void setResumeAt(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string != null && string.equals(this.resumeAt)) {
            return;
        }
        if (string == null && this.resumeAt == null) {
            return;
        }
        SDMSSchedulingEntityGeneric sDMSSchedulingEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingEntity) Change of system object not allowed"));
        }
        if (sDMSSchedulingEntityGeneric.versions.o_v == null || sDMSSchedulingEntityGeneric.versions.o_v.size() == 0 || sDMSSchedulingEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingEntityGeneric = (SDMSSchedulingEntityGeneric)this.change(systemEnvironment);
        }
        if (string != null && string.length() > 20) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(SchedulingEntity) Length of $1 exceeds maximum length $2", "resumeAt", "20"));
        }
        sDMSSchedulingEntityGeneric.resumeAt = string;
        sDMSSchedulingEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSchedulingEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingEntityGeneric != this) {
            sDMSSchedulingEntityGeneric.versions.table.index(systemEnvironment, sDMSSchedulingEntityGeneric, 0L);
        }
    }

    public Integer getResumeIn(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.resumeIn;
    }

    public void setResumeIn(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.resumeIn)) {
            return;
        }
        if (n == null && this.resumeIn == null) {
            return;
        }
        SDMSSchedulingEntityGeneric sDMSSchedulingEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingEntity) Change of system object not allowed"));
        }
        if (sDMSSchedulingEntityGeneric.versions.o_v == null || sDMSSchedulingEntityGeneric.versions.o_v.size() == 0 || sDMSSchedulingEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingEntityGeneric = (SDMSSchedulingEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSchedulingEntityGeneric.resumeIn = n;
        sDMSSchedulingEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSchedulingEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingEntityGeneric != this) {
            sDMSSchedulingEntityGeneric.versions.table.index(systemEnvironment, sDMSSchedulingEntityGeneric, 0L);
        }
    }

    public Integer getResumeBase(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.resumeBase;
    }

    public String getResumeBaseAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getResumeBase(systemEnvironment);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "MINUTE";
            }
            case 1: {
                return "HOUR";
            }
            case 2: {
                return "DAY";
            }
            case 3: {
                return "WEEK";
            }
            case 4: {
                return "MONTH";
            }
            case 5: {
                return "YEAR";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown SchedulingEntity.resumeBase: $1", this.getResumeBase(systemEnvironment)));
    }

    public void setResumeBase(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.resumeBase)) {
            return;
        }
        if (n == null && this.resumeBase == null) {
            return;
        }
        SDMSSchedulingEntityGeneric sDMSSchedulingEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingEntity) Change of system object not allowed"));
        }
        if (sDMSSchedulingEntityGeneric.versions.o_v == null || sDMSSchedulingEntityGeneric.versions.o_v.size() == 0 || sDMSSchedulingEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingEntityGeneric = (SDMSSchedulingEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSchedulingEntityGeneric.resumeBase = n;
        sDMSSchedulingEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSchedulingEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingEntityGeneric != this) {
            sDMSSchedulingEntityGeneric.versions.table.index(systemEnvironment, sDMSSchedulingEntityGeneric, 0L);
        }
    }

    public Boolean getMasterSubmittable(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.masterSubmittable;
    }

    public String getMasterSubmittableAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Boolean bl = this.getMasterSubmittable(systemEnvironment);
        boolean bl2 = bl;
        if (bl2) {
            return "MASTER";
        }
        if (!bl2) {
            return "NOMASTER";
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown SchedulingEntity.masterSubmittable: $1", this.getMasterSubmittable(systemEnvironment)));
    }

    public void setMasterSubmittable(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (this.masterSubmittable.equals(bl)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingEntity) Change of system object not allowed"));
            }
            SDMSSchedulingEntityGeneric sDMSSchedulingEntityGeneric = (SDMSSchedulingEntityGeneric)this.change(systemEnvironment);
            sDMSSchedulingEntityGeneric.masterSubmittable = bl;
            sDMSSchedulingEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSSchedulingEntityGeneric.changeTs = systemEnvironment.txTime();
            sDMSSchedulingEntityGeneric.versions.table.index(systemEnvironment, sDMSSchedulingEntityGeneric, 128L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Integer getTimeoutAmount(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.timeoutAmount;
    }

    public void setTimeoutAmount(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.timeoutAmount)) {
            return;
        }
        if (n == null && this.timeoutAmount == null) {
            return;
        }
        SDMSSchedulingEntityGeneric sDMSSchedulingEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingEntity) Change of system object not allowed"));
        }
        if (sDMSSchedulingEntityGeneric.versions.o_v == null || sDMSSchedulingEntityGeneric.versions.o_v.size() == 0 || sDMSSchedulingEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingEntityGeneric = (SDMSSchedulingEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSchedulingEntityGeneric.timeoutAmount = n;
        sDMSSchedulingEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSchedulingEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingEntityGeneric != this) {
            sDMSSchedulingEntityGeneric.versions.table.index(systemEnvironment, sDMSSchedulingEntityGeneric, 0L);
        }
    }

    public Integer getTimeoutBase(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.timeoutBase;
    }

    public String getTimeoutBaseAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getTimeoutBase(systemEnvironment);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "MINUTE";
            }
            case 1: {
                return "HOUR";
            }
            case 2: {
                return "DAY";
            }
            case 3: {
                return "WEEK";
            }
            case 4: {
                return "MONTH";
            }
            case 5: {
                return "YEAR";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown SchedulingEntity.timeoutBase: $1", this.getTimeoutBase(systemEnvironment)));
    }

    public void setTimeoutBase(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.timeoutBase)) {
            return;
        }
        if (n == null && this.timeoutBase == null) {
            return;
        }
        SDMSSchedulingEntityGeneric sDMSSchedulingEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingEntity) Change of system object not allowed"));
        }
        if (sDMSSchedulingEntityGeneric.versions.o_v == null || sDMSSchedulingEntityGeneric.versions.o_v.size() == 0 || sDMSSchedulingEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingEntityGeneric = (SDMSSchedulingEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSchedulingEntityGeneric.timeoutBase = n;
        sDMSSchedulingEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSchedulingEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingEntityGeneric != this) {
            sDMSSchedulingEntityGeneric.versions.table.index(systemEnvironment, sDMSSchedulingEntityGeneric, 0L);
        }
    }

    public Long getTimeoutStateId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.timeoutStateId;
    }

    public void setTimeoutStateId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.timeoutStateId)) {
            return;
        }
        if (l == null && this.timeoutStateId == null) {
            return;
        }
        SDMSSchedulingEntityGeneric sDMSSchedulingEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingEntity) Change of system object not allowed"));
        }
        if (sDMSSchedulingEntityGeneric.versions.o_v == null || sDMSSchedulingEntityGeneric.versions.o_v.size() == 0 || sDMSSchedulingEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingEntityGeneric = (SDMSSchedulingEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSchedulingEntityGeneric.timeoutStateId = l;
        sDMSSchedulingEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSchedulingEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingEntityGeneric != this) {
            sDMSSchedulingEntityGeneric.versions.table.index(systemEnvironment, sDMSSchedulingEntityGeneric, 0L);
        }
    }

    public Boolean getSameNode(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.sameNode;
    }

    public String getSameNodeAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Boolean bl = this.getSameNode(systemEnvironment);
        if (bl == null) {
            return null;
        }
        boolean bl2 = bl;
        if (bl2) {
            return "SAME_NODE";
        }
        if (!bl2) {
            return "NOSAME_NODE";
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown SchedulingEntity.sameNode: $1", this.getSameNode(systemEnvironment)));
    }

    public void setSameNode(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (bl != null && bl.equals(this.sameNode)) {
            return;
        }
        if (bl == null && this.sameNode == null) {
            return;
        }
        SDMSSchedulingEntityGeneric sDMSSchedulingEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingEntity) Change of system object not allowed"));
        }
        if (sDMSSchedulingEntityGeneric.versions.o_v == null || sDMSSchedulingEntityGeneric.versions.o_v.size() == 0 || sDMSSchedulingEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingEntityGeneric = (SDMSSchedulingEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSchedulingEntityGeneric.sameNode = bl;
        sDMSSchedulingEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSchedulingEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingEntityGeneric != this) {
            sDMSSchedulingEntityGeneric.versions.table.index(systemEnvironment, sDMSSchedulingEntityGeneric, 0L);
        }
    }

    public Boolean getGangSchedule(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.gangSchedule;
    }

    public String getGangScheduleAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Boolean bl = this.getGangSchedule(systemEnvironment);
        if (bl == null) {
            return null;
        }
        boolean bl2 = bl;
        if (bl2) {
            return "GANG";
        }
        if (!bl2) {
            return "NOGANG";
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown SchedulingEntity.gangSchedule: $1", this.getGangSchedule(systemEnvironment)));
    }

    public void setGangSchedule(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (bl != null && bl.equals(this.gangSchedule)) {
            return;
        }
        if (bl == null && this.gangSchedule == null) {
            return;
        }
        SDMSSchedulingEntityGeneric sDMSSchedulingEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingEntity) Change of system object not allowed"));
        }
        if (sDMSSchedulingEntityGeneric.versions.o_v == null || sDMSSchedulingEntityGeneric.versions.o_v.size() == 0 || sDMSSchedulingEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingEntityGeneric = (SDMSSchedulingEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSchedulingEntityGeneric.gangSchedule = bl;
        sDMSSchedulingEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSchedulingEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingEntityGeneric != this) {
            sDMSSchedulingEntityGeneric.versions.table.index(systemEnvironment, sDMSSchedulingEntityGeneric, 0L);
        }
    }

    public Integer getDependencyOperation(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.dependencyOperation;
    }

    public String getDependencyOperationAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getDependencyOperation(systemEnvironment);
        switch (n) {
            case 1: {
                return "AND";
            }
            case 2: {
                return "OR";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown SchedulingEntity.dependencyOperation: $1", this.getDependencyOperation(systemEnvironment)));
    }

    public void setDependencyOperation(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.dependencyOperation.equals(n)) {
            return;
        }
        SDMSSchedulingEntityGeneric sDMSSchedulingEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingEntity) Change of system object not allowed"));
        }
        if (sDMSSchedulingEntityGeneric.versions.o_v == null || sDMSSchedulingEntityGeneric.versions.o_v.size() == 0 || sDMSSchedulingEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingEntityGeneric = (SDMSSchedulingEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSchedulingEntityGeneric.dependencyOperation = n;
        sDMSSchedulingEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSchedulingEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingEntityGeneric != this) {
            sDMSSchedulingEntityGeneric.versions.table.index(systemEnvironment, sDMSSchedulingEntityGeneric, 0L);
        }
    }

    public Long getEsmpId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.esmpId;
    }

    public void setEsmpId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.esmpId)) {
            return;
        }
        if (l == null && this.esmpId == null) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingEntity) Change of system object not allowed"));
            }
            SDMSSchedulingEntityGeneric sDMSSchedulingEntityGeneric = (SDMSSchedulingEntityGeneric)this.change(systemEnvironment);
            sDMSSchedulingEntityGeneric.esmpId = l;
            sDMSSchedulingEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSSchedulingEntityGeneric.changeTs = systemEnvironment.txTime();
            sDMSSchedulingEntityGeneric.versions.table.index(systemEnvironment, sDMSSchedulingEntityGeneric, 4L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getEspId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.espId;
    }

    public void setEspId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.espId)) {
            return;
        }
        if (l == null && this.espId == null) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingEntity) Change of system object not allowed"));
            }
            SDMSSchedulingEntityGeneric sDMSSchedulingEntityGeneric = (SDMSSchedulingEntityGeneric)this.change(systemEnvironment);
            sDMSSchedulingEntityGeneric.espId = l;
            sDMSSchedulingEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSSchedulingEntityGeneric.changeTs = systemEnvironment.txTime();
            sDMSSchedulingEntityGeneric.versions.table.index(systemEnvironment, sDMSSchedulingEntityGeneric, 8L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getQaId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.qaId;
    }

    public void setQaId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.qaId)) {
            return;
        }
        if (l == null && this.qaId == null) {
            return;
        }
        SDMSSchedulingEntityGeneric sDMSSchedulingEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingEntity) Change of system object not allowed"));
        }
        if (sDMSSchedulingEntityGeneric.versions.o_v == null || sDMSSchedulingEntityGeneric.versions.o_v.size() == 0 || sDMSSchedulingEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingEntityGeneric = (SDMSSchedulingEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSchedulingEntityGeneric.qaId = l;
        sDMSSchedulingEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSchedulingEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingEntityGeneric != this) {
            sDMSSchedulingEntityGeneric.versions.table.index(systemEnvironment, sDMSSchedulingEntityGeneric, 0L);
        }
    }

    public Long getNeId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.neId;
    }

    public void setNeId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.neId)) {
            return;
        }
        if (l == null && this.neId == null) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingEntity) Change of system object not allowed"));
            }
            SDMSSchedulingEntityGeneric sDMSSchedulingEntityGeneric = (SDMSSchedulingEntityGeneric)this.change(systemEnvironment);
            sDMSSchedulingEntityGeneric.neId = l;
            sDMSSchedulingEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSSchedulingEntityGeneric.changeTs = systemEnvironment.txTime();
            sDMSSchedulingEntityGeneric.versions.table.index(systemEnvironment, sDMSSchedulingEntityGeneric, 16L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getFpId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.fpId;
    }

    public void setFpId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.fpId)) {
            return;
        }
        if (l == null && this.fpId == null) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingEntity) Change of system object not allowed"));
            }
            SDMSSchedulingEntityGeneric sDMSSchedulingEntityGeneric = (SDMSSchedulingEntityGeneric)this.change(systemEnvironment);
            sDMSSchedulingEntityGeneric.fpId = l;
            sDMSSchedulingEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSSchedulingEntityGeneric.changeTs = systemEnvironment.txTime();
            sDMSSchedulingEntityGeneric.versions.table.index(systemEnvironment, sDMSSchedulingEntityGeneric, 32L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Boolean getCancelLeadFlag(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.cancelLeadFlag;
    }

    public void setCancelLeadFlag(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (this.cancelLeadFlag.equals(bl)) {
            return;
        }
        SDMSSchedulingEntityGeneric sDMSSchedulingEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingEntity) Change of system object not allowed"));
        }
        if (sDMSSchedulingEntityGeneric.versions.o_v == null || sDMSSchedulingEntityGeneric.versions.o_v.size() == 0 || sDMSSchedulingEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingEntityGeneric = (SDMSSchedulingEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSchedulingEntityGeneric.cancelLeadFlag = bl;
        sDMSSchedulingEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSchedulingEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingEntityGeneric != this) {
            sDMSSchedulingEntityGeneric.versions.table.index(systemEnvironment, sDMSSchedulingEntityGeneric, 0L);
        }
    }

    public Integer getCancelApproval(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.cancelApproval;
    }

    public String getCancelApprovalAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getCancelApproval(systemEnvironment);
        switch (n) {
            case 0: {
                return "DEFAULT";
            }
            case 1: {
                return "PARENT";
            }
            case 2: {
                return "NO";
            }
            case 5: {
                return "APPROVE";
            }
            case 4: {
                return "REVIEW";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown SchedulingEntity.cancelApproval: $1", this.getCancelApproval(systemEnvironment)));
    }

    public void setCancelApproval(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.cancelApproval.equals(n)) {
            return;
        }
        SDMSSchedulingEntityGeneric sDMSSchedulingEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingEntity) Change of system object not allowed"));
        }
        if (sDMSSchedulingEntityGeneric.versions.o_v == null || sDMSSchedulingEntityGeneric.versions.o_v.size() == 0 || sDMSSchedulingEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingEntityGeneric = (SDMSSchedulingEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSchedulingEntityGeneric.cancelApproval = n;
        sDMSSchedulingEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSchedulingEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingEntityGeneric != this) {
            sDMSSchedulingEntityGeneric.versions.table.index(systemEnvironment, sDMSSchedulingEntityGeneric, 0L);
        }
    }

    public Boolean getRerunLeadFlag(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.rerunLeadFlag;
    }

    public void setRerunLeadFlag(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (this.rerunLeadFlag.equals(bl)) {
            return;
        }
        SDMSSchedulingEntityGeneric sDMSSchedulingEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingEntity) Change of system object not allowed"));
        }
        if (sDMSSchedulingEntityGeneric.versions.o_v == null || sDMSSchedulingEntityGeneric.versions.o_v.size() == 0 || sDMSSchedulingEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingEntityGeneric = (SDMSSchedulingEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSchedulingEntityGeneric.rerunLeadFlag = bl;
        sDMSSchedulingEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSchedulingEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingEntityGeneric != this) {
            sDMSSchedulingEntityGeneric.versions.table.index(systemEnvironment, sDMSSchedulingEntityGeneric, 0L);
        }
    }

    public Integer getRerunApproval(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.rerunApproval;
    }

    public String getRerunApprovalAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getRerunApproval(systemEnvironment);
        switch (n) {
            case 0: {
                return "DEFAULT";
            }
            case 1: {
                return "PARENT";
            }
            case 2: {
                return "NO";
            }
            case 5: {
                return "APPROVE";
            }
            case 4: {
                return "REVIEW";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown SchedulingEntity.rerunApproval: $1", this.getRerunApproval(systemEnvironment)));
    }

    public void setRerunApproval(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.rerunApproval.equals(n)) {
            return;
        }
        SDMSSchedulingEntityGeneric sDMSSchedulingEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingEntity) Change of system object not allowed"));
        }
        if (sDMSSchedulingEntityGeneric.versions.o_v == null || sDMSSchedulingEntityGeneric.versions.o_v.size() == 0 || sDMSSchedulingEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingEntityGeneric = (SDMSSchedulingEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSchedulingEntityGeneric.rerunApproval = n;
        sDMSSchedulingEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSchedulingEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingEntityGeneric != this) {
            sDMSSchedulingEntityGeneric.versions.table.index(systemEnvironment, sDMSSchedulingEntityGeneric, 0L);
        }
    }

    public Boolean getEnableLeadFlag(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.enableLeadFlag;
    }

    public void setEnableLeadFlag(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (this.enableLeadFlag.equals(bl)) {
            return;
        }
        SDMSSchedulingEntityGeneric sDMSSchedulingEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingEntity) Change of system object not allowed"));
        }
        if (sDMSSchedulingEntityGeneric.versions.o_v == null || sDMSSchedulingEntityGeneric.versions.o_v.size() == 0 || sDMSSchedulingEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingEntityGeneric = (SDMSSchedulingEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSchedulingEntityGeneric.enableLeadFlag = bl;
        sDMSSchedulingEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSchedulingEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingEntityGeneric != this) {
            sDMSSchedulingEntityGeneric.versions.table.index(systemEnvironment, sDMSSchedulingEntityGeneric, 0L);
        }
    }

    public Integer getEnableApproval(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.enableApproval;
    }

    public String getEnableApprovalAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getEnableApproval(systemEnvironment);
        switch (n) {
            case 0: {
                return "DEFAULT";
            }
            case 1: {
                return "PARENT";
            }
            case 2: {
                return "NO";
            }
            case 5: {
                return "APPROVE";
            }
            case 4: {
                return "REVIEW";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown SchedulingEntity.enableApproval: $1", this.getEnableApproval(systemEnvironment)));
    }

    public void setEnableApproval(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.enableApproval.equals(n)) {
            return;
        }
        SDMSSchedulingEntityGeneric sDMSSchedulingEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingEntity) Change of system object not allowed"));
        }
        if (sDMSSchedulingEntityGeneric.versions.o_v == null || sDMSSchedulingEntityGeneric.versions.o_v.size() == 0 || sDMSSchedulingEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingEntityGeneric = (SDMSSchedulingEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSchedulingEntityGeneric.enableApproval = n;
        sDMSSchedulingEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSchedulingEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingEntityGeneric != this) {
            sDMSSchedulingEntityGeneric.versions.table.index(systemEnvironment, sDMSSchedulingEntityGeneric, 0L);
        }
    }

    public Boolean getSetStateLeadFlag(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.setStateLeadFlag;
    }

    public void setSetStateLeadFlag(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (this.setStateLeadFlag.equals(bl)) {
            return;
        }
        SDMSSchedulingEntityGeneric sDMSSchedulingEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingEntity) Change of system object not allowed"));
        }
        if (sDMSSchedulingEntityGeneric.versions.o_v == null || sDMSSchedulingEntityGeneric.versions.o_v.size() == 0 || sDMSSchedulingEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingEntityGeneric = (SDMSSchedulingEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSchedulingEntityGeneric.setStateLeadFlag = bl;
        sDMSSchedulingEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSchedulingEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingEntityGeneric != this) {
            sDMSSchedulingEntityGeneric.versions.table.index(systemEnvironment, sDMSSchedulingEntityGeneric, 0L);
        }
    }

    public Integer getSetStateApproval(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.setStateApproval;
    }

    public String getSetStateApprovalAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getSetStateApproval(systemEnvironment);
        switch (n) {
            case 0: {
                return "DEFAULT";
            }
            case 1: {
                return "PARENT";
            }
            case 2: {
                return "NO";
            }
            case 5: {
                return "APPROVE";
            }
            case 4: {
                return "REVIEW";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown SchedulingEntity.setStateApproval: $1", this.getSetStateApproval(systemEnvironment)));
    }

    public void setSetStateApproval(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.setStateApproval.equals(n)) {
            return;
        }
        SDMSSchedulingEntityGeneric sDMSSchedulingEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingEntity) Change of system object not allowed"));
        }
        if (sDMSSchedulingEntityGeneric.versions.o_v == null || sDMSSchedulingEntityGeneric.versions.o_v.size() == 0 || sDMSSchedulingEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingEntityGeneric = (SDMSSchedulingEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSchedulingEntityGeneric.setStateApproval = n;
        sDMSSchedulingEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSchedulingEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingEntityGeneric != this) {
            sDMSSchedulingEntityGeneric.versions.table.index(systemEnvironment, sDMSSchedulingEntityGeneric, 0L);
        }
    }

    public Boolean getIgnDepLeadFlag(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.ignDepLeadFlag;
    }

    public void setIgnDepLeadFlag(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (this.ignDepLeadFlag.equals(bl)) {
            return;
        }
        SDMSSchedulingEntityGeneric sDMSSchedulingEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingEntity) Change of system object not allowed"));
        }
        if (sDMSSchedulingEntityGeneric.versions.o_v == null || sDMSSchedulingEntityGeneric.versions.o_v.size() == 0 || sDMSSchedulingEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingEntityGeneric = (SDMSSchedulingEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSchedulingEntityGeneric.ignDepLeadFlag = bl;
        sDMSSchedulingEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSchedulingEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingEntityGeneric != this) {
            sDMSSchedulingEntityGeneric.versions.table.index(systemEnvironment, sDMSSchedulingEntityGeneric, 0L);
        }
    }

    public Integer getIgnDepApproval(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.ignDepApproval;
    }

    public String getIgnDepApprovalAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getIgnDepApproval(systemEnvironment);
        switch (n) {
            case 0: {
                return "DEFAULT";
            }
            case 1: {
                return "PARENT";
            }
            case 2: {
                return "NO";
            }
            case 5: {
                return "APPROVE";
            }
            case 4: {
                return "REVIEW";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown SchedulingEntity.ignDepApproval: $1", this.getIgnDepApproval(systemEnvironment)));
    }

    public void setIgnDepApproval(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.ignDepApproval.equals(n)) {
            return;
        }
        SDMSSchedulingEntityGeneric sDMSSchedulingEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingEntity) Change of system object not allowed"));
        }
        if (sDMSSchedulingEntityGeneric.versions.o_v == null || sDMSSchedulingEntityGeneric.versions.o_v.size() == 0 || sDMSSchedulingEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingEntityGeneric = (SDMSSchedulingEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSchedulingEntityGeneric.ignDepApproval = n;
        sDMSSchedulingEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSchedulingEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingEntityGeneric != this) {
            sDMSSchedulingEntityGeneric.versions.table.index(systemEnvironment, sDMSSchedulingEntityGeneric, 0L);
        }
    }

    public Boolean getIgnRssLeadFlag(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.ignRssLeadFlag;
    }

    public void setIgnRssLeadFlag(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (this.ignRssLeadFlag.equals(bl)) {
            return;
        }
        SDMSSchedulingEntityGeneric sDMSSchedulingEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingEntity) Change of system object not allowed"));
        }
        if (sDMSSchedulingEntityGeneric.versions.o_v == null || sDMSSchedulingEntityGeneric.versions.o_v.size() == 0 || sDMSSchedulingEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingEntityGeneric = (SDMSSchedulingEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSchedulingEntityGeneric.ignRssLeadFlag = bl;
        sDMSSchedulingEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSchedulingEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingEntityGeneric != this) {
            sDMSSchedulingEntityGeneric.versions.table.index(systemEnvironment, sDMSSchedulingEntityGeneric, 0L);
        }
    }

    public Integer getIgnRssApproval(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.ignRssApproval;
    }

    public String getIgnRssApprovalAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getIgnRssApproval(systemEnvironment);
        switch (n) {
            case 0: {
                return "DEFAULT";
            }
            case 1: {
                return "PARENT";
            }
            case 2: {
                return "NO";
            }
            case 5: {
                return "APPROVE";
            }
            case 4: {
                return "REVIEW";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown SchedulingEntity.ignRssApproval: $1", this.getIgnRssApproval(systemEnvironment)));
    }

    public void setIgnRssApproval(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.ignRssApproval.equals(n)) {
            return;
        }
        SDMSSchedulingEntityGeneric sDMSSchedulingEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingEntity) Change of system object not allowed"));
        }
        if (sDMSSchedulingEntityGeneric.versions.o_v == null || sDMSSchedulingEntityGeneric.versions.o_v.size() == 0 || sDMSSchedulingEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingEntityGeneric = (SDMSSchedulingEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSchedulingEntityGeneric.ignRssApproval = n;
        sDMSSchedulingEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSchedulingEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingEntityGeneric != this) {
            sDMSSchedulingEntityGeneric.versions.table.index(systemEnvironment, sDMSSchedulingEntityGeneric, 0L);
        }
    }

    public Boolean getCloneLeadFlag(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.cloneLeadFlag;
    }

    public void setCloneLeadFlag(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (this.cloneLeadFlag.equals(bl)) {
            return;
        }
        SDMSSchedulingEntityGeneric sDMSSchedulingEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingEntity) Change of system object not allowed"));
        }
        if (sDMSSchedulingEntityGeneric.versions.o_v == null || sDMSSchedulingEntityGeneric.versions.o_v.size() == 0 || sDMSSchedulingEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingEntityGeneric = (SDMSSchedulingEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSchedulingEntityGeneric.cloneLeadFlag = bl;
        sDMSSchedulingEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSchedulingEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingEntityGeneric != this) {
            sDMSSchedulingEntityGeneric.versions.table.index(systemEnvironment, sDMSSchedulingEntityGeneric, 0L);
        }
    }

    public Integer getCloneApproval(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.cloneApproval;
    }

    public String getCloneApprovalAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getCloneApproval(systemEnvironment);
        switch (n) {
            case 0: {
                return "DEFAULT";
            }
            case 1: {
                return "PARENT";
            }
            case 2: {
                return "NO";
            }
            case 5: {
                return "APPROVE";
            }
            case 4: {
                return "REVIEW";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown SchedulingEntity.cloneApproval: $1", this.getCloneApproval(systemEnvironment)));
    }

    public void setCloneApproval(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.cloneApproval.equals(n)) {
            return;
        }
        SDMSSchedulingEntityGeneric sDMSSchedulingEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingEntity) Change of system object not allowed"));
        }
        if (sDMSSchedulingEntityGeneric.versions.o_v == null || sDMSSchedulingEntityGeneric.versions.o_v.size() == 0 || sDMSSchedulingEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingEntityGeneric = (SDMSSchedulingEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSchedulingEntityGeneric.cloneApproval = n;
        sDMSSchedulingEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSchedulingEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingEntityGeneric != this) {
            sDMSSchedulingEntityGeneric.versions.table.index(systemEnvironment, sDMSSchedulingEntityGeneric, 0L);
        }
    }

    public Boolean getEditParmLeadFlag(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.editParmLeadFlag;
    }

    public void setEditParmLeadFlag(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (this.editParmLeadFlag.equals(bl)) {
            return;
        }
        SDMSSchedulingEntityGeneric sDMSSchedulingEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingEntity) Change of system object not allowed"));
        }
        if (sDMSSchedulingEntityGeneric.versions.o_v == null || sDMSSchedulingEntityGeneric.versions.o_v.size() == 0 || sDMSSchedulingEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingEntityGeneric = (SDMSSchedulingEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSchedulingEntityGeneric.editParmLeadFlag = bl;
        sDMSSchedulingEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSchedulingEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingEntityGeneric != this) {
            sDMSSchedulingEntityGeneric.versions.table.index(systemEnvironment, sDMSSchedulingEntityGeneric, 0L);
        }
    }

    public Integer getEditParmApproval(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.editParmApproval;
    }

    public String getEditParmApprovalAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getEditParmApproval(systemEnvironment);
        switch (n) {
            case 0: {
                return "DEFAULT";
            }
            case 1: {
                return "PARENT";
            }
            case 2: {
                return "NO";
            }
            case 5: {
                return "APPROVE";
            }
            case 4: {
                return "REVIEW";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown SchedulingEntity.editParmApproval: $1", this.getEditParmApproval(systemEnvironment)));
    }

    public void setEditParmApproval(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.editParmApproval.equals(n)) {
            return;
        }
        SDMSSchedulingEntityGeneric sDMSSchedulingEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingEntity) Change of system object not allowed"));
        }
        if (sDMSSchedulingEntityGeneric.versions.o_v == null || sDMSSchedulingEntityGeneric.versions.o_v.size() == 0 || sDMSSchedulingEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingEntityGeneric = (SDMSSchedulingEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSchedulingEntityGeneric.editParmApproval = n;
        sDMSSchedulingEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSchedulingEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingEntityGeneric != this) {
            sDMSSchedulingEntityGeneric.versions.table.index(systemEnvironment, sDMSSchedulingEntityGeneric, 0L);
        }
    }

    public Boolean getKillLeadFlag(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.killLeadFlag;
    }

    public void setKillLeadFlag(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (this.killLeadFlag.equals(bl)) {
            return;
        }
        SDMSSchedulingEntityGeneric sDMSSchedulingEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingEntity) Change of system object not allowed"));
        }
        if (sDMSSchedulingEntityGeneric.versions.o_v == null || sDMSSchedulingEntityGeneric.versions.o_v.size() == 0 || sDMSSchedulingEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingEntityGeneric = (SDMSSchedulingEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSchedulingEntityGeneric.killLeadFlag = bl;
        sDMSSchedulingEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSchedulingEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingEntityGeneric != this) {
            sDMSSchedulingEntityGeneric.versions.table.index(systemEnvironment, sDMSSchedulingEntityGeneric, 0L);
        }
    }

    public Integer getKillApproval(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.killApproval;
    }

    public String getKillApprovalAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getKillApproval(systemEnvironment);
        switch (n) {
            case 0: {
                return "DEFAULT";
            }
            case 1: {
                return "PARENT";
            }
            case 2: {
                return "NO";
            }
            case 5: {
                return "APPROVE";
            }
            case 4: {
                return "REVIEW";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown SchedulingEntity.killApproval: $1", this.getKillApproval(systemEnvironment)));
    }

    public void setKillApproval(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.killApproval.equals(n)) {
            return;
        }
        SDMSSchedulingEntityGeneric sDMSSchedulingEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingEntity) Change of system object not allowed"));
        }
        if (sDMSSchedulingEntityGeneric.versions.o_v == null || sDMSSchedulingEntityGeneric.versions.o_v.size() == 0 || sDMSSchedulingEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingEntityGeneric = (SDMSSchedulingEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSchedulingEntityGeneric.killApproval = n;
        sDMSSchedulingEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSchedulingEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingEntityGeneric != this) {
            sDMSSchedulingEntityGeneric.versions.table.index(systemEnvironment, sDMSSchedulingEntityGeneric, 0L);
        }
    }

    public Boolean getSetJobStateLeadFlag(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.setJobStateLeadFlag;
    }

    public void setSetJobStateLeadFlag(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (this.setJobStateLeadFlag.equals(bl)) {
            return;
        }
        SDMSSchedulingEntityGeneric sDMSSchedulingEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingEntity) Change of system object not allowed"));
        }
        if (sDMSSchedulingEntityGeneric.versions.o_v == null || sDMSSchedulingEntityGeneric.versions.o_v.size() == 0 || sDMSSchedulingEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingEntityGeneric = (SDMSSchedulingEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSchedulingEntityGeneric.setJobStateLeadFlag = bl;
        sDMSSchedulingEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSchedulingEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingEntityGeneric != this) {
            sDMSSchedulingEntityGeneric.versions.table.index(systemEnvironment, sDMSSchedulingEntityGeneric, 0L);
        }
    }

    public Integer getSetJobStateApproval(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.setJobStateApproval;
    }

    public String getSetJobStateApprovalAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getSetJobStateApproval(systemEnvironment);
        switch (n) {
            case 0: {
                return "DEFAULT";
            }
            case 1: {
                return "PARENT";
            }
            case 2: {
                return "NO";
            }
            case 5: {
                return "APPROVE";
            }
            case 4: {
                return "REVIEW";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown SchedulingEntity.setJobStateApproval: $1", this.getSetJobStateApproval(systemEnvironment)));
    }

    public void setSetJobStateApproval(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.setJobStateApproval.equals(n)) {
            return;
        }
        SDMSSchedulingEntityGeneric sDMSSchedulingEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingEntity) Change of system object not allowed"));
        }
        if (sDMSSchedulingEntityGeneric.versions.o_v == null || sDMSSchedulingEntityGeneric.versions.o_v.size() == 0 || sDMSSchedulingEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingEntityGeneric = (SDMSSchedulingEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSchedulingEntityGeneric.setJobStateApproval = n;
        sDMSSchedulingEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSchedulingEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingEntityGeneric != this) {
            sDMSSchedulingEntityGeneric.versions.table.index(systemEnvironment, sDMSSchedulingEntityGeneric, 0L);
        }
    }

    public Long getInheritPrivs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.inheritPrivs;
    }

    public void setInheritPrivs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.inheritPrivs.equals(l)) {
            return;
        }
        SDMSSchedulingEntityGeneric sDMSSchedulingEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingEntity) Change of system object not allowed"));
        }
        if (sDMSSchedulingEntityGeneric.versions.o_v == null || sDMSSchedulingEntityGeneric.versions.o_v.size() == 0 || sDMSSchedulingEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingEntityGeneric = (SDMSSchedulingEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSchedulingEntityGeneric.inheritPrivs = l;
        sDMSSchedulingEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSchedulingEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingEntityGeneric != this) {
            sDMSSchedulingEntityGeneric.versions.table.index(systemEnvironment, sDMSSchedulingEntityGeneric, 0L);
        }
    }

    public Long getCreatorUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.creatorUId;
    }

    void setCreatorUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.creatorUId.equals(l)) {
            return;
        }
        SDMSSchedulingEntityGeneric sDMSSchedulingEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingEntity) Change of system object not allowed"));
        }
        if (sDMSSchedulingEntityGeneric.versions.o_v == null || sDMSSchedulingEntityGeneric.versions.o_v.size() == 0 || sDMSSchedulingEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingEntityGeneric = (SDMSSchedulingEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSchedulingEntityGeneric.creatorUId = l;
        sDMSSchedulingEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSchedulingEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingEntityGeneric != this) {
            sDMSSchedulingEntityGeneric.versions.table.index(systemEnvironment, sDMSSchedulingEntityGeneric, 0L);
        }
    }

    public Long getCreateTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.createTs;
    }

    void setCreateTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.createTs.equals(l)) {
            return;
        }
        SDMSSchedulingEntityGeneric sDMSSchedulingEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingEntity) Change of system object not allowed"));
        }
        if (sDMSSchedulingEntityGeneric.versions.o_v == null || sDMSSchedulingEntityGeneric.versions.o_v.size() == 0 || sDMSSchedulingEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingEntityGeneric = (SDMSSchedulingEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSchedulingEntityGeneric.createTs = l;
        sDMSSchedulingEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSchedulingEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingEntityGeneric != this) {
            sDMSSchedulingEntityGeneric.versions.table.index(systemEnvironment, sDMSSchedulingEntityGeneric, 0L);
        }
    }

    public Long getChangerUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changerUId;
    }

    public void setChangerUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        SDMSSchedulingEntityGeneric sDMSSchedulingEntityGeneric = this;
        if (sDMSSchedulingEntityGeneric.versions.o_v == null || sDMSSchedulingEntityGeneric.versions.o_v.size() == 0 || sDMSSchedulingEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingEntityGeneric = (SDMSSchedulingEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSchedulingEntityGeneric.changerUId = l;
        sDMSSchedulingEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingEntityGeneric != this) {
            sDMSSchedulingEntityGeneric.versions.table.index(systemEnvironment, sDMSSchedulingEntityGeneric, 0L);
        }
    }

    public Long getChangeTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changeTs;
    }

    void setChangeTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.changeTs.equals(l)) {
            return;
        }
        SDMSSchedulingEntityGeneric sDMSSchedulingEntityGeneric = this;
        if (sDMSSchedulingEntityGeneric.versions.o_v == null || sDMSSchedulingEntityGeneric.versions.o_v.size() == 0 || sDMSSchedulingEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingEntityGeneric = (SDMSSchedulingEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSchedulingEntityGeneric.changeTs = l;
        sDMSSchedulingEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        if (sDMSSchedulingEntityGeneric != this) {
            sDMSSchedulingEntityGeneric.versions.table.index(systemEnvironment, sDMSSchedulingEntityGeneric, 0L);
        }
    }

    public SDMSSchedulingEntityGeneric set_FolderIdName(SystemEnvironment systemEnvironment, Long l, String string) throws SDMSException {
        SDMSSchedulingEntityGeneric sDMSSchedulingEntityGeneric;
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141637", "(SchedulingEntity) Change of system object not allowed"));
            }
            sDMSSchedulingEntityGeneric = (SDMSSchedulingEntityGeneric)this.change(systemEnvironment);
            sDMSSchedulingEntityGeneric.folderId = l;
            if (string != null && string.length() > 64) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01201290026", "(SchedulingEntity) Length of $1 exceeds maximum length $2", "changeTs", "64"));
            }
            sDMSSchedulingEntityGeneric.name = string;
            sDMSSchedulingEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSSchedulingEntityGeneric.changeTs = systemEnvironment.txTime();
            sDMSSchedulingEntityGeneric.versions.table.index(systemEnvironment, sDMSSchedulingEntityGeneric);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        return sDMSSchedulingEntityGeneric;
    }

    public SDMSSchedulingEntityGeneric set_FolderIdMasterSubmittable(SystemEnvironment systemEnvironment, Long l, Boolean bl) throws SDMSException {
        SDMSSchedulingEntityGeneric sDMSSchedulingEntityGeneric;
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141637", "(SchedulingEntity) Change of system object not allowed"));
            }
            sDMSSchedulingEntityGeneric = (SDMSSchedulingEntityGeneric)this.change(systemEnvironment);
            sDMSSchedulingEntityGeneric.folderId = l;
            sDMSSchedulingEntityGeneric.masterSubmittable = bl;
            sDMSSchedulingEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSSchedulingEntityGeneric.changeTs = systemEnvironment.txTime();
            sDMSSchedulingEntityGeneric.versions.table.index(systemEnvironment, sDMSSchedulingEntityGeneric);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        return sDMSSchedulingEntityGeneric;
    }

    @Override
    protected SDMSProxy toProxy(SystemEnvironment systemEnvironment) {
        return new SDMSSchedulingEntity(this);
    }

    protected SDMSSchedulingEntityGeneric(Long l, String string, Long l2, Long l3, Integer n, String string2, String string3, String string4, String string5, String string6, Boolean bl, String string7, Boolean bl2, Integer n2, Integer n3, String string8, Integer n4, Integer n5, Integer n6, Integer n7, Boolean bl3, String string9, Integer n8, Integer n9, Boolean bl4, Integer n10, Integer n11, Long l4, Boolean bl5, Boolean bl6, Integer n12, Long l5, Long l6, Long l7, Long l8, Long l9, Boolean bl7, Integer n13, Boolean bl8, Integer n14, Boolean bl9, Integer n15, Boolean bl10, Integer n16, Boolean bl11, Integer n17, Boolean bl12, Integer n18, Boolean bl13, Integer n19, Boolean bl14, Integer n20, Boolean bl15, Integer n21, Boolean bl16, Integer n22, Long l10, Long l11, Long l12, Long l13, Long l14, long l15, long l16) {
        this.id = l;
        this.name = string;
        this.folderId = l2;
        this.ownerId = l3;
        this.type = n;
        this.runProgram = string2;
        this.rerunProgram = string3;
        this.killProgram = string4;
        this.workdir = string5;
        this.logfile = string6;
        this.truncLog = bl;
        this.errlogfile = string7;
        this.truncErrlog = bl2;
        this.expectedRuntime = n2;
        this.expectedFinaltime = n3;
        this.getExpectedRuntime = string8;
        this.priority = n4;
        this.minPriority = n5;
        this.agingAmount = n6;
        this.agingBase = n7;
        this.submitSuspended = bl3;
        this.resumeAt = string9;
        this.resumeIn = n8;
        this.resumeBase = n9;
        this.masterSubmittable = bl4;
        this.timeoutAmount = n10;
        this.timeoutBase = n11;
        this.timeoutStateId = l4;
        this.sameNode = bl5;
        this.gangSchedule = bl6;
        this.dependencyOperation = n12;
        this.esmpId = l5;
        this.espId = l6;
        this.qaId = l7;
        this.neId = l8;
        this.fpId = l9;
        this.cancelLeadFlag = bl7;
        this.cancelApproval = n13;
        this.rerunLeadFlag = bl8;
        this.rerunApproval = n14;
        this.enableLeadFlag = bl9;
        this.enableApproval = n15;
        this.setStateLeadFlag = bl10;
        this.setStateApproval = n16;
        this.ignDepLeadFlag = bl11;
        this.ignDepApproval = n17;
        this.ignRssLeadFlag = bl12;
        this.ignRssApproval = n18;
        this.cloneLeadFlag = bl13;
        this.cloneApproval = n19;
        this.editParmLeadFlag = bl14;
        this.editParmApproval = n20;
        this.killLeadFlag = bl15;
        this.killApproval = n21;
        this.setJobStateLeadFlag = bl16;
        this.setJobStateApproval = n22;
        this.inheritPrivs = l10;
        this.creatorUId = l11;
        this.createTs = l12;
        this.changerUId = l13;
        this.changeTs = l14;
        this.validFrom = l15;
        this.validTo = l16;
    }

    protected String tableName() {
        return tableName;
    }

    @Override
    protected void insertDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pInsert[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "INSERT INTO " + string2 + "SCHEDULING_ENTITY" + string3 + " (ID, " + string2 + "NAME" + string3 + ", " + string2 + "FOLDER_ID" + string3 + ", " + string2 + "OWNER_ID" + string3 + ", " + string2 + "TYPE" + string3 + ", " + string2 + "RUN_PROGRAM" + string3 + ", " + string2 + "RERUN_PROGRAM" + string3 + ", " + string2 + "KILL_PROGRAM" + string3 + ", " + string2 + "WORKDIR" + string3 + ", " + string2 + "LOGFILE" + string3 + ", " + string2 + "TRUNC_LOG" + string3 + ", " + string2 + "ERRLOGFILE" + string3 + ", " + string2 + "TRUNC_ERRLOG" + string3 + ", " + string2 + "EXPECTED_RUNTIME" + string3 + ", " + string2 + "EXPECTED_FINALTIME" + string3 + ", " + string2 + "GET_EXPECTED_RUNTIME" + string3 + ", " + string2 + "PRIORITY" + string3 + ", " + string2 + "MIN_PRIORITY" + string3 + ", " + string2 + "AGING_AMOUNT" + string3 + ", " + string2 + "AGING_BASE" + string3 + ", " + string2 + "SUBMIT_SUSPENDED" + string3 + ", " + string2 + "RESUME_AT" + string3 + ", " + string2 + "RESUME_IN" + string3 + ", " + string2 + "RESUME_BASE" + string3 + ", " + string2 + "MASTER_SUBMITTABLE" + string3 + ", " + string2 + "TIMEOUT_AMOUNT" + string3 + ", " + string2 + "TIMEOUT_BASE" + string3 + ", " + string2 + "TIMEOUT_STATE_ID" + string3 + ", " + string2 + "SAME_NODE" + string3 + ", " + string2 + "GANG_SCHEDULE" + string3 + ", " + string2 + "DEPENDENCY_OPERATION" + string3 + ", " + string2 + "ESMP_ID" + string3 + ", " + string2 + "ESP_ID" + string3 + ", " + string2 + "QA_ID" + string3 + ", " + string2 + "NE_ID" + string3 + ", " + string2 + "FP_ID" + string3 + ", " + string2 + "CANCEL_LEAD_FLAG" + string3 + ", " + string2 + "CANCEL_APPROVAL" + string3 + ", " + string2 + "RERUN_LEAD_FLAG" + string3 + ", " + string2 + "RERUN_APPROVAL" + string3 + ", " + string2 + "ENABLE_LEAD_FLAG" + string3 + ", " + string2 + "ENABLE_APPROVAL" + string3 + ", " + string2 + "SET_STATE_LEAD_FLAG" + string3 + ", " + string2 + "SET_STATE_APPROVAL" + string3 + ", " + string2 + "IGN_DEP_LEAD_FLAG" + string3 + ", " + string2 + "IGN_DEP_APPROVAL" + string3 + ", " + string2 + "IGN_RSS_LEAD_FLAG" + string3 + ", " + string2 + "IGN_RSS_APPROVAL" + string3 + ", " + string2 + "CLONE_LEAD_FLAG" + string3 + ", " + string2 + "CLONE_APPROVAL" + string3 + ", " + string2 + "EDIT_PARM_LEAD_FLAG" + string3 + ", " + string2 + "EDIT_PARM_APPROVAL" + string3 + ", " + string2 + "KILL_LEAD_FLAG" + string3 + ", " + string2 + "KILL_APPROVAL" + string3 + ", " + string2 + "SET_JOB_STATE_LEAD_FLAG" + string3 + ", " + string2 + "SET_JOB_STATE_APPROVAL" + string3 + ", " + string2 + "INHERIT_PRIVS" + string3 + ", " + string2 + "CREATOR_U_ID" + string3 + ", " + string2 + "CREATE_TS" + string3 + ", " + string2 + "CHANGER_U_ID" + string3 + ", " + string2 + "CHANGE_TS" + string3 + ", VALID_FROM, VALID_TO) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                SDMSSchedulingEntityGeneric.pInsert[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110181952", "SchedulingEntity: $1\n$2", string, sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pInsert[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.setString(2, this.name);
            preparedStatement.setLong(3, this.folderId);
            preparedStatement.setLong(4, this.ownerId);
            preparedStatement.setInt(5, this.type);
            if (this.runProgram == null) {
                preparedStatement.setNull(6, 12);
            } else {
                preparedStatement.setString(6, this.runProgram);
            }
            if (this.rerunProgram == null) {
                preparedStatement.setNull(7, 12);
            } else {
                preparedStatement.setString(7, this.rerunProgram);
            }
            if (this.killProgram == null) {
                preparedStatement.setNull(8, 12);
            } else {
                preparedStatement.setString(8, this.killProgram);
            }
            if (this.workdir == null) {
                preparedStatement.setNull(9, 12);
            } else {
                preparedStatement.setString(9, this.workdir);
            }
            if (this.logfile == null) {
                preparedStatement.setNull(10, 12);
            } else {
                preparedStatement.setString(10, this.logfile);
            }
            if (this.truncLog == null) {
                preparedStatement.setNull(11, 4);
            } else {
                preparedStatement.setInt(11, this.truncLog != false ? 1 : 0);
            }
            if (this.errlogfile == null) {
                preparedStatement.setNull(12, 12);
            } else {
                preparedStatement.setString(12, this.errlogfile);
            }
            if (this.truncErrlog == null) {
                preparedStatement.setNull(13, 4);
            } else {
                preparedStatement.setInt(13, this.truncErrlog != false ? 1 : 0);
            }
            if (this.expectedRuntime == null) {
                preparedStatement.setNull(14, 4);
            } else {
                preparedStatement.setInt(14, this.expectedRuntime);
            }
            if (this.expectedFinaltime == null) {
                preparedStatement.setNull(15, 4);
            } else {
                preparedStatement.setInt(15, this.expectedFinaltime);
            }
            if (this.getExpectedRuntime == null) {
                preparedStatement.setNull(16, 12);
            } else {
                preparedStatement.setString(16, this.getExpectedRuntime);
            }
            preparedStatement.setInt(17, this.priority);
            if (this.minPriority == null) {
                preparedStatement.setNull(18, 4);
            } else {
                preparedStatement.setInt(18, this.minPriority);
            }
            if (this.agingAmount == null) {
                preparedStatement.setNull(19, 4);
            } else {
                preparedStatement.setInt(19, this.agingAmount);
            }
            if (this.agingBase == null) {
                preparedStatement.setNull(20, 4);
            } else {
                preparedStatement.setInt(20, this.agingBase);
            }
            preparedStatement.setInt(21, this.submitSuspended != false ? 1 : 0);
            if (this.resumeAt == null) {
                preparedStatement.setNull(22, 12);
            } else {
                preparedStatement.setString(22, this.resumeAt);
            }
            if (this.resumeIn == null) {
                preparedStatement.setNull(23, 4);
            } else {
                preparedStatement.setInt(23, this.resumeIn);
            }
            if (this.resumeBase == null) {
                preparedStatement.setNull(24, 4);
            } else {
                preparedStatement.setInt(24, this.resumeBase);
            }
            preparedStatement.setInt(25, this.masterSubmittable != false ? 1 : 0);
            if (this.timeoutAmount == null) {
                preparedStatement.setNull(26, 4);
            } else {
                preparedStatement.setInt(26, this.timeoutAmount);
            }
            if (this.timeoutBase == null) {
                preparedStatement.setNull(27, 4);
            } else {
                preparedStatement.setInt(27, this.timeoutBase);
            }
            if (this.timeoutStateId == null) {
                preparedStatement.setNull(28, 4);
            } else {
                preparedStatement.setLong(28, this.timeoutStateId);
            }
            if (this.sameNode == null) {
                preparedStatement.setNull(29, 4);
            } else {
                preparedStatement.setInt(29, this.sameNode != false ? 1 : 0);
            }
            if (this.gangSchedule == null) {
                preparedStatement.setNull(30, 4);
            } else {
                preparedStatement.setInt(30, this.gangSchedule != false ? 1 : 0);
            }
            preparedStatement.setInt(31, this.dependencyOperation);
            if (this.esmpId == null) {
                preparedStatement.setNull(32, 4);
            } else {
                preparedStatement.setLong(32, this.esmpId);
            }
            if (this.espId == null) {
                preparedStatement.setNull(33, 4);
            } else {
                preparedStatement.setLong(33, this.espId);
            }
            if (this.qaId == null) {
                preparedStatement.setNull(34, 4);
            } else {
                preparedStatement.setLong(34, this.qaId);
            }
            if (this.neId == null) {
                preparedStatement.setNull(35, 4);
            } else {
                preparedStatement.setLong(35, this.neId);
            }
            if (this.fpId == null) {
                preparedStatement.setNull(36, 4);
            } else {
                preparedStatement.setLong(36, this.fpId);
            }
            preparedStatement.setInt(37, this.cancelLeadFlag != false ? 1 : 0);
            preparedStatement.setInt(38, this.cancelApproval);
            preparedStatement.setInt(39, this.rerunLeadFlag != false ? 1 : 0);
            preparedStatement.setInt(40, this.rerunApproval);
            preparedStatement.setInt(41, this.enableLeadFlag != false ? 1 : 0);
            preparedStatement.setInt(42, this.enableApproval);
            preparedStatement.setInt(43, this.setStateLeadFlag != false ? 1 : 0);
            preparedStatement.setInt(44, this.setStateApproval);
            preparedStatement.setInt(45, this.ignDepLeadFlag != false ? 1 : 0);
            preparedStatement.setInt(46, this.ignDepApproval);
            preparedStatement.setInt(47, this.ignRssLeadFlag != false ? 1 : 0);
            preparedStatement.setInt(48, this.ignRssApproval);
            preparedStatement.setInt(49, this.cloneLeadFlag != false ? 1 : 0);
            preparedStatement.setInt(50, this.cloneApproval);
            preparedStatement.setInt(51, this.editParmLeadFlag != false ? 1 : 0);
            preparedStatement.setInt(52, this.editParmApproval);
            preparedStatement.setInt(53, this.killLeadFlag != false ? 1 : 0);
            preparedStatement.setInt(54, this.killApproval);
            preparedStatement.setInt(55, this.setJobStateLeadFlag != false ? 1 : 0);
            preparedStatement.setInt(56, this.setJobStateApproval);
            preparedStatement.setLong(57, this.inheritPrivs);
            preparedStatement.setLong(58, this.creatorUId);
            preparedStatement.setLong(59, this.createTs);
            preparedStatement.setLong(60, this.changerUId);
            preparedStatement.setLong(61, this.changeTs);
            preparedStatement.setLong(62, systemEnvironment.tx.versionId);
            preparedStatement.setLong(63, Long.MAX_VALUE);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110181954", "SchedulingEntity: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
    }

    @Override
    protected void updateDBObject(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.closeDBObject(systemEnvironment);
        this.insertDBObject(systemEnvironment);
    }

    @Override
    protected void deleteDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        this.closeDBObject(systemEnvironment);
    }

    private void closeDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pUpdate[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = systemEnvironment.dbConnection.getMetaData().getDriverName();
                boolean bl = string2.startsWith("PostgreSQL");
                String string3 = SystemEnvironment.SQUOTE;
                String string4 = SystemEnvironment.EQUOTE;
                string = "UPDATE " + string3 + "SCHEDULING_ENTITY" + string4 + " SET VALID_TO = ?,     CHANGE_TS = ?,     CHANGER_U_ID = ? WHERE ID = ?  AND VALID_TO = " + (bl ? "CAST ('9223372036854775807' AS DECIMAL)" : "9223372036854775807");
                SDMSSchedulingEntityGeneric.pUpdate[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110181955", "SchedulingEntity : $1\n$2", string, sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pUpdate[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, systemEnvironment.tx.versionId);
            preparedStatement.setLong(2, this.changeTs);
            preparedStatement.setLong(3, this.changerUId);
            preparedStatement.setLong(4, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110181956", "SchedulingEntity: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
    }

    public static boolean checkType(Integer n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public static boolean checkTruncLog(Boolean bl) {
        if (bl == null) {
            return true;
        }
        if (!bl.booleanValue()) {
            return true;
        }
        return bl == true;
    }

    public static boolean checkTruncErrlog(Boolean bl) {
        if (bl == null) {
            return true;
        }
        if (!bl.booleanValue()) {
            return true;
        }
        return bl == true;
    }

    public static boolean checkAgingBase(Integer n) {
        if (n == null) {
            return true;
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public static boolean checkSubmitSuspended(Boolean bl) {
        if (bl.booleanValue()) {
            return true;
        }
        return bl == false;
    }

    public static boolean checkResumeBase(Integer n) {
        if (n == null) {
            return true;
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public static boolean checkMasterSubmittable(Boolean bl) {
        if (bl.booleanValue()) {
            return true;
        }
        return bl == false;
    }

    public static boolean checkTimeoutBase(Integer n) {
        if (n == null) {
            return true;
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public static boolean checkSameNode(Boolean bl) {
        if (bl == null) {
            return true;
        }
        if (bl.booleanValue()) {
            return true;
        }
        return bl == false;
    }

    public static boolean checkGangSchedule(Boolean bl) {
        if (bl == null) {
            return true;
        }
        if (bl.booleanValue()) {
            return true;
        }
        return bl == false;
    }

    public static boolean checkDependencyOperation(Integer n) {
        switch (n) {
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    public static boolean checkCancelApproval(Integer n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public static boolean checkRerunApproval(Integer n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public static boolean checkEnableApproval(Integer n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public static boolean checkSetStateApproval(Integer n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public static boolean checkIgnDepApproval(Integer n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public static boolean checkIgnRssApproval(Integer n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public static boolean checkCloneApproval(Integer n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public static boolean checkEditParmApproval(Integer n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public static boolean checkKillApproval(Integer n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public static boolean checkSetJobStateApproval(Integer n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void print() {
        SDMSThread.doTrace(null, "Type : SchedulingEntity", 2);
        SDMSThread.doTrace(null, "id : " + this.id, 2);
        SDMSThread.doTrace(null, "name : " + this.name, 2);
        SDMSThread.doTrace(null, "folderId : " + this.folderId, 2);
        SDMSThread.doTrace(null, "ownerId : " + this.ownerId, 2);
        SDMSThread.doTrace(null, "type : " + this.type, 2);
        SDMSThread.doTrace(null, "runProgram : " + this.runProgram, 2);
        SDMSThread.doTrace(null, "rerunProgram : " + this.rerunProgram, 2);
        SDMSThread.doTrace(null, "killProgram : " + this.killProgram, 2);
        SDMSThread.doTrace(null, "workdir : " + this.workdir, 2);
        SDMSThread.doTrace(null, "logfile : " + this.logfile, 2);
        SDMSThread.doTrace(null, "truncLog : " + this.truncLog, 2);
        SDMSThread.doTrace(null, "errlogfile : " + this.errlogfile, 2);
        SDMSThread.doTrace(null, "truncErrlog : " + this.truncErrlog, 2);
        SDMSThread.doTrace(null, "expectedRuntime : " + this.expectedRuntime, 2);
        SDMSThread.doTrace(null, "expectedFinaltime : " + this.expectedFinaltime, 2);
        SDMSThread.doTrace(null, "getExpectedRuntime : " + this.getExpectedRuntime, 2);
        SDMSThread.doTrace(null, "priority : " + this.priority, 2);
        SDMSThread.doTrace(null, "minPriority : " + this.minPriority, 2);
        SDMSThread.doTrace(null, "agingAmount : " + this.agingAmount, 2);
        SDMSThread.doTrace(null, "agingBase : " + this.agingBase, 2);
        SDMSThread.doTrace(null, "submitSuspended : " + this.submitSuspended, 2);
        SDMSThread.doTrace(null, "resumeAt : " + this.resumeAt, 2);
        SDMSThread.doTrace(null, "resumeIn : " + this.resumeIn, 2);
        SDMSThread.doTrace(null, "resumeBase : " + this.resumeBase, 2);
        SDMSThread.doTrace(null, "masterSubmittable : " + this.masterSubmittable, 2);
        SDMSThread.doTrace(null, "timeoutAmount : " + this.timeoutAmount, 2);
        SDMSThread.doTrace(null, "timeoutBase : " + this.timeoutBase, 2);
        SDMSThread.doTrace(null, "timeoutStateId : " + this.timeoutStateId, 2);
        SDMSThread.doTrace(null, "sameNode : " + this.sameNode, 2);
        SDMSThread.doTrace(null, "gangSchedule : " + this.gangSchedule, 2);
        SDMSThread.doTrace(null, "dependencyOperation : " + this.dependencyOperation, 2);
        SDMSThread.doTrace(null, "esmpId : " + this.esmpId, 2);
        SDMSThread.doTrace(null, "espId : " + this.espId, 2);
        SDMSThread.doTrace(null, "qaId : " + this.qaId, 2);
        SDMSThread.doTrace(null, "neId : " + this.neId, 2);
        SDMSThread.doTrace(null, "fpId : " + this.fpId, 2);
        SDMSThread.doTrace(null, "cancelLeadFlag : " + this.cancelLeadFlag, 2);
        SDMSThread.doTrace(null, "cancelApproval : " + this.cancelApproval, 2);
        SDMSThread.doTrace(null, "rerunLeadFlag : " + this.rerunLeadFlag, 2);
        SDMSThread.doTrace(null, "rerunApproval : " + this.rerunApproval, 2);
        SDMSThread.doTrace(null, "enableLeadFlag : " + this.enableLeadFlag, 2);
        SDMSThread.doTrace(null, "enableApproval : " + this.enableApproval, 2);
        SDMSThread.doTrace(null, "setStateLeadFlag : " + this.setStateLeadFlag, 2);
        SDMSThread.doTrace(null, "setStateApproval : " + this.setStateApproval, 2);
        SDMSThread.doTrace(null, "ignDepLeadFlag : " + this.ignDepLeadFlag, 2);
        SDMSThread.doTrace(null, "ignDepApproval : " + this.ignDepApproval, 2);
        SDMSThread.doTrace(null, "ignRssLeadFlag : " + this.ignRssLeadFlag, 2);
        SDMSThread.doTrace(null, "ignRssApproval : " + this.ignRssApproval, 2);
        SDMSThread.doTrace(null, "cloneLeadFlag : " + this.cloneLeadFlag, 2);
        SDMSThread.doTrace(null, "cloneApproval : " + this.cloneApproval, 2);
        SDMSThread.doTrace(null, "editParmLeadFlag : " + this.editParmLeadFlag, 2);
        SDMSThread.doTrace(null, "editParmApproval : " + this.editParmApproval, 2);
        SDMSThread.doTrace(null, "killLeadFlag : " + this.killLeadFlag, 2);
        SDMSThread.doTrace(null, "killApproval : " + this.killApproval, 2);
        SDMSThread.doTrace(null, "setJobStateLeadFlag : " + this.setJobStateLeadFlag, 2);
        SDMSThread.doTrace(null, "setJobStateApproval : " + this.setJobStateApproval, 2);
        SDMSThread.doTrace(null, "inheritPrivs : " + this.inheritPrivs, 2);
        SDMSThread.doTrace(null, "creatorUId : " + this.creatorUId, 2);
        SDMSThread.doTrace(null, "createTs : " + this.createTs, 2);
        SDMSThread.doTrace(null, "changerUId : " + this.changerUId, 2);
        SDMSThread.doTrace(null, "changeTs : " + this.changeTs, 2);
        SDMSThread.doTrace(null, "validFrom : " + this.validFrom, 2);
        SDMSThread.doTrace(null, "validTo : " + this.validTo, 2);
        this.dumpVersions(2);
    }

    @Override
    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer(n + 1);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        String string = new String(stringBuffer);
        String string2 = string + "id : " + this.id + "\n" + string + "name                : " + this.name + "\n" + string + "folderId            : " + this.folderId + "\n" + string + "ownerId             : " + this.ownerId + "\n" + string + "type                : " + this.type + "\n" + string + "runProgram          : " + this.runProgram + "\n" + string + "rerunProgram        : " + this.rerunProgram + "\n" + string + "killProgram         : " + this.killProgram + "\n" + string + "workdir             : " + this.workdir + "\n" + string + "logfile             : " + this.logfile + "\n" + string + "truncLog            : " + this.truncLog + "\n" + string + "errlogfile          : " + this.errlogfile + "\n" + string + "truncErrlog         : " + this.truncErrlog + "\n" + string + "expectedRuntime     : " + this.expectedRuntime + "\n" + string + "expectedFinaltime   : " + this.expectedFinaltime + "\n" + string + "getExpectedRuntime  : " + this.getExpectedRuntime + "\n" + string + "priority            : " + this.priority + "\n" + string + "minPriority         : " + this.minPriority + "\n" + string + "agingAmount         : " + this.agingAmount + "\n" + string + "agingBase           : " + this.agingBase + "\n" + string + "submitSuspended     : " + this.submitSuspended + "\n" + string + "resumeAt            : " + this.resumeAt + "\n" + string + "resumeIn            : " + this.resumeIn + "\n" + string + "resumeBase          : " + this.resumeBase + "\n" + string + "masterSubmittable   : " + this.masterSubmittable + "\n" + string + "timeoutAmount       : " + this.timeoutAmount + "\n" + string + "timeoutBase         : " + this.timeoutBase + "\n" + string + "timeoutStateId      : " + this.timeoutStateId + "\n" + string + "sameNode            : " + this.sameNode + "\n" + string + "gangSchedule        : " + this.gangSchedule + "\n" + string + "dependencyOperation : " + this.dependencyOperation + "\n" + string + "esmpId              : " + this.esmpId + "\n" + string + "espId               : " + this.espId + "\n" + string + "qaId                : " + this.qaId + "\n" + string + "neId                : " + this.neId + "\n" + string + "fpId                : " + this.fpId + "\n" + string + "cancelLeadFlag      : " + this.cancelLeadFlag + "\n" + string + "cancelApproval      : " + this.cancelApproval + "\n" + string + "rerunLeadFlag       : " + this.rerunLeadFlag + "\n" + string + "rerunApproval       : " + this.rerunApproval + "\n" + string + "enableLeadFlag      : " + this.enableLeadFlag + "\n" + string + "enableApproval      : " + this.enableApproval + "\n" + string + "setStateLeadFlag    : " + this.setStateLeadFlag + "\n" + string + "setStateApproval    : " + this.setStateApproval + "\n" + string + "ignDepLeadFlag      : " + this.ignDepLeadFlag + "\n" + string + "ignDepApproval      : " + this.ignDepApproval + "\n" + string + "ignRssLeadFlag      : " + this.ignRssLeadFlag + "\n" + string + "ignRssApproval      : " + this.ignRssApproval + "\n" + string + "cloneLeadFlag       : " + this.cloneLeadFlag + "\n" + string + "cloneApproval       : " + this.cloneApproval + "\n" + string + "editParmLeadFlag    : " + this.editParmLeadFlag + "\n" + string + "editParmApproval    : " + this.editParmApproval + "\n" + string + "killLeadFlag        : " + this.killLeadFlag + "\n" + string + "killApproval        : " + this.killApproval + "\n" + string + "setJobStateLeadFlag : " + this.setJobStateLeadFlag + "\n" + string + "setJobStateApproval : " + this.setJobStateApproval + "\n" + string + "inheritPrivs        : " + this.inheritPrivs + "\n" + string + "creatorUId          : " + this.creatorUId + "\n" + string + "createTs            : " + this.createTs + "\n" + string + "changerUId          : " + this.changerUId + "\n" + string + "changeTs            : " + this.changeTs + "\n" + string + "validFrom : " + this.validFrom + "\n" + string + "validTo : " + this.validTo + "\n";
        return string2;
    }

    public String toString() {
        String string = this.toString(0);
        return string;
    }
}

