/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSGrant;
import de.independit.scheduler.server.repository.SDMSGrantTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSObjectCommentTable;
import de.independit.scheduler.server.repository.SDMSPrivilege;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSRepository;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityGeneric;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import java.util.HashMap;
import java.util.Vector;

public class SDMSSchedulingEntityProxyGeneric
extends SDMSProxy {
    public static final int JOB = 1;
    public static final int BATCH = 2;
    public static final int MILESTONE = 3;
    public static final int AND = 1;
    public static final int OR = 2;
    public static final boolean SUSPEND = true;
    public static final boolean NOSUSPEND = false;
    public static final boolean MASTER = true;
    public static final boolean NOMASTER = false;
    public static final boolean SAME_NODE = true;
    public static final boolean NOSAME_NODE = false;
    public static final boolean GANG = true;
    public static final boolean NOGANG = false;
    public static final boolean TRUNC = true;
    public static final boolean NOTRUNC = false;
    public static final int MINUTE = 0;
    public static final int HOUR = 1;
    public static final int DAY = 2;
    public static final int WEEK = 3;
    public static final int MONTH = 4;
    public static final int YEAR = 5;
    public static final int DEFAULT = 0;
    public static final int PARENT = 1;
    public static final int NO = 2;
    public static final int REVIEW = 4;
    public static final int APPROVE = 5;
    public static final long privilegeMask = 12868064029L;
    public static final int name_size = 64;
    public static final int runProgram_size = 512;
    public static final int rerunProgram_size = 512;
    public static final int killProgram_size = 512;
    public static final int workdir_size = 512;
    public static final int logfile_size = 512;
    public static final int errlogfile_size = 512;
    public static final int getExpectedRuntime_size = 32;
    public static final int resumeAt_size = 20;

    protected SDMSSchedulingEntityProxyGeneric(SDMSObject sDMSObject) {
        super(sDMSObject);
    }

    protected static SDMSSchedulingEntity getProxy(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) {
        int n = SDMSSchedulingEntityTable.table.tableIndex;
        SDMSProxy sDMSProxy = SDMSRepository.getProxy(n);
        if (sDMSProxy == null) {
            sDMSProxy = new SDMSSchedulingEntity(sDMSObject);
        } else {
            sDMSProxy.initProxy(sDMSObject);
        }
        systemEnvironment.tx.addUsedProxy(n, sDMSProxy);
        return (SDMSSchedulingEntity)sDMSProxy;
    }

    public String getName(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getName(systemEnvironment);
    }

    public void setName(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSSchedulingEntityGeneric)this.object).setName(systemEnvironment, string);
    }

    public static int getNameMaxLength() {
        return 64;
    }

    public Long getFolderId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getFolderId(systemEnvironment);
    }

    public void setFolderId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSSchedulingEntityGeneric)this.object).setFolderId(systemEnvironment, l);
    }

    @Override
    public Long getOwnerId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getOwnerId(systemEnvironment);
    }

    public void setOwnerId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSSchedulingEntityGeneric)this.object).setOwnerId(systemEnvironment, l);
    }

    public Integer getType(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getType(systemEnvironment);
    }

    public String getTypeAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getTypeAsString(systemEnvironment);
    }

    public void setType(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSSchedulingEntityGeneric)this.object).setType(systemEnvironment, n);
    }

    public String getRunProgram(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getRunProgram(systemEnvironment);
    }

    public void setRunProgram(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSSchedulingEntityGeneric)this.object).setRunProgram(systemEnvironment, string);
    }

    public static int getRunProgramMaxLength() {
        return 512;
    }

    public String getRerunProgram(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getRerunProgram(systemEnvironment);
    }

    public void setRerunProgram(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSSchedulingEntityGeneric)this.object).setRerunProgram(systemEnvironment, string);
    }

    public static int getRerunProgramMaxLength() {
        return 512;
    }

    public String getKillProgram(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getKillProgram(systemEnvironment);
    }

    public void setKillProgram(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSSchedulingEntityGeneric)this.object).setKillProgram(systemEnvironment, string);
    }

    public static int getKillProgramMaxLength() {
        return 512;
    }

    public String getWorkdir(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getWorkdir(systemEnvironment);
    }

    public void setWorkdir(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSSchedulingEntityGeneric)this.object).setWorkdir(systemEnvironment, string);
    }

    public static int getWorkdirMaxLength() {
        return 512;
    }

    public String getLogfile(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getLogfile(systemEnvironment);
    }

    public void setLogfile(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSSchedulingEntityGeneric)this.object).setLogfile(systemEnvironment, string);
    }

    public static int getLogfileMaxLength() {
        return 512;
    }

    public Boolean getTruncLog(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getTruncLog(systemEnvironment);
    }

    public String getTruncLogAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getTruncLogAsString(systemEnvironment);
    }

    public void setTruncLog(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSSchedulingEntityGeneric)this.object).setTruncLog(systemEnvironment, bl);
    }

    public String getErrlogfile(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getErrlogfile(systemEnvironment);
    }

    public void setErrlogfile(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSSchedulingEntityGeneric)this.object).setErrlogfile(systemEnvironment, string);
    }

    public static int getErrlogfileMaxLength() {
        return 512;
    }

    public Boolean getTruncErrlog(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getTruncErrlog(systemEnvironment);
    }

    public String getTruncErrlogAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getTruncErrlogAsString(systemEnvironment);
    }

    public void setTruncErrlog(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSSchedulingEntityGeneric)this.object).setTruncErrlog(systemEnvironment, bl);
    }

    public Integer getExpectedRuntime(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getExpectedRuntime(systemEnvironment);
    }

    public void setExpectedRuntime(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSSchedulingEntityGeneric)this.object).setExpectedRuntime(systemEnvironment, n);
    }

    public Integer getExpectedFinaltime(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getExpectedFinaltime(systemEnvironment);
    }

    public void setExpectedFinaltime(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSSchedulingEntityGeneric)this.object).setExpectedFinaltime(systemEnvironment, n);
    }

    public String getGetExpectedRuntime(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getGetExpectedRuntime(systemEnvironment);
    }

    public void setGetExpectedRuntime(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSSchedulingEntityGeneric)this.object).setGetExpectedRuntime(systemEnvironment, string);
    }

    public static int getGetExpectedRuntimeMaxLength() {
        return 32;
    }

    public Integer getPriority(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getPriority(systemEnvironment);
    }

    public void setPriority(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSSchedulingEntityGeneric)this.object).setPriority(systemEnvironment, n);
    }

    public Integer getMinPriority(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getMinPriority(systemEnvironment);
    }

    public void setMinPriority(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSSchedulingEntityGeneric)this.object).setMinPriority(systemEnvironment, n);
    }

    public Integer getAgingAmount(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getAgingAmount(systemEnvironment);
    }

    public void setAgingAmount(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSSchedulingEntityGeneric)this.object).setAgingAmount(systemEnvironment, n);
    }

    public Integer getAgingBase(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getAgingBase(systemEnvironment);
    }

    public String getAgingBaseAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getAgingBaseAsString(systemEnvironment);
    }

    public void setAgingBase(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSSchedulingEntityGeneric)this.object).setAgingBase(systemEnvironment, n);
    }

    public Boolean getSubmitSuspended(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getSubmitSuspended(systemEnvironment);
    }

    public String getSubmitSuspendedAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getSubmitSuspendedAsString(systemEnvironment);
    }

    public void setSubmitSuspended(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSSchedulingEntityGeneric)this.object).setSubmitSuspended(systemEnvironment, bl);
    }

    public String getResumeAt(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getResumeAt(systemEnvironment);
    }

    public void setResumeAt(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSSchedulingEntityGeneric)this.object).setResumeAt(systemEnvironment, string);
    }

    public static int getResumeAtMaxLength() {
        return 20;
    }

    public Integer getResumeIn(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getResumeIn(systemEnvironment);
    }

    public void setResumeIn(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSSchedulingEntityGeneric)this.object).setResumeIn(systemEnvironment, n);
    }

    public Integer getResumeBase(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getResumeBase(systemEnvironment);
    }

    public String getResumeBaseAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getResumeBaseAsString(systemEnvironment);
    }

    public void setResumeBase(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSSchedulingEntityGeneric)this.object).setResumeBase(systemEnvironment, n);
    }

    public Boolean getMasterSubmittable(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getMasterSubmittable(systemEnvironment);
    }

    public String getMasterSubmittableAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getMasterSubmittableAsString(systemEnvironment);
    }

    public void setMasterSubmittable(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSSchedulingEntityGeneric)this.object).setMasterSubmittable(systemEnvironment, bl);
    }

    public Integer getTimeoutAmount(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getTimeoutAmount(systemEnvironment);
    }

    public void setTimeoutAmount(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSSchedulingEntityGeneric)this.object).setTimeoutAmount(systemEnvironment, n);
    }

    public Integer getTimeoutBase(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getTimeoutBase(systemEnvironment);
    }

    public String getTimeoutBaseAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getTimeoutBaseAsString(systemEnvironment);
    }

    public void setTimeoutBase(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSSchedulingEntityGeneric)this.object).setTimeoutBase(systemEnvironment, n);
    }

    public Long getTimeoutStateId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getTimeoutStateId(systemEnvironment);
    }

    public void setTimeoutStateId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSSchedulingEntityGeneric)this.object).setTimeoutStateId(systemEnvironment, l);
    }

    public Boolean getSameNode(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getSameNode(systemEnvironment);
    }

    public String getSameNodeAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getSameNodeAsString(systemEnvironment);
    }

    public void setSameNode(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSSchedulingEntityGeneric)this.object).setSameNode(systemEnvironment, bl);
    }

    public Boolean getGangSchedule(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getGangSchedule(systemEnvironment);
    }

    public String getGangScheduleAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getGangScheduleAsString(systemEnvironment);
    }

    public void setGangSchedule(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSSchedulingEntityGeneric)this.object).setGangSchedule(systemEnvironment, bl);
    }

    public Integer getDependencyOperation(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getDependencyOperation(systemEnvironment);
    }

    public String getDependencyOperationAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getDependencyOperationAsString(systemEnvironment);
    }

    public void setDependencyOperation(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSSchedulingEntityGeneric)this.object).setDependencyOperation(systemEnvironment, n);
    }

    public Long getEsmpId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getEsmpId(systemEnvironment);
    }

    public void setEsmpId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSSchedulingEntityGeneric)this.object).setEsmpId(systemEnvironment, l);
    }

    public Long getEspId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getEspId(systemEnvironment);
    }

    public void setEspId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSSchedulingEntityGeneric)this.object).setEspId(systemEnvironment, l);
    }

    public Long getQaId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getQaId(systemEnvironment);
    }

    public void setQaId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSSchedulingEntityGeneric)this.object).setQaId(systemEnvironment, l);
    }

    public Long getNeId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getNeId(systemEnvironment);
    }

    public void setNeId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSSchedulingEntityGeneric)this.object).setNeId(systemEnvironment, l);
    }

    public Long getFpId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getFpId(systemEnvironment);
    }

    public void setFpId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSSchedulingEntityGeneric)this.object).setFpId(systemEnvironment, l);
    }

    public Boolean getCancelLeadFlag(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getCancelLeadFlag(systemEnvironment);
    }

    public void setCancelLeadFlag(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSSchedulingEntityGeneric)this.object).setCancelLeadFlag(systemEnvironment, bl);
    }

    public Integer getCancelApproval(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getCancelApproval(systemEnvironment);
    }

    public String getCancelApprovalAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getCancelApprovalAsString(systemEnvironment);
    }

    public void setCancelApproval(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSSchedulingEntityGeneric)this.object).setCancelApproval(systemEnvironment, n);
    }

    public Boolean getRerunLeadFlag(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getRerunLeadFlag(systemEnvironment);
    }

    public void setRerunLeadFlag(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSSchedulingEntityGeneric)this.object).setRerunLeadFlag(systemEnvironment, bl);
    }

    public Integer getRerunApproval(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getRerunApproval(systemEnvironment);
    }

    public String getRerunApprovalAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getRerunApprovalAsString(systemEnvironment);
    }

    public void setRerunApproval(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSSchedulingEntityGeneric)this.object).setRerunApproval(systemEnvironment, n);
    }

    public Boolean getEnableLeadFlag(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getEnableLeadFlag(systemEnvironment);
    }

    public void setEnableLeadFlag(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSSchedulingEntityGeneric)this.object).setEnableLeadFlag(systemEnvironment, bl);
    }

    public Integer getEnableApproval(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getEnableApproval(systemEnvironment);
    }

    public String getEnableApprovalAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getEnableApprovalAsString(systemEnvironment);
    }

    public void setEnableApproval(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSSchedulingEntityGeneric)this.object).setEnableApproval(systemEnvironment, n);
    }

    public Boolean getSetStateLeadFlag(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getSetStateLeadFlag(systemEnvironment);
    }

    public void setSetStateLeadFlag(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSSchedulingEntityGeneric)this.object).setSetStateLeadFlag(systemEnvironment, bl);
    }

    public Integer getSetStateApproval(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getSetStateApproval(systemEnvironment);
    }

    public String getSetStateApprovalAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getSetStateApprovalAsString(systemEnvironment);
    }

    public void setSetStateApproval(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSSchedulingEntityGeneric)this.object).setSetStateApproval(systemEnvironment, n);
    }

    public Boolean getIgnDepLeadFlag(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getIgnDepLeadFlag(systemEnvironment);
    }

    public void setIgnDepLeadFlag(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSSchedulingEntityGeneric)this.object).setIgnDepLeadFlag(systemEnvironment, bl);
    }

    public Integer getIgnDepApproval(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getIgnDepApproval(systemEnvironment);
    }

    public String getIgnDepApprovalAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getIgnDepApprovalAsString(systemEnvironment);
    }

    public void setIgnDepApproval(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSSchedulingEntityGeneric)this.object).setIgnDepApproval(systemEnvironment, n);
    }

    public Boolean getIgnRssLeadFlag(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getIgnRssLeadFlag(systemEnvironment);
    }

    public void setIgnRssLeadFlag(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSSchedulingEntityGeneric)this.object).setIgnRssLeadFlag(systemEnvironment, bl);
    }

    public Integer getIgnRssApproval(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getIgnRssApproval(systemEnvironment);
    }

    public String getIgnRssApprovalAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getIgnRssApprovalAsString(systemEnvironment);
    }

    public void setIgnRssApproval(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSSchedulingEntityGeneric)this.object).setIgnRssApproval(systemEnvironment, n);
    }

    public Boolean getCloneLeadFlag(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getCloneLeadFlag(systemEnvironment);
    }

    public void setCloneLeadFlag(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSSchedulingEntityGeneric)this.object).setCloneLeadFlag(systemEnvironment, bl);
    }

    public Integer getCloneApproval(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getCloneApproval(systemEnvironment);
    }

    public String getCloneApprovalAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getCloneApprovalAsString(systemEnvironment);
    }

    public void setCloneApproval(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSSchedulingEntityGeneric)this.object).setCloneApproval(systemEnvironment, n);
    }

    public Boolean getEditParmLeadFlag(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getEditParmLeadFlag(systemEnvironment);
    }

    public void setEditParmLeadFlag(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSSchedulingEntityGeneric)this.object).setEditParmLeadFlag(systemEnvironment, bl);
    }

    public Integer getEditParmApproval(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getEditParmApproval(systemEnvironment);
    }

    public String getEditParmApprovalAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getEditParmApprovalAsString(systemEnvironment);
    }

    public void setEditParmApproval(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSSchedulingEntityGeneric)this.object).setEditParmApproval(systemEnvironment, n);
    }

    public Boolean getKillLeadFlag(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getKillLeadFlag(systemEnvironment);
    }

    public void setKillLeadFlag(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSSchedulingEntityGeneric)this.object).setKillLeadFlag(systemEnvironment, bl);
    }

    public Integer getKillApproval(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getKillApproval(systemEnvironment);
    }

    public String getKillApprovalAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getKillApprovalAsString(systemEnvironment);
    }

    public void setKillApproval(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSSchedulingEntityGeneric)this.object).setKillApproval(systemEnvironment, n);
    }

    public Boolean getSetJobStateLeadFlag(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getSetJobStateLeadFlag(systemEnvironment);
    }

    public void setSetJobStateLeadFlag(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSSchedulingEntityGeneric)this.object).setSetJobStateLeadFlag(systemEnvironment, bl);
    }

    public Integer getSetJobStateApproval(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getSetJobStateApproval(systemEnvironment);
    }

    public String getSetJobStateApprovalAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getSetJobStateApprovalAsString(systemEnvironment);
    }

    public void setSetJobStateApproval(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSSchedulingEntityGeneric)this.object).setSetJobStateApproval(systemEnvironment, n);
    }

    @Override
    public Long getInheritPrivs(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getInheritPrivs(systemEnvironment);
    }

    public void setInheritPrivs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 0x200000100L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSSchedulingEntityGeneric)this.object).setInheritPrivs(systemEnvironment, l);
    }

    public Long getCreatorUId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getCreatorUId(systemEnvironment);
    }

    private void setCreatorUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSSchedulingEntityGeneric)this.object).setCreatorUId(systemEnvironment, l);
    }

    public Long getCreateTs(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getCreateTs(systemEnvironment);
    }

    private void setCreateTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSSchedulingEntityGeneric)this.object).setCreateTs(systemEnvironment, l);
    }

    public Long getChangerUId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getChangerUId(systemEnvironment);
    }

    public void setChangerUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSSchedulingEntityGeneric)this.object).setChangerUId(systemEnvironment, l);
    }

    protected SDMSSchedulingEntity setChangerUIdNoCheck(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        ((SDMSSchedulingEntityGeneric)this.object).setChangerUId(systemEnvironment, l);
        return (SDMSSchedulingEntity)this;
    }

    public Long getChangeTs(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSchedulingEntityGeneric)this.object).getChangeTs(systemEnvironment);
    }

    private void setChangeTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSSchedulingEntityGeneric)this.object).setChangeTs(systemEnvironment, l);
    }

    protected SDMSSchedulingEntity setChangeTsNoCheck(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        ((SDMSSchedulingEntityGeneric)this.object).setChangeTs(systemEnvironment, l);
        return (SDMSSchedulingEntity)this;
    }

    public SDMSSchedulingEntity set_FolderIdName(SystemEnvironment systemEnvironment, Long l, String string) throws SDMSException {
        this.checkRead(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181242"));
        }
        ((SDMSSchedulingEntityGeneric)this.object).set_FolderIdName(systemEnvironment, l, string);
        return (SDMSSchedulingEntity)this;
    }

    public SDMSSchedulingEntity set_FolderIdMasterSubmittable(SystemEnvironment systemEnvironment, Long l, Boolean bl) throws SDMSException {
        this.checkRead(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181242"));
        }
        ((SDMSSchedulingEntityGeneric)this.object).set_FolderIdMasterSubmittable(systemEnvironment, l, bl);
        return (SDMSSchedulingEntity)this;
    }

    @Override
    public SDMSKey getSortKey(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSKey sDMSKey = null;
        Long l = this.getId(systemEnvironment);
        if (systemEnvironment.tx.sortKeyMap == null) {
            systemEnvironment.tx.sortKeyMap = new HashMap();
        } else {
            sDMSKey = (SDMSKey)systemEnvironment.tx.sortKeyMap.get(l);
        }
        if (sDMSKey != null) {
            return sDMSKey;
        }
        boolean bl = false;
        sDMSKey = new SDMSKey();
        sDMSKey.add((Comparable)((Object)((SDMSSchedulingEntity)this).pathString(systemEnvironment)));
        systemEnvironment.tx.sortKeyMap.put(l, sDMSKey);
        return sDMSKey;
    }

    @Override
    public void delete(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSObjectCommentTable.dropComment(systemEnvironment, this.getId(systemEnvironment));
        Vector vector = SDMSGrantTable.idx_objectId.getVector(systemEnvironment, this.getId(systemEnvironment));
        for (int i = 0; i < vector.size(); ++i) {
            SDMSGrant sDMSGrant = (SDMSGrant)vector.get(i);
            sDMSGrant.setDeleteVersion(systemEnvironment, systemEnvironment.tx.txId);
        }
        super.delete(systemEnvironment);
    }

    @Override
    public final boolean checkPrivileges(SystemEnvironment systemEnvironment, long l) throws SDMSException {
        return (this.getPrivileges(systemEnvironment, l, true, null) & l) == l;
    }

    public final boolean checkPrivileges(SystemEnvironment systemEnvironment, long l, long l2) throws SDMSException {
        return (this.getPrivileges(systemEnvironment, l, true, null, l2) & l) == l;
    }

    @Override
    public long getPrivilegeMask() {
        return 12868064029L;
    }

    @Override
    public final SDMSPrivilege getPrivileges(SystemEnvironment systemEnvironment) throws SDMSException {
        return new SDMSPrivilege(systemEnvironment, this.getPrivileges(systemEnvironment, 12868064029L, false, null));
    }

    @Override
    public final SDMSPrivilege getPrivilegesForGroups(SystemEnvironment systemEnvironment, Vector vector) throws SDMSException {
        return new SDMSPrivilege(systemEnvironment, this.getPrivileges(systemEnvironment, 12868064029L, false, vector));
    }

    @Override
    public long getPrivileges(SystemEnvironment systemEnvironment, long l, boolean bl, Vector vector) throws SDMSException {
        Vector vector2 = vector == null ? new Vector() : vector;
        long l2 = 0L;
        if (systemEnvironment.cEnv.isUser()) {
            if (vector == null) {
                vector2.addAll(systemEnvironment.cEnv.gid());
            }
            if (vector2.contains(SDMSObject.adminGId)) {
                return l;
            }
            if (vector2.contains(this.getOwnerId(systemEnvironment))) {
                l2 = l & 0xFFFFFFFFFFFFFFFBL;
                if (l2 == l) {
                    return l2;
                }
            } else {
                for (int i = 0; i < vector2.size(); ++i) {
                    try {
                        SDMSGrant sDMSGrant = SDMSGrantTable.idx_objectId_gId_getUnique(systemEnvironment, new SDMSKey(this.getId(systemEnvironment), (Long)vector2.get(i)));
                        l2 |= sDMSGrant.getPrivs(systemEnvironment).longValue();
                        l2 = this.addImplicitPrivs(l2) & l;
                        if (l2 != l) continue;
                        return l2;
                    }
                    catch (NotFoundException notFoundException) {
                        // empty catch block
                    }
                }
            }
        }
        return l2;
    }

    public final SDMSPrivilege getPrivileges(SystemEnvironment systemEnvironment, long l) throws SDMSException {
        return new SDMSPrivilege(systemEnvironment, this.getPrivileges(systemEnvironment, 12868064029L, false, null, l));
    }

    public final SDMSPrivilege getPrivilegesForGroups(SystemEnvironment systemEnvironment, Vector vector, long l) throws SDMSException {
        return new SDMSPrivilege(systemEnvironment, this.getPrivileges(systemEnvironment, 12868064029L, false, vector, l));
    }

    public long getPrivileges(SystemEnvironment systemEnvironment, long l, boolean bl, Vector vector, long l2) throws SDMSException {
        Vector vector2 = vector == null ? new Vector() : vector;
        long l3 = 0L;
        if (systemEnvironment.cEnv.isUser()) {
            if (vector == null) {
                vector2.addAll(systemEnvironment.cEnv.gid());
            }
            if (vector2.contains(SDMSObject.adminGId)) {
                return l;
            }
            if (vector2.contains(this.getOwnerId(systemEnvironment))) {
                l3 = l & 0xFFFFFFFFFFFFFFFBL;
                if (l3 == l) {
                    return l3;
                }
            } else {
                for (int i = 0; i < vector2.size(); ++i) {
                    try {
                        SDMSGrant sDMSGrant = SDMSGrantTable.idx_objectId_gId_getUnique(systemEnvironment, new SDMSKey(this.getId(systemEnvironment), (Long)vector2.get(i)));
                        l3 |= sDMSGrant.getPrivs(systemEnvironment).longValue();
                        l3 = this.addImplicitPrivs(l3) & l;
                        if (l3 != l) continue;
                        return l3;
                    }
                    catch (NotFoundException notFoundException) {
                        // empty catch block
                    }
                }
            }
        }
        return l3;
    }

    @Override
    public SDMSMessage accessViolationMessage(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        SDMSMessage sDMSMessage = new SDMSMessage(systemEnvironment, string, "Insufficient privileges accessing Scheduling Entity $1", ((SDMSSchedulingEntity)this).pathString(systemEnvironment));
        return sDMSMessage;
    }

    @Override
    protected void touch(SystemEnvironment systemEnvironment) throws SDMSException {
        this.setChangerUIdNoCheck(systemEnvironment, systemEnvironment.cEnv.uid());
        this.setChangeTsNoCheck(systemEnvironment, systemEnvironment.txTime());
    }

    public void print() {
        ((SDMSSchedulingEntityGeneric)this.object).print();
    }
}

