/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.exception.SDMSSQLException;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSSchedulingHierarchy;
import de.independit.scheduler.server.repository.SDMSSchedulingHierarchyTableGeneric;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class SDMSSchedulingHierarchyGeneric
extends SDMSObject
implements Cloneable {
    public static final int CHILDSUSPEND = 1;
    public static final int NOSUSPEND = 2;
    public static final int SUSPEND = 3;
    public static final int MERGE_LOCAL = 1;
    public static final int MERGE_GLOBAL = 2;
    public static final int NOMERGE = 3;
    public static final int FAILURE = 4;
    public static final boolean STATIC = true;
    public static final boolean DYNAMIC = false;
    public static final boolean ENABLED = false;
    public static final boolean DISABLED = true;
    public static final int AND = 1;
    public static final int OR = 2;
    public static final int MINUTE = 0;
    public static final int HOUR = 1;
    public static final int DAY = 2;
    public static final int WEEK = 3;
    public static final int MONTH = 4;
    public static final int YEAR = 5;
    public static final int nr_id = 1;
    public static final int nr_seParentId = 2;
    public static final int nr_seChildId = 3;
    public static final int nr_aliasName = 4;
    public static final int nr_isStatic = 5;
    public static final int nr_isDisabled = 6;
    public static final int nr_priority = 7;
    public static final int nr_suspend = 8;
    public static final int nr_resumeAt = 9;
    public static final int nr_resumeIn = 10;
    public static final int nr_resumeBase = 11;
    public static final int nr_mergeMode = 12;
    public static final int nr_estpId = 13;
    public static final int nr_intId = 14;
    public static final int nr_enableCondition = 15;
    public static final int nr_enableMode = 16;
    public static final int nr_creatorUId = 17;
    public static final int nr_createTs = 18;
    public static final int nr_changerUId = 19;
    public static final int nr_changeTs = 20;
    public static String tableName = "SCHEDULING_HIERARCHY";
    protected Long seParentId;
    protected Long seChildId;
    protected String aliasName;
    protected Boolean isStatic;
    protected Boolean isDisabled;
    protected Integer priority;
    protected Integer suspend;
    protected String resumeAt;
    protected Integer resumeIn;
    protected Integer resumeBase;
    protected Integer mergeMode;
    protected Long estpId;
    protected Long intId;
    protected String enableCondition;
    protected Integer enableMode;
    protected Long creatorUId;
    protected Long createTs;
    protected Long changerUId;
    protected Long changeTs;
    private static PreparedStatement[] pUpdate = new PreparedStatement[128];
    private static PreparedStatement[] pDelete = new PreparedStatement[128];
    private static PreparedStatement[] pInsert = new PreparedStatement[128];

    public SDMSSchedulingHierarchyGeneric(SystemEnvironment systemEnvironment, Long l, Long l2, String string, Boolean bl, Boolean bl2, Integer n, Integer n2, String string2, Integer n3, Integer n4, Integer n5, Long l3, Long l4, String string3, Integer n6, Long l5, Long l6, Long l7, Long l8) throws SDMSException {
        super(systemEnvironment, SDMSSchedulingHierarchyTableGeneric.table);
        this.seParentId = l;
        this.seChildId = l2;
        if (string != null && string.length() > 64) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(SchedulingHierarchy) Length of $1 exceeds maximum length $2", "aliasName", "64"));
        }
        this.aliasName = string;
        this.isStatic = bl;
        this.isDisabled = bl2;
        this.priority = n;
        this.suspend = n2;
        if (string2 != null && string2.length() > 20) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(SchedulingHierarchy) Length of $1 exceeds maximum length $2", "resumeAt", "20"));
        }
        this.resumeAt = string2;
        this.resumeIn = n3;
        this.resumeBase = n4;
        this.mergeMode = n5;
        this.estpId = l3;
        this.intId = l4;
        if (string3 != null && string3.length() > 2048) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(SchedulingHierarchy) Length of $1 exceeds maximum length $2", "enableCondition", "2048"));
        }
        this.enableCondition = string3;
        this.enableMode = n6;
        this.creatorUId = l5;
        this.createTs = l6;
        this.changerUId = l7;
        this.changeTs = l8;
    }

    public Long getSeParentId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.seParentId;
    }

    public void setSeParentId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.seParentId)) {
            return;
        }
        if (l == null && this.seParentId == null) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingHierarchy) Change of system object not allowed"));
            }
            SDMSSchedulingHierarchyGeneric sDMSSchedulingHierarchyGeneric = (SDMSSchedulingHierarchyGeneric)this.change(systemEnvironment);
            sDMSSchedulingHierarchyGeneric.seParentId = l;
            sDMSSchedulingHierarchyGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSSchedulingHierarchyGeneric.changeTs = systemEnvironment.txTime();
            sDMSSchedulingHierarchyGeneric.versions.table.index(systemEnvironment, sDMSSchedulingHierarchyGeneric, 49L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getSeChildId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.seChildId;
    }

    public void setSeChildId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.seChildId)) {
            return;
        }
        if (l == null && this.seChildId == null) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingHierarchy) Change of system object not allowed"));
            }
            SDMSSchedulingHierarchyGeneric sDMSSchedulingHierarchyGeneric = (SDMSSchedulingHierarchyGeneric)this.change(systemEnvironment);
            sDMSSchedulingHierarchyGeneric.seChildId = l;
            sDMSSchedulingHierarchyGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSSchedulingHierarchyGeneric.changeTs = systemEnvironment.txTime();
            sDMSSchedulingHierarchyGeneric.versions.table.index(systemEnvironment, sDMSSchedulingHierarchyGeneric, 18L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public String getAliasName(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.aliasName;
    }

    public void setAliasName(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string != null && string.equals(this.aliasName)) {
            return;
        }
        if (string == null && this.aliasName == null) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingHierarchy) Change of system object not allowed"));
            }
            SDMSSchedulingHierarchyGeneric sDMSSchedulingHierarchyGeneric = (SDMSSchedulingHierarchyGeneric)this.change(systemEnvironment);
            if (string != null && string.length() > 64) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(SchedulingHierarchy) Length of $1 exceeds maximum length $2", "aliasName", "64"));
            }
            sDMSSchedulingHierarchyGeneric.aliasName = string;
            sDMSSchedulingHierarchyGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSSchedulingHierarchyGeneric.changeTs = systemEnvironment.txTime();
            sDMSSchedulingHierarchyGeneric.versions.table.index(systemEnvironment, sDMSSchedulingHierarchyGeneric, 32L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Boolean getIsStatic(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.isStatic;
    }

    public String getIsStaticAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Boolean bl = this.getIsStatic(systemEnvironment);
        boolean bl2 = bl;
        if (bl2) {
            return "STATIC";
        }
        if (!bl2) {
            return "DYNAMIC";
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown SchedulingHierarchy.isStatic: $1", this.getIsStatic(systemEnvironment)));
    }

    public void setIsStatic(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (this.isStatic.equals(bl)) {
            return;
        }
        SDMSSchedulingHierarchyGeneric sDMSSchedulingHierarchyGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingHierarchy) Change of system object not allowed"));
        }
        if (sDMSSchedulingHierarchyGeneric.versions.o_v == null || sDMSSchedulingHierarchyGeneric.versions.o_v.size() == 0 || sDMSSchedulingHierarchyGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingHierarchyGeneric = (SDMSSchedulingHierarchyGeneric)this.change(systemEnvironment);
        }
        sDMSSchedulingHierarchyGeneric.isStatic = bl;
        sDMSSchedulingHierarchyGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSchedulingHierarchyGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingHierarchyGeneric != this) {
            sDMSSchedulingHierarchyGeneric.versions.table.index(systemEnvironment, sDMSSchedulingHierarchyGeneric, 0L);
        }
    }

    public Boolean getIsDisabled(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.isDisabled;
    }

    public String getIsDisabledAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Boolean bl = this.getIsDisabled(systemEnvironment);
        boolean bl2 = bl;
        if (!bl2) {
            return "ENABLED";
        }
        if (bl2) {
            return "DISABLED";
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown SchedulingHierarchy.isDisabled: $1", this.getIsDisabled(systemEnvironment)));
    }

    public void setIsDisabled(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (this.isDisabled.equals(bl)) {
            return;
        }
        SDMSSchedulingHierarchyGeneric sDMSSchedulingHierarchyGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingHierarchy) Change of system object not allowed"));
        }
        if (sDMSSchedulingHierarchyGeneric.versions.o_v == null || sDMSSchedulingHierarchyGeneric.versions.o_v.size() == 0 || sDMSSchedulingHierarchyGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingHierarchyGeneric = (SDMSSchedulingHierarchyGeneric)this.change(systemEnvironment);
        }
        sDMSSchedulingHierarchyGeneric.isDisabled = bl;
        sDMSSchedulingHierarchyGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSchedulingHierarchyGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingHierarchyGeneric != this) {
            sDMSSchedulingHierarchyGeneric.versions.table.index(systemEnvironment, sDMSSchedulingHierarchyGeneric, 0L);
        }
    }

    public Integer getPriority(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.priority;
    }

    public void setPriority(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.priority.equals(n)) {
            return;
        }
        SDMSSchedulingHierarchyGeneric sDMSSchedulingHierarchyGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingHierarchy) Change of system object not allowed"));
        }
        if (sDMSSchedulingHierarchyGeneric.versions.o_v == null || sDMSSchedulingHierarchyGeneric.versions.o_v.size() == 0 || sDMSSchedulingHierarchyGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingHierarchyGeneric = (SDMSSchedulingHierarchyGeneric)this.change(systemEnvironment);
        }
        sDMSSchedulingHierarchyGeneric.priority = n;
        sDMSSchedulingHierarchyGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSchedulingHierarchyGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingHierarchyGeneric != this) {
            sDMSSchedulingHierarchyGeneric.versions.table.index(systemEnvironment, sDMSSchedulingHierarchyGeneric, 0L);
        }
    }

    public Integer getSuspend(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.suspend;
    }

    public String getSuspendAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getSuspend(systemEnvironment);
        switch (n) {
            case 1: {
                return "CHILDSUSPEND";
            }
            case 2: {
                return "NOSUSPEND";
            }
            case 3: {
                return "SUSPEND";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown SchedulingHierarchy.suspend: $1", this.getSuspend(systemEnvironment)));
    }

    public void setSuspend(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.suspend.equals(n)) {
            return;
        }
        SDMSSchedulingHierarchyGeneric sDMSSchedulingHierarchyGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingHierarchy) Change of system object not allowed"));
        }
        if (sDMSSchedulingHierarchyGeneric.versions.o_v == null || sDMSSchedulingHierarchyGeneric.versions.o_v.size() == 0 || sDMSSchedulingHierarchyGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingHierarchyGeneric = (SDMSSchedulingHierarchyGeneric)this.change(systemEnvironment);
        }
        sDMSSchedulingHierarchyGeneric.suspend = n;
        sDMSSchedulingHierarchyGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSchedulingHierarchyGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingHierarchyGeneric != this) {
            sDMSSchedulingHierarchyGeneric.versions.table.index(systemEnvironment, sDMSSchedulingHierarchyGeneric, 0L);
        }
    }

    public String getResumeAt(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.resumeAt;
    }

    public void setResumeAt(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string != null && string.equals(this.resumeAt)) {
            return;
        }
        if (string == null && this.resumeAt == null) {
            return;
        }
        SDMSSchedulingHierarchyGeneric sDMSSchedulingHierarchyGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingHierarchy) Change of system object not allowed"));
        }
        if (sDMSSchedulingHierarchyGeneric.versions.o_v == null || sDMSSchedulingHierarchyGeneric.versions.o_v.size() == 0 || sDMSSchedulingHierarchyGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingHierarchyGeneric = (SDMSSchedulingHierarchyGeneric)this.change(systemEnvironment);
        }
        if (string != null && string.length() > 20) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(SchedulingHierarchy) Length of $1 exceeds maximum length $2", "resumeAt", "20"));
        }
        sDMSSchedulingHierarchyGeneric.resumeAt = string;
        sDMSSchedulingHierarchyGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSchedulingHierarchyGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingHierarchyGeneric != this) {
            sDMSSchedulingHierarchyGeneric.versions.table.index(systemEnvironment, sDMSSchedulingHierarchyGeneric, 0L);
        }
    }

    public Integer getResumeIn(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.resumeIn;
    }

    public void setResumeIn(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.resumeIn)) {
            return;
        }
        if (n == null && this.resumeIn == null) {
            return;
        }
        SDMSSchedulingHierarchyGeneric sDMSSchedulingHierarchyGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingHierarchy) Change of system object not allowed"));
        }
        if (sDMSSchedulingHierarchyGeneric.versions.o_v == null || sDMSSchedulingHierarchyGeneric.versions.o_v.size() == 0 || sDMSSchedulingHierarchyGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingHierarchyGeneric = (SDMSSchedulingHierarchyGeneric)this.change(systemEnvironment);
        }
        sDMSSchedulingHierarchyGeneric.resumeIn = n;
        sDMSSchedulingHierarchyGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSchedulingHierarchyGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingHierarchyGeneric != this) {
            sDMSSchedulingHierarchyGeneric.versions.table.index(systemEnvironment, sDMSSchedulingHierarchyGeneric, 0L);
        }
    }

    public Integer getResumeBase(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.resumeBase;
    }

    public String getResumeBaseAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getResumeBase(systemEnvironment);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "MINUTE";
            }
            case 1: {
                return "HOUR";
            }
            case 2: {
                return "DAY";
            }
            case 3: {
                return "WEEK";
            }
            case 4: {
                return "MONTH";
            }
            case 5: {
                return "YEAR";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown SchedulingHierarchy.resumeBase: $1", this.getResumeBase(systemEnvironment)));
    }

    public void setResumeBase(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.resumeBase)) {
            return;
        }
        if (n == null && this.resumeBase == null) {
            return;
        }
        SDMSSchedulingHierarchyGeneric sDMSSchedulingHierarchyGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingHierarchy) Change of system object not allowed"));
        }
        if (sDMSSchedulingHierarchyGeneric.versions.o_v == null || sDMSSchedulingHierarchyGeneric.versions.o_v.size() == 0 || sDMSSchedulingHierarchyGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingHierarchyGeneric = (SDMSSchedulingHierarchyGeneric)this.change(systemEnvironment);
        }
        sDMSSchedulingHierarchyGeneric.resumeBase = n;
        sDMSSchedulingHierarchyGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSchedulingHierarchyGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingHierarchyGeneric != this) {
            sDMSSchedulingHierarchyGeneric.versions.table.index(systemEnvironment, sDMSSchedulingHierarchyGeneric, 0L);
        }
    }

    public Integer getMergeMode(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.mergeMode;
    }

    public String getMergeModeAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getMergeMode(systemEnvironment);
        switch (n) {
            case 1: {
                return "MERGE_LOCAL";
            }
            case 2: {
                return "MERGE_GLOBAL";
            }
            case 3: {
                return "NOMERGE";
            }
            case 4: {
                return "FAILURE";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown SchedulingHierarchy.mergeMode: $1", this.getMergeMode(systemEnvironment)));
    }

    public void setMergeMode(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.mergeMode.equals(n)) {
            return;
        }
        SDMSSchedulingHierarchyGeneric sDMSSchedulingHierarchyGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingHierarchy) Change of system object not allowed"));
        }
        if (sDMSSchedulingHierarchyGeneric.versions.o_v == null || sDMSSchedulingHierarchyGeneric.versions.o_v.size() == 0 || sDMSSchedulingHierarchyGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingHierarchyGeneric = (SDMSSchedulingHierarchyGeneric)this.change(systemEnvironment);
        }
        sDMSSchedulingHierarchyGeneric.mergeMode = n;
        sDMSSchedulingHierarchyGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSchedulingHierarchyGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingHierarchyGeneric != this) {
            sDMSSchedulingHierarchyGeneric.versions.table.index(systemEnvironment, sDMSSchedulingHierarchyGeneric, 0L);
        }
    }

    public Long getEstpId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.estpId;
    }

    public void setEstpId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.estpId)) {
            return;
        }
        if (l == null && this.estpId == null) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingHierarchy) Change of system object not allowed"));
            }
            SDMSSchedulingHierarchyGeneric sDMSSchedulingHierarchyGeneric = (SDMSSchedulingHierarchyGeneric)this.change(systemEnvironment);
            sDMSSchedulingHierarchyGeneric.estpId = l;
            sDMSSchedulingHierarchyGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSSchedulingHierarchyGeneric.changeTs = systemEnvironment.txTime();
            sDMSSchedulingHierarchyGeneric.versions.table.index(systemEnvironment, sDMSSchedulingHierarchyGeneric, 4L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getIntId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.intId;
    }

    public void setIntId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.intId)) {
            return;
        }
        if (l == null && this.intId == null) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingHierarchy) Change of system object not allowed"));
            }
            SDMSSchedulingHierarchyGeneric sDMSSchedulingHierarchyGeneric = (SDMSSchedulingHierarchyGeneric)this.change(systemEnvironment);
            sDMSSchedulingHierarchyGeneric.intId = l;
            sDMSSchedulingHierarchyGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSSchedulingHierarchyGeneric.changeTs = systemEnvironment.txTime();
            sDMSSchedulingHierarchyGeneric.versions.table.index(systemEnvironment, sDMSSchedulingHierarchyGeneric, 8L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public String getEnableCondition(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.enableCondition;
    }

    public void setEnableCondition(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string != null && string.equals(this.enableCondition)) {
            return;
        }
        if (string == null && this.enableCondition == null) {
            return;
        }
        SDMSSchedulingHierarchyGeneric sDMSSchedulingHierarchyGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingHierarchy) Change of system object not allowed"));
        }
        if (sDMSSchedulingHierarchyGeneric.versions.o_v == null || sDMSSchedulingHierarchyGeneric.versions.o_v.size() == 0 || sDMSSchedulingHierarchyGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingHierarchyGeneric = (SDMSSchedulingHierarchyGeneric)this.change(systemEnvironment);
        }
        if (string != null && string.length() > 2048) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(SchedulingHierarchy) Length of $1 exceeds maximum length $2", "enableCondition", "2048"));
        }
        sDMSSchedulingHierarchyGeneric.enableCondition = string;
        sDMSSchedulingHierarchyGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSchedulingHierarchyGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingHierarchyGeneric != this) {
            sDMSSchedulingHierarchyGeneric.versions.table.index(systemEnvironment, sDMSSchedulingHierarchyGeneric, 0L);
        }
    }

    public Integer getEnableMode(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.enableMode;
    }

    public String getEnableModeAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getEnableMode(systemEnvironment);
        switch (n) {
            case 1: {
                return "AND";
            }
            case 2: {
                return "OR";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown SchedulingHierarchy.enableMode: $1", this.getEnableMode(systemEnvironment)));
    }

    public void setEnableMode(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.enableMode.equals(n)) {
            return;
        }
        SDMSSchedulingHierarchyGeneric sDMSSchedulingHierarchyGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingHierarchy) Change of system object not allowed"));
        }
        if (sDMSSchedulingHierarchyGeneric.versions.o_v == null || sDMSSchedulingHierarchyGeneric.versions.o_v.size() == 0 || sDMSSchedulingHierarchyGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingHierarchyGeneric = (SDMSSchedulingHierarchyGeneric)this.change(systemEnvironment);
        }
        sDMSSchedulingHierarchyGeneric.enableMode = n;
        sDMSSchedulingHierarchyGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSchedulingHierarchyGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingHierarchyGeneric != this) {
            sDMSSchedulingHierarchyGeneric.versions.table.index(systemEnvironment, sDMSSchedulingHierarchyGeneric, 0L);
        }
    }

    public Long getCreatorUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.creatorUId;
    }

    void setCreatorUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.creatorUId.equals(l)) {
            return;
        }
        SDMSSchedulingHierarchyGeneric sDMSSchedulingHierarchyGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingHierarchy) Change of system object not allowed"));
        }
        if (sDMSSchedulingHierarchyGeneric.versions.o_v == null || sDMSSchedulingHierarchyGeneric.versions.o_v.size() == 0 || sDMSSchedulingHierarchyGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingHierarchyGeneric = (SDMSSchedulingHierarchyGeneric)this.change(systemEnvironment);
        }
        sDMSSchedulingHierarchyGeneric.creatorUId = l;
        sDMSSchedulingHierarchyGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSchedulingHierarchyGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingHierarchyGeneric != this) {
            sDMSSchedulingHierarchyGeneric.versions.table.index(systemEnvironment, sDMSSchedulingHierarchyGeneric, 0L);
        }
    }

    public Long getCreateTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.createTs;
    }

    void setCreateTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.createTs.equals(l)) {
            return;
        }
        SDMSSchedulingHierarchyGeneric sDMSSchedulingHierarchyGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SchedulingHierarchy) Change of system object not allowed"));
        }
        if (sDMSSchedulingHierarchyGeneric.versions.o_v == null || sDMSSchedulingHierarchyGeneric.versions.o_v.size() == 0 || sDMSSchedulingHierarchyGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingHierarchyGeneric = (SDMSSchedulingHierarchyGeneric)this.change(systemEnvironment);
        }
        sDMSSchedulingHierarchyGeneric.createTs = l;
        sDMSSchedulingHierarchyGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSchedulingHierarchyGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingHierarchyGeneric != this) {
            sDMSSchedulingHierarchyGeneric.versions.table.index(systemEnvironment, sDMSSchedulingHierarchyGeneric, 0L);
        }
    }

    public Long getChangerUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changerUId;
    }

    public void setChangerUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        SDMSSchedulingHierarchyGeneric sDMSSchedulingHierarchyGeneric = this;
        if (sDMSSchedulingHierarchyGeneric.versions.o_v == null || sDMSSchedulingHierarchyGeneric.versions.o_v.size() == 0 || sDMSSchedulingHierarchyGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingHierarchyGeneric = (SDMSSchedulingHierarchyGeneric)this.change(systemEnvironment);
        }
        sDMSSchedulingHierarchyGeneric.changerUId = l;
        sDMSSchedulingHierarchyGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSchedulingHierarchyGeneric != this) {
            sDMSSchedulingHierarchyGeneric.versions.table.index(systemEnvironment, sDMSSchedulingHierarchyGeneric, 0L);
        }
    }

    public Long getChangeTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changeTs;
    }

    void setChangeTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.changeTs.equals(l)) {
            return;
        }
        SDMSSchedulingHierarchyGeneric sDMSSchedulingHierarchyGeneric = this;
        if (sDMSSchedulingHierarchyGeneric.versions.o_v == null || sDMSSchedulingHierarchyGeneric.versions.o_v.size() == 0 || sDMSSchedulingHierarchyGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSchedulingHierarchyGeneric = (SDMSSchedulingHierarchyGeneric)this.change(systemEnvironment);
        }
        sDMSSchedulingHierarchyGeneric.changeTs = l;
        sDMSSchedulingHierarchyGeneric.changerUId = systemEnvironment.cEnv.uid();
        if (sDMSSchedulingHierarchyGeneric != this) {
            sDMSSchedulingHierarchyGeneric.versions.table.index(systemEnvironment, sDMSSchedulingHierarchyGeneric, 0L);
        }
    }

    public SDMSSchedulingHierarchyGeneric set_SeParentIdSeChildId(SystemEnvironment systemEnvironment, Long l, Long l2) throws SDMSException {
        SDMSSchedulingHierarchyGeneric sDMSSchedulingHierarchyGeneric;
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141637", "(SchedulingHierarchy) Change of system object not allowed"));
            }
            sDMSSchedulingHierarchyGeneric = (SDMSSchedulingHierarchyGeneric)this.change(systemEnvironment);
            sDMSSchedulingHierarchyGeneric.seParentId = l;
            sDMSSchedulingHierarchyGeneric.seChildId = l2;
            sDMSSchedulingHierarchyGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSSchedulingHierarchyGeneric.changeTs = systemEnvironment.txTime();
            sDMSSchedulingHierarchyGeneric.versions.table.index(systemEnvironment, sDMSSchedulingHierarchyGeneric);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        return sDMSSchedulingHierarchyGeneric;
    }

    public SDMSSchedulingHierarchyGeneric set_SeParentIdAliasName(SystemEnvironment systemEnvironment, Long l, String string) throws SDMSException {
        SDMSSchedulingHierarchyGeneric sDMSSchedulingHierarchyGeneric;
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141637", "(SchedulingHierarchy) Change of system object not allowed"));
            }
            sDMSSchedulingHierarchyGeneric = (SDMSSchedulingHierarchyGeneric)this.change(systemEnvironment);
            sDMSSchedulingHierarchyGeneric.seParentId = l;
            if (string != null && string.length() > 64) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01201290025", "(SchedulingHierarchy) Length of $1 exceeds maximum length $2", "changeTs", "64"));
            }
            sDMSSchedulingHierarchyGeneric.aliasName = string;
            sDMSSchedulingHierarchyGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSSchedulingHierarchyGeneric.changeTs = systemEnvironment.txTime();
            sDMSSchedulingHierarchyGeneric.versions.table.index(systemEnvironment, sDMSSchedulingHierarchyGeneric);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        return sDMSSchedulingHierarchyGeneric;
    }

    @Override
    protected SDMSProxy toProxy(SystemEnvironment systemEnvironment) {
        return new SDMSSchedulingHierarchy(this);
    }

    protected SDMSSchedulingHierarchyGeneric(Long l, Long l2, Long l3, String string, Boolean bl, Boolean bl2, Integer n, Integer n2, String string2, Integer n3, Integer n4, Integer n5, Long l4, Long l5, String string3, Integer n6, Long l6, Long l7, Long l8, Long l9, long l10, long l11) {
        this.id = l;
        this.seParentId = l2;
        this.seChildId = l3;
        this.aliasName = string;
        this.isStatic = bl;
        this.isDisabled = bl2;
        this.priority = n;
        this.suspend = n2;
        this.resumeAt = string2;
        this.resumeIn = n3;
        this.resumeBase = n4;
        this.mergeMode = n5;
        this.estpId = l4;
        this.intId = l5;
        this.enableCondition = string3;
        this.enableMode = n6;
        this.creatorUId = l6;
        this.createTs = l7;
        this.changerUId = l8;
        this.changeTs = l9;
        this.validFrom = l10;
        this.validTo = l11;
    }

    protected String tableName() {
        return tableName;
    }

    @Override
    protected void insertDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pInsert[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "INSERT INTO " + string2 + "SCHEDULING_HIERARCHY" + string3 + " (ID, " + string2 + "SE_PARENT_ID" + string3 + ", " + string2 + "SE_CHILD_ID" + string3 + ", " + string2 + "ALIAS_NAME" + string3 + ", " + string2 + "IS_STATIC" + string3 + ", " + string2 + "IS_DISABLED" + string3 + ", " + string2 + "PRIORITY" + string3 + ", " + string2 + "SUSPEND" + string3 + ", " + string2 + "RESUME_AT" + string3 + ", " + string2 + "RESUME_IN" + string3 + ", " + string2 + "RESUME_BASE" + string3 + ", " + string2 + "MERGE_MODE" + string3 + ", " + string2 + "ESTP_ID" + string3 + ", " + string2 + "INT_ID" + string3 + ", " + string2 + "ENABLE_CONDITION" + string3 + ", " + string2 + "ENABLE_MODE" + string3 + ", " + string2 + "CREATOR_U_ID" + string3 + ", " + string2 + "CREATE_TS" + string3 + ", " + string2 + "CHANGER_U_ID" + string3 + ", " + string2 + "CHANGE_TS" + string3 + ", VALID_FROM, VALID_TO) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                SDMSSchedulingHierarchyGeneric.pInsert[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110181952", "SchedulingHierarchy: $1\n$2", string, sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pInsert[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            if (this.seParentId == null) {
                preparedStatement.setNull(2, 4);
            } else {
                preparedStatement.setLong(2, this.seParentId);
            }
            if (this.seChildId == null) {
                preparedStatement.setNull(3, 4);
            } else {
                preparedStatement.setLong(3, this.seChildId);
            }
            if (this.aliasName == null) {
                preparedStatement.setNull(4, 12);
            } else {
                preparedStatement.setString(4, this.aliasName);
            }
            preparedStatement.setInt(5, this.isStatic != false ? 1 : 0);
            preparedStatement.setInt(6, this.isDisabled != false ? 1 : 0);
            preparedStatement.setInt(7, this.priority);
            preparedStatement.setInt(8, this.suspend);
            if (this.resumeAt == null) {
                preparedStatement.setNull(9, 12);
            } else {
                preparedStatement.setString(9, this.resumeAt);
            }
            if (this.resumeIn == null) {
                preparedStatement.setNull(10, 4);
            } else {
                preparedStatement.setInt(10, this.resumeIn);
            }
            if (this.resumeBase == null) {
                preparedStatement.setNull(11, 4);
            } else {
                preparedStatement.setInt(11, this.resumeBase);
            }
            preparedStatement.setInt(12, this.mergeMode);
            if (this.estpId == null) {
                preparedStatement.setNull(13, 4);
            } else {
                preparedStatement.setLong(13, this.estpId);
            }
            if (this.intId == null) {
                preparedStatement.setNull(14, 4);
            } else {
                preparedStatement.setLong(14, this.intId);
            }
            if (this.enableCondition == null) {
                preparedStatement.setNull(15, 12);
            } else {
                preparedStatement.setString(15, this.enableCondition);
            }
            preparedStatement.setInt(16, this.enableMode);
            preparedStatement.setLong(17, this.creatorUId);
            preparedStatement.setLong(18, this.createTs);
            preparedStatement.setLong(19, this.changerUId);
            preparedStatement.setLong(20, this.changeTs);
            preparedStatement.setLong(21, systemEnvironment.tx.versionId);
            preparedStatement.setLong(22, Long.MAX_VALUE);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110181954", "SchedulingHierarchy: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
    }

    @Override
    protected void updateDBObject(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.closeDBObject(systemEnvironment);
        this.insertDBObject(systemEnvironment);
    }

    @Override
    protected void deleteDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        this.closeDBObject(systemEnvironment);
    }

    private void closeDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pUpdate[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = systemEnvironment.dbConnection.getMetaData().getDriverName();
                boolean bl = string2.startsWith("PostgreSQL");
                String string3 = SystemEnvironment.SQUOTE;
                String string4 = SystemEnvironment.EQUOTE;
                string = "UPDATE " + string3 + "SCHEDULING_HIERARCHY" + string4 + " SET VALID_TO = ?,     CHANGE_TS = ?,     CHANGER_U_ID = ? WHERE ID = ?  AND VALID_TO = " + (bl ? "CAST ('9223372036854775807' AS DECIMAL)" : "9223372036854775807");
                SDMSSchedulingHierarchyGeneric.pUpdate[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110181955", "SchedulingHierarchy : $1\n$2", string, sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pUpdate[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, systemEnvironment.tx.versionId);
            preparedStatement.setLong(2, this.changeTs);
            preparedStatement.setLong(3, this.changerUId);
            preparedStatement.setLong(4, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110181956", "SchedulingHierarchy: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
    }

    public static boolean checkIsStatic(Boolean bl) {
        if (bl.booleanValue()) {
            return true;
        }
        return bl == false;
    }

    public static boolean checkIsDisabled(Boolean bl) {
        if (!bl.booleanValue()) {
            return true;
        }
        return bl == true;
    }

    public static boolean checkSuspend(Integer n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public static boolean checkResumeBase(Integer n) {
        if (n == null) {
            return true;
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public static boolean checkMergeMode(Integer n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    public static boolean checkEnableMode(Integer n) {
        switch (n) {
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void print() {
        SDMSThread.doTrace(null, "Type : SchedulingHierarchy", 2);
        SDMSThread.doTrace(null, "id : " + this.id, 2);
        SDMSThread.doTrace(null, "seParentId : " + this.seParentId, 2);
        SDMSThread.doTrace(null, "seChildId : " + this.seChildId, 2);
        SDMSThread.doTrace(null, "aliasName : " + this.aliasName, 2);
        SDMSThread.doTrace(null, "isStatic : " + this.isStatic, 2);
        SDMSThread.doTrace(null, "isDisabled : " + this.isDisabled, 2);
        SDMSThread.doTrace(null, "priority : " + this.priority, 2);
        SDMSThread.doTrace(null, "suspend : " + this.suspend, 2);
        SDMSThread.doTrace(null, "resumeAt : " + this.resumeAt, 2);
        SDMSThread.doTrace(null, "resumeIn : " + this.resumeIn, 2);
        SDMSThread.doTrace(null, "resumeBase : " + this.resumeBase, 2);
        SDMSThread.doTrace(null, "mergeMode : " + this.mergeMode, 2);
        SDMSThread.doTrace(null, "estpId : " + this.estpId, 2);
        SDMSThread.doTrace(null, "intId : " + this.intId, 2);
        SDMSThread.doTrace(null, "enableCondition : " + this.enableCondition, 2);
        SDMSThread.doTrace(null, "enableMode : " + this.enableMode, 2);
        SDMSThread.doTrace(null, "creatorUId : " + this.creatorUId, 2);
        SDMSThread.doTrace(null, "createTs : " + this.createTs, 2);
        SDMSThread.doTrace(null, "changerUId : " + this.changerUId, 2);
        SDMSThread.doTrace(null, "changeTs : " + this.changeTs, 2);
        SDMSThread.doTrace(null, "validFrom : " + this.validFrom, 2);
        SDMSThread.doTrace(null, "validTo : " + this.validTo, 2);
        this.dumpVersions(2);
    }

    @Override
    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer(n + 1);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        String string = new String(stringBuffer);
        String string2 = string + "id : " + this.id + "\n" + string + "seParentId      : " + this.seParentId + "\n" + string + "seChildId       : " + this.seChildId + "\n" + string + "aliasName       : " + this.aliasName + "\n" + string + "isStatic        : " + this.isStatic + "\n" + string + "isDisabled      : " + this.isDisabled + "\n" + string + "priority        : " + this.priority + "\n" + string + "suspend         : " + this.suspend + "\n" + string + "resumeAt        : " + this.resumeAt + "\n" + string + "resumeIn        : " + this.resumeIn + "\n" + string + "resumeBase      : " + this.resumeBase + "\n" + string + "mergeMode       : " + this.mergeMode + "\n" + string + "estpId          : " + this.estpId + "\n" + string + "intId           : " + this.intId + "\n" + string + "enableCondition : " + this.enableCondition + "\n" + string + "enableMode      : " + this.enableMode + "\n" + string + "creatorUId      : " + this.creatorUId + "\n" + string + "createTs        : " + this.createTs + "\n" + string + "changerUId      : " + this.changerUId + "\n" + string + "changeTs        : " + this.changeTs + "\n" + string + "validFrom : " + this.validFrom + "\n" + string + "validTo : " + this.validTo + "\n";
        return string2;
    }

    public String toString() {
        String string = this.toString(0);
        return string;
    }
}

