/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSIndex;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityStats;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityStatsGeneric;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityStatsTable;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SDMSSubmittedEntityStatsTableGeneric
extends SDMSTable {
    public static final String tableName = "SUBMITTED_ENTITY_STATS";
    public static SDMSSubmittedEntityStatsTable table = null;
    public static final String[] columnNames = new String[]{"ID", "SME_ID", "RERUN_SEQ", "SCOPE_ID", "JOB_ESD_ID", "EXIT_CODE", "COMMANDLINE", "WORKDIR", "LOGFILE", "ERRLOGFILE", "EXTPID", "SYNC_TS", "RESOURCE_TS", "RUNNABLE_TS", "START_TS", "FINISH_TS", "CREATOR_U_ID", "CREATE_TS", "CHANGER_U_ID", "CHANGE_TS"};
    public static SDMSIndex idx_smeId;
    public static SDMSIndex idx_scopeId;
    public static SDMSIndex idx_smeId_rerunSeq;

    public SDMSSubmittedEntityStatsTableGeneric(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
        if (table != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182009", "SubmittedEntityStats"));
        }
        table = (SDMSSubmittedEntityStatsTable)this;
        table = (SDMSSubmittedEntityStatsTable)this;
        this.isVersioned = false;
        idx_smeId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "smeId");
        idx_scopeId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "scopeId");
        idx_smeId_rerunSeq = new SDMSIndex(systemEnvironment, 1, this.isVersioned, table, "smeId_rerunSeq");
    }

    public SDMSSubmittedEntityStats create(SystemEnvironment systemEnvironment, Long l, Integer n, Long l2, Long l3, Integer n2, String string, String string2, String string3, String string4, String string5, Long l4, Long l5, Long l6, Long l7, Long l8) throws SDMSException {
        SDMSSubmittedEntityStats sDMSSubmittedEntityStats;
        Long l9 = systemEnvironment.cEnv.uid();
        Long l10 = systemEnvironment.txTime();
        Long l11 = systemEnvironment.cEnv.uid();
        Long l12 = systemEnvironment.txTime();
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182049", "SubmittedEntityStats"));
        }
        this.validate(systemEnvironment, l, n, l2, l3, n2, string, string2, string3, string4, string5, l4, l5, l6, l7, l8, l9, l10, l11, l12);
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSSubmittedEntityStatsGeneric sDMSSubmittedEntityStatsGeneric = new SDMSSubmittedEntityStatsGeneric(systemEnvironment, l, n, l2, l3, n2, string, string2, string3, string4, string5, l4, l5, l6, l7, l8, l9, l10, l11, l12);
        try {
            systemEnvironment.tx.addToTouchSet(systemEnvironment, sDMSSubmittedEntityStatsGeneric.versions, true);
            table.put(systemEnvironment, sDMSSubmittedEntityStatsGeneric.id, sDMSSubmittedEntityStatsGeneric.versions);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            sDMSSubmittedEntityStats = (SDMSSubmittedEntityStats)sDMSSubmittedEntityStatsGeneric.toProxy(systemEnvironment);
            sDMSSubmittedEntityStats.current = true;
        }
        catch (SDMSException sDMSException) {
            SDMSSubmittedEntityStats sDMSSubmittedEntityStats2 = (SDMSSubmittedEntityStats)sDMSSubmittedEntityStatsGeneric.toProxy(systemEnvironment);
            sDMSSubmittedEntityStats2.current = true;
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        if (!this.checkCreatePrivs(systemEnvironment, sDMSSubmittedEntityStats)) {
            throw new AccessViolationException(sDMSSubmittedEntityStats.accessViolationMessage(systemEnvironment, "01402270738"));
        }
        sDMSSubmittedEntityStats.touchMaster(systemEnvironment);
        return sDMSSubmittedEntityStats;
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSSubmittedEntityStats sDMSSubmittedEntityStats) throws SDMSException {
        return sDMSSubmittedEntityStats.checkPrivileges(systemEnvironment, 1L);
    }

    protected void validate(SystemEnvironment systemEnvironment, Long l, Integer n, Long l2, Long l3, Integer n2, String string, String string2, String string3, String string4, String string5, Long l4, Long l5, Long l6, Long l7, Long l8, Long l9, Long l10, Long l11, Long l12) throws SDMSException {
    }

    @Override
    protected SDMSObject rowToObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        long l2;
        Long l3;
        Long l4;
        Long l5;
        Long l6;
        Long l7;
        Long l8;
        Long l9;
        Long l10;
        Long l11;
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        Integer n;
        Long l12;
        Long l13;
        Integer n2;
        Long l14;
        Long l15;
        try {
            l15 = resultSet.getLong(1);
            l14 = resultSet.getLong(2);
            n2 = resultSet.getInt(3);
            l13 = resultSet.getLong(4);
            if (resultSet.wasNull()) {
                l13 = null;
            }
            l12 = resultSet.getLong(5);
            if (resultSet.wasNull()) {
                l12 = null;
            }
            n = resultSet.getInt(6);
            if (resultSet.wasNull()) {
                n = null;
            }
            string5 = resultSet.getString(7);
            if (resultSet.wasNull()) {
                string5 = null;
            }
            string4 = resultSet.getString(8);
            if (resultSet.wasNull()) {
                string4 = null;
            }
            string3 = resultSet.getString(9);
            if (resultSet.wasNull()) {
                string3 = null;
            }
            string2 = resultSet.getString(10);
            if (resultSet.wasNull()) {
                string2 = null;
            }
            string = resultSet.getString(11);
            if (resultSet.wasNull()) {
                string = null;
            }
            l11 = resultSet.getLong(12);
            if (resultSet.wasNull()) {
                l11 = null;
            }
            l10 = resultSet.getLong(13);
            if (resultSet.wasNull()) {
                l10 = null;
            }
            l9 = resultSet.getLong(14);
            if (resultSet.wasNull()) {
                l9 = null;
            }
            l8 = resultSet.getLong(15);
            if (resultSet.wasNull()) {
                l8 = null;
            }
            l7 = resultSet.getLong(16);
            if (resultSet.wasNull()) {
                l7 = null;
            }
            l6 = resultSet.getLong(17);
            l5 = resultSet.getLong(18);
            l4 = resultSet.getLong(19);
            l3 = resultSet.getLong(20);
            l2 = 0L;
            l = Long.MAX_VALUE;
        }
        catch (SQLException sQLException) {
            SDMSThread.doTrace(null, "SQL Error : " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182045", "SubmittedEntityStats: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
        if (l < systemEnvironment.lowestActiveVersion) {
            return null;
        }
        return new SDMSSubmittedEntityStatsGeneric(l15, l14, n2, l13, l12, n, string5, string4, string3, string2, string, l11, l10, l9, l8, l7, l6, l5, l4, l3, l2, l);
    }

    @Override
    protected void loadTable(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        int n = 0;
        int n2 = 0;
        boolean bl = SystemEnvironment.isPostgreSQL;
        String string = SystemEnvironment.SQUOTE;
        String string2 = SystemEnvironment.EQUOTE;
        Statement statement = systemEnvironment.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + this.tableName() + string2 + ".ID, " + string + "SME_ID" + string2 + ", " + string + "RERUN_SEQ" + string2 + ", " + string + "SCOPE_ID" + string2 + ", " + string + "JOB_ESD_ID" + string2 + ", " + string + "EXIT_CODE" + string2 + ", " + string + "COMMANDLINE" + string2 + ", " + string + "WORKDIR" + string2 + ", " + string + "LOGFILE" + string2 + ", " + string + "ERRLOGFILE" + string2 + ", " + string + "EXTPID" + string2 + ", " + string + "SYNC_TS" + string2 + ", " + string + "RESOURCE_TS" + string2 + ", " + string + "RUNNABLE_TS" + string2 + ", " + string + "START_TS" + string2 + ", " + string + "FINISH_TS" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + " FROM " + string + this.tableName() + string2 + ",        SME2LOAD  WHERE " + string + this.tableName() + string2 + ".SME_ID = SME2LOAD.ID");
        while (resultSet.next()) {
            try {
                if (this.loadObject(systemEnvironment, resultSet)) {
                    ++n2;
                }
                ++n;
            }
            catch (Exception exception) {
                SDMSThread.doTrace(null, "Exception caught while loading table " + this.tableName() + ", ID = " + Long.valueOf(resultSet.getLong(1)), -1);
                throw exception;
            }
        }
        statement.close();
        SDMSThread.doTrace(null, "Read " + n + ", Loaded " + n2 + " rows for " + this.tableName(), 0);
    }

    @Override
    public String checkIndex(SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        boolean bl = idx_smeId.check(((SDMSSubmittedEntityStatsGeneric)sDMSObject).smeId, sDMSObject);
        string = string + "idx_smeId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_scopeId.check(((SDMSSubmittedEntityStatsGeneric)sDMSObject).scopeId, sDMSObject);
        string = string + "idx_scopeId: " + (bl ? "ok" : "missing") + "\n";
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSSubmittedEntityStatsGeneric)sDMSObject).smeId);
        sDMSKey.add(((SDMSSubmittedEntityStatsGeneric)sDMSObject).rerunSeq);
        bl = idx_smeId_rerunSeq.check(sDMSKey, sDMSObject);
        string = string + "idx_smeId_rerunSeq: " + (bl ? "ok" : "missing") + "\n";
        return string;
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.index(systemEnvironment, sDMSObject, -1L);
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject, long l) throws SDMSException {
        idx_smeId.put(systemEnvironment, ((SDMSSubmittedEntityStatsGeneric)sDMSObject).smeId, sDMSObject, (1L & l) != 0L);
        idx_scopeId.put(systemEnvironment, ((SDMSSubmittedEntityStatsGeneric)sDMSObject).scopeId, sDMSObject, (2L & l) != 0L);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSSubmittedEntityStatsGeneric)sDMSObject).smeId);
        sDMSKey.add(((SDMSSubmittedEntityStatsGeneric)sDMSObject).rerunSeq);
        idx_smeId_rerunSeq.put(systemEnvironment, sDMSKey, sDMSObject, (4L & l) != 0L);
    }

    @Override
    protected void unIndex(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        idx_smeId.remove(systemEnvironment, ((SDMSSubmittedEntityStatsGeneric)sDMSObject).smeId, sDMSObject);
        idx_scopeId.remove(systemEnvironment, ((SDMSSubmittedEntityStatsGeneric)sDMSObject).scopeId, sDMSObject);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSSubmittedEntityStatsGeneric)sDMSObject).smeId);
        sDMSKey.add(((SDMSSubmittedEntityStatsGeneric)sDMSObject).rerunSeq);
        idx_smeId_rerunSeq.remove(systemEnvironment, sDMSKey, sDMSObject);
    }

    public static SDMSSubmittedEntityStats getObject(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSSubmittedEntityStats)table.get(systemEnvironment, l);
    }

    public static SDMSSubmittedEntityStats getObjectForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSSubmittedEntityStats)table.getForUpdate(systemEnvironment, l);
    }

    public static SDMSSubmittedEntityStats getObject(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        return (SDMSSubmittedEntityStats)table.get(systemEnvironment, l, l2);
    }

    public static SDMSSubmittedEntityStats idx_smeId_rerunSeq_getUnique(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSSubmittedEntityStats)idx_smeId_rerunSeq.getUnique(systemEnvironment, object);
    }

    public static SDMSSubmittedEntityStats idx_smeId_rerunSeq_getUniqueForUpdate(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSSubmittedEntityStats)idx_smeId_rerunSeq.getUniqueForUpdate(systemEnvironment, object);
    }

    public static SDMSSubmittedEntityStats idx_smeId_rerunSeq_getUnique(SystemEnvironment systemEnvironment, Object object, long l) throws SDMSException {
        return (SDMSSubmittedEntityStats)idx_smeId_rerunSeq.getUnique(systemEnvironment, object, l);
    }

    @Override
    public String tableName() {
        return tableName;
    }

    @Override
    public String[] columnNames() {
        return columnNames;
    }
}

