-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE EXIT_STATE_MAPPING (
    ID                             bigint NOT NULL
    , ESMP_ID                        bigint          NOT NULL
    , ESD_ID                         bigint          NOT NULL
    , ECR_START                      integer             NULL
    , ECR_END                        integer             NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
    , VALID_FROM                   bigint NOT NULL
    , VALID_TO                     bigint NOT NULL
);
CREATE INDEX PK_EXIT_STATE_MAPPING
ON EXIT_STATE_MAPPING(ID);
CREATE VIEW SCI_C_EXIT_STATE_MAPPING AS
SELECT 
    ID 
    , ESMP_ID                        AS ESMP_ID
    , ESD_ID                         AS ESD_ID
    , ECR_START                      AS ECR_START
    , ECR_END                        AS ECR_END
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM EXIT_STATE_MAPPING
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_EXIT_STATE_MAPPING AS
SELECT 
    ID 
    , ESMP_ID                        AS ESMP_ID
    , ESD_ID                         AS ESD_ID
    , ECR_START                      AS ECR_START
    , ECR_END                        AS ECR_END
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM EXIT_STATE_MAPPING;
