-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE EXTENTS (
    ID                             bigint NOT NULL
    , O_ID                           bigint          NOT NULL
    , SME_ID                         bigint          NOT NULL
    , SEQUENCE                       int8            NOT NULL
    , EXTENT                         lvarchar(256)   NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_EXTENTS
ON EXTENTS(ID);
CREATE VIEW SCI_EXTENTS (ID,O_ID,SME_ID,SEQUENCE,EXTENT,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , O_ID                           AS O_ID
    , SME_ID                         AS SME_ID
    , SEQUENCE                       AS SEQUENCE
    , EXTENT                         AS EXTENT
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM EXTENTS;
CREATE TABLE ARC_EXTENTS (
    ID                             bigint NOT NULL
    , O_ID                           bigint           NULL
    , SME_ID                         bigint           NULL
    , SEQUENCE                       int8             NULL
    , EXTENT                         lvarchar(256)    NULL
    , CREATOR_U_ID                   bigint           NULL
    , CREATE_TS                      bigint           NULL
    , CHANGER_U_ID                   bigint           NULL
    , CHANGE_TS                      bigint           NULL
);
