-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE POOL (
    ID                             bigint NOT NULL
    , NR_ID                          bigint          NOT NULL
    , SCOPE_ID                       bigint          NOT NULL
    , OWNER_ID                       bigint          NOT NULL
    , MANAGER_ID                     bigint              NULL
    , DIST_ID                        bigint              NULL
    , DEFINED_AMOUNT                 int8            NOT NULL
    , AMOUNT                         int8            NOT NULL
    , FREE_AMOUNT                    int8            NOT NULL
    , CHILD_ALLOCATED                int8            NOT NULL
    , EVALUATION_CYCLE               int8                NULL
    , NEXT_EVALUATION_TIME           bigint          NOT NULL
    , TAG                            lvarchar(64)        NULL
    , TRACE_INTERVAL                 int8                NULL
    , TRACE_BASE                     int8                NULL
    , TRACE_BASE_MULTIPLIER          int8            NOT NULL
    , TD0_AVG                        float           NOT NULL
    , TD1_AVG                        float           NOT NULL
    , TD2_AVG                        float           NOT NULL
    , LW_AVG                         float           NOT NULL
    , LAST_EVAL                      bigint          NOT NULL
    , LAST_WRITE                     bigint          NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_POOL
ON POOL(ID);
CREATE VIEW SCI_POOL (ID,NR_ID,SCOPE_ID,OWNER_ID,MANAGER_ID,DIST_ID,DEFINED_AMOUNT,AMOUNT,FREE_AMOUNT,CHILD_ALLOCATED,EVALUATION_CYCLE,NEXT_EVALUATION_TIME,TAG,TRACE_INTERVAL,TRACE_BASE,TRACE_BASE_MULTIPLIER,TD0_AVG,TD1_AVG,TD2_AVG,LW_AVG,LAST_EVAL,LAST_WRITE,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , NR_ID                          AS NR_ID
    , SCOPE_ID                       AS SCOPE_ID
    , OWNER_ID                       AS OWNER_ID
    , MANAGER_ID                     AS MANAGER_ID
    , DIST_ID                        AS DIST_ID
    , DEFINED_AMOUNT                 AS DEFINED_AMOUNT
    , AMOUNT                         AS AMOUNT
    , FREE_AMOUNT                    AS FREE_AMOUNT
    , CHILD_ALLOCATED                AS CHILD_ALLOCATED
    , EVALUATION_CYCLE               AS EVALUATION_CYCLE
    , NEXT_EVALUATION_TIME           AS NEXT_EVALUATION_TIME
    , TAG                            AS TAG
    , TRACE_INTERVAL                 AS TRACE_INTERVAL
    , TRACE_BASE                     AS TRACE_BASE
    , TRACE_BASE_MULTIPLIER          AS TRACE_BASE_MULTIPLIER
    , TD0_AVG                        AS TD0_AVG
    , TD1_AVG                        AS TD1_AVG
    , TD2_AVG                        AS TD2_AVG
    , LW_AVG                         AS LW_AVG
    , dbinfo ('utc_to_datetime', round(mod(LAST_EVAL, 1125899906842624)/1000)) AS LAST_EVAL
    , dbinfo ('utc_to_datetime', round(mod(LAST_WRITE, 1125899906842624)/1000)) AS LAST_WRITE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM POOL;
