CREATE VIEW SCI_SME_QUARTER (
        JAHR,
        QUARTAL,
        ANZAHL,
        EXPECTED_ANZAHL,
        AVG_ANZAHL_PRO_TAG)
AS
SELECT
	JAHR,
	(((MONAT-1)/3)+1),
	SUM(ANZAHL),
	CASE DATEPART(year,GETDATE())*100 + DATEPART(QUARTER, GETDATE())
		WHEN JAHR*100+(((MONAT-1)/3)+1) 
		THEN
			SUM(ANZAHL) *
			-- anzahl Tage im aktuellen quartal
			DATEDIFF(day,
				DATEADD(month,((MONAT-1)/3)*3,DATEADD(year,JAHR,0)),
				DATEADD(month,(((MONAT-1)/3)+1)*3,DATEADD(year,JAHR,0))
			) /
			-- vergangene Tage im aktuellen quartal
			DATEDIFF(day,
				DATEADD(month,((MONAT-1)/3)*3,DATEADD(year,DATEDIFF(year,0,GETDATE()),0)),
				GETDATE()
			)
		ELSE
			SUM(ANZAHL)
		END,
	CASE DATEPART(year,GETDATE())*100 + DATEPART(QUARTER, GETDATE())
		WHEN JAHR*100+(((MONAT-1)/3)+1) 
		THEN
			SUM(ANZAHL) * 100 /
			-- vergangene Tage im aktuellen quartal
			DATEDIFF(day,
				DATEADD(month,((MONAT-1)/3)*3,DATEADD(year,DATEDIFF(year,0,GETDATE()),0)),
				GETDATE()
			)
		ELSE
			SUM(ANZAHL) * 100 /
			-- anzahl Tage im quartal
			DATEDIFF(day,
				DATEADD(month,((MONAT-1)/3)*3,DATEADD(year,JAHR,0)),
				DATEADD(month,(((MONAT-1)/3)+1)*3,DATEADD(year,JAHR,0))
			)
		END / 100.0
from SCI_SME_COUNTER
group by JAHR,((MONAT-1)/3);
go

