-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE `RUNNABLE_QUEUE` (
    `ID`                           decimal(20) NOT NULL
    , `SME_ID`                       decimal(20)     NOT NULL
    , `SCOPE_ID`                     decimal(20)         NULL
    , `STATE`                        integer         NOT NULL
    , `CREATOR_U_ID`                 decimal(20)     NOT NULL
    , `CREATE_TS`                    decimal(20)     NOT NULL
    , `CHANGER_U_ID`                 decimal(20)     NOT NULL
    , `CHANGE_TS`                    decimal(20)     NOT NULL
) ENGINE = INNODB;
CREATE UNIQUE INDEX PK_RUNNABLE_QUEUE
ON `RUNNABLE_QUEUE`(`ID`);
CREATE VIEW SCI_RUNNABLE_QUEUE AS
SELECT 
    ID 
    , `SME_ID`                       AS `SME_ID`
    , `SCOPE_ID`                     AS `SCOPE_ID`
    , CASE `STATE` WHEN 1 THEN 'DEPENDENCY_WAIT' WHEN 2 THEN 'SYNCHRONIZE_WAIT' WHEN 3 THEN 'RESOURCE_WAIT' WHEN 4 THEN 'RUNNABLE' WHEN 5 THEN 'STARTING' END AS `STATE`
    , `CREATOR_U_ID`                 AS `CREATOR_U_ID`
    , from_unixtime((`CREATE_TS` & ~1125899906842624)/1000) AS `CREATE_TS`
    , `CHANGER_U_ID`                 AS `CHANGER_U_ID`
    , from_unixtime((`CHANGE_TS` & ~1125899906842624)/1000) AS `CHANGE_TS`
  FROM `RUNNABLE_QUEUE`;
