#include <stdlib.h>
#include <stdio.h>
#include <fcntl.h>
#include <signal.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <limits.h>
#include <string.h>
#include "common.h"

volatile pid_t childpid = 0;

int sighandling()
{
#define	Sigaction(a, b, c) if(sigaction((a), (b), (c)) == -1) return 1;
	struct sigaction sa;

	sa.sa_handler = MY_SIG_IGN;	/* effectively SIG_IGN, defined in common.h */
	sigemptyset(&sa.sa_mask);
	sa.sa_flags = SA_RESTART;
	Sigaction(SIGINT,  &sa, NULL);
	Sigaction(SIGPIPE, &sa, NULL);
	Sigaction(SIGALRM, &sa, NULL);
	Sigaction(SIGTTIN, &sa, NULL);
	Sigaction(SIGTTOU, &sa, NULL);

	sa.sa_handler = exit_handler;
	Sigaction(SIGQUIT, &sa, NULL);
	Sigaction(SIGTERM, &sa, NULL);
	Sigaction(SIGUSR1, &sa, NULL);
	Sigaction(SIGUSR2, &sa, NULL);

	sa.sa_handler = hup_handler;
	Sigaction(SIGHUP,  &sa, NULL);
	/* set sigchld handler do hup_handler (is a nop) because we will */
	/* wait after getting EOF from childs stdout */
	sa.sa_flags |= SA_NOCLDSTOP;
	Sigaction(SIGCHLD, &sa, NULL);

	return 0;
}

int reset_sighandling()
{
	struct sigaction sa;

	sa.sa_handler = MY_SIG_DFL;	/* effectively SIG_DFL, defined in common.h */
	sigemptyset(&sa.sa_mask);
	sa.sa_flags = SA_RESTART;
	Sigaction(SIGINT,  &sa, NULL);
	Sigaction(SIGPIPE, &sa, NULL);
	Sigaction(SIGALRM, &sa, NULL);
	Sigaction(SIGTTIN, &sa, NULL);
	Sigaction(SIGTTOU, &sa, NULL);
	Sigaction(SIGQUIT, &sa, NULL);
	Sigaction(SIGTERM, &sa, NULL);
	Sigaction(SIGUSR1, &sa, NULL);
	Sigaction(SIGUSR2, &sa, NULL);
	Sigaction(SIGHUP,  &sa, NULL);
	Sigaction(SIGCHLD, &sa, NULL);

#undef Sigaction

	return 0;
}


int check_name(char *name, char **target)
{
	char *curdir;

	if(*name != '/') {	/* relative path */
		curdir = (char *) malloc(PATH_MAX + 1 + strlen(name) + 1);
		if(curdir == NULL) {
			fprintf(stderr, "Error while allocating memory\n");
			return 1;	/* no memory */
		}
		if(getcwd(curdir, PATH_MAX) == NULL) {
			exit(1);
		}
		sprintf(curdir + strlen(curdir), "/%s", name);
		*target = curdir;
	} else {
		*target = name;
	}
	return 0;
}


int redirect(char *outfile)
{
	int n;
	int flags = O_WRONLY|O_APPEND|O_SYNC;
	struct stat buf;

	if(strcmp(outfile, "-")) {	/* if not stdout/stderr */ 
		if( stat(outfile, &buf) ) {
			if(errno == ENOENT) {
				flags = O_WRONLY|O_CREAT|O_SYNC;
			} else {
				exit(14);
			}
		}

		n = open(outfile, flags, S_IRUSR|S_IWUSR|S_IRGRP);
		if(n < 0) {
			perror(" error opening file ");
			exit(10);
		}
		if(dup2(n, fileno(stdout))<0) {
			perror(" error dupping stdout ");
			exit(11);
		}
		if(dup2(n, fileno(stderr))<0) {
			/* error dupping stderr */
			exit(12);
		}
		close(n);
	}

	return 0;
}


int daemonize(char *outfile)
{
	pid_t pid;

	if(outfile != NULL) {
		if(redirect(outfile)) return 1;
	}

	if((pid = fork()) != 0) {	/* parent */
		if(pid < 0) return -1;
		exit(0);
	}
	setsid();			/* set session group */
	fclose(stdin);			/* no stdin */
	if(chdir("/") != 0) {
		/* don't know what to do; should be successful */;
	}

	/* fork again, so we're not a sessionleader */
	if((pid = fork()) != 0) {	/* parent */
		if(pid < 0) return -1;
		exit(0);
	}

	return 0;
}

