/*
** $Id: common.h,v 2.0 2004/04/19 15:25:42 ronald Exp $
**
** Copyright (C) 2002 topIT Informationstechnologie GmbH
**
*/

#ifndef __DAEMONIZE_H__
#define __DAEMONIZE_H__

extern volatile pid_t childpid;

extern void exit_handler(int p);
extern void hup_handler(int p);
extern void chld_handler(int p);
extern int sighandling(void);
extern int reset_sighandling(void);
extern int redirect(char *outfile);
extern int daemonize(char *outfile);
extern int check_name(char *name, char **target);

/*
** for some reason the solaris definitions don't suit perfectly on the
** situation GNU expects. For now, just to avoid warnings, we redefine
** the constants
*/
#ifdef SOLARIS
#define MY_SIG_DFL	(void(*)(int))0
#define MY_SIG_IGN	(void (*)(int))1
#else
#define MY_SIG_DFL	SIG_DFL
#define MY_SIG_IGN	SIG_IGN
#endif

#endif
