%{
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#ifdef LINUX
#include <linux/limits.h>
#else
#include <limits.h>
#endif

#define MAXDEPTH 32
#define MAXFILES 2048

typedef struct _bufstate {
	char *filename;
	YY_BUFFER_STATE state;
} bufstate;

int envlevel = 0;
int cmdactive = 0;
char **filelist;
int filectr;
int numfiles;
char *actfilename;
char **paths;
int numpaths;
char fname[PATH_MAX];

bufstate bufstack[MAXDEPTH];
int curdepth = 0;	/* is actually the next free entry */

/* we keep track of already included files, so we don't include twice */
char *processed[MAXFILES];
int files_processed = 0;

%}
%option nounput

UMLAUT  \\\"[aouAOU]
INPUT   (\n[ \t]*)?"\\input{"
BSVERB	(\n[ \t]*)?\\"begin{sverbatim}"[ \t]*\n
BVERB	(\n[ \t]*)?\\"begin{verbatim}"[ \t]*\n
ESVERB	\\"end{sverbatim}"[ \t\n]*
EVERB	\\"end{verbatim}"[ \t\n]*
SZET    "{\\ss}"
BREAK   \\-
LINEBRK \\\\[ \t]*\n
COMMENT \n?%[^\n]*\n
TEXCMD	(\n[ \t]*)?\\[^ \t\n\r\\{}\[\]"-]*
PAR	\n([ \t]*\n)+
NL	\n
LBRACE	"{"
RBRACE	"}"
LITBRACE	\\[{}]
FILENAME [^}]*"}"[ \t\n]*

%s INCLUDE
%s VERBATIM

%%

<INITIAL>{BVERB}	{
			printf("%s", yytext);
			BEGIN(VERBATIM);
		}
<INITIAL>{BSVERB}	{
			printf("%s", yytext);
			BEGIN(VERBATIM);
		}
<VERBATIM>{EVERB}	{
			printf("%s", yytext);
			BEGIN(INITIAL);
		}
<VERBATIM>{ESVERB}	{
			printf("%s", yytext);
			BEGIN(INITIAL);
		}
<VERBATIM>.	{
			printf("%s", yytext);
		}
<INITIAL>{INPUT}	{
			printf("%s", yytext);
			BEGIN(INCLUDE);
		}
<INCLUDE>{FILENAME}	{
			printf("%s", yytext);
			fprintf(stderr, "found an input statement: %s\n", yytext);

			/* determine filename (strip trailing }, blanks, tabs and the newline) */
			int i = strlen(yytext) - 1;
			while( yytext[i] != '}'  && i >= 0) --i;
			if (i < 1) {
				fprintf(stderr, "Syntax error on \\input statement\n");
				exit(1);
			}
			yytext[i] = '\0';
			/* if the file is called something.tex.indexed, strip the .indexed */
			if (i > 8 && strcmp(yytext+i-8, ".indexed") == 0) { 
				i -= 8;
				yytext[i] = '\0';
			}
			/* last but not least, remove trailing ws */
			i = 0;
			while(yytext[i] == '\n' || yytext[i] == ' ' || yytext[i] == '\t') ++i;

			/* did we already process the file? */
			for (i = 0; i < files_processed; ++i) {
				if (strcmp(yytext, processed[i]) == 0) break;
			}

			if (i == files_processed) {

				if (curdepth == MAXDEPTH) {
					fprintf(stderr, "Too many nested files\n");
					exit(1);
				}

				yyin = fopen(yytext, "r");
				if (yyin == NULL) {
					int pn = 0;
					/* we now search the paths  and try .tex endings */
					strcpy(fname, yytext);
					strcat(fname, ".tex");
					yyin = fopen(fname, "r");
					if (yyin != NULL) pn = numpaths;
					while (pn < numpaths) {
						strcpy(fname, paths[pn]);
						strcat(fname, "/");
						strcat(fname, yytext);
						yyin = fopen(fname, "r");
						if (yyin != NULL) break;
						strcat(fname, ".tex");
						yyin = fopen(fname, "r");
						if (yyin != NULL) break;
						pn++;
					}
					if (yyin == NULL) {
						fprintf(stderr, "Couldn't open %s : %s\n", yytext, strerror(errno));
						exit(1);
					}
				}

				actfilename = strdup(yytext);
				processed[files_processed] = actfilename;
				if (processed[files_processed] == NULL) {
					fprintf(stderr, "Out of memory error\n");
					exit(1);
				}
				files_processed++;

				bufstack[curdepth].state = YY_CURRENT_BUFFER;
				bufstack[curdepth].filename = actfilename;
				curdepth++;

				printf("\n%%-----------------------------------------------------------------\n");
				printf("%% file: %s\n", actfilename);
				printf("%%-----------------------------------------------------------------\n");

				yy_switch_to_buffer(yy_create_buffer( yyin, YY_BUF_SIZE ));
			}

			BEGIN(INITIAL);
		}

{UMLAUT}	{
			switch(yytext[strlen(yytext) - 1]) {
				case 'a': printf("ä"); break;
				case 'A': printf("Ä"); break;
				case 'o': printf("ö"); break;
				case 'O': printf("Ö"); break;
				case 'u': printf("ü"); break;
				case 'U': printf("Ü"); break;
			}
			if (envlevel == 0) cmdactive = 0;
		}
{SZET}		{
			printf("ß");
			if (envlevel == 0) cmdactive = 0;
		}
{BREAK}		{
			cmdactive = 0;
			/* discard */
		}
<INITIAL>{LINEBRK}	{
			printf("\\\\\n");
			cmdactive = 0;
		}
<INITIAL>{TEXCMD}	{
			int i = 0;
			printf("%s", yytext);
			while(yytext[i] == '\n' || yytext[i] == ' ' || yytext[i] == '\t') ++i;
			fprintf(stderr, "%s\n", yytext);
			cmdactive = 1;
		}
<INITIAL>{COMMENT}	{
			printf("%s", yytext);
			if (envlevel == 0) cmdactive = 0;
		}
<INITIAL>{PAR}		{
			printf("\n");
			if (envlevel == 0) cmdactive = 0;
		}
<INITIAL>{NL}		{
			if (cmdactive == 1)
				printf("\n");
			else
				printf(" <LF> ");
			if (envlevel == 0) cmdactive = 0;
		}
<INITIAL>{LITBRACE}	{
			printf("%s", yytext);
		}
<INITIAL>{LBRACE}	{
			envlevel++;
			printf("%s", yytext);
		}
<INITIAL>{RBRACE}	{
			envlevel--;
			printf("%s", yytext);
		}

<INITIAL>.	{
			printf( "%s", yytext );
			if (envlevel == 0) cmdactive = 0;
		}

<<EOF>>		{
			curdepth--;
			if (curdepth >= 0) {
				printf("\n%% End of Inputfile %s\n", bufstack[curdepth].filename);
				FILE *tmp = yyin;
				yy_delete_buffer( YY_CURRENT_BUFFER );
				yy_switch_to_buffer(bufstack[curdepth].state);
				fclose(tmp);
			} else {
				yyterminate();
			}
		}

%%

int yywrap()
{
	if (filectr > numfiles) return 1;
	yyin = fopen(filelist[filectr], "r");
	if (yyin == NULL) {
		fprintf(stderr, "Error opening %s: %s\n", filelist[filectr], strerror(errno));
		fprintf(stderr, "Aborting ...\n");
		exit(1);
	}
	printf("\n%%-----------------------------------------------------------------\n");
	printf("%% file: %s\n", filelist[filectr]);
	printf("%%-----------------------------------------------------------------\n");
	filectr++;
	return 0;
}

int main( int argc, char **argv )
{
	char *path;

	if ( argc > 1 ) {
		filelist = argv;
		numfiles = argc - 1;
		filectr = 1;
		yywrap();
	} else {
		fprintf(stderr, "Argument missing\n");
		fprintf(stderr, "Usage: %s filename {filename}\n", argv[0]);
		exit(1);
	}
	path = getenv("TEXINPUTS");
	if (path != NULL) {
		paths = (char **) malloc(strlen(path)/2 * sizeof(char **));
		if (paths == NULL) {
			fprintf(stderr, "Memory allocation error\n");
			exit(2);
		}
		numpaths = 0;
		while(*path) {
			while(*path == ':') {	/* skip and rub out separators */
				*path = '\0';
				path++;
			}
			if (*path) {		/* if still path left */
				paths[numpaths] = path;
				numpaths++;
			}
			while(*path && *path != ':') path++;	/* skip non separators */
		}
	} else {
		numpaths = 0;
		paths = NULL;
	}

	yylex();
	exit(0);
}
