﻿using System;
using System.Linq;
using System.ServiceProcess;
using System.Threading;

using Scrolllog;

namespace ScrolllogService
{
	public partial class ScrolllogService : ServiceBase
	{

		private Scrolllog.Scrolllog _scrolllog = null;
		private Thread _thread = null;

		public ScrolllogService(Scrolllog.Scrolllog s)
		{
			_scrolllog = s;
			_scrolllog.ExitServiceEvent += _scrolllog_ExitServiceEvent;
		}

		protected override void OnStart(string[] args)
		{
			// merge args with the ones specified in the startparameters
			// already specified values are overwritten
			// on Error don't start
			if (args.Count() > 0) {
				if(!_scrolllog.GetOps(args)) {
					ExitEventArgs e = new ExitEventArgs();
					e.ServiceName = _scrolllog.getServiceName();
					_scrolllog.ThrowExitServiceEvent(this, e);
				}
			}
			_thread = new System.Threading.Thread(new System.Threading.ThreadStart(_scrolllog.RunScrolllog));          
			_thread.Start();
		}        

		protected override void OnStop()
		{
			if (_thread != null) {
				_thread.Abort();
				_thread = null;
			}
		}

		void _scrolllog_ExitServiceEvent(Object sender, ExitEventArgs e)
		{
			try {        
				new ServiceController(e.ServiceName).Stop();
	    		} catch (Exception) {
				//_scrolllog.WriteError(ex);
			}
		}

	}
}
