﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;

namespace Scrolllog
{
    /// <summary>
    /// Helper Class for non Scrolllog-specific methods
    /// </summary>
    public class Utility
    {
        /// <summary>
        /// Static method to check if a path name is valid
        /// </summary>
        /// <param name="path"></param>
        /// <returns></returns>
        public static bool ValidFilePath(string path)
        {
            List<char> charlist = Path.GetInvalidPathChars().ToList();
            bool valid = true;
            
            charlist.ForEach((char m) =>
            {
                if (path.Contains(m))
                    valid = false;
            });

            return valid;
        }

        /// <summary>
        /// Static method to check if a filename is valid
        /// </summary>
        /// <param name="Filename"></param>
        /// <returns></returns>
        public static bool ValidFileName(string Filename)
        {
            List<char> charlist = Path.GetInvalidFileNameChars().ToList();
            bool valid = true;

            charlist.ForEach((char m) =>
            {
                if (Filename.Replace(".","").Contains(m))
                    valid = false;
            });

            return valid;
        }

        /// <summary>
        /// Gets the Number from a Filename
        /// </summary>
        /// <param name="s"></param>
        /// <returns></returns>
        public static int GetNumberFromString(string s)
        {
            int idx = s.LastIndexOf(".");
            string number = s.Substring(idx + 1);            
            
            return Int32.Parse(number);
        }


        public static bool IsNullOrEmptyOrBlank(string s)
        {
            if (s != null)
                s = s.Trim();

            return String.IsNullOrEmpty(s);
        }

    }
}
