﻿/*
 * Created by SharpDevelop.
 * User: Administrator
 * Date: 20.12.2013
 * Time: 11:22
 * 
 * To change this template use Tools | Options | Coding | Edit Standard Headers.
 */
using System;
using System.IO;

namespace shutdownjs
{
	class Program
	{
		private static void usage()
		{
			Console.Write("Usage: shutdownjs configfile\n");
		}
		
		private static bool openFileForReading(string name, out StreamReader fs)
		{
			StreamReader f = null;
			bool rc = false;
			try {
				f = File.OpenText(name);
				
				rc = true;
			} catch (System.ArgumentException ae) {
				Console.Write("Invalid Filename: '" + name + "' (" + ae.ToString() + ")\n");
			} catch (System.IO.PathTooLongException ptl) {
				Console.Write("Path too long: '" + name + "' (" + ptl.ToString() + ")\n");
			} catch (System.IO.DirectoryNotFoundException dnf) {				
				Console.Write("File not found: '" + name + "' (" + dnf.ToString() + ")\n");
			} catch (System.UnauthorizedAccessException uae) {
				Console.Write("Read denied: '" + name + "' (" + uae.ToString() + ")\n");
			} catch (System.IO.FileNotFoundException fnf) {
				Console.Write("File not found: '" + name + "' (" + fnf.ToString() + ")\n");
			} catch (System.NotSupportedException nse) {
				Console.Write("Invalid format: '" + name + "' (" + nse.ToString() + ")\n");
			}
			fs = f;
			return rc;
		}
		
		private static int processFile(string name)
		{
			StreamReader f;
			string s;
			if (!openFileForReading(name, out f)) return 1;
			
			while ((s = f.ReadLine()) != null) {
				s = s.Trim(null);
				string upperS = s.ToUpperInvariant();
				if (upperS.StartsWith("REPOUSER")) {
					int start = upperS.IndexOf("G");	// The string looks like
										// RepoUser= "GLOBAL.'SOMETHING'..."
					int end = s.LastIndexOf("\"");
					if (end == -1) end = s.Length;
					string jsn = s.Substring(start, end - start);
					Console.Write("SHUTDOWN SCOPE " + jsn + ";\n");
					break;
				}
			}
			
			f.Close();
			return 0;
		}
		
		public static int Main(string[] args)
		{
			if (args.Length != 1) {
				usage();
				return 1;
			}
			if (!File.Exists(args[0])) {
				Console.Write("Configuration file not found\n\n");
				usage();
				return 1;
			}
			return processFile(args[0]);
		}
	}
}