#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <windows.h>

/* typedef int   Bool */
#define true  (1 == 1)
#define false (1 == 0)

#define BUFSIZE	2048

char buf[BUFSIZE];

void usage()
{
	fprintf(stdout, "Usage: shutdownjs configfile\n");
}
		
int openFileForReading(char *name, HANDLE *fs)
{
	fs = CreateFile(name, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	if (fs == INVALID_HANDLE_VALUE) return false;
		
	return true;
}
		
int processFile(char *name)
{
	HANDLE f;
	DWORD bytesRead;
	int pos;

	if (!openFileForReading(name, &f)) return false;
			
	while (ReadFile(f, buf, BUFSIZE, &bytesRead, NULL) && bytesRead > 0) {
		/* trim first */
		pos = strlen(buf) - 1;
		while (pos >=0 && isblank(buf[pos])) {
			buf[pos] = '\0';
			--pos;
		}
		/* now uppercase */
		while (pos >= 0) {
			buf[pos] = toupper(buf[pos]);
			--pos;
		}
		if (strncmp(buf, "REPOUSER", 8)) {
			pos = 8;
			while (buf[pos] != 'G') ++pos;
			printf("SHUTDOWN SCOPE %s;\n", buf + pos);
		}
	}
			
	CloseHandle(f);
	return true;
}
		
int main(int argc, char *argv[])
{
	if (argc != 2) {
		usage();
		return 1;
	}
/*
			if (!File.Exists(args[0])) {
				Console.Write("Configuration file not found\n\n");
				usage();
				return 1;
			}
*/
	if (processFile(argv[1])) return 0;
	return 1;
}
