CREATE OR REPLACE VIEW sci_sme_quarter (jahr, quartal, anzahl,
                 expected_anzahl, avg_anzahl_pro_tag)
AS
SELECT jahr,
       trunc((monat-1)/3)+1,
       sum(anzahl),
       decode(TRIM(to_char(jahr))||TRIM(to_char(trunc((monat-1)/3)+1)),
              to_char(sysdate,'YYYYQ'),
                  round(sum(anzahl) *
                        /* anzahl Tage im aktuellen quartal */
                        timestampdiff(16 , add_months(trunc_timestamp(current timestamp,'Q'),3) - trunc_timestamp(current timestamp,'Q')) /
                        /* vergangene Tage im aktuellen quartal */
                        timestampdiff(16 , current timestamp - trunc_timestamp(current timestamp,'Q'))
                      , 2
                  ),
              sum(anzahl)
       ),
       decode(TRIM(to_char(jahr))||TRIM(to_char(trunc((monat-1)/3)+1)),
              to_char(sysdate,'YYYYQ'),
                  round(sum(anzahl) /
                        /* anzahl Tage im aktuellen quartal */
                        timestampdiff(16, add_months(trunc_timestamp(current timestamp,'Q'),3) - trunc_timestamp(current timestamp,'Q'))
                      , 2
                  ),
              round(sum(anzahl) /
                    /* anzahl Tage im quartal */
                    timestampdiff(16, 
                                  add_months(add_months(to_date(TRIM(TO_CHAR(jahr)),'YYYY'),trunc((monat-1)/3)*3), 3)
                                       - add_months(to_date(TRIM(TO_CHAR(jahr)),'YYYY'),trunc((monat-1)/3)*3)
                    )
                  , 2
              )
       )
FROM sme_counter
GROUP BY jahr, trunc((monat-1)/3)
;
