-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE POOL (
    ID                             bigint NOT NULL
    , NR_ID                          bigint          NOT NULL
    , SCOPE_ID                       bigint          NOT NULL
    , OWNER_ID                       bigint          NOT NULL
    , MANAGER_ID                     bigint              NULL
    , DIST_ID                        bigint              NULL
    , DEFINED_AMOUNT                 integer         NOT NULL
    , AMOUNT                         integer         NOT NULL
    , FREE_AMOUNT                    integer         NOT NULL
    , CHILD_ALLOCATED                integer         NOT NULL
    , EVALUATION_CYCLE               integer             NULL
    , NEXT_EVALUATION_TIME           bigint          NOT NULL
    , TAG                            varchar(64)         NULL
    , TRACE_INTERVAL                 integer             NULL
    , TRACE_BASE                     integer             NULL
    , TRACE_BASE_MULTIPLIER          integer         NOT NULL
    , TD0_AVG                        float           NOT NULL
    , TD1_AVG                        float           NOT NULL
    , TD2_AVG                        float           NOT NULL
    , LW_AVG                         float           NOT NULL
    , LAST_EVAL                      bigint          NOT NULL
    , LAST_WRITE                     bigint          NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_POOL
ON POOL(ID);
CREATE VIEW SCI_POOL AS
SELECT 
    ID 
    , NR_ID                          AS NR_ID
    , SCOPE_ID                       AS SCOPE_ID
    , OWNER_ID                       AS OWNER_ID
    , MANAGER_ID                     AS MANAGER_ID
    , DIST_ID                        AS DIST_ID
    , DEFINED_AMOUNT                 AS DEFINED_AMOUNT
    , AMOUNT                         AS AMOUNT
    , FREE_AMOUNT                    AS FREE_AMOUNT
    , CHILD_ALLOCATED                AS CHILD_ALLOCATED
    , EVALUATION_CYCLE               AS EVALUATION_CYCLE
    , NEXT_EVALUATION_TIME           AS NEXT_EVALUATION_TIME
    , TAG                            AS TAG
    , TRACE_INTERVAL                 AS TRACE_INTERVAL
    , TRACE_BASE                     AS TRACE_BASE
    , TRACE_BASE_MULTIPLIER          AS TRACE_BASE_MULTIPLIER
    , TD0_AVG                        AS TD0_AVG
    , TD1_AVG                        AS TD1_AVG
    , TD2_AVG                        AS TD2_AVG
    , LW_AVG                         AS LW_AVG
    , timestamp('1970-01-01-00.00.00') + int(mod(LAST_EVAL, 1125899906842624)/1000) seconds AS LAST_EVAL
    , timestamp('1970-01-01-00.00.00') + int(mod(LAST_WRITE, 1125899906842624)/1000) seconds AS LAST_WRITE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM POOL;
