-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE SCHEDULING_HIERARCHY (
    ID                             bigint NOT NULL
    , SE_PARENT_ID                   bigint              NULL
    , SE_CHILD_ID                    bigint              NULL
    , ALIAS_NAME                     varchar(64)         NULL
    , IS_STATIC                      integer         NOT NULL
    , IS_DISABLED                    integer         NOT NULL
    , PRIORITY                       integer         NOT NULL
    , SUSPEND                        integer         NOT NULL
    , RESUME_AT                      varchar(20)         NULL
    , RESUME_IN                      integer             NULL
    , RESUME_BASE                    integer             NULL
    , MERGE_MODE                     integer         NOT NULL
    , ESTP_ID                        bigint              NULL
    , INT_ID                         bigint              NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
    , VALID_FROM                   bigint NOT NULL
    , VALID_TO                     bigint NOT NULL
);
CREATE INDEX PK_SCHEDULING_HIERARCHY
ON SCHEDULING_HIERARCHY(ID);
CREATE VIEW SCI_C_SCHEDULING_HIERARCHY AS
SELECT 
    ID 
    , SE_PARENT_ID                   AS SE_PARENT_ID
    , SE_CHILD_ID                    AS SE_CHILD_ID
    , ALIAS_NAME                     AS ALIAS_NAME
    , DECODE (IS_STATIC, 1, 'STATIC', 0, 'DYNAMIC') AS IS_STATIC
    , DECODE (IS_DISABLED, 0, 'ENABLED', 1, 'DISABLED') AS IS_DISABLED
    , PRIORITY                       AS PRIORITY
    , DECODE (SUSPEND, 1, 'CHILDSUSPEND', 2, 'NOSUSPEND', 3, 'SUSPEND') AS SUSPEND
    , RESUME_AT                      AS RESUME_AT
    , RESUME_IN                      AS RESUME_IN
    , DECODE (RESUME_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS RESUME_BASE
    , DECODE (MERGE_MODE, 1, 'MERGE_LOCAL', 2, 'MERGE_GLOBAL', 3, 'NOMERGE', 4, 'FAILURE') AS MERGE_MODE
    , ESTP_ID                        AS ESTP_ID
    , INT_ID                         AS INT_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM SCHEDULING_HIERARCHY
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_SCHEDULING_HIERARCHY AS
SELECT 
    ID 
    , SE_PARENT_ID                   AS SE_PARENT_ID
    , SE_CHILD_ID                    AS SE_CHILD_ID
    , ALIAS_NAME                     AS ALIAS_NAME
    , DECODE (IS_STATIC, 1, 'STATIC', 0, 'DYNAMIC') AS IS_STATIC
    , DECODE (IS_DISABLED, 0, 'ENABLED', 1, 'DISABLED') AS IS_DISABLED
    , PRIORITY                       AS PRIORITY
    , DECODE (SUSPEND, 1, 'CHILDSUSPEND', 2, 'NOSUSPEND', 3, 'SUSPEND') AS SUSPEND
    , RESUME_AT                      AS RESUME_AT
    , RESUME_IN                      AS RESUME_IN
    , DECODE (RESUME_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS RESUME_BASE
    , DECODE (MERGE_MODE, 1, 'MERGE_LOCAL', 2, 'MERGE_GLOBAL', 3, 'NOMERGE', 4, 'FAILURE') AS MERGE_MODE
    , ESTP_ID                        AS ESTP_ID
    , INT_ID                         AS INT_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM SCHEDULING_HIERARCHY;
