ALTER TABLE RESOURCE_ALLOCATION
    ADD STICKY_NAME varchar(64)
    ADD STICKY_PARENT bigint;
DROP VIEW SCI_RESOURCE_ALLOCATION;
CREATE VIEW SCI_RESOURCE_ALLOCATION AS
SELECT 
    ID 
    , R_ID                           AS R_ID
    , SME_ID                         AS SME_ID
    , NR_ID                          AS NR_ID
    , AMOUNT                         AS AMOUNT
    , ORIG_AMOUNT                    AS ORIG_AMOUNT
    , DECODE (KEEP_MODE, 0, 'NOKEEP', 1, 'KEEP', 2, 'KEEP_FINAL') AS KEEP_MODE
    , DECODE (IS_STICKY, 1, 'TRUE', 0, 'FALSE') AS IS_STICKY
    , STICKY_NAME                    AS STICKY_NAME
    , STICKY_PARENT                  AS STICKY_PARENT
    , DECODE (ALLOCATION_TYPE, 1, 'REQUEST', 6, 'MASTER_REQUEST', 2, 'RESERVATION', 3, 'MASTER_RESERVATION', 4, 'ALLOCATION', 5, 'IGNORE') AS ALLOCATION_TYPE
    , RSMP_ID                        AS RSMP_ID
    , DECODE (LOCKMODE, 255, 'N', 0, 'X', 2, 'SX', 4, 'S', 6, 'SC') AS LOCKMODE
    , REFCOUNT                       AS REFCOUNT
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM RESOURCE_ALLOCATION;
ALTER TABLE RESOURCE_REQUIREMENT
    ADD STICKY_NAME varchar(64)
    ADD STICKY_PARENT bigint;
DROP VIEW SCI_C_RESOURCE_REQUIREMENT;
DROP VIEW SCI_V_RESOURCE_REQUIREMENT;
CREATE VIEW SCI_C_RESOURCE_REQUIREMENT AS
SELECT 
    ID 
    , NR_ID                          AS NR_ID
    , SE_ID                          AS SE_ID
    , AMOUNT                         AS AMOUNT
    , DECODE (KEEP_MODE, 0, 'NOKEEP', 1, 'KEEP', 2, 'KEEP_FINAL') AS KEEP_MODE
    , DECODE (IS_STICKY, 1, 'TRUE', 0, 'FALSE') AS IS_STICKY
    , STICKY_NAME                    AS STICKY_NAME
    , STICKY_PARENT                  AS STICKY_PARENT
    , RSMP_ID                        AS RSMP_ID
    , EXPIRED_AMOUNT                 AS EXPIRED_AMOUNT
    , DECODE (EXPIRED_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS EXPIRED_BASE
    , DECODE (LOCKMODE, 255, 'N', 0, 'X', 2, 'SX', 4, 'S', 6, 'SC') AS LOCKMODE
    , CONDITION                      AS CONDITION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM RESOURCE_REQUIREMENT
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_RESOURCE_REQUIREMENT AS
SELECT 
    ID 
    , NR_ID                          AS NR_ID
    , SE_ID                          AS SE_ID
    , AMOUNT                         AS AMOUNT
    , DECODE (KEEP_MODE, 0, 'NOKEEP', 1, 'KEEP', 2, 'KEEP_FINAL') AS KEEP_MODE
    , DECODE (IS_STICKY, 1, 'TRUE', 0, 'FALSE') AS IS_STICKY
    , STICKY_NAME                    AS STICKY_NAME
    , STICKY_PARENT                  AS STICKY_PARENT
    , RSMP_ID                        AS RSMP_ID
    , EXPIRED_AMOUNT                 AS EXPIRED_AMOUNT
    , DECODE (EXPIRED_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS EXPIRED_BASE
    , DECODE (LOCKMODE, 255, 'N', 0, 'X', 2, 'SX', 4, 'S', 6, 'SC') AS LOCKMODE
    , CONDITION                      AS CONDITION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM RESOURCE_REQUIREMENT;
ALTER TABLE SCOPE
    ADD SALT varchar(64)
    ADD METHOD integer DEFAULT 0 NOT NULL;
DROP VIEW SCI_SCOPE;
CREATE VIEW SCI_SCOPE AS
SELECT 
    ID 
    , NAME                           AS NAME
    , OWNER_ID                       AS OWNER_ID
    , PARENT_ID                      AS PARENT_ID
    , DECODE (TYPE, 1, 'SCOPE', 2, 'SERVER') AS TYPE
    , DECODE (IS_TERMINATE, 1, 'TRUE', 0, 'FALSE') AS IS_TERMINATE
    , DECODE (HAS_ALTEREDCONFIG, 1, 'TRUE', 0, 'FALSE') AS HAS_ALTEREDCONFIG
    , DECODE (IS_SUSPENDED, 1, 'TRUE', 0, 'FALSE') AS IS_SUSPENDED
    , DECODE (IS_ENABLED, 1, 'TRUE', 0, 'FALSE') AS IS_ENABLED
    , DECODE (IS_REGISTERED, 1, 'TRUE', 0, 'FALSE') AS IS_REGISTERED
    , DECODE (STATE, 1, 'NOMINAL', 2, 'NONFATAL', 3, 'FATAL') AS STATE
    , PID                            AS PID
    , NODE                           AS NODE
    , ERRMSG                         AS ERRMSG
    , LAST_ACTIVE                    AS LAST_ACTIVE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
    , INHERIT_PRIVS                  AS INHERIT_PRIVS
  FROM SCOPE;
ALTER TABLE USERS
    ADD SALT varchar(64)
    ADD METHOD integer DEFAULT 0 NOT NULL;
DROP VIEW SCI_USERS;
CREATE VIEW SCI_USERS AS
SELECT 
    ID 
    , NAME                           AS NAME
    , DECODE (IS_ENABLED, 1, 'TRUE', 0, 'FALSE') AS IS_ENABLED
    , DEFAULT_G_ID                   AS DEFAULT_G_ID
    , DELETE_VERSION                 AS DELETE_VERSION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM USERS;
CREATE TABLE SME2LOAD (ID BIGINT NOT NULL);
CREATE INDEX SME2LOAD_IDX ON SME2LOAD (ID);
CREATE INDEX SME_IDX ON SUBMITTED_ENTITY (MASTER_ID, ID, STATE, FINAL_TS);
CREATE INDEX KILL_JOB_IDX ON KILL_JOB (SME_ID);
CREATE INDEX AUDIT_TRAIL_IDX ON AUDIT_TRAIL (OBJECT_ID);
CREATE INDEX ENTITY_VARIABLE_IDX ON ENTITY_VARIABLE (SME_ID);
CREATE INDEX DEPENDENCY_INSTANCE_IDX ON DEPENDENCY_INSTANCE (DEPENDENT_ID);
CREATE INDEX HIERARCHY_INSTANCE_IDX ON HIERARCHY_INSTANCE (CHILD_ID);
UPDATE RESOURCE_ALLOCATION
   SET STICKY_PARENT = (
       SELECT MASTER_ID
         FROM SUBMITTED_ENTITY
        WHERE ID = SME_ID
       )
 WHERE IS_STICKY = 1
   AND SME_ID > 0;
UPDATE RESOURCE_ALLOCATION
   SET STICKY_PARENT = -SME_ID
 WHERE IS_STICKY = 1
   AND SME_ID < 0;
ALTER TABLE SCOPE ALTER PASSWD SET DATA TYPE VARCHAR(64);
