ALTER TABLE DEPENDENCY_DEFINITION
    ADD RESOLVE_MODE integer DEFAULT 0 NOT NULL
    ADD EXPIRED_AMOUNT integer
    ADD EXPIRED_BASE integer
    ADD SELECT_CONDITION varchar(1024);
DROP VIEW SCI_C_DEPENDENCY_DEFINITION;
DROP VIEW SCI_V_DEPENDENCY_DEFINITION;
CREATE VIEW SCI_C_DEPENDENCY_DEFINITION AS
SELECT 
    ID 
    , SE_DEPENDENT_ID                AS SE_DEPENDENT_ID
    , SE_REQUIRED_ID                 AS SE_REQUIRED_ID
    , NAME                           AS NAME
    , DECODE (UNRESOLVED_HANDLING, 1, 'IGNORE', 2, 'ERROR', 3, 'SUSPEND', 4, 'DEFER', 5, 'DEFER_IGNORE') AS UNRESOLVED_HANDLING
    , DECODE (DMODE, 1, 'ALL_FINAL', 2, 'JOB_FINAL') AS DMODE
    , DECODE (STATE_SELECTION, 0, 'FINAL', 1, 'ALL_REACHABLE', 2, 'UNREACHABLE', 3, 'DEFAULT') AS STATE_SELECTION
    , CONDITION                      AS CONDITION
    , DECODE (RESOLVE_MODE, 0, 'INTERNAL', 1, 'EXTERNAL', 2, 'BOTH') AS RESOLVE_MODE
    , EXPIRED_AMOUNT                 AS EXPIRED_AMOUNT
    , DECODE (EXPIRED_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS EXPIRED_BASE
    , SELECT_CONDITION               AS SELECT_CONDITION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM DEPENDENCY_DEFINITION
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_DEPENDENCY_DEFINITION AS
SELECT 
    ID 
    , SE_DEPENDENT_ID                AS SE_DEPENDENT_ID
    , SE_REQUIRED_ID                 AS SE_REQUIRED_ID
    , NAME                           AS NAME
    , DECODE (UNRESOLVED_HANDLING, 1, 'IGNORE', 2, 'ERROR', 3, 'SUSPEND', 4, 'DEFER', 5, 'DEFER_IGNORE') AS UNRESOLVED_HANDLING
    , DECODE (DMODE, 1, 'ALL_FINAL', 2, 'JOB_FINAL') AS DMODE
    , DECODE (STATE_SELECTION, 0, 'FINAL', 1, 'ALL_REACHABLE', 2, 'UNREACHABLE', 3, 'DEFAULT') AS STATE_SELECTION
    , CONDITION                      AS CONDITION
    , DECODE (RESOLVE_MODE, 0, 'INTERNAL', 1, 'EXTERNAL', 2, 'BOTH') AS RESOLVE_MODE
    , EXPIRED_AMOUNT                 AS EXPIRED_AMOUNT
    , DECODE (EXPIRED_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS EXPIRED_BASE
    , SELECT_CONDITION               AS SELECT_CONDITION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM DEPENDENCY_DEFINITION;
ALTER TABLE DEPENDENCY_INSTANCE
    ADD REQUIRED_SE_ID bigint;
ALTER TABLE ARC_DEPENDENCY_INSTANCE
    ADD REQUIRED_SE_ID bigint;
DROP VIEW SCI_DEPENDENCY_INSTANCE;
CREATE VIEW SCI_DEPENDENCY_INSTANCE AS
SELECT 
    ID 
    , DD_ID                          AS DD_ID
    , DEPENDENT_ID                   AS DEPENDENT_ID
    , DEPENDENT_ID_ORIG              AS DEPENDENT_ID_ORIG
    , DECODE (DEPENDENCY_OPERATION, 1, 'AND', 2, 'OR') AS DEPENDENCY_OPERATION
    , REQUIRED_ID                    AS REQUIRED_ID
    , REQUIRED_SE_ID                 AS REQUIRED_SE_ID
    , DECODE (STATE, 0, 'OPEN', 1, 'FULFILLED', 2, 'FAILED', 3, 'BROKEN', 4, 'DEFERRED', 8, 'CANCELLED') AS STATE
    , DECODE (IGNORE, 0, 'NO', 1, 'YES', 2, 'RECURSIVE') AS IGNORE
    , DI_ID_ORIG                     AS DI_ID_ORIG
    , SE_VERSION                     AS SE_VERSION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM DEPENDENCY_INSTANCE;
ALTER TABLE INTERVALL
    ADD OBJ_ID bigint
    ADD OBJ_TYPE integer;
DROP VIEW SCI_INTERVALL;
CREATE VIEW SCI_INTERVALL AS
SELECT 
    ID 
    , NAME                           AS NAME
    , OWNER_ID                       AS OWNER_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(START_TIME, 1125899906842624)/1000) seconds AS START_TIME
    , timestamp('1970-01-01-00.00.00') + int(mod(END_TIME, 1125899906842624)/1000) seconds AS END_TIME
    , DELAY                          AS DELAY
    , DECODE (BASE_INTERVAL, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS BASE_INTERVAL
    , BASE_INTERVAL_MULTIPLIER       AS BASE_INTERVAL_MULTIPLIER
    , DECODE (DURATION, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS DURATION
    , DURATION_MULTIPLIER            AS DURATION_MULTIPLIER
    , timestamp('1970-01-01-00.00.00') + int(mod(SYNC_TIME, 1125899906842624)/1000) seconds AS SYNC_TIME
    , DECODE (IS_INVERSE, 1, 'TRUE', 0, 'FALSE') AS IS_INVERSE
    , DECODE (IS_MERGE, 1, 'TRUE', 0, 'FALSE') AS IS_MERGE
    , EMBEDDED_INT_ID                AS EMBEDDED_INT_ID
    , SE_ID                          AS SE_ID
    , OBJ_ID                         AS OBJ_ID
    , DECODE (OBJ_TYPE, 25, 'DISTRIBUTION', 8, 'USER', 9, 'JOB_DEFINITION', 11, 'RESOURCE', 15, 'SCOPE', 16, 'TRIGGER', 18, 'EVENT', 19, 'INTERVAL', 20, 'SCHEDULE', 22, 'SCHEDULED_EVENT', 28, 'RESOURCE_TEMPLATE', 88, 'INTERVAL_DISPATCHER') AS OBJ_TYPE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM INTERVALL;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE INTERVAL_DISPATCHER (
    ID                             bigint NOT NULL
    , INT_ID                         bigint          NOT NULL
    , SEQ_NO                         integer         NOT NULL
    , NAME                           varchar(64)     NOT NULL
    , SELECT_INT_ID                  bigint              NULL
    , FILTER_INT_ID                  bigint              NULL
    , IS_ENABLED                     integer         NOT NULL
    , IS_ACTIVE                      integer         NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_INTERVAL_DISPATCHER
ON INTERVAL_DISPATCHER(ID);
DROP VIEW SCI_INTERVAL_DISPATCHER;
CREATE VIEW SCI_INTERVAL_DISPATCHER AS
SELECT 
    ID 
    , INT_ID                         AS INT_ID
    , SEQ_NO                         AS SEQ_NO
    , NAME                           AS NAME
    , SELECT_INT_ID                  AS SELECT_INT_ID
    , FILTER_INT_ID                  AS FILTER_INT_ID
    , DECODE (IS_ENABLED, 1, 'TRUE', 0, 'FALSE') AS IS_ENABLED
    , DECODE (IS_ACTIVE, 1, 'TRUE', 0, 'FALSE') AS IS_ACTIVE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM INTERVAL_DISPATCHER;
ALTER TABLE SCHEDULING_HIERARCHY
    ADD INT_ID bigint;
DROP VIEW SCI_C_SCHEDULING_HIERARCHY;
DROP VIEW SCI_V_SCHEDULING_HIERARCHY;
CREATE VIEW SCI_C_SCHEDULING_HIERARCHY AS
SELECT 
    ID 
    , SE_PARENT_ID                   AS SE_PARENT_ID
    , SE_CHILD_ID                    AS SE_CHILD_ID
    , ALIAS_NAME                     AS ALIAS_NAME
    , DECODE (IS_STATIC, 1, 'STATIC', 0, 'DYNAMIC') AS IS_STATIC
    , DECODE (IS_DISABLED, 0, 'ENABLED', 1, 'DISABLED') AS IS_DISABLED
    , PRIORITY                       AS PRIORITY
    , DECODE (SUSPEND, 1, 'CHILDSUSPEND', 2, 'NOSUSPEND', 3, 'SUSPEND') AS SUSPEND
    , RESUME_AT                      AS RESUME_AT
    , RESUME_IN                      AS RESUME_IN
    , DECODE (RESUME_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS RESUME_BASE
    , DECODE (MERGE_MODE, 1, 'MERGE_LOCAL', 2, 'MERGE_GLOBAL', 3, 'NOMERGE', 4, 'FAILURE') AS MERGE_MODE
    , ESTP_ID                        AS ESTP_ID
    , INT_ID                         AS INT_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM SCHEDULING_HIERARCHY
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_SCHEDULING_HIERARCHY AS
SELECT 
    ID 
    , SE_PARENT_ID                   AS SE_PARENT_ID
    , SE_CHILD_ID                    AS SE_CHILD_ID
    , ALIAS_NAME                     AS ALIAS_NAME
    , DECODE (IS_STATIC, 1, 'STATIC', 0, 'DYNAMIC') AS IS_STATIC
    , DECODE (IS_DISABLED, 0, 'ENABLED', 1, 'DISABLED') AS IS_DISABLED
    , PRIORITY                       AS PRIORITY
    , DECODE (SUSPEND, 1, 'CHILDSUSPEND', 2, 'NOSUSPEND', 3, 'SUSPEND') AS SUSPEND
    , RESUME_AT                      AS RESUME_AT
    , RESUME_IN                      AS RESUME_IN
    , DECODE (RESUME_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS RESUME_BASE
    , DECODE (MERGE_MODE, 1, 'MERGE_LOCAL', 2, 'MERGE_GLOBAL', 3, 'NOMERGE', 4, 'FAILURE') AS MERGE_MODE
    , ESTP_ID                        AS ESTP_ID
    , INT_ID                         AS INT_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM SCHEDULING_HIERARCHY;
ALTER TABLE SUBMITTED_ENTITY
    ADD TIME_ZONE varchar(32);
ALTER TABLE ARC_SUBMITTED_ENTITY
    ADD TIME_ZONE varchar(32);
DROP VIEW SCI_SUBMITTED_ENTITY;
CREATE VIEW SCI_SUBMITTED_ENTITY AS
SELECT 
    ID 
    , MASTER_ID                      AS MASTER_ID
    , SUBMIT_TAG                     AS SUBMIT_TAG
    , DECODE (UNRESOLVED_HANDLING, 1, 'UH_IGNORE', 3, 'UH_SUSPEND', 2, 'UH_ERROR') AS UNRESOLVED_HANDLING
    , SE_ID                          AS SE_ID
    , CHILD_TAG                      AS CHILD_TAG
    , SE_VERSION                     AS SE_VERSION
    , OWNER_ID                       AS OWNER_ID
    , PARENT_ID                      AS PARENT_ID
    , SCOPE_ID                       AS SCOPE_ID
    , DECODE (IS_STATIC, 1, 'TRUE', 0, 'FALSE') AS IS_STATIC
    , DECODE (IS_DISABLED, 1, 'TRUE', 0, 'FALSE') AS IS_DISABLED
    , OLD_STATE                      AS OLD_STATE
    , DECODE (MERGE_MODE, 1, 'MERGE_LOCAL', 2, 'MERGE_GLOBAL', 3, 'NOMERGE', 4, 'FAILURE') AS MERGE_MODE
    , DECODE (STATE, 0, 'SUBMITTED', 1, 'DEPENDENCY_WAIT', 2, 'SYNCHRONIZE_WAIT', 3, 'RESOURCE_WAIT', 4, 'RUNNABLE', 5, 'STARTING', 6, 'STARTED', 7, 'RUNNING', 8, 'TO_KILL', 9, 'KILLED', 10, 'CANCELLED', 11, 'FINISHED', 12, 'FINAL', 13, 'BROKEN_ACTIVE', 14, 'BROKEN_FINISHED', 15, 'ERROR', 16, 'UNREACHABLE') AS STATE
    , JOB_ESD_ID                     AS JOB_ESD_ID
    , JOB_ESD_PREF                   AS JOB_ESD_PREF
    , DECODE (JOB_IS_FINAL, 1, 'TRUE', 0, 'FALSE') AS JOB_IS_FINAL
    , DECODE (JOB_IS_RESTARTABLE, 1, 'TRUE', 0, 'FALSE') AS JOB_IS_RESTARTABLE
    , FINAL_ESD_ID                   AS FINAL_ESD_ID
    , EXIT_CODE                      AS EXIT_CODE
    , COMMANDLINE                    AS COMMANDLINE
    , RR_COMMANDLINE                 AS RR_COMMANDLINE
    , RERUN_SEQ                      AS RERUN_SEQ
    , DECODE (IS_REPLACED, 1, 'TRUE', 0, 'FALSE') AS IS_REPLACED
    , DECODE (IS_CANCELLED, 1, 'TRUE', 0, 'FALSE') AS IS_CANCELLED
    , BASE_SME_ID                    AS BASE_SME_ID
    , REASON_SME_ID                  AS REASON_SME_ID
    , FIRE_SME_ID                    AS FIRE_SME_ID
    , FIRE_SE_ID                     AS FIRE_SE_ID
    , TR_ID                          AS TR_ID
    , TR_SD_ID_OLD                   AS TR_SD_ID_OLD
    , TR_SD_ID_NEW                   AS TR_SD_ID_NEW
    , TR_SEQ                         AS TR_SEQ
    , WORKDIR                        AS WORKDIR
    , LOGFILE                        AS LOGFILE
    , ERRLOGFILE                     AS ERRLOGFILE
    , PID                            AS PID
    , EXTPID                         AS EXTPID
    , ERROR_MSG                      AS ERROR_MSG
    , KILL_ID                        AS KILL_ID
    , KILL_EXIT_CODE                 AS KILL_EXIT_CODE
    , DECODE (IS_SUSPENDED, 2, 'ADMINSUSPEND', 1, 'SUSPEND', 0, 'NOSUSPEND') AS IS_SUSPENDED
    , DECODE (IS_SUSPENDED_LOCAL, 1, 'TRUE', 0, 'FALSE') AS IS_SUSPENDED_LOCAL
    , PRIORITY                       AS PRIORITY
    , RAW_PRIORITY                   AS RAW_PRIORITY
    , NICE                           AS NICE
    , NP_NICE                        AS NP_NICE
    , MIN_PRIORITY                   AS MIN_PRIORITY
    , AGING_AMOUNT                   AS AGING_AMOUNT
    , PARENT_SUSPENDED               AS PARENT_SUSPENDED
    , CHILD_SUSPENDED                AS CHILD_SUSPENDED
    , WARN_COUNT                     AS WARN_COUNT
    , WARN_LINK                      AS WARN_LINK
    , timestamp('1970-01-01-00.00.00') + int(mod(SUBMIT_TS, 1125899906842624)/1000) seconds AS SUBMIT_TS
    , timestamp('1970-01-01-00.00.00') + int(mod(RESUME_TS, 1125899906842624)/1000) seconds AS RESUME_TS
    , timestamp('1970-01-01-00.00.00') + int(mod(SYNC_TS, 1125899906842624)/1000) seconds AS SYNC_TS
    , timestamp('1970-01-01-00.00.00') + int(mod(RESOURCE_TS, 1125899906842624)/1000) seconds AS RESOURCE_TS
    , timestamp('1970-01-01-00.00.00') + int(mod(RUNNABLE_TS, 1125899906842624)/1000) seconds AS RUNNABLE_TS
    , timestamp('1970-01-01-00.00.00') + int(mod(START_TS, 1125899906842624)/1000) seconds AS START_TS
    , timestamp('1970-01-01-00.00.00') + int(mod(FINSH_TS, 1125899906842624)/1000) seconds AS FINSH_TS
    , timestamp('1970-01-01-00.00.00') + int(mod(FINAL_TS, 1125899906842624)/1000) seconds AS FINAL_TS
    , IDLE_TIME                      AS IDLE_TIME
    , DEPENDENCY_WAIT_TIME           AS DEPENDENCY_WAIT_TIME
    , SUSPEND_TIME                   AS SUSPEND_TIME
    , SYNC_TIME                      AS SYNC_TIME
    , RESOURCE_TIME                  AS RESOURCE_TIME
    , JOBSERVER_TIME                 AS JOBSERVER_TIME
    , RESTARTABLE_TIME               AS RESTARTABLE_TIME
    , CHILD_WAIT_TIME                AS CHILD_WAIT_TIME
    , OP_SUSRES_TS                   AS OP_SUSRES_TS
    , NPE_ID                         AS NPE_ID
    , TIME_ZONE                      AS TIME_ZONE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
    , ((NVL(FINAL_TS, TIMESTAMPDIFF(2, CURRENT TIMESTAMP - CURRENT TIMEZONE - TIMESTAMP('1970-01-01-00.00.00')) * 1000) - SUBMIT_TS) / 1000) - DEPENDENCY_WAIT_TIME AS PROCESS_TIME
  FROM SUBMITTED_ENTITY;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE TRIGGER_PARAMETER (
    ID                             bigint NOT NULL
    , NAME                           varchar(64)     NOT NULL
    , EXPRESSION                     varchar(1024)   NOT NULL
    , TRIGGER_ID                     bigint          NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
    , VALID_FROM                   bigint NOT NULL
    , VALID_TO                     bigint NOT NULL
);
CREATE INDEX PK_TRIGGER_PARAMETER
ON TRIGGER_PARAMETER(ID);
DROP VIEW SCI_C_TRIGGER_PARAMETER;
DROP VIEW SCI_V_TRIGGER_PARAMETER;
CREATE VIEW SCI_C_TRIGGER_PARAMETER AS
SELECT 
    ID 
    , NAME                           AS NAME
    , EXPRESSION                     AS EXPRESSION
    , TRIGGER_ID                     AS TRIGGER_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM TRIGGER_PARAMETER
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_TRIGGER_PARAMETER AS
SELECT 
    ID 
    , NAME                           AS NAME
    , EXPRESSION                     AS EXPRESSION
    , TRIGGER_ID                     AS TRIGGER_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM TRIGGER_PARAMETER;
ALTER TABLE SCOPE ALTER NODE SET DATA TYPE VARCHAR(64);
