ALTER TABLE ENTITY_VARIABLE ADD (
    IS_LONG integer DEFAULT 0 NOT NULL
);
ALTER TABLE ARC_ENTITY_VARIABLE ADD (
    IS_LONG integer
);
DROP VIEW SCI_ENTITY_VARIABLE;
CREATE VIEW SCI_ENTITY_VARIABLE (ID,SME_ID,NAME,VALUE,IS_LOCAL,IS_LONG,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , SME_ID                         AS SME_ID
    , NAME                           AS NAME
    , VALUE                          AS VALUE
    , DECODE (IS_LOCAL, 1, 'TRUE', 0, 'FALSE') AS IS_LOCAL
    , DECODE (IS_LONG, 1, 'TRUE', 0, 'FALSE') AS IS_LONG
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM ENTITY_VARIABLE;
CREATE TABLE ARC_EXTENTS (
    ID                             bigint NOT NULL
    , O_ID                           bigint           NULL
    , SME_ID                         bigint           NULL
    , SEQUENCE                       int8             NULL
    , EXTENT                         lvarchar(256)    NULL
    , CREATOR_U_ID                   bigint           NULL
    , CREATE_TS                      bigint           NULL
    , CHANGER_U_ID                   bigint           NULL
    , CHANGE_TS                      bigint           NULL
);
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE EXTENTS (
    ID                             bigint NOT NULL
    , O_ID                           bigint          NOT NULL
    , SME_ID                         bigint          NOT NULL
    , SEQUENCE                       int8            NOT NULL
    , EXTENT                         lvarchar(256)   NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_EXTENTS
ON EXTENTS(ID);
DROP VIEW SCI_EXTENTS;
CREATE VIEW SCI_EXTENTS (ID,O_ID,SME_ID,SEQUENCE,EXTENT,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , O_ID                           AS O_ID
    , SME_ID                         AS SME_ID
    , SEQUENCE                       AS SEQUENCE
    , EXTENT                         AS EXTENT
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM EXTENTS;
ALTER TABLE PARAMETER_DEFINITION ADD (
    IS_LONG integer DEFAULT 0 NOT NULL
);
DROP VIEW SCI_C_PARAMETER_DEFINITION;
DROP VIEW SCI_V_PARAMETER_DEFINITION;
CREATE VIEW SCI_C_PARAMETER_DEFINITION (ID,SE_ID,NAME,TYPE,AGG_FUNCTION,DEFAULTVALUE,IS_LOCAL,LINK_PD_ID,EXPORT_NAME,IS_LONG,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , SE_ID                          AS SE_ID
    , NAME                           AS NAME
    , DECODE (TYPE, 10, 'REFERENCE', 20, 'CHILDREFERENCE', 30, 'CONSTANT', 40, 'RESULT', 50, 'PARAMETER', 60, 'EXPRESSION', 70, 'IMPORT', 80, 'DYNAMIC', 81, 'DYNAMICVALUE', 90, 'LOCAL_CONSTANT', 91, 'RESOURCEREFERENCE') AS TYPE
    , DECODE (AGG_FUNCTION, 0, 'NONE', 61, 'AVG', 62, 'COUNT', 63, 'MIN', 64, 'MAX', 65, 'SUM') AS AGG_FUNCTION
    , DEFAULTVALUE                   AS DEFAULTVALUE
    , DECODE (IS_LOCAL, 1, 'TRUE', 0, 'FALSE') AS IS_LOCAL
    , LINK_PD_ID                     AS LINK_PD_ID
    , EXPORT_NAME                    AS EXPORT_NAME
    , DECODE (IS_LONG, 1, 'TRUE', 0, 'FALSE') AS IS_LONG
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM PARAMETER_DEFINITION
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_PARAMETER_DEFINITION (ID,SE_ID,NAME,TYPE,AGG_FUNCTION,DEFAULTVALUE,IS_LOCAL,LINK_PD_ID,EXPORT_NAME,IS_LONG,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , SE_ID                          AS SE_ID
    , NAME                           AS NAME
    , DECODE (TYPE, 10, 'REFERENCE', 20, 'CHILDREFERENCE', 30, 'CONSTANT', 40, 'RESULT', 50, 'PARAMETER', 60, 'EXPRESSION', 70, 'IMPORT', 80, 'DYNAMIC', 81, 'DYNAMICVALUE', 90, 'LOCAL_CONSTANT', 91, 'RESOURCEREFERENCE') AS TYPE
    , DECODE (AGG_FUNCTION, 0, 'NONE', 61, 'AVG', 62, 'COUNT', 63, 'MIN', 64, 'MAX', 65, 'SUM') AS AGG_FUNCTION
    , DEFAULTVALUE                   AS DEFAULTVALUE
    , DECODE (IS_LOCAL, 1, 'TRUE', 0, 'FALSE') AS IS_LOCAL
    , LINK_PD_ID                     AS LINK_PD_ID
    , EXPORT_NAME                    AS EXPORT_NAME
    , DECODE (IS_LONG, 1, 'TRUE', 0, 'FALSE') AS IS_LONG
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM PARAMETER_DEFINITION;
ALTER TABLE RESOURCE_REQUIREMENT ADD (
    IGNORE_ON_RERUN integer DEFAULT 0 NOT NULL
);
DROP VIEW SCI_C_RESOURCE_REQUIREMENT;
DROP VIEW SCI_V_RESOURCE_REQUIREMENT;
CREATE VIEW SCI_C_RESOURCE_REQUIREMENT (ID,NR_ID,SE_ID,AMOUNT,KEEP_MODE,IS_STICKY,STICKY_NAME,STICKY_PARENT,RSMP_ID,EXPIRED_AMOUNT,EXPIRED_BASE,IGNORE_ON_RERUN,LOCKMODE,CONDITION,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , NR_ID                          AS NR_ID
    , SE_ID                          AS SE_ID
    , AMOUNT                         AS AMOUNT
    , DECODE (KEEP_MODE, 0, 'NOKEEP', 1, 'KEEP', 2, 'KEEP_FINAL') AS KEEP_MODE
    , DECODE (IS_STICKY, 1, 'TRUE', 0, 'FALSE') AS IS_STICKY
    , STICKY_NAME                    AS STICKY_NAME
    , STICKY_PARENT                  AS STICKY_PARENT
    , RSMP_ID                        AS RSMP_ID
    , EXPIRED_AMOUNT                 AS EXPIRED_AMOUNT
    , DECODE (EXPIRED_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS EXPIRED_BASE
    , DECODE (IGNORE_ON_RERUN, 1, 'TRUE', 0, 'FALSE') AS IGNORE_ON_RERUN
    , DECODE (LOCKMODE, 255, 'N', 0, 'X', 2, 'SX', 4, 'S', 6, 'SC') AS LOCKMODE
    , CONDITION                      AS CONDITION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM RESOURCE_REQUIREMENT
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_RESOURCE_REQUIREMENT (ID,NR_ID,SE_ID,AMOUNT,KEEP_MODE,IS_STICKY,STICKY_NAME,STICKY_PARENT,RSMP_ID,EXPIRED_AMOUNT,EXPIRED_BASE,IGNORE_ON_RERUN,LOCKMODE,CONDITION,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , NR_ID                          AS NR_ID
    , SE_ID                          AS SE_ID
    , AMOUNT                         AS AMOUNT
    , DECODE (KEEP_MODE, 0, 'NOKEEP', 1, 'KEEP', 2, 'KEEP_FINAL') AS KEEP_MODE
    , DECODE (IS_STICKY, 1, 'TRUE', 0, 'FALSE') AS IS_STICKY
    , STICKY_NAME                    AS STICKY_NAME
    , STICKY_PARENT                  AS STICKY_PARENT
    , RSMP_ID                        AS RSMP_ID
    , EXPIRED_AMOUNT                 AS EXPIRED_AMOUNT
    , DECODE (EXPIRED_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS EXPIRED_BASE
    , DECODE (IGNORE_ON_RERUN, 1, 'TRUE', 0, 'FALSE') AS IGNORE_ON_RERUN
    , DECODE (LOCKMODE, 255, 'N', 0, 'X', 2, 'SX', 4, 'S', 6, 'SC') AS LOCKMODE
    , CONDITION                      AS CONDITION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM RESOURCE_REQUIREMENT;
CREATE TABLE ARC_SUBMITTED_ENTITY_STATS (
    ID                             bigint NOT NULL
    , SME_ID                         bigint           NULL
    , RERUN_SEQ                      int8             NULL
    , SCOPE_ID                       bigint           NULL
    , JOB_ESD_ID                     bigint           NULL
    , EXIT_CODE                      int8             NULL
    , COMMANDLINE                    lvarchar(512)    NULL
    , WORKDIR                        lvarchar(512)    NULL
    , LOGFILE                        lvarchar(512)    NULL
    , ERRLOGFILE                     lvarchar(512)    NULL
    , EXTPID                         lvarchar(32)     NULL
    , SYNC_TS                        bigint           NULL
    , RESOURCE_TS                    bigint           NULL
    , RUNNABLE_TS                    bigint           NULL
    , START_TS                       bigint           NULL
    , FINISH_TS                      bigint           NULL
    , CREATOR_U_ID                   bigint           NULL
    , CREATE_TS                      bigint           NULL
    , CHANGER_U_ID                   bigint           NULL
    , CHANGE_TS                      bigint           NULL
);
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE SUBMITTED_ENTITY_STATS (
    ID                             bigint NOT NULL
    , SME_ID                         bigint          NOT NULL
    , RERUN_SEQ                      int8            NOT NULL
    , SCOPE_ID                       bigint              NULL
    , JOB_ESD_ID                     bigint              NULL
    , EXIT_CODE                      int8                NULL
    , COMMANDLINE                    lvarchar(512)       NULL
    , WORKDIR                        lvarchar(512)       NULL
    , LOGFILE                        lvarchar(512)       NULL
    , ERRLOGFILE                     lvarchar(512)       NULL
    , EXTPID                         lvarchar(32)        NULL
    , SYNC_TS                        bigint              NULL
    , RESOURCE_TS                    bigint              NULL
    , RUNNABLE_TS                    bigint              NULL
    , START_TS                       bigint              NULL
    , FINISH_TS                      bigint              NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_SUBMITTED_ENTITY_STATS
ON SUBMITTED_ENTITY_STATS(ID);
DROP VIEW SCI_SUBMITTED_ENTITY_STATS;
CREATE VIEW SCI_SUBMITTED_ENTITY_STATS (ID,SME_ID,RERUN_SEQ,SCOPE_ID,JOB_ESD_ID,EXIT_CODE,COMMANDLINE,WORKDIR,LOGFILE,ERRLOGFILE,EXTPID,SYNC_TS,RESOURCE_TS,RUNNABLE_TS,START_TS,FINISH_TS,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , SME_ID                         AS SME_ID
    , RERUN_SEQ                      AS RERUN_SEQ
    , SCOPE_ID                       AS SCOPE_ID
    , JOB_ESD_ID                     AS JOB_ESD_ID
    , EXIT_CODE                      AS EXIT_CODE
    , COMMANDLINE                    AS COMMANDLINE
    , WORKDIR                        AS WORKDIR
    , LOGFILE                        AS LOGFILE
    , ERRLOGFILE                     AS ERRLOGFILE
    , EXTPID                         AS EXTPID
    , dbinfo ('utc_to_datetime', round(mod(SYNC_TS, 1125899906842624)/1000)) AS SYNC_TS
    , dbinfo ('utc_to_datetime', round(mod(RESOURCE_TS, 1125899906842624)/1000)) AS RESOURCE_TS
    , dbinfo ('utc_to_datetime', round(mod(RUNNABLE_TS, 1125899906842624)/1000)) AS RUNNABLE_TS
    , dbinfo ('utc_to_datetime', round(mod(START_TS, 1125899906842624)/1000)) AS START_TS
    , dbinfo ('utc_to_datetime', round(mod(FINISH_TS, 1125899906842624)/1000)) AS FINISH_TS
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM SUBMITTED_ENTITY_STATS;
ALTER TABLE USERS ADD (
    CONNECTION_TYPE int8 DEFAULT 0 NOT NULL
);
DROP VIEW SCI_USERS;
CREATE VIEW SCI_USERS (ID,NAME,IS_ENABLED,DEFAULT_G_ID,CONNECTION_TYPE,DELETE_VERSION,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , DECODE (IS_ENABLED, 1, 'TRUE', 0, 'FALSE') AS IS_ENABLED
    , DEFAULT_G_ID                   AS DEFAULT_G_ID
    , DECODE (CONNECTION_TYPE, 0, 'PLAIN', 1, 'SSL', 2, 'SSL_AUTH') AS CONNECTION_TYPE
    , DELETE_VERSION                 AS DELETE_VERSION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM USERS;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE USER_EQUIV (
    ID                             bigint NOT NULL
    , U_ID                           bigint          NOT NULL
    , ALT_U_TYPE                     int8            NOT NULL
    , ALT_U_ID                       bigint          NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_USER_EQUIV
ON USER_EQUIV(ID);
DROP VIEW SCI_USER_EQUIV;
CREATE VIEW SCI_USER_EQUIV (ID,U_ID,ALT_U_TYPE,ALT_U_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , U_ID                           AS U_ID
    , DECODE (ALT_U_TYPE, 0, 'USER', 1, 'SERVER') AS ALT_U_TYPE
    , ALT_U_ID                       AS ALT_U_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM USER_EQUIV;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE VERSIONED_EXTENTS (
    ID                             bigint NOT NULL
    , O_ID                           bigint          NOT NULL
    , SEQUENCE                       int8            NOT NULL
    , EXTENT                         lvarchar(256)   NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
    , VALID_FROM                   bigint NOT NULL
    , VALID_TO                     bigint NOT NULL
);
CREATE INDEX PK_VERSIONED_EXTENTS
ON VERSIONED_EXTENTS(ID);
DROP VIEW SCI_C_VERSIONED_EXTENTS;
DROP VIEW SCI_V_VERSIONED_EXTENTS;
CREATE VIEW SCI_C_VERSIONED_EXTENTS (ID,O_ID,SEQUENCE,EXTENT,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , O_ID                           AS O_ID
    , SEQUENCE                       AS SEQUENCE
    , EXTENT                         AS EXTENT
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM VERSIONED_EXTENTS
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_VERSIONED_EXTENTS (ID,O_ID,SEQUENCE,EXTENT,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , O_ID                           AS O_ID
    , SEQUENCE                       AS SEQUENCE
    , EXTENT                         AS EXTENT
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM VERSIONED_EXTENTS;
