-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE ENTITY_VARIABLE (
    ID                             NUMBER (38) PRIMARY KEY
    , SME_ID                         NUMBER (38)          NOT NULL
    , NAME                           VARCHAR2 (64 CHAR)   NOT NULL
    , VALUE                          VARCHAR2 (256 CHAR)      NULL
    , IS_LOCAL                       NUMBER (1)           NOT NULL
    , EV_LINK                        NUMBER (38)              NULL
    , IS_LONG                        NUMBER (1)           NOT NULL
    , CREATOR_U_ID                   NUMBER (38)          NOT NULL
    , CREATE_TS                      NUMBER (38)          NOT NULL
    , CHANGER_U_ID                   NUMBER (38)          NOT NULL
    , CHANGE_TS                      NUMBER (38)          NOT NULL
);
CREATE OR REPLACE VIEW SCI_ENTITY_VARIABLE AS
SELECT 
    ID 
    , SME_ID                         AS SME_ID
    , NAME                           AS NAME
    , VALUE                          AS VALUE
    , DECODE (IS_LOCAL, 1, 'TRUE', 0, 'FALSE') AS IS_LOCAL
    , DECODE (IS_LONG, 1, 'TRUE', 0, 'FALSE') AS IS_LONG
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , pkg_time.gmt2local(CREATE_TS) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , pkg_time.gmt2local(CHANGE_TS) AS CHANGE_TS
  FROM ENTITY_VARIABLE;
CREATE TABLE ARC_ENTITY_VARIABLE (
    ID                             NUMBER (38) NOT NULL
    , SME_ID                         NUMBER (38)           NULL
    , NAME                           VARCHAR2 (64 CHAR)    NULL
    , VALUE                          VARCHAR2 (256 CHAR)   NULL
    , IS_LOCAL                       NUMBER (1)            NULL
    , EV_LINK                        NUMBER (38)           NULL
    , IS_LONG                        NUMBER (1)            NULL
    , CREATOR_U_ID                   NUMBER (38)           NULL
    , CREATE_TS                      NUMBER (38)           NULL
    , CHANGER_U_ID                   NUMBER (38)           NULL
    , CHANGE_TS                      NUMBER (38)           NULL
);
