ALTER TABLE ENTITY_VARIABLE ADD (
    IS_LONG NUMBER (1) DEFAULT 0 NOT NULL
);
ALTER TABLE ARC_ENTITY_VARIABLE ADD (
    IS_LONG NUMBER (1)
);
CREATE OR REPLACE VIEW SCI_ENTITY_VARIABLE AS
SELECT 
    ID 
    , SME_ID                         AS SME_ID
    , NAME                           AS NAME
    , VALUE                          AS VALUE
    , DECODE (IS_LOCAL, 1, 'TRUE', 0, 'FALSE') AS IS_LOCAL
    , DECODE (IS_LONG, 1, 'TRUE', 0, 'FALSE') AS IS_LONG
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , pkg_time.gmt2local(CREATE_TS) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , pkg_time.gmt2local(CHANGE_TS) AS CHANGE_TS
  FROM ENTITY_VARIABLE;
CREATE TABLE ARC_EXTENTS (
    ID                             NUMBER (38) NOT NULL
    , O_ID                           NUMBER (38)           NULL
    , SME_ID                         NUMBER (38)           NULL
    , SEQUENCE                       NUMBER (38)           NULL
    , EXTENT                         VARCHAR2 (256 CHAR)   NULL
    , CREATOR_U_ID                   NUMBER (38)           NULL
    , CREATE_TS                      NUMBER (38)           NULL
    , CHANGER_U_ID                   NUMBER (38)           NULL
    , CHANGE_TS                      NUMBER (38)           NULL
);
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE EXTENTS (
    ID                             NUMBER (38) PRIMARY KEY
    , O_ID                           NUMBER (38)          NOT NULL
    , SME_ID                         NUMBER (38)          NOT NULL
    , SEQUENCE                       NUMBER (38)          NOT NULL
    , EXTENT                         VARCHAR2 (256 CHAR)  NOT NULL
    , CREATOR_U_ID                   NUMBER (38)          NOT NULL
    , CREATE_TS                      NUMBER (38)          NOT NULL
    , CHANGER_U_ID                   NUMBER (38)          NOT NULL
    , CHANGE_TS                      NUMBER (38)          NOT NULL
);
CREATE OR REPLACE VIEW SCI_EXTENTS AS
SELECT 
    ID 
    , O_ID                           AS O_ID
    , SME_ID                         AS SME_ID
    , SEQUENCE                       AS SEQUENCE
    , EXTENT                         AS EXTENT
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , pkg_time.gmt2local(CREATE_TS) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , pkg_time.gmt2local(CHANGE_TS) AS CHANGE_TS
  FROM EXTENTS;
ALTER TABLE PARAMETER_DEFINITION ADD (
    IS_LONG NUMBER (1) DEFAULT 0 NOT NULL
);
CREATE OR REPLACE VIEW SCI_C_PARAMETER_DEFINITION AS
SELECT 
    ID 
    , SE_ID                          AS SE_ID
    , NAME                           AS NAME
    , DECODE (TYPE, 10, 'REFERENCE', 20, 'CHILDREFERENCE', 30, 'CONSTANT', 40, 'RESULT', 50, 'PARAMETER', 60, 'EXPRESSION', 70, 'IMPORT', 80, 'DYNAMIC', 81, 'DYNAMICVALUE', 90, 'LOCAL_CONSTANT', 91, 'RESOURCEREFERENCE') AS TYPE
    , DECODE (AGG_FUNCTION, 0, 'NONE', 61, 'AVG', 62, 'COUNT', 63, 'MIN', 64, 'MAX', 65, 'SUM') AS AGG_FUNCTION
    , DEFAULTVALUE                   AS DEFAULTVALUE
    , DECODE (IS_LOCAL, 1, 'TRUE', 0, 'FALSE') AS IS_LOCAL
    , LINK_PD_ID                     AS LINK_PD_ID
    , EXPORT_NAME                    AS EXPORT_NAME
    , DECODE (IS_LONG, 1, 'TRUE', 0, 'FALSE') AS IS_LONG
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , pkg_time.gmt2local(CREATE_TS) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , pkg_time.gmt2local(CHANGE_TS) AS CHANGE_TS
  FROM PARAMETER_DEFINITION
 WHERE VALID_TO = 9223372036854775807;
CREATE OR REPLACE VIEW SCI_V_PARAMETER_DEFINITION AS
SELECT 
    ID 
    , SE_ID                          AS SE_ID
    , NAME                           AS NAME
    , DECODE (TYPE, 10, 'REFERENCE', 20, 'CHILDREFERENCE', 30, 'CONSTANT', 40, 'RESULT', 50, 'PARAMETER', 60, 'EXPRESSION', 70, 'IMPORT', 80, 'DYNAMIC', 81, 'DYNAMICVALUE', 90, 'LOCAL_CONSTANT', 91, 'RESOURCEREFERENCE') AS TYPE
    , DECODE (AGG_FUNCTION, 0, 'NONE', 61, 'AVG', 62, 'COUNT', 63, 'MIN', 64, 'MAX', 65, 'SUM') AS AGG_FUNCTION
    , DEFAULTVALUE                   AS DEFAULTVALUE
    , DECODE (IS_LOCAL, 1, 'TRUE', 0, 'FALSE') AS IS_LOCAL
    , LINK_PD_ID                     AS LINK_PD_ID
    , EXPORT_NAME                    AS EXPORT_NAME
    , DECODE (IS_LONG, 1, 'TRUE', 0, 'FALSE') AS IS_LONG
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , pkg_time.gmt2local(CREATE_TS) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , pkg_time.gmt2local(CHANGE_TS) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM PARAMETER_DEFINITION;
ALTER TABLE RESOURCE_REQUIREMENT ADD (
    IGNORE_ON_RERUN NUMBER (1) DEFAULT 0 NOT NULL
);
CREATE OR REPLACE VIEW SCI_C_RESOURCE_REQUIREMENT AS
SELECT 
    ID 
    , NR_ID                          AS NR_ID
    , SE_ID                          AS SE_ID
    , AMOUNT                         AS AMOUNT
    , DECODE (KEEP_MODE, 0, 'NOKEEP', 1, 'KEEP', 2, 'KEEP_FINAL') AS KEEP_MODE
    , DECODE (IS_STICKY, 1, 'TRUE', 0, 'FALSE') AS IS_STICKY
    , STICKY_NAME                    AS STICKY_NAME
    , STICKY_PARENT                  AS STICKY_PARENT
    , RSMP_ID                        AS RSMP_ID
    , EXPIRED_AMOUNT                 AS EXPIRED_AMOUNT
    , DECODE (EXPIRED_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS EXPIRED_BASE
    , DECODE (IGNORE_ON_RERUN, 1, 'TRUE', 0, 'FALSE') AS IGNORE_ON_RERUN
    , DECODE (LOCKMODE, 255, 'N', 0, 'X', 2, 'SX', 4, 'S', 6, 'SC') AS LOCKMODE
    , CONDITION                      AS CONDITION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , pkg_time.gmt2local(CREATE_TS) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , pkg_time.gmt2local(CHANGE_TS) AS CHANGE_TS
  FROM RESOURCE_REQUIREMENT
 WHERE VALID_TO = 9223372036854775807;
CREATE OR REPLACE VIEW SCI_V_RESOURCE_REQUIREMENT AS
SELECT 
    ID 
    , NR_ID                          AS NR_ID
    , SE_ID                          AS SE_ID
    , AMOUNT                         AS AMOUNT
    , DECODE (KEEP_MODE, 0, 'NOKEEP', 1, 'KEEP', 2, 'KEEP_FINAL') AS KEEP_MODE
    , DECODE (IS_STICKY, 1, 'TRUE', 0, 'FALSE') AS IS_STICKY
    , STICKY_NAME                    AS STICKY_NAME
    , STICKY_PARENT                  AS STICKY_PARENT
    , RSMP_ID                        AS RSMP_ID
    , EXPIRED_AMOUNT                 AS EXPIRED_AMOUNT
    , DECODE (EXPIRED_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS EXPIRED_BASE
    , DECODE (IGNORE_ON_RERUN, 1, 'TRUE', 0, 'FALSE') AS IGNORE_ON_RERUN
    , DECODE (LOCKMODE, 255, 'N', 0, 'X', 2, 'SX', 4, 'S', 6, 'SC') AS LOCKMODE
    , CONDITION                      AS CONDITION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , pkg_time.gmt2local(CREATE_TS) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , pkg_time.gmt2local(CHANGE_TS) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM RESOURCE_REQUIREMENT;
CREATE TABLE ARC_SUBMITTED_ENTITY_STATS (
    ID                             NUMBER (38) NOT NULL
    , SME_ID                         NUMBER (38)           NULL
    , RERUN_SEQ                      NUMBER (38)           NULL
    , SCOPE_ID                       NUMBER (38)           NULL
    , JOB_ESD_ID                     NUMBER (38)           NULL
    , EXIT_CODE                      NUMBER (38)           NULL
    , COMMANDLINE                    VARCHAR2 (512 CHAR)   NULL
    , WORKDIR                        VARCHAR2 (512 CHAR)   NULL
    , LOGFILE                        VARCHAR2 (512 CHAR)   NULL
    , ERRLOGFILE                     VARCHAR2 (512 CHAR)   NULL
    , EXTPID                         VARCHAR2 (32 CHAR)    NULL
    , SYNC_TS                        NUMBER (38)           NULL
    , RESOURCE_TS                    NUMBER (38)           NULL
    , RUNNABLE_TS                    NUMBER (38)           NULL
    , START_TS                       NUMBER (38)           NULL
    , FINISH_TS                      NUMBER (38)           NULL
    , CREATOR_U_ID                   NUMBER (38)           NULL
    , CREATE_TS                      NUMBER (38)           NULL
    , CHANGER_U_ID                   NUMBER (38)           NULL
    , CHANGE_TS                      NUMBER (38)           NULL
);
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE SUBMITTED_ENTITY_STATS (
    ID                             NUMBER (38) PRIMARY KEY
    , SME_ID                         NUMBER (38)          NOT NULL
    , RERUN_SEQ                      NUMBER (38)          NOT NULL
    , SCOPE_ID                       NUMBER (38)              NULL
    , JOB_ESD_ID                     NUMBER (38)              NULL
    , EXIT_CODE                      NUMBER (38)              NULL
    , COMMANDLINE                    VARCHAR2 (512 CHAR)      NULL
    , WORKDIR                        VARCHAR2 (512 CHAR)      NULL
    , LOGFILE                        VARCHAR2 (512 CHAR)      NULL
    , ERRLOGFILE                     VARCHAR2 (512 CHAR)      NULL
    , EXTPID                         VARCHAR2 (32 CHAR)       NULL
    , SYNC_TS                        NUMBER (38)              NULL
    , RESOURCE_TS                    NUMBER (38)              NULL
    , RUNNABLE_TS                    NUMBER (38)              NULL
    , START_TS                       NUMBER (38)              NULL
    , FINISH_TS                      NUMBER (38)              NULL
    , CREATOR_U_ID                   NUMBER (38)          NOT NULL
    , CREATE_TS                      NUMBER (38)          NOT NULL
    , CHANGER_U_ID                   NUMBER (38)          NOT NULL
    , CHANGE_TS                      NUMBER (38)          NOT NULL
);
CREATE OR REPLACE VIEW SCI_SUBMITTED_ENTITY_STATS AS
SELECT 
    ID 
    , SME_ID                         AS SME_ID
    , RERUN_SEQ                      AS RERUN_SEQ
    , SCOPE_ID                       AS SCOPE_ID
    , JOB_ESD_ID                     AS JOB_ESD_ID
    , EXIT_CODE                      AS EXIT_CODE
    , COMMANDLINE                    AS COMMANDLINE
    , WORKDIR                        AS WORKDIR
    , LOGFILE                        AS LOGFILE
    , ERRLOGFILE                     AS ERRLOGFILE
    , EXTPID                         AS EXTPID
    , pkg_time.gmt2local(SYNC_TS) AS SYNC_TS
    , pkg_time.gmt2local(RESOURCE_TS) AS RESOURCE_TS
    , pkg_time.gmt2local(RUNNABLE_TS) AS RUNNABLE_TS
    , pkg_time.gmt2local(START_TS) AS START_TS
    , pkg_time.gmt2local(FINISH_TS) AS FINISH_TS
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , pkg_time.gmt2local(CREATE_TS) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , pkg_time.gmt2local(CHANGE_TS) AS CHANGE_TS
  FROM SUBMITTED_ENTITY_STATS;
ALTER TABLE USERS ADD (
    CONNECTION_TYPE NUMBER (38) DEFAULT 0 NOT NULL
);
CREATE OR REPLACE VIEW SCI_USERS AS
SELECT 
    ID 
    , NAME                           AS NAME
    , DECODE (IS_ENABLED, 1, 'TRUE', 0, 'FALSE') AS IS_ENABLED
    , DEFAULT_G_ID                   AS DEFAULT_G_ID
    , DECODE (CONNECTION_TYPE, 0, 'PLAIN', 1, 'SSL', 2, 'SSL_AUTH') AS CONNECTION_TYPE
    , DELETE_VERSION                 AS DELETE_VERSION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , pkg_time.gmt2local(CREATE_TS) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , pkg_time.gmt2local(CHANGE_TS) AS CHANGE_TS
  FROM USERS;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE USER_EQUIV (
    ID                             NUMBER (38) PRIMARY KEY
    , U_ID                           NUMBER (38)          NOT NULL
    , ALT_U_TYPE                     NUMBER (38)          NOT NULL
    , ALT_U_ID                       NUMBER (38)          NOT NULL
    , CREATOR_U_ID                   NUMBER (38)          NOT NULL
    , CREATE_TS                      NUMBER (38)          NOT NULL
    , CHANGER_U_ID                   NUMBER (38)          NOT NULL
    , CHANGE_TS                      NUMBER (38)          NOT NULL
);
CREATE OR REPLACE VIEW SCI_USER_EQUIV AS
SELECT 
    ID 
    , U_ID                           AS U_ID
    , DECODE (ALT_U_TYPE, 0, 'USER', 1, 'SERVER') AS ALT_U_TYPE
    , ALT_U_ID                       AS ALT_U_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , pkg_time.gmt2local(CREATE_TS) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , pkg_time.gmt2local(CHANGE_TS) AS CHANGE_TS
  FROM USER_EQUIV;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE VERSIONED_EXTENTS (
    ID                             NUMBER (38) NOT NULL
    , O_ID                           NUMBER (38)          NOT NULL
    , SEQUENCE                       NUMBER (38)          NOT NULL
    , EXTENT                         VARCHAR2 (256 CHAR)  NOT NULL
    , CREATOR_U_ID                   NUMBER (38)          NOT NULL
    , CREATE_TS                      NUMBER (38)          NOT NULL
    , CHANGER_U_ID                   NUMBER (38)          NOT NULL
    , CHANGE_TS                      NUMBER (38)          NOT NULL
    , VALID_FROM                   NUMBER (38) NOT NULL
    , VALID_TO                     NUMBER (38) NOT NULL
    , PRIMARY KEY (ID, VALID_TO)
);
CREATE OR REPLACE VIEW SCI_C_VERSIONED_EXTENTS AS
SELECT 
    ID 
    , O_ID                           AS O_ID
    , SEQUENCE                       AS SEQUENCE
    , EXTENT                         AS EXTENT
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , pkg_time.gmt2local(CREATE_TS) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , pkg_time.gmt2local(CHANGE_TS) AS CHANGE_TS
  FROM VERSIONED_EXTENTS
 WHERE VALID_TO = 9223372036854775807;
CREATE OR REPLACE VIEW SCI_V_VERSIONED_EXTENTS AS
SELECT 
    ID 
    , O_ID                           AS O_ID
    , SEQUENCE                       AS SEQUENCE
    , EXTENT                         AS EXTENT
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , pkg_time.gmt2local(CREATE_TS) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , pkg_time.gmt2local(CHANGE_TS) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM VERSIONED_EXTENTS;
