/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.jobserver;

import de.independit.scheduler.jobserver.Config;
import de.independit.scheduler.jobserver.Environment;
import de.independit.scheduler.jobserver.JobServer;
import de.independit.scheduler.jobserver.Notifier;
import de.independit.scheduler.jobserver.ProcessInfo;
import de.independit.scheduler.jobserver.RepoIface;
import de.independit.scheduler.jobserver.Server;
import de.independit.scheduler.jobserver.Trace;
import de.independit.scheduler.jobserver.Utils;
import de.independit.scheduler.server.SDMSConstants;
import java.io.File;
import java.io.IOException;
import java.nio.channels.OverlappingFileLockException;

public class EiThread
extends Thread {
    private static final long DEFAULT_NOP_DELAY = 30000L;
    private final RepoIface ri;
    private final Config cfg;
    private final String jid;
    private final File workdir;
    private final String[] env;

    public EiThread(RepoIface repoIface, Config config, String string) {
        this(repoIface, config, string, repoIface.getJobData().env, null, repoIface.getJobData().jobenv);
    }

    public EiThread(RepoIface repoIface, Config config, String string, Environment environment, File file, Environment environment2) {
        this.ri = repoIface;
        this.cfg = config;
        this.jid = string;
        this.workdir = file;
        Environment environment3 = Environment.getSystemEnvironment();
        if (environment2 != null) {
            environment3.putAll(environment2);
        }
        environment3 = environment3.merge(environment, repoIface, config);
        this.env = environment3.toArray();
        this.setPriority(1);
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public final void run() {
        block40: {
            try {
                var1_1 = Runtime.getRuntime();
                var2_4 = true;
                var3_5 = 0;
                var6_7 = var5_6 = Server.getFeil(this.cfg, this.jid);
                synchronized (var6_7) {
                    var4_9 = new String[]{this.cfg.get("JOBEXECUTOR").toString(), String.valueOf(ProcessInfo.getBoottimeHow()), var5_6.getFilename().toString(), ProcessInfo.getBoottime(ProcessInfo.getBoottimeHow())};
                }
                var6_8 = (Long)this.cfg.get("NOPDELAY");
                var8_11 = Math.min(var6_8, 30000L);
                if (this.workdir != null && ((Boolean)this.cfg.get("CREATE_WORKDIR")).booleanValue() && !this.workdir.exists() && !this.workdir.mkdirs()) {
                    this.ri.notifyError(RepoIface.NONFATAL, "(03110261111) Cannot create working directory " + this.workdir.toString());
                    var2_4 = false;
                }
                if (var2_4) {
                    var11_12 = 0;
                    while (true) {
                        try {
                            var10_22 = var1_1.exec(var4_9, this.env);
                        }
                        catch (IOException var12_14) {
                            Utils.sleep(1000L);
                            if (++var11_12 < 5) continue;
                            this.ri.notifyError(RepoIface.NONFATAL, "(04302012116) Cannot launch job executor: " + var12_14.getMessage() + " (" + var12_14.getClass().getName() + ")");
                            System.exit(1);
                            continue;
                        }
                        break;
                    }
                    try {
                        var12_15 = var10_22.getInputStream();
                        var12_15.close();
                    }
                    catch (IOException var12_16) {
                        Trace.warning("(03210171637) Error closing pipe stdout : " + var12_16.getMessage() + " (" + var12_16.getClass().getName() + ")");
                    }
                    try {
                        var12_15 = var10_22.getErrorStream();
                        var12_15.close();
                    }
                    catch (IOException var12_17) {
                        Trace.warning("(03210171638) Error closing pipe stderr : " + var12_17.getMessage() + " (" + var12_17.getClass().getName() + ")");
                    }
                    try {
                        var12_15 = var10_22.getOutputStream();
                        var12_15.close();
                    }
                    catch (IOException var12_18) {
                        Trace.warning("(03210171639) Error closing pipe stdin : " + var12_18.getMessage() + " (" + var12_18.getClass().getName() + ")");
                    }
                    while (true) {
                        try {
                            var3_5 = var10_22.waitFor();
                        }
                        catch (InterruptedException var12_19) {
                            continue;
                        }
                        break;
                    }
                }
                var10_22 = null;
                var11_13 = var5_6;
                synchronized (var11_13) {
                    if (Server.feilExists(this.jid)) {
                        try {
                            var5_6.open();
                            var5_6.scan();
                            if (var3_5 == 42) {
                                Trace.warning("(02402051056)Job executor for job " + this.jid + " returned error = " + var3_5 + ", double execution ignored");
                            }
                            if (var3_5 != 0) {
                                var12_15 = var5_6.getExtPid();
                                var13_23 = false;
                                if (!var12_15.equals("")) {
                                    var14_24 = ProcessInfo.getStartTimes(this.cfg, null);
                                    var13_23 = ProcessInfo.isAlive((String)var12_15, var14_24);
                                }
                                if (var13_23) {
                                    var5_6.setStatus("BROKEN_ACTIVE");
                                }
                                var5_6.setError("(04301271445) Job executor returned errno = " + var3_5);
                                var5_6.setStatus("ERROR");
                            }
                            if (!var2_4) {
                                var5_6.setError("(03110261111) Cannot create working directory " + this.workdir.toString());
                                var5_6.setStatus("ERROR");
                            }
                            if (!var5_6.getStatus().equals("STARTED")) ** GOTO lbl96
                            var5_6.setError("(04302042027) Error launching job executor");
                            var5_6.setStatus("ERROR");
                        }
                        catch (OverlappingFileLockException var12_20) {
                        }
                        catch (IOException var12_21) {
                            var10_22 = var12_21;
                        }
                        finally {
                            var5_6.close();
                        }
                    } else {
                        System.out.println("Feil for jid " + this.jid + " does not exist !");
                    }
                }
lbl96:
                // 9 sources

                if (var10_22 == null) break block40;
                var11_13 = var5_6;
                synchronized (var11_13) {
                    this.ri.notifyError(RepoIface.NONFATAL, "(04302042025) Cannot operate on jobfile " + String.valueOf(var5_6.getFilename()) + ": " + var10_22.getMessage() + " (" + var10_22.getClass().getName() + ")");
                }
            }
            catch (Exception var1_2) {
                this.ri.notifyError(RepoIface.FATAL, "(03510221606) Exception caught while starting Thread : " + var1_2.toString());
            }
            catch (Error var1_3) {
                this.ri.notifyError(RepoIface.FATAL, "(03510221607) Exception caught while starting Thread : " + var1_3.toString());
            }
        }
        Trace.debug("EiThread:Removing jid " + this.jid + " from jidsWithEiThread");
        JobServer.server.removeJidWithEiThread(this.jid);
        Trace.debug("EiThread:Adding jid " + this.jid + " to jidsToBreed");
        JobServer.server.addJidToBreed(this.jid);
        Notifier.interrupt(SDMSConstants.lZERO);
    }
}

