/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.jobserver;

import de.independit.scheduler.jobserver.Descr;
import de.independit.scheduler.jobserver.Trace;
import de.independit.scheduler.jobserver.Utils;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.SyncFailedException;
import java.nio.channels.FileChannel;
import java.nio.channels.OverlappingFileLockException;
import java.nio.charset.Charset;
import java.util.Vector;
import java.util.regex.Pattern;

public class Feil {
    public static final String STATUS_STARTED = "STARTED";
    public static final String STATUS_RUNNING = "RUNNING";
    public static final String STATUS_FINISHED = "FINISHED";
    public static final String STATUS_BROKEN_ACTIVE = "BROKEN_ACTIVE";
    public static final String STATUS_BROKEN_FINISHED = "BROKEN_FINISHED";
    public static final String STATUS_ERROR = "ERROR";
    public static final String STATUS_CHILD_ERROR = "CHILD_ERROR";
    public static final String ERROR_POSTFIX = "_ERROR";
    private static final int PREALLOC_SIZE = 16384;
    private static final int CHUNK_SIZE = 2048;
    private static final Pattern NEWLINE_PATTERN = Pattern.compile(".*[\\n\\r].*", 32);
    private static String DEV_NULL = "/dev/null";
    public static final String ID = "id";
    public static final String STATUS = "status";
    public static final String COMMAND = "command";
    public static final String ARGUMENT = "argument";
    public static final String WORKDIR = "workdir";
    public static final String USEPATH = "usepath";
    public static final String VERBOSELOGS = "verboselogs";
    public static final String LOGFILE = "logfile";
    public static final String LOGFILEAPPEND = "logfile_append";
    public static final String ERRLOG = "errlog";
    public static final String ERRLOGAPPEND = "errlog_append";
    public static final String SAMELOGS = "samelogs";
    public static final String EXECPID = "execpid";
    public static final String EXTPID = "extpid";
    public static final String STATUS_TX = "status_tx";
    public static final String RETURNCODE = "returncode";
    public static final String ERROR = "error";
    public static final String RUN = "run";
    public static final String INCOMPLETE = "incomplete";
    public static final String COMPLETE = "complete";
    private final File filnam;
    private final String jid;
    private RandomAccessFile rfil;
    private String id = "";
    private String status = "";
    private String command = "";
    private Vector args = new Vector();
    private String workdir = "";
    private boolean usepath = false;
    private boolean verboseLogs = false;
    private String logfile = "";
    private boolean logappend = false;
    private String errlog = "";
    private boolean errappend = false;
    private boolean samelogs = false;
    private String timestamp = "";
    private String runningTS = "";
    private String exec_pid = "";
    private String ext_pid = "";
    private String status_tx = "";
    private String return_code = "";
    private String run = "";
    private StringBuffer error = new StringBuffer();
    private boolean complete = false;
    public boolean doEmergencyRename = false;

    public Feil(File file, String string) {
        this.filnam = new File(file.toString() + string);
        this.jid = string;
    }

    public Feil(String string) {
        this.filnam = new File(string);
        this.jid = "0";
    }

    public File getFilename() {
        return this.filnam;
    }

    public boolean exists() {
        return this.filnam.exists();
    }

    public long length() throws IOException {
        if (this.rfil != null) {
            return this.rfil.length();
        }
        Trace.error("(03210221115) Tried to request filelength on a closed file");
        Trace.error("Stacktrace :\n" + String.valueOf(new Exception().getStackTrace()));
        return 0L;
    }

    public boolean emergency_rename() {
        boolean bl = false;
        String string = "UNKNOWN";
        Object object = string;
        try {
            string = this.filnam.getCanonicalPath();
            object = string + ERROR_POSTFIX;
            File file = new File((String)object);
            bl = this.filnam.renameTo(file);
        }
        catch (IOException iOException) {
            Trace.error("I/O Error occured : " + iOException.toString() + " (" + iOException.getClass().getName() + ")");
        }
        if (!bl) {
            Trace.error("Error occured trying to rename " + string + " to " + (String)object);
        }
        return bl;
    }

    public final boolean getIncomplete() {
        return !this.complete;
    }

    public final boolean getComplete() {
        return this.complete;
    }

    public final String getId() {
        return this.id;
    }

    public final String getStatus() {
        return this.status;
    }

    public final String getStatusTimestamp() {
        return this.timestamp;
    }

    public final String getExecPid() {
        return this.exec_pid;
    }

    public final String getExtPid() {
        return this.ext_pid;
    }

    public final String getStatus_Tx() {
        return this.status_tx;
    }

    public final String getReturnCode() {
        return this.return_code;
    }

    public final String getError() {
        return this.error.toString();
    }

    public final String getRunningTimestamp() {
        return this.runningTS;
    }

    public final String getRun() {
        return this.run;
    }

    public final String getCommand() {
        return this.command;
    }

    public final Vector getArgs() {
        return this.args;
    }

    public final String getWorkdir() {
        return this.workdir;
    }

    public final boolean getUsepath() {
        return this.usepath;
    }

    public final boolean getVerboseLogs() {
        return this.verboseLogs;
    }

    public final String getLogfile() {
        return this.logfile;
    }

    public final boolean getLogappend() {
        return this.logappend;
    }

    public final String getErrlog() {
        return this.errlog;
    }

    public final boolean getErrappend() {
        return this.errappend;
    }

    public final boolean getSamelogs() {
        return this.samelogs;
    }

    private final byte[] read() {
        try {
            byte[] byArray = new byte[2048];
            this.rfil.seek(0L);
            this.rfil.read(byArray);
            if (byArray[2047] != 0) {
                byArray = new byte[(int)this.rfil.length()];
                this.rfil.seek(0L);
                this.rfil.read(byArray);
            }
            return byArray;
        }
        catch (IOException iOException) {
            Trace.error("I/O Exception while reading file " + this.filnam.toString() + " : " + iOException.getMessage() + " (" + iOException.getClass().getName() + ")");
            return new byte[0];
        }
    }

    private final String println(String string) throws IOException {
        int n;
        String string2 = Utils.timestampNow();
        byte[] byArray = Charset.defaultCharset().encode(string2 + " " + string + "\n").array();
        for (n = byArray.length; n > 0 && byArray[n - 1] == 0; --n) {
        }
        this.rfil.write(byArray, 0, n);
        return string2.substring(1, string2.indexOf(93));
    }

    private final String println(String string, String string2) throws IOException {
        if (string2 != null) {
            StringBuffer stringBuffer = new StringBuffer(string);
            if (NEWLINE_PATTERN.matcher(string2).matches()) {
                int n;
                stringBuffer.append("'");
                byte[] byArray = Charset.defaultCharset().encode(string2).array();
                for (n = byArray.length; n > 0 && byArray[n - 1] == 0; --n) {
                }
                stringBuffer.append(n);
            }
            stringBuffer.append("=");
            stringBuffer.append(string2);
            return this.println(stringBuffer.toString());
        }
        return "";
    }

    public final String append(String string, String string2) throws IOException {
        int n;
        byte[] byArray = this.read();
        for (n = 0; n < byArray.length && byArray[n] != 0; ++n) {
        }
        this.rfil.seek(n);
        return this.println(string, string2);
    }

    public final void create(Descr descr, boolean bl, boolean bl2) throws IOException {
        boolean bl3 = true;
        this.rfil = new RandomAccessFile(this.filnam, "rws");
        this.rfil.setLength(0L);
        bl3 &= this.filnam.setReadable(false, false);
        bl3 &= this.filnam.setWritable(false, false);
        bl3 &= this.filnam.setExecutable(false, false);
        bl3 &= this.filnam.setReadable(true, true);
        if (!(bl3 &= this.filnam.setWritable(true, true))) {
            Trace.warning("Failed to set file permissions on taskfile");
        }
        try {
            this.id = descr.id;
            this.run = descr.run;
            this.status = STATUS_STARTED;
            this.println(INCOMPLETE);
            this.println(ID, descr.id);
            this.println(RUN, descr.run);
            this.timestamp = this.println(STATUS, this.status);
            this.println(COMMAND, descr.cmd);
            for (int i = 0; i < descr.args.length; ++i) {
                this.println(ARGUMENT, descr.args[i]);
            }
            this.println(WORKDIR, descr.dir.toString());
            if (bl) {
                this.println(USEPATH);
            }
            if (bl2) {
                this.println(VERBOSELOGS);
            }
            if (descr.log != null) {
                this.println(LOGFILE, descr.log.toString());
                if (descr.logapp) {
                    this.println(LOGFILEAPPEND);
                }
            }
            if (descr.elog != null) {
                this.println(ERRLOG, descr.elog.toString());
                if (descr.elogapp) {
                    this.println(ERRLOGAPPEND);
                }
            }
            if (descr.samelog) {
                this.println(SAMELOGS);
            }
            this.println(COMPLETE);
            this.rfil.write(new byte[Math.max(0, 16384 - (int)this.length())]);
            this.rfil.getFD().sync();
        }
        catch (SyncFailedException syncFailedException) {
            Trace.error("(03210150807) Sync() failed on jobfile " + String.valueOf(this.getFilename()) + ": " + syncFailedException.getMessage());
            throw syncFailedException;
        }
        catch (IOException iOException) {
            Trace.error("I/O Exception while creating file " + this.filnam.getCanonicalPath() + " : " + iOException.getMessage() + " (" + iOException.getClass().getName() + ")");
            throw iOException;
        }
        finally {
            this.close();
        }
    }

    public final void remove() {
        this.close();
        if (!this.filnam.delete()) {
            Trace.error("(04504090126) Error deleting " + String.valueOf(this.filnam));
        }
    }

    public final void open() throws IOException {
        this.rfil = new RandomAccessFile(this.filnam, "rws");
        try {
            FileChannel fileChannel = this.rfil.getChannel();
            fileChannel.lock();
        }
        catch (OverlappingFileLockException overlappingFileLockException) {
            Trace.warning("(03210221131) Overlapping File Lock Exception on File " + String.valueOf(this.filnam) + " ignored");
        }
    }

    public final void close() {
        try {
            if (this.rfil != null && this.rfil.getChannel().isOpen()) {
                this.rfil.close();
            } else if (this.rfil != null) {
                Trace.error("(03210221111) Duplicate close on file " + String.valueOf(this.filnam));
            }
            this.rfil = null;
        }
        catch (IOException iOException) {
            Trace.error("(04504090121) Error closing " + String.valueOf(this.filnam) + ": " + iOException.getMessage() + " (" + iOException.getClass().getName() + ")");
        }
    }

    public final void scan() {
        int n;
        this.error.setLength(0);
        this.complete = false;
        String string = new String(this.read());
        for (n = string.length(); n > 0 && string.charAt(n - 1) == '\u0000'; --n) {
        }
        int n2 = 0;
        while (n2 < n) {
            String string2 = null;
            String string3 = null;
            if ((n2 = string.indexOf(93, n2)) == -1) break;
            String string4 = string.substring(string.lastIndexOf(91, n2) + 1, n2);
            while (++n2 < n && string.charAt(n2) == ' ') {
            }
            if (n2 >= n) break;
            int n3 = n2;
            while (++n2 < n && "=\n\r".indexOf(string.charAt(n2)) == -1) {
            }
            if (n2 >= n) break;
            string2 = string.substring(n3, n2);
            if (string.charAt(n2) != '=') {
                string3 = null;
            } else {
                int n4 = ++n2;
                int n5 = string2.indexOf(39);
                if (n5 == -1) {
                    while (++n2 < n && "\n\r".indexOf(string.charAt(n2)) == -1) {
                    }
                } else {
                    try {
                        int n6 = Integer.parseInt(string2.substring(n5 + 1));
                        string2 = string2.substring(0, n5);
                        n2 += n6;
                    }
                    catch (NumberFormatException numberFormatException) {
                        while (++n2 < n && "\n\r".indexOf(string.charAt(n2)) == -1) {
                        }
                    }
                }
                string3 = string.substring(n4, n2);
            }
            ++n2;
            if (string2.equals(ID)) {
                this.id = string3;
                continue;
            }
            if (string2.equals(RUN)) {
                this.run = string3;
                continue;
            }
            if (string2.equals(EXECPID)) {
                this.exec_pid = string3;
                continue;
            }
            if (string2.equals(EXTPID)) {
                this.ext_pid = string3;
                continue;
            }
            if (string2.equals(STATUS_TX)) {
                this.status_tx = string3;
                continue;
            }
            if (string2.equals(RETURNCODE)) {
                this.return_code = string3;
                continue;
            }
            if (string2.equals(INCOMPLETE)) {
                this.complete = false;
                continue;
            }
            if (string2.equals(COMPLETE)) {
                this.complete = true;
                continue;
            }
            if (string2.equals(COMMAND)) {
                this.command = string3;
                continue;
            }
            if (string2.equals(ARGUMENT)) {
                this.args.add(string3);
                continue;
            }
            if (string2.equals(WORKDIR)) {
                this.workdir = string3;
                continue;
            }
            if (string2.equals(USEPATH)) {
                this.usepath = true;
                continue;
            }
            if (string2.equals(VERBOSELOGS)) {
                this.verboseLogs = true;
                continue;
            }
            if (string2.equals(LOGFILE)) {
                this.logfile = string3;
                continue;
            }
            if (string2.equals(ERRLOG)) {
                this.errlog = string3;
                continue;
            }
            if (string2.equals(ERRLOGAPPEND)) {
                this.errappend = true;
                continue;
            }
            if (string2.equals(LOGFILEAPPEND)) {
                this.logappend = true;
                continue;
            }
            if (string2.equals(SAMELOGS)) {
                this.samelogs = true;
                continue;
            }
            if (string2.equals(STATUS)) {
                this.status = string3;
                this.timestamp = string4;
                if (!this.status.equals(STATUS_RUNNING)) continue;
                this.runningTS = this.timestamp;
                continue;
            }
            if (!string2.equals(ERROR)) continue;
            if (this.error.length() != 0) {
                this.error.append("\n");
            }
            this.error.append(string3);
        }
        if (this.id.equals("")) {
            this.id = this.jid;
        }
        if (this.logfile.equals("")) {
            this.logfile = DEV_NULL;
        }
        if (this.errlog.equals("")) {
            this.logfile = DEV_NULL;
        }
    }

    public final void setStatus(String string) throws IOException {
        this.status = string;
        this.timestamp = this.append(STATUS, string);
        if (string.equals(STATUS_RUNNING)) {
            this.runningTS = this.timestamp;
        }
    }

    public final void setStatus_Tx(String string) throws IOException {
        this.status_tx = string;
        this.append(STATUS_TX, string);
    }

    public final void setError(String string) throws IOException {
        this.error.setLength(0);
        this.error.append(string);
        this.append(ERROR, string);
    }
}

