/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.jobserver;

import com.sun.jna.Pointer;
import de.independit.scheduler.jobserver.Config;
import de.independit.scheduler.jobserver.Kernel32;
import de.independit.scheduler.jobserver.Trace;
import de.independit.scheduler.jobserver.W32API;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ProcessInfo {
    static final long BOOTTIME_JITTER = 90L;
    static Long STARTTIME_JITTER = null;
    static final String[] netCmd = new String[]{"net", "stats", "srv"};
    static final String[] uptimeCmd = new String[]{"uptime"};
    public static final char BOOTTIME_NONE = 'N';
    public static final char BOOTTIME_SYSTEM = 'S';
    public static final char BOOTTIME_FILE = 'F';
    public static final char BOOTTIME_DEFAULT = 'N';
    private static char boottimeHow = (char)78;
    private static final String VAR_RUN_LASTBOOT = "/var/run/lastboot";
    private static HashMap<String, Long> bootTimes = new HashMap();

    public static String getPid(Process process) {
        long l = 0L;
        if (process.getClass().getName().equals("java.lang.UNIXProcess")) {
            try {
                Field field = process.getClass().getDeclaredField("pid");
                field.setAccessible(true);
                l = field.getInt(process);
            }
            catch (Exception exception) {
                throw new RuntimeException("(02310251000) Cannot get pid of child Process : " + exception.toString());
            }
        }
        if (System.getProperty("os.name").toLowerCase().contains("win")) {
            try {
                Field field = process.getClass().getDeclaredField("handle");
                field.setAccessible(true);
                long l2 = field.getLong(process);
                Kernel32 kernel32 = Kernel32.INSTANCE;
                W32API.HANDLE hANDLE = new W32API.HANDLE();
                hANDLE.setPointer(Pointer.createConstant((long)l2));
                l = kernel32.GetProcessId(hANDLE);
            }
            catch (Exception exception) {
                throw new RuntimeException("(02310251001) Cannot get pid of child Process : " + exception.toString());
            }
        }
        return "" + l;
    }

    public static String getPid() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        String string = runtimeMXBean.getName();
        String string2 = string.split("@")[0];
        return string2;
    }

    private static String getBootTimeFile() {
        String string = System.getProperty("os.name").toLowerCase();
        if (string.contains("mac") || string.contains("nix") || string.contains("nux") || string.contains("aix") || string.contains("sunos")) {
            File file = new File(VAR_RUN_LASTBOOT);
            return Long.valueOf(file.lastModified()).toString();
        }
        return "0";
    }

    private static String getBootTimeSystem() {
        try {
            Pattern pattern;
            Matcher matcher;
            Process process;
            BufferedReader bufferedReader;
            String string;
            long l = -1L;
            String string2 = System.getProperty("os.name").toLowerCase();
            if (string2.contains("win")) {
                String string3;
                Process process2 = Runtime.getRuntime().exec(netCmd);
                BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(process2.getInputStream()));
                String string4 = ProcessInfo.getPattern();
                int n = string4.length();
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string4);
                while ((string3 = bufferedReader2.readLine()) != null) {
                    int n2 = string3.length();
                    if (n2 < n) continue;
                    string3 = string3.substring(n2 - n);
                    try {
                        l = simpleDateFormat.parse(string3).getTime() / 1000L;
                        break;
                    }
                    catch (ParseException parseException) {
                    }
                }
            } else if ((string2.contains("mac") || string2.contains("nix") || string2.contains("nux") || string2.contains("aix") || string2.contains("sunos")) && (string = (bufferedReader = new BufferedReader(new InputStreamReader((process = Runtime.getRuntime().exec(uptimeCmd)).getInputStream()))).readLine()) != null && (matcher = (pattern = Pattern.compile("((\\d+) days,)? (\\d+):(\\d+)")).matcher(string)).find()) {
                String string5 = matcher.group(2);
                String string6 = matcher.group(3);
                String string7 = matcher.group(4);
                int n = string5 != null ? Integer.parseInt(string5) : 0;
                int n3 = string6 != null ? Integer.parseInt(string6) : 0;
                int n4 = string7 != null ? Integer.parseInt(string7) : 0;
                l = System.currentTimeMillis() / 1000L - (long)(n4 * 60 + n3 * 60 * 60 + n * 60 * 60 * 24);
            }
            return Long.valueOf(l).toString();
        }
        catch (Exception exception) {
            throw new RuntimeException("(02310251147) Cannot get boot time : " + exception.toString());
        }
    }

    private static String getPattern() {
        Date date = new Date();
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2, Locale.getDefault());
        String string = dateFormat.format(date);
        if (dateFormat instanceof SimpleDateFormat) {
            return ((SimpleDateFormat)dateFormat).toPattern();
        }
        return "unknown";
    }

    private static long getStartTime(String string) {
        long l = 0L;
        String string2 = System.getProperty("os.name").toLowerCase();
        if (string2.contains("sunos") || string2.contains("nux")) {
            try {
                BasicFileAttributes basicFileAttributes = Files.readAttributes(Paths.get("/proc/" + string, new String[0]), BasicFileAttributes.class, new LinkOption[0]);
                l = basicFileAttributes.creationTime().to(TimeUnit.SECONDS);
            }
            catch (Exception exception) {
                return 0L;
            }
        }
        return l;
    }

    public static synchronized HashMap<String, Long> getStartTimes(Config config, HashMap<String, Long> hashMap) {
        HashMap<String, Long> hashMap2 = hashMap;
        if (hashMap2 == null) {
            hashMap2 = new HashMap();
        } else {
            hashMap2.clear();
        }
        if (STARTTIME_JITTER == null) {
            STARTTIME_JITTER = (long)((Long)config.get("STARTTIME_JITTER"));
        }
        if (STARTTIME_JITTER == 0L) {
            return hashMap2;
        }
        File file = (File)config.get("JOBFILEPREFIX");
        File file2 = new File(file.getParent() + "/starttimes." + String.valueOf(config.get("REPOUSER")));
        String string = null;
        try {
            string = file2.getCanonicalPath();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string2 = System.getProperty("os.name").toLowerCase();
        if (string2.contains("mac") || string2.contains("nix") || string2.contains("nux") || string2.contains("aix") || string2.contains("hp-ux")) {
            try {
                String string3;
                ProcessBuilder processBuilder = new ProcessBuilder("ps", "-e", "-o", "pid=", "-o", "etime=");
                Map<String, String> map = processBuilder.environment();
                if (string2.contains("hp-ux")) {
                    map.put("UNIX95", "1");
                }
                processBuilder.redirectOutput(new File(string));
                processBuilder.redirectErrorStream(true);
                Process process = processBuilder.start();
                process.getOutputStream().close();
                process.getInputStream().close();
                process.getErrorStream().close();
                try {
                    process.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try {
                    while (process.isAlive()) {
                        Thread.sleep(100L);
                        process.destroy();
                        System.gc();
                    }
                    process = null;
                    System.gc();
                }
                catch (Exception exception) {
                    System.out.println("Warning: " + exception.toString());
                }
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(string)));
                long l = System.currentTimeMillis() / 1000L;
                while ((string3 = bufferedReader.readLine()) != null) {
                    string3 = string3.trim();
                    String[] stringArray = string3.split("  *");
                    String string4 = stringArray[0];
                    String string5 = stringArray.length < 2 ? "00:00:00" : stringArray[1];
                    String[] stringArray2 = string5.split("[-:]");
                    long l2 = 0L;
                    int n = 0;
                    try {
                        if (stringArray2.length > 3) {
                            l2 += (long)(Integer.parseInt(stringArray2[n]) * 86400);
                            ++n;
                        }
                        if (stringArray2.length > 2) {
                            l2 += (long)(Integer.parseInt(stringArray2[n]) * 3600);
                            ++n;
                        }
                        l2 += (long)(Integer.parseInt(stringArray2[n]) * 60);
                        l2 += (long)Integer.parseInt(stringArray2[++n]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        l2 = 0L;
                    }
                    Long l3 = l - l2;
                    hashMap2.put(string4, l3);
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException("(02310251043) Exception in getStartTimes() : " + iOException.toString());
            }
        }
        if (string2.contains("win")) {
            Object object;
            Object object2;
            Object object3;
            try {
                object3 = System.getenv("BICSUITEHOME");
                if (object3 == null) {
                    throw new Exception("ERROR: BICSUITEHOME must be set, but isn't");
                }
                object2 = new ProcessBuilder((String)object3 + "\\bin\\winps.exe");
                ((ProcessBuilder)object2).redirectOutput(new File(string));
                ((ProcessBuilder)object2).redirectErrorStream(true);
                object = ((ProcessBuilder)object2).start();
                ((Process)object).getOutputStream().close();
                ((Process)object).getInputStream().close();
                ((Process)object).getErrorStream().close();
                try {
                    ((Process)object).waitFor();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try {
                    while (((Process)object).isAlive()) {
                        Thread.sleep(100L);
                        ((Process)object).destroy();
                        System.gc();
                    }
                    object = null;
                    System.gc();
                }
                catch (Exception exception) {
                    System.out.println("Warning: " + exception.toString());
                }
            }
            catch (Exception exception) {
                throw new RuntimeException("(03203141513) Error running winps : " + exception.toString());
            }
            try {
                object3 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), "UTF-8"));
                object = "yyyyMMddHHmmss";
                int n = ((String)object).length();
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat((String)object + " z");
                while ((object2 = ((BufferedReader)object3).readLine()) != null) {
                    if (((String)(object2 = ((String)object2).trim())).length() < n) continue;
                    String string6 = ((String)object2).substring(0, n);
                    String string7 = ((String)object2).substring(n);
                    int n2 = string7.indexOf(" ");
                    if (n2 < 0 || (string7 = string7.substring(n2).trim()).equals("")) continue;
                    try {
                        Long l = simpleDateFormat.parse(string6 + " UTC").getTime() / 1000L;
                        hashMap2.put(string7, l);
                    }
                    catch (ParseException parseException) {}
                }
                ((BufferedReader)object3).close();
            }
            catch (Exception exception) {
                throw new RuntimeException("(02310251044) Process start times : " + exception.toString());
            }
        }
        Trace.error("Unknown Operating System : " + string2);
        return hashMap2;
    }

    public static boolean isAlive(String string, HashMap<String, Long> hashMap) {
        long l;
        String string2;
        if (STARTTIME_JITTER == 0L) {
            return true;
        }
        int n = 0;
        int n2 = 0;
        while (string.charAt(n2) != '@') {
            ++n2;
        }
        try {
            string2 = string.substring(n, n2);
            long l2 = Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new RuntimeException("(023102812133) Invalid processId " + string + " : " + numberFormatException.toString());
        }
        n = n2 + 1;
        char c = string.charAt(n);
        n2 = ++n;
        while (string.charAt(n2) != '+') {
            ++n2;
        }
        String string3 = string.substring(n, n2);
        n = n2 + 1;
        String string4 = string.substring(n);
        long l3 = 0L;
        if (!hashMap.containsKey(string2)) {
            l3 = ProcessInfo.getStartTime(string2);
            if (l3 == 0L) {
                return false;
            }
        } else {
            l3 = hashMap.get(string2);
        }
        if (Math.abs(l3 - (l = Long.parseLong(string4))) > STARTTIME_JITTER) {
            Trace.warning("strPid = : " + string2 + ", startTimeJob = " + Long.valueOf(l3).toString() + " startTimePid = " + l);
        }
        return true;
    }

    public static String getBoottime(char c) {
        if (!bootTimes.containsKey("" + c)) {
            String string = "0";
            switch (c) {
                case 'S': {
                    string = ProcessInfo.getBootTimeSystem();
                    break;
                }
                case 'F': {
                    string = ProcessInfo.getBootTimeFile();
                }
            }
            bootTimes.put("" + c, Long.valueOf(string));
        }
        return bootTimes.get("" + c).toString();
    }

    public static boolean setBoottimeHow(char c) {
        if (boottimeHow == 'N' || boottimeHow == 'S' || boottimeHow == 'F') {
            boottimeHow = c;
            return true;
        }
        return false;
    }

    public static char getBoottimeHow() {
        return 'N';
    }
}

