/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.jobserver;

import de.independit.scheduler.jobserver.Utils;
import de.independit.scheduler.server.output.SDMSOutput;
import de.independit.scheduler.server.output.SDMSOutputContainer;
import de.independit.scheduler.server.output.SDMSOutputLabel;
import java.util.Vector;

public final class Trace {
    public static final String __version = "@(#) $Id: Trace.java,v 2.2.16.1 2013/03/14 10:24:07 ronald Exp $";
    public static final int FATAL = -2;
    public static final int ERROR = -1;
    public static final int INFO = 0;
    public static final int WARNING = 1;
    public static final int MESSAGE = 2;
    public static final int DEBUG = 3;
    public static final int DEFAULT = 1;
    private static int level = 1;

    public static final void setLevel(int n) {
        level = n;
    }

    private static final String levelString(int n) {
        switch (n) {
            case -2: {
                return "FATAL  ";
            }
            case -1: {
                return "ERROR  ";
            }
            case 0: {
                return "INFO   ";
            }
            case 1: {
                return "WARNING";
            }
            case 3: {
                return "DEBUG  ";
            }
            case 2: {
                return "MESSAGE";
            }
        }
        return "UNKNOWN";
    }

    private static final void trace(String string, int n) {
        if (n <= level) {
            String string2 = Utils.timestampNow();
            System.err.println(Trace.levelString(n) + " [Jobserver]\t" + string2.substring(1, string2.length() - 1) + " " + string);
        }
    }

    public static final void fatal(String string) {
        Trace.trace(string, -2);
    }

    public static final void error(String string) {
        Trace.trace(string, -1);
    }

    public static final void info(String string) {
        Trace.trace(string, 0);
    }

    public static final void warning(String string) {
        Trace.trace(string, 1);
    }

    public static final void debug(String string) {
        Trace.trace(string, 3);
    }

    public static final void message(String string) {
        Trace.trace(string, 2);
    }

    private static final String dump_field(Object object) {
        if (object == null) {
            return "<null>";
        }
        if (object instanceof String) {
            return "\"" + String.valueOf(object) + "\"";
        }
        if (object instanceof SDMSOutputContainer) {
            return Trace.dump_table((SDMSOutputContainer)object);
        }
        if (object instanceof Vector) {
            Vector vector = (Vector)object;
            StringBuffer stringBuffer = new StringBuffer("[");
            for (int i = 0; i < vector.size(); ++i) {
                if (i != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(Trace.dump_field(vector.get(i)));
            }
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
        return object.toString();
    }

    private static final String dump_record(SDMSOutputContainer sDMSOutputContainer) {
        Vector vector = (Vector)sDMSOutputContainer.dataset.get(0);
        StringBuffer stringBuffer = new StringBuffer("record=[");
        for (int i = 0; i < sDMSOutputContainer.desc.size(); ++i) {
            if (i != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(((SDMSOutputLabel)sDMSOutputContainer.desc.get((int)i)).name);
            stringBuffer.append("=");
            stringBuffer.append(Trace.dump_field(i < vector.size() ? vector.get(i) : null));
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private static final String dump_table(SDMSOutputContainer sDMSOutputContainer) {
        int n = sDMSOutputContainer.dataset.size();
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer("table=[");
        for (int i = 0; i < n; ++i) {
            if (n2 != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("#");
            stringBuffer.append(n2++);
            stringBuffer.append("=[");
            Vector vector = (Vector)sDMSOutputContainer.dataset.get(i);
            for (int j = 0; j < sDMSOutputContainer.desc.size(); ++j) {
                if (j != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(((SDMSOutputLabel)sDMSOutputContainer.desc.get((int)j)).name);
                stringBuffer.append("=");
                stringBuffer.append(Trace.dump_field(vector.get(j)));
            }
            stringBuffer.append("]");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static final String dump(SDMSOutput sDMSOutput) {
        StringBuffer stringBuffer = new StringBuffer();
        if (sDMSOutput.container != null) {
            stringBuffer.append("container=[");
            if (sDMSOutput.container.title != null) {
                stringBuffer.append("title=");
                stringBuffer.append(Trace.dump_field(sDMSOutput.container.title));
                stringBuffer.append(", ");
            }
            if (sDMSOutput.container.columns == 0) {
                stringBuffer.append(Trace.dump_record(sDMSOutput.container));
            } else {
                stringBuffer.append(Trace.dump_table(sDMSOutput.container));
            }
            stringBuffer.append("]");
        }
        if (sDMSOutput.feedback != null) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("feedback=");
            stringBuffer.append(Trace.dump_field(sDMSOutput.feedback));
        }
        if (sDMSOutput.error != null) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("error=[code=");
            stringBuffer.append(Trace.dump_field(sDMSOutput.error.code));
            stringBuffer.append(", message=");
            stringBuffer.append(Trace.dump_field(sDMSOutput.error.message));
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }

    private Trace() {
    }
}

