/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.jobserver;

import de.independit.scheduler.jobserver.Libjni;
import de.independit.scheduler.jobserver.RepoIface;
import de.independit.scheduler.jobserver.Trace;
import de.independit.scheduler.server.SystemEnvironment;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Utils {
    public static final char TIMESTAMP_LEADIN = '[';
    public static final char TIMESTAMP_LEADOUT = ']';
    public static final char BOOTTIME_NONE = 'N';
    public static final char BOOTTIME_SYSTEM = 'S';
    public static final char BOOTTIME_FILE = 'F';
    public static final char BOOTTIME_DEFAULT = 'N';
    private static final String LIBRARY_NAME = "BICsuite";
    private static final SimpleDateFormat DATE_FORMAT = (SimpleDateFormat)SystemEnvironment.staticJSCommDateFormat.clone();
    private static final Libjni jni = new Libjni();

    public static final String getVersion() {
        return Libjni.getVersion();
    }

    public static final String getCopyright() {
        return Libjni.getCopyright();
    }

    public static final String getCompany() {
        return Libjni.getCompany();
    }

    public static final String getProtocol() {
        return Libjni.getProtocol();
    }

    public static final void abortProgram(String string) {
        Trace.fatal("***ERROR*** " + string);
        Trace.fatal("Program aborted");
        System.exit(1);
    }

    public static final void abortProgram(RepoIface repoIface, String string) {
        repoIface.notifyError(RepoIface.FATAL, string);
        Utils.abortProgram(string);
    }

    public static final String asGMT(Date date) {
        return "[" + DATE_FORMAT.format(date) + "]";
    }

    public static final String timestampNow() {
        return Utils.asGMT(new Date());
    }

    public static final void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            Trace.debug("Just been woken up");
        }
    }

    public static final String quoted(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = stringBuffer.length() - 1; i >= 0; --i) {
            switch (stringBuffer.charAt(i)) {
                case '\'': 
                case '\\': {
                    stringBuffer.insert(i, '\\');
                }
            }
        }
        return stringBuffer.toString();
    }

    public static final boolean isOneOf(String string, String[] stringArray) {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    public static final String getMyPid() {
        return String.valueOf(Utils.getPid());
    }

    private static final int getPid() {
        return jni.getPid();
    }

    public static final boolean isAlive(RepoIface repoIface, String string) {
        return jni.isAlive(string);
    }

    public static final String getEnvCmd() {
        return jni.getEnvCmd();
    }

    public static final String chdir(String string) {
        return jni.chdir(string);
    }

    public static final String setBoottimeHow(char c) {
        if (jni.setBoottimeHow(c)) {
            return null;
        }
        return "Oops";
    }

    public static final char getBoottimeHow() {
        return jni.getBoottimeHow();
    }

    public static final String getProcessStartTime(long l) {
        return jni.getProcessStartTime(l);
    }

    private Utils() {
    }
}

