/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.jobserver.jexecutor;

import de.independit.scheduler.jobserver.ProcessInfo;
import de.independit.scheduler.jobserver.jexecutor.Jexecutor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.Vector;

public class JProcessExecutor
extends Jexecutor {
    private boolean isComplete;
    private boolean usePath;
    private String workdir;
    private String logfile;
    private boolean samelogs;
    private boolean logappend;
    private boolean errappend;
    private String errlog;
    private String command;
    private Vector arguments;
    private PrintStream userLog;
    private long myStartTime = 0L;
    private long userStartTime = 0L;

    @Override
    public String getMyStarttime() {
        return "" + this.myStartTime;
    }

    @Override
    public String getUserStarttime() {
        return "" + this.userStartTime;
    }

    @Override
    public String getPid() {
        return ProcessInfo.getPid();
    }

    @Override
    public String getPid(Process process) {
        return ProcessInfo.getPid(process);
    }

    private String checkPath(String string, String string2, boolean bl) {
        File file = new File(string);
        if (file.isAbsolute() && file.canExecute()) {
            return string;
        }
        if (file.isAbsolute()) {
            return null;
        }
        file = new File(string2 + File.separator + string);
        if (file.canExecute()) {
            return file.toString();
        }
        if (!bl) {
            return null;
        }
        String string3 = System.getenv("PATH");
        String[] stringArray = string3.split(File.pathSeparator);
        for (int i = 0; i < stringArray.length; ++i) {
            file = new File(stringArray[i] + File.separator + string);
            if (!file.canExecute()) continue;
            return file.toString();
        }
        return null;
    }

    private void redirectOutput(ProcessBuilder processBuilder) {
        Object object;
        this.userLog = null;
        File file = new File(this.logfile);
        try {
            if (!file.isAbsolute()) {
                file = new File(this.workdir + File.separator + this.logfile);
            }
            object = new FileOutputStream(file, this.logappend);
            if (!this.logappend) {
                ((FileOutputStream)object).close();
                object = new FileOutputStream(file, true);
            }
            this.userLog = new PrintStream((OutputStream)object, true);
            processBuilder.redirectOutput(ProcessBuilder.Redirect.appendTo(file));
        }
        catch (IOException iOException) {
            throw new RuntimeException("Cannot open logfile " + String.valueOf(file) + " : " + iOException.toString());
        }
        object = new File(this.errlog);
        try {
            if (!((File)object).isAbsolute()) {
                object = new File(this.workdir + File.separator + this.errlog);
            }
            if (!this.samelogs) {
                if (!this.errappend) {
                    FileOutputStream fileOutputStream = new FileOutputStream((File)object, this.errappend);
                    fileOutputStream.close();
                }
                processBuilder.redirectError(ProcessBuilder.Redirect.appendTo((File)object));
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("Cannot open errlogfile " + String.valueOf(object) + " : " + iOException.toString());
        }
        processBuilder.redirectErrorStream(this.samelogs);
    }

    private Process startUserProcess(ProcessBuilder processBuilder) {
        processBuilder.directory(new File(this.workdir));
        Process process = null;
        try {
            if (this.taskfile.getVerboseLogs()) {
                this.userLog.println(new Date().toString() + " started");
            }
            process = processBuilder.start();
            this.userStartTime = System.currentTimeMillis() / 1000L;
        }
        catch (IOException iOException) {
            try {
                this.taskfile.open();
                this.taskfile.append("CHILD_ERROR", "(02310220819) Cannot execute " + this.command + " : " + iOException.toString());
                this.taskfile.close();
            }
            catch (IOException iOException2) {
                throw new RuntimeException("(02310220940) Cannot write taskfile : " + iOException2.toString());
            }
            return null;
        }
        try {
            this.taskfile.open();
            this.taskfile.append("execpid", this.getProcessId(process));
            this.taskfile.append("extpid", this.getProcessId());
            this.taskfile.append("status", "RUNNING");
            this.taskfile.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException("(02310220941) Cannot write taskfile : " + iOException.toString());
        }
        return process;
    }

    private void getTaskfileInfo() {
        if (this.argsType != 0) {
            throw new RuntimeException("Programm arguments not evaluated");
        }
        boolean bl = this.taskfile.getComplete();
        if (!bl) {
            throw new RuntimeException("Taskfile " + this.taskfile.toString() + " seems to be incomplete");
        }
        this.usePath = this.taskfile.getUsepath();
        this.workdir = this.taskfile.getWorkdir();
        this.logfile = this.taskfile.getLogfile();
        this.samelogs = this.taskfile.getSamelogs();
        this.logappend = this.taskfile.getLogappend();
        this.errappend = this.taskfile.getErrappend();
        this.errlog = this.samelogs ? this.logfile : this.taskfile.getErrlog();
        this.command = this.taskfile.getCommand();
        this.arguments = this.taskfile.getArgs();
    }

    @Override
    public void run() {
        Object object;
        this.myStartTime = System.currentTimeMillis() / 1000L;
        this.getTaskfileInfo();
        String[] stringArray = new String[this.arguments.size() + 1];
        stringArray[0] = this.checkPath(this.command, this.workdir, this.usePath);
        if (stringArray[0] == null) {
            try {
                this.taskfile.open();
                this.taskfile.append("CHILD_ERROR", "(02310221008) Cannot execute " + this.command);
                this.taskfile.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException("(02310220940) Cannot write taskfile : " + iOException.toString());
            }
            return;
        }
        for (int i = 0; i < this.arguments.size(); ++i) {
            stringArray[i + 1] = (String)this.arguments.get(i);
        }
        ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
        if (this.env != null) {
            object = processBuilder.environment();
            object.putAll(this.env);
        }
        this.redirectOutput(processBuilder);
        object = this.startUserProcess(processBuilder);
        if (object != null) {
            while (true) {
                try {
                    ((Process)object).waitFor();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    continue;
                }
                break;
            }
            if (this.taskfile.getVerboseLogs()) {
                this.userLog.println(new Date().toString() + " finished (" + ((Process)object).exitValue() + ")");
            }
            try {
                this.taskfile.open();
                this.taskfile.append("returncode", Integer.valueOf(((Process)object).exitValue()).toString());
                this.taskfile.append("status", "FINISHED");
            }
            catch (IOException iOException) {
                throw new RuntimeException("(02310220942) Cannot write taskfile : " + iOException.toString());
            }
        }
        this.userLog.close();
    }

    public static void main(String[] stringArray) {
        int n = -1;
        try {
            JProcessExecutor jProcessExecutor = new JProcessExecutor();
            try {
                n = jProcessExecutor.checkArgs(stringArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.out.println(JProcessExecutor.getUsage());
                System.exit(1);
            }
            switch (n) {
                case 0: {
                    jProcessExecutor.run();
                    break;
                }
                case 2: {
                    System.out.println(JProcessExecutor.getUsage());
                    break;
                }
                case 1: {
                    System.out.println(JProcessExecutor.getVersion());
                    break;
                }
                default: {
                    System.err.println("Invalid internal state! argState contains : " + n);
                    System.exit(1);
                    break;
                }
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            System.exit(1);
        }
        System.exit(0);
    }
}

