/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.jobserver.jexecutor;

import de.independit.scheduler.jobserver.Feil;
import java.util.Map;

public abstract class Jexecutor {
    public static final char BT_SYSTEM = 'S';
    public static final char BT_FILE = 'F';
    public static final char BT_NONE = 'N';
    public static final char PID_SEP = '@';
    public static final char JIF_SEP = '+';
    public static final int ARGS_NOTREAD = -1;
    public static final int ARGS_RUN = 0;
    public static final int ARGS_VERSION = 1;
    public static final int ARGS_HELP = 2;
    public String boottime = "0";
    public char how = (char)78;
    public String taskfileName = null;
    protected Feil taskfile;
    protected Map<String, String> env = null;
    protected int argsType = -1;

    public Jexecutor() {
        this.initialize();
    }

    public Jexecutor(Map<String, String> map) {
        this.initialize();
        this.env = map;
    }

    private void initialize() {
        this.argsType = -1;
    }

    public abstract String getMyStarttime();

    public abstract String getUserStarttime();

    public abstract String getPid();

    public abstract String getPid(Process var1);

    public String getProcessId() {
        String string = this.getPid();
        String string2 = this.getMyStarttime();
        return string + "@" + this.how + this.boottime + "+" + string2;
    }

    public String getProcessId(Process process) {
        String string = this.getPid(process);
        String string2 = this.getUserStarttime();
        return string + "@" + this.how + this.boottime + "+" + string2;
    }

    protected static String getUsage() {
        return "Usage:\nJexecutor [--version|-v] [--help|-h] [<boottime_how> <taskfileName> [boottime]]\n\nExactly one of the optional argument sets must be specified\ni.e. either the version request, or this help request or some specification on what to do";
    }

    protected static String getVersion() {
        return "Jobserver (executor) 2.6\nCopyright (C) 2013 independIT Integrative Technologies GmbH\nAll rights reserved";
    }

    protected int checkArgs(String[] stringArray) throws IllegalArgumentException, RuntimeException {
        if (stringArray.length >= 1 && (stringArray[0].equals("--version") || stringArray[0].equals("-v"))) {
            this.argsType = 1;
            return 1;
        }
        if (stringArray.length >= 1 && (stringArray[0].equals("--help") || stringArray[0].equals("-h"))) {
            this.argsType = 2;
            return 2;
        }
        if (stringArray.length == 2 || stringArray.length == 3) {
            if (stringArray.length == 2) {
                this.taskfileName = stringArray[1];
            } else {
                this.how = stringArray[0].charAt(0);
                this.taskfileName = stringArray[1];
                this.boottime = stringArray[2];
            }
            this.taskfile = new Feil(this.taskfileName);
            try {
                this.taskfile.open();
                this.taskfile.scan();
                this.taskfile.close();
            }
            catch (Exception exception) {
                throw new RuntimeException("Error occurred during initial taskfile processing");
            }
            this.argsType = 0;
            return 0;
        }
        throw new IllegalArgumentException();
    }

    public abstract void run();

    private static void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

