/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler;

import de.independit.scheduler.SDMSApp.App;
import de.independit.scheduler.SDMSApp.Option;
import de.independit.scheduler.SDMSApp.RetryException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.output.SDMSLineRenderer;
import de.independit.scheduler.server.output.SDMSOutput;
import de.independit.scheduler.shell.MiniParser;
import de.independit.scheduler.shell.MiniScanner;
import java.io.BufferedReader;
import java.io.Console;
import java.io.IOException;
import java.io.InputStreamReader;

public class sdmsh
extends App {
    public static final String __version = "@(#) $Id: sdmsh.java,v 2.16.4.1 2013/03/14 10:24:02 ronald Exp $";
    String host = "localhost";
    String user = null;
    String pass = null;
    int port = 2506;
    int timeout = -1;
    MiniParser mp = null;
    MiniScanner scanner = null;
    public static final String MYSILENT = "MYSILENT";
    public static final String MYTIMEOUT = "CONNTIMEOUT";

    @Override
    public void addOptions() {
        this.addOption("S", null, null, MYSILENT, null, null, false, "[No] (error) messages are printed (has preference over -s)");
        this.addOption(null, "timeout", "Timeout", MYTIMEOUT, null, "timeout", false, "Number of seconds after which the server will remove an idle session. 0 means no timeout.");
    }

    private static String getValue(String string, boolean bl) {
        try {
            if (!bl) {
                Console console = System.console();
                if (console != null) {
                    System.out.print(string);
                    String string2 = new String(console.readPassword());
                    return string2;
                }
                InputStreamReader inputStreamReader = new InputStreamReader(System.in);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                System.out.print(string);
                return bufferedReader.readLine();
            }
            InputStreamReader inputStreamReader = new InputStreamReader(System.in);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            System.out.print(string);
            return bufferedReader.readLine();
        }
        catch (IOException iOException) {
            System.err.println("FATAL ERROR while reading from stdin");
            System.exit(1);
            return null;
        }
    }

    @Override
    public String getName() {
        return "sdmsh";
    }

    @Override
    public boolean canRetry() {
        return false;
    }

    @Override
    public String getUsageArguments() {
        return "user password host port";
    }

    @Override
    public boolean specificParse() {
        Option option;
        if (this.options.isSet(MYSILENT)) {
            option = this.options.getOption(MYSILENT);
            this.options.getOption("SILENT").set(option);
            this.silent = option.getBValue();
        }
        if (this.options.isSet("USER")) {
            this.user = this.options.getValue("USER");
            if (this.options.isSet("PASS")) {
                this.pass = this.options.getValue("PASS");
            }
        } else if (this.options.isSet("JID")) {
            this.user = this.options.getValue("JID");
            if (this.options.isSet("KEY")) {
                this.pass = this.options.getValue("KEY");
            }
        }
        if (this.options.isSet("HOST")) {
            this.host = this.options.getValue("HOST");
        }
        try {
            if (this.options.isSet("PORT")) {
                this.port = Integer.parseInt(this.options.getValue("PORT"));
            }
        }
        catch (Exception exception) {
            if (!this.silent) {
                System.err.println("port be an integer !");
            }
            return false;
        }
        try {
            if (this.options.isSet(MYTIMEOUT)) {
                this.timeout = Integer.parseInt(this.options.getValue(MYTIMEOUT));
            }
        }
        catch (Exception exception) {
            if (!this.silent) {
                System.err.println("timeout be an integer !");
            }
            return false;
        }
        block12: for (int i = 0; i < this.options.rest.size(); ++i) {
            switch (i) {
                case 0: {
                    this.user = (String)this.options.rest.get(i);
                    option = this.options.getOption("USER");
                    option.set(this.user, false);
                    continue block12;
                }
                case 1: {
                    this.pass = (String)this.options.rest.get(i);
                    option = this.options.getOption("PASS");
                    option.set(this.pass, false);
                    continue block12;
                }
                case 2: {
                    this.host = (String)this.options.rest.get(i);
                    option = this.options.getOption("HOST");
                    option.set(this.host, false);
                    continue block12;
                }
                case 3: {
                    try {
                        this.port = Integer.parseInt((String)this.options.rest.get(i));
                    }
                    catch (Exception exception) {
                        if (!this.silent) {
                            System.err.println("port be an integer !");
                        }
                        return false;
                    }
                    option = this.options.getOption("PORT");
                    option.set((String)this.options.rest.get(i), false);
                }
            }
        }
        if (!(this.options.isSet("HELP") || this.options.getOption("HELP").getBValue() || this.options.isSet("AUTH") && this.options.getValue("AUTH").equals("WINSSO"))) {
            if (this.user == null) {
                this.user = sdmsh.getValue("USERNAME: ", true);
                option = this.options.getOption("USER");
                option.set(this.user, false);
            }
            if (this.pass == null) {
                this.pass = sdmsh.getValue("PASSWORD: ", false);
                option = this.options.getOption("PASS");
                option.set(this.pass, false);
            }
        }
        if (System.console() == null && !this.options.isSet("VERBOSE") && !this.silent) {
            option = this.options.getOption("VERBOSE");
            option.set(null, true);
            this.verbose = true;
        }
        if (this.user != null) {
            App.userName = this.user;
        }
        return true;
    }

    @Override
    public boolean validateOptions() {
        return true;
    }

    @Override
    public void render(SDMSOutput sDMSOutput) throws SDMSException {
        ((SDMSLineRenderer)this.mp.getOutputRenderer()).setPrompt("[" + App.userName + "@" + this.host + ":" + this.port + "] SDMS> ");
        if (this.mp != null) {
            this.mp.render(sDMSOutput);
        }
    }

    @Override
    public boolean setupApp() {
        this.scanner = new MiniScanner(new InputStreamReader(System.in));
        this.mp = new MiniParser();
        SDMSLineRenderer sDMSLineRenderer = new SDMSLineRenderer("[" + App.userName + "@" + this.host + ":" + this.port + "] SDMS> ");
        this.mp.setOutputRenderer(sDMSLineRenderer);
        this.mp.setEnvInfo(this.host, this.port, this.user);
        this.mp.setPrintCmd(this.verbose);
        sDMSLineRenderer.setSilent(this.silent);
        sDMSLineRenderer.setVerbose(this.verbose);
        return true;
    }

    @Override
    public int go() throws RetryException {
        try {
            this.mp.setServerConnection(this.serverConnection);
            try {
                this.mp.yyparse(this.scanner);
            }
            catch (MiniParser.yyException yyException2) {
                if (!this.silent) {
                    System.out.println("Oops : " + String.valueOf(yyException2) + " at line " + this.scanner.yyline());
                }
            }
        }
        catch (SDMSException sDMSException) {
            if (!this.silent) {
                System.err.println("***ERROR*** " + sDMSException.getMessage());
            }
        }
        catch (IOException iOException) {
            if (!this.silent) {
                System.err.println("***ERROR*** " + iOException.getMessage());
            }
        }
        finally {
            return 1;
        }
        return 0;
    }

    public static void main(String[] stringArray) {
        System.exit(new sdmsh().run(stringArray));
    }
}

