/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server;

import de.independit.scheduler.server.util.SDMSThread;
import java.security.cert.Certificate;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;

class MyListener
implements HandshakeCompletedListener {
    private boolean finished = false;

    @Override
    public void handshakeCompleted(HandshakeCompletedEvent handshakeCompletedEvent) {
        SSLSession sSLSession = handshakeCompletedEvent.getSession();
        SDMSThread.doTrace(null, "\n================================================================", 2);
        SDMSThread.doTrace(null, "Handshake Completed with peer " + sSLSession.getPeerHost(), 2);
        SDMSThread.doTrace(null, "\t cipher: " + sSLSession.getCipherSuite(), 2);
        Certificate[] certificateArray = null;
        try {
            certificateArray = sSLSession.getPeerCertificates();
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            certificateArray = null;
        }
        if (certificateArray != null) {
            SDMSThread.doTrace(null, "peer certificates:", 2);
            for (int i = 0; i < certificateArray.length; ++i) {
                SDMSThread.doTrace(null, "\tcerts[" + i + "]: " + String.valueOf(certificateArray[i]), 2);
            }
        } else {
            SDMSThread.doTrace(null, "No peer certificates presented", 2);
        }
        SDMSThread.doTrace(null, "================================================================", 2);
        this.finished = true;
    }

    public boolean isFinished() {
        return this.finished;
    }
}

