/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server;

import de.independit.scheduler.server.DBCleanupThread;
import de.independit.scheduler.server.GarbageThread;
import de.independit.scheduler.server.InitRepositoryThread;
import de.independit.scheduler.server.NotifierThread;
import de.independit.scheduler.server.OrdinaryListenThread;
import de.independit.scheduler.server.RenewTicketThread;
import de.independit.scheduler.server.SSLListenThread;
import de.independit.scheduler.server.SchedulingThread;
import de.independit.scheduler.server.ShutdownThread;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.TimerThread;
import de.independit.scheduler.server.TriggerThread;
import de.independit.scheduler.server.WorkerThread;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSRepository;
import de.independit.scheduler.server.util.SDMSThread;
import de.independit.scheduler.server.util.SyncFifo;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;

public class Server {
    public static final String __version = "@(#) $Id: Server.java,v 2.17.2.6 2013/09/11 11:50:39 ronald Exp $";
    private ThreadGroup utg;
    private SSLListenThread ssllt;
    private OrdinaryListenThread ult;
    private OrdinaryListenThread svt;
    private SchedulingThread wst;
    private GarbageThread gst;
    private TimerThread tt;
    private TriggerThread trt;
    private InitRepositoryThread irt;
    private ThreadGroup wg;
    private SyncFifo cmdQueue;
    private SyncFifo roCmdQueue;
    private WorkerThread[] wt;
    private ShutdownThread shutt;
    private RenewTicketThread rtt;
    private DBCleanupThread dbct;
    private NotifierThread notifier;
    private String iniFile;
    private SystemEnvironment env;

    public Server(String string, boolean bl, boolean bl2, String string2, String string3, String string4) {
        this.iniFile = string;
        Properties properties = this.readProperties();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string5 = (String)enumeration.nextElement();
            if (string5.equals("DbPasswd") || string5.equals("SysPasswd") || string5.equals("KeyStorePassword") || string5.equals("TrustStorePassword")) continue;
            SDMSThread.doTrace(null, string5 + "=" + properties.getProperty(string5), 0);
        }
        this.env = new SystemEnvironment(properties, string2, string3, string4, this);
        if (bl) {
            this.env.disableConnect();
        }
        if (bl2) {
            SystemEnvironment.setProtectMode();
        }
    }

    public Properties readProperties() {
        Properties properties = new Properties();
        InputStream inputStream = Server.class.getResourceAsStream(this.iniFile);
        try {
            if (inputStream == null) {
                inputStream = new FileInputStream(this.iniFile);
            }
            properties.load(inputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            SDMSThread.doTrace(null, "Properties File not found : " + String.valueOf(fileNotFoundException), -2);
        }
        catch (IOException iOException) {
            SDMSThread.doTrace(null, "Error loading Properties file: " + String.valueOf(iOException), -2);
        }
        return properties;
    }

    public String getIniFile() {
        return this.iniFile;
    }

    private void initShutdownThread() {
        this.shutt = new ShutdownThread(this.env, this);
        Runtime runtime = Runtime.getRuntime();
        runtime.addShutdownHook(this.shutt);
    }

    private void initRenewTicketThread() throws SDMSException {
        SystemEnvironment.ticketThread = this.rtt = new RenewTicketThread(this);
        this.rtt.initRenewTicketThread(this.env);
        this.rtt.getTicket(this.rtt.pSysEnv);
    }

    private void startRenewTicketThread() throws SDMSException {
        SDMSThread.doTrace(null, "Starting Renew Ticket Thread", 0);
        this.rtt.start();
    }

    private void initDBCleanupThread() throws SDMSException {
        SystemEnvironment.dbCleanupThread = this.dbct = new DBCleanupThread(this);
        this.dbct.initDBCleanupThread(this.env);
    }

    private void startDBCleanupThread() throws SDMSException {
        SDMSThread.doTrace(null, "Starting Database Cleanup Thread", 0);
        this.dbct.start();
    }

    private void initNotifierThread() throws SDMSException {
        SystemEnvironment.notifier = this.notifier = new NotifierThread(this.env, this.roCmdQueue);
        this.notifier.initNotifierThread(this.env);
    }

    private void startNotifierThread() throws SDMSException {
        SDMSThread.doTrace(null, "Starting Notifier Thread", 0);
        this.notifier.start();
    }

    private void createRepository() throws SDMSException {
        new SDMSRepository(this.env);
    }

    private void initWorkers() throws SDMSException {
        this.wg = new ThreadGroup("WorkerThreads");
        this.cmdQueue = new SyncFifo();
        this.roCmdQueue = new SyncFifo();
        SystemEnvironment.wg = this.wg;
    }

    private void startWorkers() throws SDMSException {
        int n = SystemEnvironment.maxWorker + SystemEnvironment.maxWriter;
        SDMSThread.doTrace(null, "Starting " + n + " Worker Threads", 0);
        this.wt = new WorkerThread[n];
        SyncFifo syncFifo = this.cmdQueue;
        for (int i = 0; i < n; ++i) {
            if (i >= SystemEnvironment.maxWriter) {
                syncFifo = this.roCmdQueue;
            }
            this.wt[i] = new WorkerThread(this.env, this.wg, syncFifo, i);
            this.wt[i].start();
        }
    }

    private void initScheduling() throws SDMSException {
        this.wst = new SchedulingThread(this.env, this.cmdQueue);
        this.wst.spinDelay = 50L;
        SystemEnvironment.sched = this.wst;
    }

    public void startScheduling() throws SDMSException {
        if (SystemEnvironment.getProtectMode()) {
            return;
        }
        if (this.wst.isAlive()) {
            return;
        }
        SDMSThread.doTrace(null, "Starting Scheduling Thread", 0);
        this.wst.start();
    }

    private void initGC() throws SDMSException {
        SystemEnvironment.garb = this.gst = new GarbageThread(this.env, this.cmdQueue);
    }

    private void startGC() throws SDMSException {
        SDMSThread.doTrace(null, "Starting Garbage Collection Thread", 0);
        this.gst.start();
    }

    private void initTT() throws SDMSException {
        SystemEnvironment.tt = this.trt = new TriggerThread(this.env, this.cmdQueue);
    }

    private void startTT() throws SDMSException {
        SDMSThread.doTrace(null, "Starting Trigger Thread", 0);
        this.trt.start();
    }

    private void initTimeScheduling() throws SDMSException {
        SystemEnvironment.timer = this.tt = new TimerThread(this.env, this.cmdQueue);
    }

    public void startTimeScheduling() throws SDMSException {
        if (SystemEnvironment.getProtectMode()) {
            return;
        }
        if (this.tt.isAlive()) {
            return;
        }
        SDMSThread.doTrace(null, "Starting Time Scheduling Thread", 0);
        this.tt.start();
    }

    private void initIRT() throws SDMSException {
        this.irt = new InitRepositoryThread(this.env, this.cmdQueue);
    }

    private void startIRT() throws SDMSException {
        SDMSThread.doTrace(null, "Starting Init Repository Thread", 0);
        this.irt.start();
    }

    private void initListener() {
        SystemEnvironment.utg = this.utg = new ThreadGroup(this.wg, "UserThreads");
    }

    private void startListener() {
        SDMSThread.doTrace(null, "Starting Listener Thread(s)", 0);
        if (SystemEnvironment.port != 0) {
            this.ult = new OrdinaryListenThread(this.utg, SystemEnvironment.port, SystemEnvironment.plainIf, SystemEnvironment.maxConnects, this.cmdQueue, this.roCmdQueue, 1);
            this.ult.start();
        } else {
            SDMSThread.doTrace(null, "Standard communication Listener disabled", 0);
            this.ult = null;
        }
        if (SystemEnvironment.service_port != 0) {
            this.svt = new OrdinaryListenThread(this.utg, SystemEnvironment.service_port, SystemEnvironment.serviceIf, 1, this.cmdQueue, this.roCmdQueue, 2);
            this.svt.start();
        } else {
            SDMSThread.doTrace(null, "Service port Listener disabled", 0);
            this.svt = null;
        }
        if (SystemEnvironment.sslport != 0) {
            try {
                this.ssllt = new SSLListenThread(this.utg, SystemEnvironment.sslport, SystemEnvironment.sslIf, SystemEnvironment.maxConnects, this.cmdQueue, this.roCmdQueue, 1);
            }
            catch (SDMSException sDMSException) {
                SDMSThread.doTrace(null, sDMSException.toString(), -2);
            }
            this.ssllt.start();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            String[] stringArray = this.ssllt.getProtocols();
            if (stringArray != null) {
                SDMSThread.doTrace(null, "TLS Listen Thread started. Supported Protocols :", 0);
                for (int i = 0; i < stringArray.length; ++i) {
                    SDMSThread.doTrace(null, "\t" + stringArray[i], 0);
                }
            }
        } else {
            SDMSThread.doTrace(null, "SSL communication Listener disabled", 0);
            this.ssllt = null;
        }
    }

    public void shutdown() {
        if (this.gst != null && this.gst.isAlive()) {
            this.gst.do_stop();
            SDMSThread.doTrace(null, "Stopped " + this.gst.toString(), 0);
        }
        if (this.ult != null) {
            if (this.ult.isAlive()) {
                this.ult.do_stop();
            }
            this.killAll();
        }
        if (this.svt != null) {
            if (this.svt.isAlive()) {
                this.svt.do_stop();
            }
            this.killAll();
        }
        if (this.ssllt != null) {
            if (this.ssllt.isAlive()) {
                this.ssllt.do_stop();
            }
            this.killAll();
        }
        if (this.wst != null && this.wst.isAlive()) {
            this.wst.do_stop();
            SDMSThread.doTrace(null, "Stopped " + this.wst.toString(), 0);
        }
        if (this.notifier != null && this.notifier.isAlive()) {
            this.notifier.do_stop();
            SDMSThread.doTrace(null, "Stopped " + this.notifier.toString(), 0);
        }
        if (this.tt != null && this.tt.isAlive()) {
            this.tt.do_stop();
            SDMSThread.doTrace(null, "Stopped " + this.tt.toString(), 0);
        }
        if (this.rtt != null && this.rtt.isAlive()) {
            this.rtt.do_stop();
            SDMSThread.doTrace(null, "Stopped " + this.rtt.toString(), 0);
        }
        if (this.dbct != null && this.dbct.isAlive()) {
            this.dbct.do_stop();
            SDMSThread.doTrace(null, "Stopped " + this.dbct.toString(), 0);
        }
        if (this.wt != null) {
            for (int i = 0; i < this.wt.length; ++i) {
                if (this.wt[i] == null || !this.wt[i].isAlive()) continue;
                this.wt[i].do_stop();
                SDMSThread.doTrace(null, "Stopped " + this.wt[i].toString(), 0);
            }
        }
        this.shutt.do_stop();
    }

    public void killUser(int n) {
        int n2 = this.utg.activeCount();
        Thread[] threadArray = new SDMSThread[n2];
        this.utg.enumerate(threadArray);
        for (int i = 0; i < n2; ++i) {
            if (threadArray[i] == null || ((SDMSThread)threadArray[i]).id() != n) continue;
            ((SDMSThread)threadArray[i]).do_stop();
        }
    }

    public void killAll() {
        int n = this.utg.activeCount();
        Thread[] threadArray = new SDMSThread[n];
        this.utg.enumerate(threadArray);
        for (int i = 0; i < n; ++i) {
            if (threadArray[i] == null || !threadArray[i].isAlive()) continue;
            ((SDMSThread)threadArray[i]).do_stop();
            SDMSThread.doTrace(null, "Stopped " + threadArray[i].toString(), 0);
        }
    }

    public static synchronized Connection connectToDB(SystemEnvironment systemEnvironment) throws FatalException {
        Connection connection;
        String string = SystemEnvironment.jdbcDriver;
        String string2 = SystemEnvironment.dbUrl;
        String string3 = SystemEnvironment.dbUser;
        String string4 = SystemEnvironment.dbPasswd;
        if (string == null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "03110181509", "No JDBC Driver Specified"));
        }
        if (string2 == null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "03110181510", "No JDBC URL Specified"));
        }
        try {
            Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "03110181511", "Class $1 not Found", string));
        }
        try {
            connection = DriverManager.getConnection(string2, string3, string4);
        }
        catch (SQLException sQLException) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "03110181512", "Unable to connect to $1, $2", string2, sQLException.toString()));
        }
        try {
            connection.setAutoCommit(false);
        }
        catch (SQLException sQLException) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "03202071128", "Cannot set autocommit off ($1)", sQLException.toString()));
        }
        if (SystemEnvironment.SQUOTE == null) {
            try {
                String string5 = connection.getMetaData().getDriverName();
                SDMSThread.doTrace(null, "JDBC Driver used : " + string5, 0);
                string5 = string5.toUpperCase();
                if (string5.startsWith("MYSQL") || string5.startsWith("MARIADB")) {
                    SystemEnvironment.SQUOTE = "`";
                    SystemEnvironment.EQUOTE = "`";
                } else if (string5.startsWith("MICROSOFT")) {
                    SystemEnvironment.SQUOTE = "[";
                    SystemEnvironment.EQUOTE = "]";
                } else if (string5.startsWith("POSTGRESQL")) {
                    SystemEnvironment.isPostgreSQL = true;
                    SystemEnvironment.SQUOTE = "";
                    SystemEnvironment.EQUOTE = "";
                } else if (string5.startsWith("ORACLE")) {
                    SystemEnvironment.SQUOTE = "\"";
                    SystemEnvironment.EQUOTE = "\"";
                } else {
                    SystemEnvironment.SQUOTE = "";
                    SystemEnvironment.EQUOTE = "";
                }
            }
            catch (SQLException sQLException) {
                SDMSThread.doTrace(null, "Unknown JDBC Driver used; run into an exception while trying to determine the Driver Name : " + sQLException.toString(), -2);
                SystemEnvironment.SQUOTE = "";
                SystemEnvironment.EQUOTE = "";
            }
        }
        return connection;
    }

    public void serverMain() {
        try {
            this.initShutdownThread();
            this.initRenewTicketThread();
            try {
                this.startRenewTicketThread();
            }
            catch (SDMSException sDMSException) {
                SDMSThread.doTrace(null, new SDMSMessage(this.env, "03302061700", "Fatal exception while starting TicketThread:\n$1", sDMSException.toString()).toString(), -2);
            }
            this.createRepository();
        }
        catch (SDMSException sDMSException) {
            SDMSThread.doTrace(null, new SDMSMessage(this.env, "03202252201", "Fatal exception while loading Repository:\n$1", sDMSException.toString()).toString(), -2);
        }
        try {
            SDMSThread.doTrace(null, "Initializing System Threads", 0);
            this.initWorkers();
            this.initListener();
            this.initScheduling();
            this.initTimeScheduling();
            this.initTT();
            this.initGC();
            this.initIRT();
            this.initNotifierThread();
            if (SystemEnvironment.dbPreserveTime > 0L) {
                this.initDBCleanupThread();
            } else {
                this.dbct = null;
            }
        }
        catch (SDMSException sDMSException) {
            SDMSThread.doTrace(null, new SDMSMessage(this.env, "03202252202", "Fatal exception while initializing System Threads:\n$1", sDMSException.toString()).toString(), -2);
        }
        try {
            this.startWorkers();
        }
        catch (SDMSException sDMSException) {
            SDMSThread.doTrace(null, new SDMSMessage(this.env, "03202252203", "Fatal exception while starting Workerthreads:\n$1", sDMSException.toString()).toString(), -2);
        }
        try {
            this.startIRT();
            try {
                this.irt.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.irt = null;
        }
        catch (SDMSException sDMSException) {
            SDMSThread.doTrace(null, new SDMSMessage(this.env, "03711131738", "Fatal exception while initializing the Repository:\n$1", sDMSException.toString()).toString(), -2);
        }
        try {
            this.startScheduling();
        }
        catch (SDMSException sDMSException) {
            SDMSThread.doTrace(null, new SDMSMessage(this.env, "03202252204", "Fatal exception while starting SchedulingThread:\n$1", sDMSException.toString()).toString(), -2);
        }
        try {
            this.startTimeScheduling();
        }
        catch (SDMSException sDMSException) {
            SDMSThread.doTrace(null, new SDMSMessage(this.env, "03206082124", "Fatal exception while starting Time Scheduling:\n$1", sDMSException.toString()).toString(), -2);
        }
        try {
            this.startTT();
        }
        catch (SDMSException sDMSException) {
            SDMSThread.doTrace(null, new SDMSMessage(this.env, "03407301455", "Fatal exception while starting trigger thread:\n$1", sDMSException.toString()).toString(), -2);
        }
        try {
            this.startGC();
        }
        catch (SDMSException sDMSException) {
            SDMSThread.doTrace(null, new SDMSMessage(this.env, "03311120827", "Fatal exception while starting garbage collector:\n$1", sDMSException.toString()).toString(), -2);
        }
        try {
            this.startNotifierThread();
        }
        catch (SDMSException sDMSException) {
            SDMSThread.doTrace(null, new SDMSMessage(this.env, "03701031503", "Fatal exception while starting notifier thread:\n$1", sDMSException.toString()).toString(), -2);
        }
        try {
            if (this.dbct != null) {
                this.startDBCleanupThread();
            }
        }
        catch (SDMSException sDMSException) {
            SDMSThread.doTrace(null, new SDMSMessage(this.env, "03311141139", "Fatal exception while starting dbCleanupThread:\n$1", sDMSException.toString()).toString(), -2);
        }
        this.startListener();
        SDMSMessage sDMSMessage = new SDMSMessage(this.env, "03110212341", "-- $1 -- $2 -- $3 -- ready --", "SDMS", "Server", "Systems");
        SDMSThread.doTrace(null, sDMSMessage.toString(), 0);
        for (int i = 0; i < this.wt.length; ++i) {
            try {
                this.wt[i].join();
                SDMSThread.doTrace(null, "Worker " + i + " terminated", 0);
            }
            catch (InterruptedException interruptedException) {
                --i;
            }
            if (i != 0) continue;
            this.shutdown();
        }
        while (true) {
            try {
                SDMSThread.doTrace(null, "Waiting for Listener", 0);
                this.ult.interrupt();
                this.ult.join();
                SDMSThread.doTrace(null, "Listener terminated", 0);
                if (this.svt != null) {
                    SDMSThread.doTrace(null, "Waiting for ServiceThread", 0);
                    this.svt.interrupt();
                    this.svt.join();
                    SDMSThread.doTrace(null, "ServiceThread terminated", 0);
                }
                if (this.dbct == null) break;
                SDMSThread.doTrace(null, "Waiting for DBCleanup", 0);
                if (this.dbct.isAlive()) {
                    this.dbct.join();
                }
                SDMSThread.doTrace(null, "DBCleanup Thread terminated", 0);
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
        System.exit(0);
    }
}

