/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server;

import de.independit.scheduler.server.ConnectionEnvironment;
import de.independit.scheduler.server.MyListener;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.parser.Parser;
import de.independit.scheduler.server.parser.SDMSParser;
import de.independit.scheduler.server.parser.Scanner;
import de.independit.scheduler.server.util.SDMSThread;
import de.independit.scheduler.server.util.SyncFifo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;

public class UserConnection
extends SDMSThread {
    public static final String __version = "@(#) $Id: UserConnection.java,v 2.6.2.1 2013/03/14 10:24:10 ronald Exp $";
    private static final Object initLock = new Object();
    private ConnectionEnvironment env;
    public Scanner scanner;
    private SDMSParser parser;
    private PrintStream ostream;
    private InputStream istream;
    private Socket sock;
    private int timeout;
    private static int i = 1000;
    private boolean isSSLConnection;
    private boolean isClientAuthenticated;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserConnection(boolean bl, ThreadGroup threadGroup, Socket socket, SyncFifo syncFifo, SyncFifo syncFifo2, int n) {
        super(threadGroup, Integer.toString(++i));
        Object object;
        this.sock = socket;
        if (socket instanceof SSLSocket) {
            object = (SSLSocket)socket;
            this.isSSLConnection = true;
            MyListener myListener = new MyListener();
            ((SSLSocket)object).addHandshakeCompletedListener(myListener);
            try {
                while (myListener.isFinished()) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                SSLSession sSLSession = ((SSLSocket)object).getSession();
                sSLSession.getPeerCertificates();
                this.isClientAuthenticated = true;
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                this.isClientAuthenticated = false;
            }
        } else {
            this.isSSLConnection = false;
            this.isClientAuthenticated = false;
        }
        try {
            object = initLock;
            synchronized (object) {
                this.ostream = new PrintStream(this.sock.getOutputStream(), true);
                this.istream = this.sock.getInputStream();
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            UserConnection.doTrace(null, "Oops -> " + String.valueOf(unsupportedEncodingException), -1);
        }
        catch (IOException iOException) {
            UserConnection.doTrace(null, "Oops -> " + String.valueOf(iOException), -1);
        }
        this.timeout = SystemEnvironment.sessionTimeout;
        this.setTimeout(this.timeout);
        this.env = new ConnectionEnvironment(i, bl, this.ostream, syncFifo, syncFifo2, n, this.sock.getInetAddress(), this.isSSLConnection, this.isClientAuthenticated);
        this.env.setMe(this);
        object = this.sock.getInetAddress();
        UserConnection.doTrace(this.env, "UserConnection from " + (String)(object != null ? ((InetAddress)object).getHostAddress() + ":" + this.sock.getPort() : "<unknown IP>") + " initialized", 2);
        this.ostream.flush();
    }

    public boolean iAmAlive() {
        if (!super.isAlive()) {
            return false;
        }
        if (!this.sock.isConnected()) {
            this.do_stop();
            return false;
        }
        return true;
    }

    public boolean getIsClientAuthenticated() {
        return this.isClientAuthenticated;
    }

    public boolean isSSLConnection() {
        return this.isSSLConnection;
    }

    public ConnectionEnvironment getEnv() {
        return this.env;
    }

    @Override
    public int id() {
        return this.env.id();
    }

    @Override
    public void do_stop() {
        this.run = false;
        try {
            this.istream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTimeout(int n) {
        if (n < 0) {
            return;
        }
        Socket socket = this.sock;
        synchronized (socket) {
            try {
                this.sock.setSoTimeout(n * 1000);
            }
            catch (SocketException socketException) {
                return;
            }
            this.timeout = n;
        }
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    public boolean inStatement() {
        if (this.parser != null) {
            return this.parser.inStatement();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void SDMSrun() {
        block15: {
            UserConnection.doTrace(this.env, "UserConnection started", 2);
            Object object = initLock;
            synchronized (object) {
                this.scanner = new Scanner(new BufferedReader(new InputStreamReader(this.istream)));
                this.parser = new SDMSParser(this.ostream, this.env);
            }
            this.scanner.setEnv(this.env);
            try {
                this.parser.yyparse(this.scanner);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                if (this.run) {
                    String string = null;
                    string = this.env.isUser() ? "user " + this.env.uid() : (this.env.isJobServer() ? "jobserver " + this.env.uid() : "job " + this.env.uid());
                    UserConnection.doTrace(this.env, "Connection (" + string + ") timed out", 1);
                }
            }
            catch (SDMSException sDMSException) {
                if (this.run) {
                    UserConnection.doTrace(this.env, "Oops -> " + String.valueOf(sDMSException) + " at line " + this.scanner.yyline(), sDMSException.getStackTrace(), -1);
                }
            }
            catch (Parser.yyException yyException2) {
                if (this.run) {
                    UserConnection.doTrace(this.env, "Oops -> " + String.valueOf(yyException2) + " at line " + this.scanner.yyline(), yyException2.getStackTrace(), -1);
                }
            }
            catch (Exception exception) {
                if (this.run) {
                    UserConnection.doTrace(this.env, "Oops -> " + String.valueOf(exception), exception.getStackTrace(), -1);
                }
            }
            catch (Error error) {
                UserConnection.doTrace(this.env, "Oops -> " + String.valueOf(error), error.getStackTrace(), -2);
            }
            try {
                this.sock.close();
            }
            catch (IOException iOException) {
                if (!this.run) break block15;
                UserConnection.doTrace(this.env, "Oops -> Socket close() problem", -1);
            }
        }
        UserConnection.doTrace(this.env, "UserConnection terminated", 2);
    }
}

