/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.output;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.output.SDMSOutput;
import de.independit.scheduler.server.output.SDMSOutputContainer;
import de.independit.scheduler.server.output.SDMSOutputError;
import de.independit.scheduler.server.output.SDMSOutputLabel;
import de.independit.scheduler.server.output.SDMSOutputRenderer;
import java.io.PrintStream;
import java.util.Vector;

public class SDMSLineRenderer
extends SDMSOutputRenderer {
    public static final String __version = "@(#) $Id: SDMSLineRenderer.java,v 2.6.2.1 2013/03/14 10:24:17 ronald Exp $";
    String prompt = null;

    public SDMSLineRenderer() {
    }

    public SDMSLineRenderer(String string) {
        this.prompt = string;
    }

    public void setPrompt(String string) {
        this.prompt = string;
    }

    public String getPrompt() {
        return this.prompt;
    }

    @Override
    public void render(SystemEnvironment systemEnvironment, SDMSOutput sDMSOutput) throws FatalException {
        this.render(systemEnvironment.cEnv.ostream(), sDMSOutput);
    }

    @Override
    public void render(PrintStream printStream, SDMSOutput sDMSOutput) throws FatalException {
        if (sDMSOutput.container != null) {
            this.renderContainer(printStream, sDMSOutput.container);
        }
        if (sDMSOutput.feedback != null && !this.silent) {
            this.renderFeedback(printStream, sDMSOutput.feedback);
        }
        if (sDMSOutput.error != null && !this.silent) {
            this.renderError(printStream, sDMSOutput.error);
        }
        if (!this.silent) {
            this.renderPrompt(printStream);
        }
    }

    private void renderContainer(PrintStream printStream, SDMSOutputContainer sDMSOutputContainer) {
        if (sDMSOutputContainer.title != null && !this.silent) {
            this.writeln(printStream, "");
            this.writeln(printStream, sDMSOutputContainer.title.toString());
        }
        if (sDMSOutputContainer.columns == 0) {
            this.renderRecord(printStream, sDMSOutputContainer);
        } else {
            this.renderTable(printStream, sDMSOutputContainer);
        }
    }

    private void renderRecord(PrintStream printStream, SDMSOutputContainer sDMSOutputContainer) {
        int n = sDMSOutputContainer.desc.size();
        int n2 = sDMSOutputContainer.labelwidth;
        Vector vector = (Vector)sDMSOutputContainer.dataset.elementAt(0);
        this.writeln(printStream, "");
        for (int i = 0; i < n; ++i) {
            this.write(printStream, this.pad(((SDMSOutputLabel)sDMSOutputContainer.desc.elementAt((int)i)).name, -n2, " ") + " : ");
            if (vector.elementAt(i) == null) {
                this.writeln(printStream, "<null>");
                continue;
            }
            if (!(vector.elementAt(i) instanceof SDMSOutputContainer)) {
                this.writeln(printStream, vector.elementAt(i).toString());
                continue;
            }
            this.writeln(printStream, "");
            this.renderTable(printStream, (SDMSOutputContainer)vector.elementAt(i));
        }
    }

    private void renderTable(PrintStream printStream, SDMSOutputContainer sDMSOutputContainer) {
        int n;
        int n2 = sDMSOutputContainer.desc.size();
        this.writeln(printStream, "");
        for (n = 0; n < n2; ++n) {
            if (n > 0) {
                this.write(printStream, " ");
            }
            this.write(printStream, this.pad(((SDMSOutputLabel)sDMSOutputContainer.desc.elementAt((int)n)).name, ((SDMSOutputLabel)sDMSOutputContainer.desc.elementAt((int)n)).length, " "));
        }
        this.writeln(printStream, "");
        for (n = 0; n < n2; ++n) {
            if (n > 0) {
                this.write(printStream, " ");
            }
            this.write(printStream, this.pad("", ((SDMSOutputLabel)sDMSOutputContainer.desc.elementAt((int)n)).length, "-"));
        }
        this.writeln(printStream, "");
        for (Vector vector : sDMSOutputContainer.dataset) {
            for (n = 0; n < n2; ++n) {
                if (n > 0) {
                    this.write(printStream, " ");
                }
                this.write(printStream, this.renderCell(vector.elementAt(n), ((SDMSOutputLabel)sDMSOutputContainer.desc.elementAt((int)n)).length));
            }
            this.writeln(printStream, "");
        }
        this.writeln(printStream, "");
    }

    private String renderCell(Object object, int n) {
        if (object != null) {
            try {
                if ((Number)object != null) {
                    n = -n;
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            return this.pad(object.toString(), n, " ");
        }
        return this.pad("<null>", n, " ");
    }

    private String pad(String string, int n, String string2) {
        String string3 = string;
        int n2 = string3.length();
        int n3 = n < 0 ? -n : n;
        for (int i = 0; i < n3 - n2; ++i) {
            string3 = n > 0 ? string3.concat(string2) : string2.concat(string3);
        }
        return string3;
    }

    private void renderFeedback(PrintStream printStream, Object object) {
        this.writeln(printStream, "");
        this.writeln(printStream, object.toString());
    }

    private void renderError(PrintStream printStream, SDMSOutputError sDMSOutputError) {
        this.writeln(printStream, "");
        this.writeln(printStream, "ERROR:" + sDMSOutputError.code + ", " + sDMSOutputError.message);
    }

    private void renderPrompt(PrintStream printStream) {
        this.writeln(printStream, "");
        this.write(printStream, this.prompt == null ? "SDMS> " : this.prompt);
    }
}

