/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SDMSConstants;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.ChownChecker;
import de.independit.scheduler.server.parser.ManipParameters;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.repository.SDMSFolder;
import de.independit.scheduler.server.repository.SDMSFolderProxyGeneric;
import de.independit.scheduler.server.repository.SDMSFolderTable;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSNamedEnvironmentTable;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import java.util.Iterator;
import java.util.Vector;

public class AlterFolder
extends Node {
    public static final String __version = "@(#) $Id: AlterFolder.java,v 2.8.2.1 2013/03/14 10:24:20 ronald Exp $";
    private ObjectURL url;
    private WithHash with;
    private boolean noerr;

    public AlterFolder(ObjectURL objectURL, WithHash withHash, Boolean bl) {
        this.url = objectURL;
        this.with = withHash;
        this.noerr = bl;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        Object object;
        SDMSFolder sDMSFolder;
        try {
            sDMSFolder = (SDMSFolder)this.url.resolve(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            if (this.noerr) {
                this.result.setFeedback(new SDMSMessage(systemEnvironment, "03311121732", "No folder altered"));
                return;
            }
            throw notFoundException;
        }
        Long l = sDMSFolder.getId(systemEnvironment);
        if (this.with.containsKey("ENVIRONMENT")) {
            String string = (String)this.with.get("ENVIRONMENT");
            if (string == null) {
                sDMSFolder.setEnvId(systemEnvironment, null);
            } else {
                systemEnvironment.checkFeatureAvailability("FOLDER_ENVIRONMENTS");
                Long l2 = SDMSNamedEnvironmentTable.idx_name_getUnique(systemEnvironment, string).getId(systemEnvironment);
                sDMSFolder.setEnvId(systemEnvironment, l2);
            }
        }
        if (this.with.containsKey("INHERIT")) {
            object = (Long)this.with.get("INHERIT");
            if (object == null) {
                object = SDMSConstants.lZERO;
            }
            long l3 = (Long)object;
            if ((sDMSFolder.getPrivilegeMask() & l3) != l3) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03202061134", "Incompatible grant"));
            }
            sDMSFolder.setInheritPrivs(systemEnvironment, (Long)object);
        }
        if (this.with.containsKey("PARAMETERS")) {
            ManipParameters.alter(systemEnvironment, l, (WithHash)this.with.get("PARAMETERS"));
        }
        if (this.with.containsKey("GROUP") || this.with.containsKey("GROUP_CASCADE")) {
            if (this.with.containsKey("GROUP") && this.with.containsKey("GROUP_CASCADE")) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03402031527", "You cannot specify both the group and the group cascade clause"));
            }
            object = this.with.containsKey("GROUP_CASCADE") ? (String)this.with.get("GROUP_CASCADE") : (String)this.with.get("GROUP");
            Long l4 = SDMSGroupTable.idx_name_deleteVersion_getUnique(systemEnvironment, new SDMSKey((Comparable)object, SDMSConstants.lZERO)).getId(systemEnvironment);
            ChownChecker.check(systemEnvironment, l4, sDMSFolder.getOwnerId(systemEnvironment));
            sDMSFolder.setOwnerId(systemEnvironment, l4);
            if (this.with.containsKey("GROUP_CASCADE")) {
                this.setChildOwner(systemEnvironment, sDMSFolder.getId(systemEnvironment), l4);
            }
        }
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03209151730", "Folder altered"));
    }

    private void setChildOwner(SystemEnvironment systemEnvironment, Long l, Long l2) throws SDMSException {
        Object object2;
        Vector vector = SDMSFolderTable.idx_parentId.getVector(systemEnvironment, l);
        for (Object object2 : vector) {
            try {
                ((SDMSFolderProxyGeneric)object2).setOwnerId(systemEnvironment, l2);
            }
            catch (AccessViolationException accessViolationException) {
                // empty catch block
            }
            this.setChildOwner(systemEnvironment, ((SDMSProxy)object2).getId(systemEnvironment), l2);
        }
        object2 = SDMSSchedulingEntityTable.idx_folderId.getVector(systemEnvironment, l);
        Iterator iterator = ((Vector)object2).iterator();
        while (iterator.hasNext()) {
            SDMSSchedulingEntity sDMSSchedulingEntity = (SDMSSchedulingEntity)iterator.next();
            try {
                sDMSSchedulingEntity.setOwnerId(systemEnvironment, l2);
            }
            catch (AccessViolationException accessViolationException) {}
        }
    }
}

