/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SDMSConstants;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.ManipJob;
import de.independit.scheduler.server.parser.SubmitJob;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.repository.SDMSDependencyInstance;
import de.independit.scheduler.server.repository.SDMSDependencyInstanceTable;
import de.independit.scheduler.server.repository.SDMSExitStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSHierarchyInstance;
import de.independit.scheduler.server.repository.SDMSHierarchyInstanceTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSKillJob;
import de.independit.scheduler.server.repository.SDMSKillJobTable;
import de.independit.scheduler.server.repository.SDMSNamedResourceProxyGeneric;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSPrivilege;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSResourceAllocation;
import de.independit.scheduler.server.repository.SDMSResourceAllocationTable;
import de.independit.scheduler.server.repository.SDMSResourceProxyGeneric;
import de.independit.scheduler.server.repository.SDMSResourceTable;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.repository.SDMSScope;
import de.independit.scheduler.server.repository.SDMSScopeTable;
import de.independit.scheduler.server.repository.SDMSSubmittedEntity;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityProxyGeneric;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityTable;
import de.independit.scheduler.server.repository.SDMSSystemMessage;
import de.independit.scheduler.server.repository.SDMSSystemMessageTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.text.ParsePosition;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Vector;

public class AlterJob
extends ManipJob {
    public static final int LOCALSUSPEND = 100;
    public static final int LOCALADMINSUSPEND = 200;
    private static final int EP = 1;
    private static final int EX = 2;
    private static final int ST = 4;
    private static final int TS = 8;
    private static final int EC = 16;
    private static final int RP = 32;
    private static final int RR = 64;
    private static final int SU = 128;
    private static final int RE = 256;
    private static final int ID = 512;
    private static final int ES = 1024;
    private static final int KI = 2048;
    private static final int CN = 4096;
    private static final int RC = 8192;
    private static final int ET = 16384;
    private static final int PR = 32768;
    private static final int NV = 65536;
    private static final int RN = 131072;
    private static final int IR = 262144;
    private static final int IN = 262144;
    private static final int RU = 524288;
    private static final int CW = 0x100000;
    private static final int SW = 0x200000;
    private static final int RS = 0x400000;
    private static final int DA = 0x800000;
    private static final int CL = 0x1000000;
    private static final int JS_ACTION = 540703;
    private static final int OP_ACTION = 16106464;
    private static final int ES_ACTION = 541696;
    private static final int KI_ACTION = 18432;
    private static final int CN_ACTION = 22528;
    private static final int DA_ACTION = 0x804080;
    private static final int RC_ACTION = 24704;
    private static final int CL_ACTION = 16793728;

    public AlterJob(Long l, WithHash withHash) {
        this.cmdtype |= 2;
        this.jobId = l;
        this.with = withHash;
    }

    public AlterJob(WithHash withHash) {
        this.cmdtype = 4;
        this.jobId = null;
        this.with = withHash;
    }

    private boolean checkConsistency(SystemEnvironment systemEnvironment) throws SDMSException {
        int n = 0;
        if (this.clone != null) {
            n += 0x1000000;
        }
        if (this.execPid != null) {
            ++n;
        }
        if (this.extPid != null) {
            n += 2;
        }
        if (this.status != null) {
            n += 4;
        }
        if (this.ts != null) {
            n += 8;
        }
        if (this.exitCode != null) {
            n += 16;
        }
        if (this.runProgram != null) {
            n += 32;
        }
        if (this.rerunProgram != null) {
            n += 64;
        }
        if (this.suspend != null) {
            n += 128;
        }
        if (this.resumeObj != null) {
            n += 0x400000;
        }
        if (this.rerunSeq != null) {
            n += 524288;
        }
        if (this.rerun != null) {
            n = this.rerun.booleanValue() ? (n += 8192) : (n += 256);
        }
        if (this.depsToIgnore != null) {
            n += 512;
        }
        if (this.exitState != null) {
            n += 1024;
        }
        if (this.kill != null) {
            n += 2048;
        }
        if (this.cancel != null) {
            n += 4096;
        }
        if (this.disable != null) {
            n += 0x800000;
        }
        if (this.priority != null) {
            n += 32768;
        }
        if (this.nicevalue != null) {
            n += 65536;
        }
        if (this.renice != null) {
            n += 131072;
        }
        if (this.resToIgnore != null) {
            n += 262144;
        }
        if (this.nrsToIgnore != null) {
            n += 262144;
        }
        if (this.errText != null) {
            n += 16384;
        }
        if (this.clearWarning != null) {
            n += 0x100000;
        }
        if (this.warning != null) {
            n += 0x200000;
        }
        if ((n & 0xFFF7BFE0) == 0 || (n & 0xFF0A3C1F) == 0 || (n & 0xFFF7BBFF) == 0 || (n & 0xFF7FBF7F) == 0 || (n & 0xFEFFBF7F) == 0 || (n & 0xFFFFA7FF) == 0 || (n & 0xFFFF9F7F) == 0) {
            if (this.nicevalue != null && this.renice != null) {
                return false;
            }
            return this.clearWarning == null || this.warning == null;
        }
        return false;
    }

    private void collectWith(SystemEnvironment systemEnvironment) throws SDMSException {
        ParsePosition parsePosition;
        this.clone = (Boolean)this.with.get("CLONE");
        this.execPid = (String)this.with.get("EXEC_PID");
        this.extPid = (String)this.with.get("EXT_PID");
        this.status = (Integer)this.with.get("STATUS");
        Vector vector = (Vector)this.with.get("EXIT_STATUS");
        if (vector != null) {
            this.exitState = (String)vector.get(0);
            this.exitStateForce = (Boolean)vector.get(1);
        }
        this.ts = (String)this.with.get("TIMESTAMP");
        if (this.ts != null) {
            parsePosition = new ParsePosition(0);
            Date date = systemEnvironment.jsCommDateFormat.parse(this.ts, parsePosition);
            if (parsePosition.getErrorIndex() != -1) {
                parsePosition = new ParsePosition(0);
                date = systemEnvironment.oldJsCommDateFormat.parse(this.ts, parsePosition);
                if (parsePosition.getErrorIndex() != -1) {
                    parsePosition = new ParsePosition(0);
                    date = systemEnvironment.systemDateFormat.parse(this.ts, parsePosition);
                    if (parsePosition.getErrorIndex() != -1) {
                        throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03205061602", "Error in date format: $1\nPosition: $2", this.ts, parsePosition.toString()));
                    }
                }
            }
            GregorianCalendar gregorianCalendar = SystemEnvironment.newGregorianCalendar();
            gregorianCalendar.setTime(date);
            this.tsLong = gregorianCalendar.getTimeInMillis();
        }
        this.exitCode = (Integer)this.with.get("EXIT_CODE");
        this.errText = (String)this.with.get("ERROR_TEXT");
        this.runProgram = (String)this.with.get("RUN_PROGRAM");
        this.rerunProgram = (String)this.with.get("RERUN_PROGRAM");
        parsePosition = this.with.get("SUSPEND");
        this.adminSuspend = Boolean.FALSE;
        this.localSuspend = Boolean.FALSE;
        if (parsePosition != null) {
            if (parsePosition instanceof Boolean) {
                this.suspend = (Boolean)((Object)parsePosition);
            } else {
                this.suspend = Boolean.TRUE;
                int n = (Integer)((Object)parsePosition);
                if (n == 200) {
                    this.adminSuspend = Boolean.TRUE;
                    this.localSuspend = Boolean.TRUE;
                } else if (n == 100) {
                    this.localSuspend = Boolean.TRUE;
                } else {
                    this.adminSuspend = Boolean.TRUE;
                }
            }
        }
        this.resumeObj = this.with.get("RESUME");
        if (this.resumeObj == null && this.with.containsKey("RESUME")) {
            this.noResume = true;
        }
        if (this.suspend == null && this.resumeObj != null && this.resumeObj instanceof Boolean) {
            this.suspend = (Boolean)this.resumeObj;
            this.resumeObj = null;
        }
        if (this.suspend != null && systemEnvironment.cEnv.isUser()) {
            if (systemEnvironment.cEnv.gid().contains(SDMSObject.adminGId)) {
                if (!this.suspend.booleanValue()) {
                    this.adminSuspend = Boolean.TRUE;
                }
            } else if (this.adminSuspend != null && this.adminSuspend.booleanValue()) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03408071555", "Insufficient privileges for admin suspend"));
            }
            if (this.adminSuspend == null) {
                this.adminSuspend = Boolean.FALSE;
            }
        }
        this.rerun = (Boolean)this.with.get("RERUN");
        this.rerunSeq = (Integer)this.with.get("RUN");
        this.kill = (Boolean)this.with.get("KILL");
        if (this.kill == Boolean.FALSE) {
            this.killRecursive = true;
            this.kill = Boolean.TRUE;
        } else {
            this.killRecursive = false;
        }
        this.cancel = (Boolean)this.with.get("CANCEL");
        this.disable = (Boolean)this.with.get("DISABLE");
        this.depsToIgnore = (Vector)this.with.get("IGNORE_DEPENDENCY");
        this.priority = (Integer)this.with.get("PRIORITY");
        this.nicevalue = (Integer)this.with.get("NICEVALUE");
        this.renice = (Integer)this.with.get("RENICE");
        this.resToIgnore = (Vector)this.with.get("IGNORE_RESOURCE");
        this.nrsToIgnore = (Vector)this.with.get("IGNORE_NAMED_RESOURCE");
        this.clearWarning = (Boolean)this.with.get("CLEAR_WARN");
        this.warning = (String)this.with.get("WARNING");
        if (!this.checkConsistency(systemEnvironment)) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03207091715", "Illegal combination of With Options"));
        }
        this.comment = (String)this.with.get("COMMENT");
    }

    private void alterByJob(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity) throws SDMSException {
        long l = sDMSSubmittedEntity.getSeVersion(systemEnvironment);
        if (this.exitState != null) {
            Long l2 = SDMSExitStateDefinitionTable.idx_name_getUnique(systemEnvironment, this.exitState, l).getId(systemEnvironment);
            this.setExitState(systemEnvironment, sDMSSubmittedEntity, l, l2, this.exitStateForce);
        } else if (this.with.containsKey("ERROR_TEXT")) {
            sDMSSubmittedEntity.setErrorMsg(systemEnvironment, this.errText);
        }
        if (this.rerun != null) {
            if (this.rerun.booleanValue()) {
                sDMSSubmittedEntity.rerunRecursive(systemEnvironment, this.jobId, this.comment, true);
            } else {
                sDMSSubmittedEntity.rerun(systemEnvironment);
            }
        }
        if (this.cancel != null && this.cancel.booleanValue()) {
            sDMSSubmittedEntity.cancel(systemEnvironment);
        }
        if (this.kill != null && this.kill.booleanValue()) {
            if (!this.killRecursive && SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSSubmittedEntity.getSeId(systemEnvironment), l).getKillProgram(systemEnvironment) == null) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "032070111144", "couldn't kill, no kill program defined"));
            }
            sDMSSubmittedEntity.kill(systemEnvironment, this.killRecursive);
        }
    }

    private void alterByJobserver(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity, long l) throws SDMSException {
        this.auditFlag = false;
        Long l2 = sDMSSubmittedEntity.getScopeId(systemEnvironment);
        SDMSScope sDMSScope = SDMSScopeTable.getObjectForUpdate(systemEnvironment, l2);
        int n = sDMSSubmittedEntity.getState(systemEnvironment);
        if (n != 5 && n != 6 && n != 7 && n != 8 && n != 9 && n != 13) {
            this.result.setFeedback(new SDMSMessage(systemEnvironment, "03205141709", "Job altered"));
            return;
        }
        if (systemEnvironment.cEnv.uid().equals(l2)) {
            if (this.status != null) {
                this.changeState(systemEnvironment, sDMSSubmittedEntity, false, this.status);
            }
            sDMSScope.setLastActive(systemEnvironment, systemEnvironment.cEnv.last());
        } else {
            this.result.setFeedback(new SDMSMessage(systemEnvironment, "03205141710", "Job altered"));
        }
        if (!sDMSScope.getIsEnabled(systemEnvironment).booleanValue() && !sDMSScope.hasActiveJobs(systemEnvironment)) {
            SDMSThread.doTrace(systemEnvironment.cEnv, "Trying to kill connection " + systemEnvironment.cEnv.getMe().id() + " of Jobserver " + sDMSScope.pathString(systemEnvironment), 2);
            if (sDMSScope.isConnected(systemEnvironment)) {
                SystemEnvironment.server.killUser(systemEnvironment.cEnv.getMe().id());
            }
            sDMSScope.setIsRegistered(systemEnvironment, Boolean.FALSE);
        }
    }

    private void checkPendingApproval(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity, int n, String string) throws SDMSException {
        Long l = sDMSSubmittedEntity.getId(systemEnvironment);
        Vector vector = SDMSSystemMessageTable.idx_smeId.getVector(systemEnvironment, l);
        for (int i = 0; i < vector.size(); ++i) {
            SDMSSystemMessage sDMSSystemMessage = (SDMSSystemMessage)vector.get(i);
            if (!sDMSSystemMessage.getIsMandatory(systemEnvironment).booleanValue()) continue;
            int n2 = sDMSSystemMessage.getOperation(systemEnvironment);
            if (n2 == n) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03309251616", "Approval request for " + string + " already pending"));
            }
            if (n2 != 1 || n != 12 || !sDMSSystemMessage.getAdditionalBool(systemEnvironment).booleanValue()) continue;
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03309261342", "Approval request for " + string + " already pending (cancel with kill)"));
        }
    }

    private Long checkChildApprovals(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity, int n) throws SDMSException {
        Comparable comparable;
        Comparable<Long> comparable2;
        int n2 = sDMSSubmittedEntity.getChildApprovalMode(systemEnvironment);
        if ((n2 & n) == 0) {
            return null;
        }
        Long l = sDMSSubmittedEntity.getId(systemEnvironment);
        Vector vector = SDMSHierarchyInstanceTable.idx_parentId.getVector(systemEnvironment, l);
        Vector<Comparable> vector2 = new Vector<Comparable>();
        for (SDMSHierarchyInstance sDMSHierarchyInstance : vector) {
            comparable2 = sDMSHierarchyInstance.getChildId(systemEnvironment);
            comparable = SDMSSubmittedEntityTable.getObject(systemEnvironment, comparable2);
            if ((n & 0x3000) == 0 && ((SDMSSubmittedEntityProxyGeneric)comparable).getJobIsFinal(systemEnvironment).booleanValue()) continue;
            int n3 = ((SDMSSubmittedEntityProxyGeneric)comparable).getApprovalMode(systemEnvironment);
            int n4 = n3 & n;
            if (n4 != 0) {
                return comparable2;
            }
            n2 = ((SDMSSubmittedEntityProxyGeneric)comparable).getChildApprovalMode(systemEnvironment);
            if ((n2 & n) == 0) continue;
            vector2.add(comparable);
        }
        for (int i = 0; i < vector2.size(); ++i) {
            comparable2 = (SDMSSubmittedEntity)vector2.get(i);
            comparable = this.checkChildApprovals(systemEnvironment, (SDMSSubmittedEntity)comparable2, n);
            if (comparable == null) continue;
            return comparable;
        }
        return null;
    }

    private void alterByOperator(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity, long l) throws SDMSException {
        Object object;
        int n;
        int n2;
        Long l2;
        Object object2;
        int n3 = sDMSSubmittedEntity.getApprovalMode(systemEnvironment);
        int n4 = sDMSSubmittedEntity.getChildApprovalMode(systemEnvironment);
        SDMSPrivilege sDMSPrivilege = sDMSSubmittedEntity.getPrivileges(systemEnvironment);
        int n5 = 0;
        Long l3 = null;
        Long l4 = null;
        if (this.resumeObj != null) {
            if (this.resumeObj instanceof WithHash) {
                object2 = (WithHash)this.resumeObj;
                l3 = -SubmitJob.getResumeInValue(systemEnvironment, (Integer)((HashMap)object2).get("MULT"), (Integer)((HashMap)object2).get("INTERVAL"));
            } else {
                l3 = SubmitJob.evalResumeObj(systemEnvironment, (String)this.resumeObj, null, null, null, true, sDMSSubmittedEntity.getEffectiveTimeZone(systemEnvironment));
            }
            if (l3 == -1L) {
                l3 = 0L;
            }
        }
        if (this.suspend != null) {
            if (sDMSPrivilege.can(0x4000000L)) {
                if (!this.suspend.booleanValue() && sDMSSubmittedEntity.getIsSuspended(systemEnvironment) == 2 && !this.adminSuspend.booleanValue()) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03408080758", "Insufficient privileges for admin resume"));
                }
            } else {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03105191535", "Insufficient privileges for suspend"));
            }
            l4 = this.suspend != false ? Long.valueOf(1L) : Long.valueOf(0L);
            if (this.localSuspend != null && this.localSuspend.booleanValue()) {
                l4 = l4 | 2L;
            }
            if (this.adminSuspend != null && this.adminSuspend.booleanValue()) {
                l4 = l4 | 4L;
            }
        }
        if (this.status != null) {
            object2 = sDMSSubmittedEntity.getStateAsString(systemEnvironment);
            String string = SDMSSubmittedEntity.convertStateToString(this.status);
            Long l5 = l2 = this.exitCode != null ? Long.valueOf(this.exitCode.intValue()) : null;
            if (!systemEnvironment.cEnv.gid().contains(SDMSObject.adminGId)) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03105191534", "Insufficient privileges for set state"));
            }
            n2 = n3 & 0x3000000;
            int n6 = n = (n2 & 0x2000000) == 0x2000000 ? 1 : 0;
            if (n2 != 0) {
                this.checkPendingApproval(systemEnvironment, sDMSSubmittedEntity, 13, "Set Job State");
                this.createSystemMessage(systemEnvironment, 1, sDMSSubmittedEntity.getId(systemEnvironment), sDMSSubmittedEntity.getMasterId(systemEnvironment), 13, n != 0, systemEnvironment.cEnv.uid(), this.comment, (long)this.status, null, l2, "SET JOB STATE: old=" + (String)object2 + ", new=" + string + (String)(l2 == null ? "" : ", Exit Code=" + l2));
            }
            if (n == 0) {
                this.changeState(systemEnvironment, sDMSSubmittedEntity, true, this.status);
            }
        }
        if (this.exitState != null) {
            if (!sDMSPrivilege.can(0x200000L)) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03105191533", "Insufficient privileges for set state"));
            }
            int n7 = n3 & 0xC0;
            boolean bl = (n7 & 0x80) == 128;
            l2 = SDMSExitStateDefinitionTable.idx_name_getUnique(systemEnvironment, this.exitState, l).getId(systemEnvironment);
            Long l6 = sDMSSubmittedEntity.getJobEsdId(systemEnvironment);
            String string = l6 != null ? SDMSExitStateDefinitionTable.getObject(systemEnvironment, l6).getName(systemEnvironment) : "<NOT SET>";
            if (n7 != 0) {
                this.checkPendingApproval(systemEnvironment, sDMSSubmittedEntity, 4, "Set Exit State");
                this.createSystemMessage(systemEnvironment, 1, sDMSSubmittedEntity.getId(systemEnvironment), sDMSSubmittedEntity.getMasterId(systemEnvironment), 4, bl, systemEnvironment.cEnv.uid(), this.comment, l2, this.exitStateForce, null, "SET EXIT STATE; old=" + string + ", new=" + this.exitState);
            }
            if (!bl) {
                this.setExitState(systemEnvironment, sDMSSubmittedEntity, l, l2, this.exitStateForce);
            }
        }
        if (this.cancel != null) {
            boolean bl;
            int n8;
            if (!sDMSPrivilege.can(131072L)) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03105191551", "Insufficient privileges for cancel"));
            }
            boolean bl2 = false;
            if (this.kill != null) {
                if (!sDMSPrivilege.can(0x80000000L)) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03105191549", "Insufficient privileges for kill"));
                }
                bl2 = true;
                this.killRecursive = true;
                this.kill = null;
            }
            boolean bl3 = ((n8 = n3 & 3) & 2) == 2;
            n2 = (n8 & 1) == 1 ? 1 : 0;
            n = n3 & 0xC00000;
            if (bl2) {
                bl3 = bl3 || ((n8 |= n) & 0x800000) == 0x800000;
                n2 = n2 != 0 || (n8 & 0x400000) == 0x400000 ? 1 : 0;
            }
            boolean bl4 = (n4 & 2) == 2 || bl2 && (n4 & 0x800000) == 0x800000;
            boolean bl5 = bl = (n4 & 1) == 1 || bl2 && (n4 & 0x400000) == 0x400000;
            if (bl4) {
                n5 = 2;
                if (bl2) {
                    n5 |= 0x800000;
                }
            } else if (bl) {
                n5 = 1;
                if (bl2) {
                    n5 |= 0x400000;
                }
            }
            object = null;
            if (!bl3) {
                if (bl4 || n2 == 0 && bl) {
                    object = this.checkChildApprovals(systemEnvironment, sDMSSubmittedEntity, n5);
                }
                if (object == null) {
                    bl4 = false;
                    bl = false;
                }
            }
            if (bl3 || n2 != 0 || bl4 || bl) {
                this.checkPendingApproval(systemEnvironment, sDMSSubmittedEntity, 1, "Cancel");
                String string = "CANCEL" + (bl2 ? " with KILL" : "");
                if (!bl3 && (n2 == 0 || bl4)) {
                    string = string + " (" + (bl4 ? "approval" : "review") + " requested by a child job, such as " + (Long)object + ")";
                }
                this.createSystemMessage(systemEnvironment, 1, sDMSSubmittedEntity.getId(systemEnvironment), sDMSSubmittedEntity.getMasterId(systemEnvironment), 1, bl3 || bl4, systemEnvironment.cEnv.uid(), this.comment, null, bl2, null, string);
            }
            if (!bl3 && !bl4) {
                if (bl2) {
                    this.performKill(systemEnvironment, sDMSSubmittedEntity);
                }
                this.performCancel(systemEnvironment, sDMSSubmittedEntity);
            }
        }
        if (this.kill != null) {
            if (!sDMSPrivilege.can(0x80000000L)) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03105191549", "Insufficient privileges for kill"));
            }
            if (this.kill.booleanValue()) {
                boolean bl = false;
                boolean bl6 = false;
                int n9 = n3 & 0xC00000;
                n2 = (n9 & 0x800000) == 0x800000 ? 1 : 0;
                int n10 = n = (n9 & 0x400000) == 0x400000 ? 1 : 0;
                if (!this.killRecursive && SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSSubmittedEntity.getSeId(systemEnvironment), l).getKillProgram(systemEnvironment) == null) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "032070111145", "couldn't kill, no kill program defined"));
                }
                if (this.killRecursive) {
                    bl = (n4 & 0x800000) == 0x800000;
                    boolean bl7 = bl6 = (n4 & 0x400000) == 0x400000;
                    if (bl) {
                        n5 = 0x800000;
                    } else if (bl6) {
                        n5 = 0x400000;
                    }
                }
                Long l7 = null;
                if (n2 == 0) {
                    if (bl || n == 0 && bl6) {
                        l7 = this.checkChildApprovals(systemEnvironment, sDMSSubmittedEntity, n5);
                    }
                    if (l7 == null) {
                        bl = false;
                        bl6 = false;
                    }
                }
                if (n2 != 0 || n != 0 || bl || bl6) {
                    this.checkPendingApproval(systemEnvironment, sDMSSubmittedEntity, 12, "Kill");
                    String string = "KILL" + (this.killRecursive ? " RECURSIVE" : "");
                    if (n2 == 0 && (n == 0 || bl)) {
                        string = string + " (" + (bl ? "approval" : "review") + " requested by a child job, such as " + l7 + ")";
                    }
                    this.createSystemMessage(systemEnvironment, 1, sDMSSubmittedEntity.getId(systemEnvironment), sDMSSubmittedEntity.getMasterId(systemEnvironment), 12, n2 != 0 || bl, systemEnvironment.cEnv.uid(), this.comment, null, this.killRecursive, null, string);
                }
                if (n2 == 0 && !bl) {
                    this.performKill(systemEnvironment, sDMSSubmittedEntity);
                }
            }
        }
        if (this.disable != null) {
            if (!sDMSPrivilege.can(524288L)) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03105191552", "Insufficient privileges for enable/disable"));
            }
            boolean bl = false;
            boolean bl8 = false;
            int n11 = n3 & 0x30;
            n2 = (n11 & 0x20) == 32 ? 1 : 0;
            n = (n11 & 0x10) == 16 ? 1 : 0;
            bl = (n4 & 0x20) == 32;
            boolean bl9 = bl8 = (n4 & 0x10) == 16;
            if (bl) {
                n5 = 32;
            } else if (bl8) {
                n5 = 16;
            }
            Long l8 = null;
            if (n2 == 0) {
                if (bl || n == 0 && bl8) {
                    l8 = this.checkChildApprovals(systemEnvironment, sDMSSubmittedEntity, n5);
                }
                if (l8 == null) {
                    bl = false;
                    bl8 = false;
                }
            }
            if (n2 != 0 || n != 0 || bl || bl8) {
                this.checkPendingApproval(systemEnvironment, sDMSSubmittedEntity, 3, "Enable");
                String string = (this.disable != false ? "DISABLE" : "ENABLE") + (l4 == null ? ", NOSUSPEND" : ((l4 & 1L) == 1L ? ", SUSPEND" : ", RESUME"));
                if (this.localSuspend.booleanValue()) {
                    string = string + " LOCAL";
                }
                if (this.adminSuspend.booleanValue()) {
                    string = string + " ADMIN";
                }
                if (l3 != null) {
                    if ((l4 & 1L) == 1L) {
                        string = string + ", RESUME";
                    }
                    string = l3 > 0L ? string + " AT " + (String)this.resumeObj : string + " IN " + l3 / -60000L + " minute(s)";
                }
                if (n2 == 0 && (n == 0 || bl)) {
                    string = string + " (" + (bl ? "approval" : "review") + " requested by a child job, such as " + l8 + ")";
                }
                this.createSystemMessage(systemEnvironment, 1, sDMSSubmittedEntity.getId(systemEnvironment), sDMSSubmittedEntity.getMasterId(systemEnvironment), 3, n2 != 0 || bl, systemEnvironment.cEnv.uid(), this.comment, l4, this.disable, l3, string);
            }
            if (n2 == 0 && !bl) {
                this.performDisable(systemEnvironment, sDMSSubmittedEntity, this.disable);
            } else {
                this.suspend = null;
                this.resumeObj = null;
            }
        }
        if (this.priority != null || this.nicevalue != null || this.renice != null) {
            if (!sDMSPrivilege.can(0x20000000L)) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03105191556", "Insufficient privileges for set priority"));
            }
            Boolean bl = Boolean.FALSE;
            if (this.priority != null) {
                if (SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSSubmittedEntity.getSeId(systemEnvironment), l).getType(systemEnvironment) != 1) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03211211229", "Cannot change the priority of a batch or milestone"));
                }
                if (this.priority < SystemEnvironment.priorityLowerBound && !systemEnvironment.cEnv.gid().contains(SDMSObject.adminGId)) {
                    this.priority = SystemEnvironment.priorityLowerBound;
                }
                this.performPriority(systemEnvironment, sDMSSubmittedEntity, bl, this.priority);
            }
            if (this.nicevalue != null) {
                bl = Boolean.TRUE;
                this.priority = this.nicevalue;
            }
            if (this.renice != null) {
                int n12 = this.renice + sDMSSubmittedEntity.getNice(systemEnvironment);
                bl = Boolean.TRUE;
                this.priority = n12;
            }
            if (bl.booleanValue()) {
                this.performPriority(systemEnvironment, sDMSSubmittedEntity, bl, this.priority);
            }
        }
        if (this.clone != null) {
            if (!sDMSPrivilege.can(0x2000000L)) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03105191559", "Insufficient privileges for clone"));
            }
            if (this.comment == null) {
                this.comment = "";
            }
            if (sDMSSubmittedEntity.getIsReplaced(systemEnvironment).booleanValue()) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03910311420", "Cannot clone an already replaced job or batch"));
            }
            if (sDMSSubmittedEntity.getState(systemEnvironment) != 12) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03910311421", "Cannot clone a job or batch that is stil active"));
            }
            Long l9 = sDMSSubmittedEntity.getParentId(systemEnvironment);
            if (l9 == null) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03910311422", "Cannot clone a master job or batch"));
            }
            boolean bl = false;
            boolean bl10 = false;
            n2 = n3 & 0x3000;
            n = (n2 & 0x2000) == 8192 ? 1 : 0;
            boolean bl11 = (n2 & 0x1000) == 4096;
            bl = (n4 & 0x2000) == 8192;
            boolean bl12 = bl10 = (n4 & 0x1000) == 4096;
            if (bl) {
                n5 = 8192;
            } else if (bl10) {
                n5 = 4096;
            }
            Long l10 = null;
            if (n == 0) {
                if (bl || !bl11 && bl10) {
                    l10 = this.checkChildApprovals(systemEnvironment, sDMSSubmittedEntity, n5);
                }
                if (l10 == null) {
                    bl = false;
                    bl10 = false;
                }
            }
            if (n != 0 || bl11 || bl || bl10) {
                this.checkPendingApproval(systemEnvironment, sDMSSubmittedEntity, 7, "Clone");
                if (this.clone.booleanValue() && l4 == null) {
                    l4 = l4 & 1L;
                }
                object = "CLONE " + (l4 == null ? ", NOSUSPEND" : ((l4 & 1L) == 1L ? ", SUSPEND" : ", RESUME"));
                if (this.localSuspend.booleanValue()) {
                    object = (String)object + " LOCAL";
                }
                if (this.adminSuspend.booleanValue()) {
                    object = (String)object + " ADMIN";
                }
                if (l3 != null) {
                    if ((l4 & 1L) == 1L) {
                        object = (String)object + ", RESUME";
                    }
                    object = l3 > 0L ? (String)object + " AT " + (String)this.resumeObj : (String)object + " IN " + l3 / -60000L + " minute(s)";
                }
                if (n == 0 && (!bl11 || bl)) {
                    object = (String)object + " (" + (bl ? "approval" : "review") + " requested by a child job, such as " + l10 + ")";
                }
                this.createSystemMessage(systemEnvironment, 1, sDMSSubmittedEntity.getId(systemEnvironment), sDMSSubmittedEntity.getMasterId(systemEnvironment), 7, n != 0 || bl, systemEnvironment.cEnv.uid(), this.comment, l4, null, l3, (String)object);
            }
            if (n == 0 && !bl) {
                object = this.performClone(systemEnvironment, sDMSSubmittedEntity);
                if (!this.clone.booleanValue()) {
                    ((SDMSSubmittedEntity)object).resume(systemEnvironment, true);
                }
            } else {
                this.suspend = null;
                this.resumeObj = null;
            }
        }
        if (this.rerun != null) {
            if (!sDMSPrivilege.can(262144L)) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03105191539", "Insufficient privileges for rerun"));
            }
            boolean bl = false;
            boolean bl13 = false;
            int n13 = n3 & 0xC;
            n2 = (n13 & 8) == 8 ? 1 : 0;
            int n14 = n = (n13 & 4) == 4 ? 1 : 0;
            if (this.rerun.booleanValue()) {
                bl = (n4 & 8) == 8;
                boolean bl14 = bl13 = (n4 & 4) == 4;
            }
            if (bl) {
                n5 = 8;
            } else if (bl13) {
                n5 = 4;
            }
            Long l11 = null;
            if (n2 == 0) {
                if (bl || n == 0 && bl13) {
                    l11 = this.checkChildApprovals(systemEnvironment, sDMSSubmittedEntity, n5);
                }
                if (l11 == null) {
                    bl = false;
                    bl13 = false;
                }
            }
            if (n2 != 0 || n != 0 || bl || bl13) {
                this.checkPendingApproval(systemEnvironment, sDMSSubmittedEntity, 2, "Rerun");
                String string = "RERUN " + (this.rerun != false ? "RECURSIVE" : "") + (l4 == null ? ", NOSUSPEND" : ((l4 & 1L) == 1L ? ", SUSPEND" : ", RESUME"));
                if (this.localSuspend.booleanValue()) {
                    string = string + " LOCAL";
                }
                if (this.adminSuspend.booleanValue()) {
                    string = string + " ADMIN";
                }
                if (l3 != null) {
                    if ((l4 & 1L) == 1L) {
                        string = string + ", RESUME";
                    }
                    string = l3 > 0L ? string + " AT " + (String)this.resumeObj : string + " IN " + l3 / -60000L + " minute(s)";
                }
                if (n2 == 0 && (n == 0 || bl)) {
                    string = string + " (" + (bl ? "approval" : "review") + " requested by a child job, such as " + l11 + ")";
                }
                this.createSystemMessage(systemEnvironment, 1, sDMSSubmittedEntity.getId(systemEnvironment), sDMSSubmittedEntity.getMasterId(systemEnvironment), 2, n2 != 0 || bl, systemEnvironment.cEnv.uid(), this.comment, l4, this.rerun, l3, string);
            }
            if (n2 == 0 && !bl) {
                this.performRerun(systemEnvironment, sDMSSubmittedEntity, this.rerun);
            } else {
                this.suspend = null;
                this.resumeObj = null;
            }
        }
        if (this.noResume) {
            sDMSSubmittedEntity.setResumeTs(systemEnvironment, null);
        }
        if (this.suspend != null || this.resumeObj != null) {
            if (sDMSPrivilege.can(0x4000000L)) {
                if (this.suspend != null && !this.suspend.booleanValue() && sDMSSubmittedEntity.getIsSuspended(systemEnvironment) == 2 && !this.adminSuspend.booleanValue()) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03408080757", "Insufficient privileges for admin resume"));
                }
                this.evalSuspend(systemEnvironment, l4, l3, sDMSSubmittedEntity);
            } else {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03105191535", "Insufficient privileges for suspend"));
            }
        }
        if (this.depsToIgnore != null) {
            if (sDMSPrivilege.can(0x400000L)) {
                this.ignoreDeps(systemEnvironment, sDMSSubmittedEntity);
            } else {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03105191553", "Insufficient privileges for ignore dependency"));
            }
        }
        if (this.resToIgnore != null) {
            if (sDMSPrivilege.can(0x800000L)) {
                this.ignoreResources(systemEnvironment, sDMSSubmittedEntity);
            } else {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03105191555", "Insufficient privileges for ignore resource"));
            }
        }
        if (this.with.containsKey("ERROR_TEXT")) {
            sDMSSubmittedEntity.setErrorMsg(systemEnvironment, this.errText);
        }
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSSubmittedEntity sDMSSubmittedEntity = null;
        boolean bl = false;
        this.collectWith(systemEnvironment);
        if (systemEnvironment.cEnv.isJob()) {
            this.jobId = systemEnvironment.cEnv.uid();
            sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObjectForUpdate(systemEnvironment, this.jobId);
        } else {
            try {
                sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObjectForUpdate(systemEnvironment, this.jobId);
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
        if (this.rerunSeq != null && sDMSSubmittedEntity != null) {
            int n;
            int n2 = this.rerunSeq;
            if (n2 < (n = sDMSSubmittedEntity.getRerunSeq(systemEnvironment).intValue())) {
                if (systemEnvironment.cEnv.isUser()) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03406031444", "Run sequence number expired"));
                }
                bl = true;
            } else if (n2 > n) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03406031442", "Run sequence number out of sync"));
            }
        }
        if (!bl) {
            if (systemEnvironment.cEnv.isJob()) {
                this.alterByJob(systemEnvironment, sDMSSubmittedEntity);
            } else {
                if (sDMSSubmittedEntity == null) {
                    this.go_killjob(systemEnvironment);
                    return;
                }
                long l = sDMSSubmittedEntity.getSeVersion(systemEnvironment);
                if (systemEnvironment.cEnv.isJobServer()) {
                    this.alterByJobserver(systemEnvironment, sDMSSubmittedEntity, l);
                } else {
                    this.alterByOperator(systemEnvironment, sDMSSubmittedEntity, l);
                }
            }
        }
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03204112159", "Job altered"));
    }

    private void changeKillJobState(SystemEnvironment systemEnvironment, SDMSKillJob sDMSKillJob, boolean bl) throws SDMSException {
        SDMSSubmittedEntity sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObject(systemEnvironment, sDMSKillJob.getSmeId(systemEnvironment));
        int n = sDMSSubmittedEntity.getState(systemEnvironment);
        sDMSKillJob.setState(systemEnvironment, this.status);
        this.delFromQueue(systemEnvironment, sDMSKillJob);
        if (this.with.containsKey("ERROR_TEXT")) {
            sDMSKillJob.setErrorMsg(systemEnvironment, this.errText);
        }
        if (this.with.containsKey("EXEC_PID")) {
            sDMSKillJob.setPid(systemEnvironment, this.execPid);
        }
        if (this.with.containsKey("EXT_PID")) {
            sDMSKillJob.setExtPid(systemEnvironment, this.extPid);
        }
        switch (this.status) {
            case 6: {
                if (this.tsLong == null) break;
                sDMSKillJob.setStartTs(systemEnvironment, this.tsLong);
                break;
            }
            case 7: {
                if (this.tsLong == null) break;
                sDMSKillJob.setStartTs(systemEnvironment, this.tsLong);
                break;
            }
            case 11: {
                if (this.tsLong != null) {
                    sDMSKillJob.setFinishTs(systemEnvironment, this.tsLong);
                }
                if (this.with.containsKey("EXIT_CODE")) {
                    sDMSKillJob.setExitCode(systemEnvironment, this.exitCode);
                    sDMSSubmittedEntity.setKillExitCode(systemEnvironment, this.exitCode);
                }
                if (n != 8) break;
                sDMSSubmittedEntity.setState(systemEnvironment, SDMSConstants.SME_KILLED);
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                if (n != 8) break;
                sDMSSubmittedEntity.setState(systemEnvironment, SDMSConstants.SME_KILLED);
                break;
            }
            case 15: {
                if (n != 8) break;
                if (sDMSSubmittedEntity.getJobEsdId(systemEnvironment) == null) {
                    sDMSSubmittedEntity.setState(systemEnvironment, SDMSConstants.SME_RUNNING);
                    break;
                }
                sDMSSubmittedEntity.setState(systemEnvironment, SDMSConstants.SME_FINISHED);
                break;
            }
            default: {
                if (!bl) break;
                sDMSKillJob.setState(systemEnvironment, this.status);
            }
        }
    }

    private void go_killjob(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSKillJob sDMSKillJob = null;
        sDMSKillJob = SDMSKillJobTable.getObject(systemEnvironment, this.jobId);
        if (systemEnvironment.cEnv.isJobServer()) {
            if (!systemEnvironment.cEnv.uid().equals(sDMSKillJob.getScopeId(systemEnvironment))) {
                this.result.setFeedback(new SDMSMessage(systemEnvironment, "03207091826", "Job altered"));
                return;
            }
            if (this.status != null) {
                this.changeKillJobState(systemEnvironment, sDMSKillJob, false);
            }
        } else if (this.status != null) {
            this.changeKillJobState(systemEnvironment, sDMSKillJob, true);
        }
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03207091825", "Job altered"));
    }

    private void ignoreDeps(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity) throws SDMSException {
        boolean bl = false;
        boolean bl2 = false;
        int n = sDMSSubmittedEntity.getChildApprovalMode(systemEnvironment);
        int n2 = sDMSSubmittedEntity.getApprovalMode(systemEnvironment) & 0x300;
        boolean bl3 = (n2 & 0x200) == 512;
        boolean bl4 = (n2 & 0x100) == 256;
        for (int i = 0; i < this.depsToIgnore.size(); ++i) {
            Vector vector = (Vector)this.depsToIgnore.get(i);
            Long l = (Long)vector.get(0);
            Boolean bl5 = (Boolean)vector.get(1);
            bl = false;
            bl2 = false;
            SDMSDependencyInstance sDMSDependencyInstance = SDMSDependencyInstanceTable.getObject(systemEnvironment, l);
            Long l2 = null;
            int n3 = 0;
            if (bl5.booleanValue()) {
                bl = (n & 0x200) == 512;
                boolean bl6 = bl2 = (n & 0x100) == 256;
                if (bl) {
                    n3 = 512;
                } else if (bl2) {
                    n3 = 256;
                }
                if (!bl3) {
                    if (bl || !bl4 && bl2) {
                        l2 = this.checkChildApprovals(systemEnvironment, sDMSSubmittedEntity, n3);
                    }
                    if (l2 == null) {
                        bl = false;
                        bl2 = false;
                    }
                }
            }
            if (bl3 || bl4 || bl || bl2) {
                SDMSSubmittedEntity sDMSSubmittedEntity2 = SDMSSubmittedEntityTable.getObject(systemEnvironment, sDMSDependencyInstance.getRequiredId(systemEnvironment));
                SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSSubmittedEntity2.getSeId(systemEnvironment), sDMSSubmittedEntity.getSeVersion(systemEnvironment));
                String string = "Ignore Dependency " + (bl5 != false ? "RECURSIVE" : "") + " of " + sDMSSubmittedEntity2.getId(systemEnvironment) + " (" + sDMSSchedulingEntity.pathString(systemEnvironment) + ")";
                if (!(bl3 || bl4 && !bl)) {
                    string = string + " (" + (bl ? "approval" : "review") + " requested by a child job, such as " + l2 + ")";
                }
                this.createSystemMessage(systemEnvironment, 1, sDMSSubmittedEntity.getId(systemEnvironment), sDMSSubmittedEntity.getMasterId(systemEnvironment), 5, bl3 || bl, systemEnvironment.cEnv.uid(), this.comment, sDMSDependencyInstance.getId(systemEnvironment), bl5, null, string);
            }
            if (bl3 || bl) continue;
            sDMSDependencyInstance.setIgnore(systemEnvironment, bl5 != false ? 2 : 1, this.jobId, this.comment);
        }
    }

    private void ignoreResources(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity) throws SDMSException {
        SDMSResourceAllocation sDMSResourceAllocation = null;
        SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSSubmittedEntity.getSeId(systemEnvironment), sDMSSubmittedEntity.getSeVersion(systemEnvironment));
        Long l = sDMSSubmittedEntity.getId(systemEnvironment);
        for (int i = 0; i < this.resToIgnore.size(); ++i) {
            int n;
            SDMSProxy sDMSProxy;
            boolean bl = false;
            Long l2 = (Long)this.resToIgnore.get(i);
            try {
                sDMSProxy = SDMSResourceTable.getObject(systemEnvironment, l2);
                Vector vector = SDMSResourceAllocationTable.idx_smeId_nrId.getVector(systemEnvironment, new SDMSKey(l, ((SDMSResourceProxyGeneric)sDMSProxy).getNrId(systemEnvironment)));
                for (n = 0; n < vector.size(); n += 1) {
                    sDMSResourceAllocation = (SDMSResourceAllocation)vector.get(n);
                    if (!sDMSResourceAllocation.getRId(systemEnvironment).equals(l2)) continue;
                    bl = true;
                    break;
                }
            }
            catch (NotFoundException notFoundException) {
                continue;
            }
            if (!bl) continue;
            sDMSProxy = SDMSNamedResourceTable.getObject(systemEnvironment, sDMSResourceAllocation.getNrId(systemEnvironment));
            if (sDMSSchedulingEntity.checkParameterRI(systemEnvironment, sDMSResourceAllocation.getNrId(systemEnvironment))) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03409291444", "You cannot ignore resource $1, parameter references exist", ((SDMSNamedResourceProxyGeneric)sDMSProxy).pathString(systemEnvironment)));
            }
            int n2 = sDMSSubmittedEntity.getApprovalMode(systemEnvironment) & 0xC00;
            int n3 = n = (n2 & 0x800) == 2048 ? 1 : 0;
            if (n2 != 0) {
                String string = "Ignore Resource " + l2.toString() + " (" + ((SDMSNamedResourceProxyGeneric)sDMSProxy).pathString(systemEnvironment) + ")";
                this.createSystemMessage(systemEnvironment, 1, sDMSSubmittedEntity.getId(systemEnvironment), sDMSSubmittedEntity.getMasterId(systemEnvironment), 6, n != 0, systemEnvironment.cEnv.uid(), this.comment, l2, null, null, string);
            }
            if (n) continue;
            sDMSResourceAllocation.ignore(systemEnvironment);
        }
        SystemEnvironment.sched.notifyChange(systemEnvironment, sDMSSubmittedEntity, 12);
    }
}

