/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SDMSConstants;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.ChownChecker;
import de.independit.scheduler.server.parser.ManipJobDefinition;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.parser.WithItem;
import de.independit.scheduler.server.repository.SDMSDependencyDefinition;
import de.independit.scheduler.server.repository.SDMSDependencyDefinitionTable;
import de.independit.scheduler.server.repository.SDMSDependencyState;
import de.independit.scheduler.server.repository.SDMSDependencyStateTable;
import de.independit.scheduler.server.repository.SDMSEventTable;
import de.independit.scheduler.server.repository.SDMSExitState;
import de.independit.scheduler.server.repository.SDMSExitStateDefinition;
import de.independit.scheduler.server.repository.SDMSExitStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSExitStateProfile;
import de.independit.scheduler.server.repository.SDMSExitStateProfileTable;
import de.independit.scheduler.server.repository.SDMSExitStateTable;
import de.independit.scheduler.server.repository.SDMSExitStateTranslationProfile;
import de.independit.scheduler.server.repository.SDMSExitStateTranslationProfileTable;
import de.independit.scheduler.server.repository.SDMSIgnoredDependency;
import de.independit.scheduler.server.repository.SDMSIgnoredDependencyTable;
import de.independit.scheduler.server.repository.SDMSInterval;
import de.independit.scheduler.server.repository.SDMSIntervalTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import de.independit.scheduler.server.repository.SDMSParameterDefinition;
import de.independit.scheduler.server.repository.SDMSParameterDefinitionProxyGeneric;
import de.independit.scheduler.server.repository.SDMSParameterDefinitionTable;
import de.independit.scheduler.server.repository.SDMSResourceReqStates;
import de.independit.scheduler.server.repository.SDMSResourceReqStatesTable;
import de.independit.scheduler.server.repository.SDMSResourceRequirement;
import de.independit.scheduler.server.repository.SDMSResourceRequirementTable;
import de.independit.scheduler.server.repository.SDMSResourceStateDefinition;
import de.independit.scheduler.server.repository.SDMSResourceStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSResourceStateMappingProfileTable;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.repository.SDMSSchedulingHierarchy;
import de.independit.scheduler.server.repository.SDMSSchedulingHierarchyProxyGeneric;
import de.independit.scheduler.server.repository.SDMSSchedulingHierarchyTable;
import de.independit.scheduler.server.repository.SDMSTrigger;
import de.independit.scheduler.server.repository.SDMSTriggerProxyGeneric;
import de.independit.scheduler.server.repository.SDMSTriggerTable;
import de.independit.scheduler.server.util.PathVector;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Vector;

public class AlterJobDefinition
extends ManipJobDefinition {
    public AlterJobDefinition(ObjectURL objectURL, WithHash withHash, Boolean bl) {
        super(objectURL, withHash, bl);
    }

    protected void checkDependents(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        Vector vector = SDMSDependencyDefinitionTable.idx_seRequiredId.getVector(systemEnvironment, l);
        for (int i = 0; i < vector.size(); ++i) {
            SDMSDependencyDefinition sDMSDependencyDefinition = (SDMSDependencyDefinition)vector.get(i);
            if (sDMSDependencyDefinition.getMode(systemEnvironment) != 2) continue;
            SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSDependencyDefinition.getSeDependentId(systemEnvironment));
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03210141809", "JOB_FINAL Dependent $1 prohibits conversion from Job to Batch or Milestone", sDMSSchedulingEntity.pathVector(systemEnvironment)));
        }
    }

    private void diffDependencies(SystemEnvironment systemEnvironment, Long l, Vector vector) throws SDMSException {
        int n;
        SDMSDependencyDefinition sDMSDependencyDefinition;
        Integer n2 = 0;
        String string = null;
        Vector vector2 = SDMSDependencyDefinitionTable.idx_seDependentId.getVector(systemEnvironment, l);
        if (vector != null) {
            for (WithHash withHash : vector) {
                Serializable serializable;
                Object object;
                Vector vector3;
                WithHash withHash2 = (WithHash)withHash.get("FULLNAME");
                if (withHash2 == null) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03204302254", "Missing Required Name"));
                }
                String string2 = (String)withHash2.get("NAME");
                Vector vector4 = (Vector)withHash2.get("PATH");
                String string3 = (String)withHash.get("DEPENDENCY");
                Integer n3 = (Integer)withHash.get("UNRESOLVED");
                Object v = withHash.get("STATUS");
                Integer n4 = null;
                if (v == null || v instanceof Vector) {
                    vector3 = (Vector)v;
                    n4 = SDMSConstants.DD_FINAL;
                } else {
                    vector3 = null;
                    object = (String)v;
                    if (((String)object).equals("DEFAULT")) {
                        n4 = SDMSConstants.DD_DEFAULT;
                    } else if (((String)object).equals("UNREACHABLE")) {
                        n4 = SDMSConstants.DD_UNREACHABLE;
                    } else if (((String)object).equals("REACHABLE")) {
                        n4 = SDMSConstants.DD_ALL_REACHABLE;
                    }
                }
                Integer n5 = (Integer)withHash.get("MODE");
                String string4 = this.canonizeCondition(systemEnvironment, (String)withHash.get("CONDITION"));
                if (string4 != null) {
                    systemEnvironment.checkFeatureAvailability("CONDITIONAL_DEPENDENCIES");
                }
                if ((n2 = (Integer)withHash.get("RESOLVE")) == null) {
                    n2 = 0;
                }
                object = null;
                Integer n6 = null;
                WithHash withHash3 = (WithHash)withHash.get("EXPIRED");
                if (withHash3 != null) {
                    object = (Integer)withHash3.get("MULT");
                    if (object == null) {
                        object = SDMSConstants.iONE;
                    }
                    n6 = (Integer)withHash3.get("INTERVAL");
                }
                string = this.canonizeCondition(systemEnvironment, (String)withHash.get("SELECT_CONDIION"));
                SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.get(systemEnvironment, vector4, string2);
                Long l2 = sDMSSchedulingEntity.getId(systemEnvironment);
                sDMSDependencyDefinition = null;
                for (n = 0; n < vector2.size(); ++n) {
                    sDMSDependencyDefinition = (SDMSDependencyDefinition)vector2.get(n);
                    serializable = sDMSDependencyDefinition.getSeRequiredId(systemEnvironment);
                    if (!((Long)serializable).equals(l2)) continue;
                    vector2.removeElementAt(n);
                    n = -1;
                    sDMSDependencyDefinition.setName(systemEnvironment, string3);
                    if (withHash.containsKey("UNRESOLVED")) {
                        sDMSDependencyDefinition.setUnresolvedHandling(systemEnvironment, n3);
                    }
                    if (withHash.containsKey("MODE")) {
                        sDMSDependencyDefinition.setMode(systemEnvironment, n5);
                    }
                    if (withHash.containsKey("STATUS")) {
                        sDMSDependencyDefinition.setStateSelection(systemEnvironment, n4);
                    }
                    if (withHash.containsKey("CONDITION")) {
                        sDMSDependencyDefinition.setCondition(systemEnvironment, string4);
                    }
                    if (withHash.containsKey("RESOLVE")) {
                        sDMSDependencyDefinition.setResolveMode(systemEnvironment, n2);
                    }
                    if (withHash.containsKey("EXPIRED")) {
                        sDMSDependencyDefinition.setExpiredAmount(systemEnvironment, (Integer)object);
                        sDMSDependencyDefinition.setExpiredBase(systemEnvironment, n6);
                    }
                    if (!withHash.containsKey("SELECT_CONDIION")) break;
                    sDMSDependencyDefinition.setSelectCondition(systemEnvironment, string);
                    break;
                }
                if (n >= vector2.size()) {
                    if (n3 == null) {
                        n3 = SDMSConstants.DD_ERROR;
                    }
                    sDMSDependencyDefinition = SDMSDependencyDefinitionTable.table.create(systemEnvironment, l, l2, string3, n3, n5, n4, string4, n2, (Integer)object, n6, string);
                }
                if (withHash.containsKey("STATUS")) {
                    this.diffDependencyState(systemEnvironment, sDMSDependencyDefinition, vector3, sDMSSchedulingEntity);
                    continue;
                }
                serializable = SDMSDependencyStateTable.idx_ddId.getVector(systemEnvironment, sDMSDependencyDefinition.getId(systemEnvironment));
                Iterator iterator = ((Vector)serializable).iterator();
                while (iterator.hasNext()) {
                    SDMSDependencyState sDMSDependencyState = (SDMSDependencyState)iterator.next();
                    sDMSDependencyState.delete(systemEnvironment);
                }
            }
        }
        for (n = 0; n < vector2.size(); ++n) {
            sDMSDependencyDefinition = (SDMSDependencyDefinition)vector2.get(n);
            sDMSDependencyDefinition.delete(systemEnvironment);
        }
    }

    private void diffDependencyState(SystemEnvironment systemEnvironment, SDMSDependencyDefinition sDMSDependencyDefinition, Vector vector, SDMSSchedulingEntity sDMSSchedulingEntity) throws SDMSException {
        SDMSDependencyState sDMSDependencyState;
        int n;
        Long l = sDMSDependencyDefinition.getId(systemEnvironment);
        Long l2 = sDMSSchedulingEntity.getEspId(systemEnvironment);
        Vector vector2 = SDMSDependencyStateTable.idx_ddId.getVector(systemEnvironment, l);
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                SDMSExitStateDefinition sDMSExitStateDefinition;
                WithItem withItem = (WithItem)vector.get(i);
                String string = (String)((Object)withItem.key);
                String string2 = this.canonizeCondition(systemEnvironment, (String)withItem.value);
                if (string2 != null) {
                    systemEnvironment.checkFeatureAvailability("CONDITIONAL_DEPENDENCIES");
                }
                for (n = 0; n < vector2.size(); ++n) {
                    sDMSDependencyState = (SDMSDependencyState)vector2.get(n);
                    sDMSExitStateDefinition = SDMSExitStateDefinitionTable.getObject(systemEnvironment, sDMSDependencyState.getEsdId(systemEnvironment));
                    if (!string.equals(sDMSExitStateDefinition.getName(systemEnvironment))) continue;
                    vector2.removeElementAt(n);
                    sDMSDependencyState.setCondition(systemEnvironment, string2);
                    n = -1;
                    break;
                }
                if (n < vector2.size()) continue;
                sDMSExitStateDefinition = null;
                try {
                    sDMSExitStateDefinition = SDMSExitStateDefinitionTable.idx_name_getUnique(systemEnvironment, string);
                }
                catch (NotFoundException notFoundException) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03205010115", "Exit State $1 does not exist", string));
                }
                SDMSExitState sDMSExitState = null;
                Long l3 = sDMSExitStateDefinition.getId(systemEnvironment);
                try {
                    sDMSExitState = SDMSExitStateTable.idx_espId_esdId_getUnique(systemEnvironment, new SDMSKey(l2, l3));
                }
                catch (NotFoundException notFoundException) {
                    SDMSExitStateProfile sDMSExitStateProfile = SDMSExitStateProfileTable.getObject(systemEnvironment, l2);
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03205010116", "Exit State $1 not in Exit State Profile $2 of $3", string, sDMSExitStateProfile.getName(systemEnvironment), sDMSSchedulingEntity.pathString(systemEnvironment)));
                }
                if (!sDMSExitState.getIsFinal(systemEnvironment).booleanValue()) {
                    SDMSExitStateProfile sDMSExitStateProfile = SDMSExitStateProfileTable.getObject(systemEnvironment, l2);
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03205010117", "Exit State $1 in Exit State Profile $2 of $3 must be a final state", string, sDMSExitStateProfile.getName(systemEnvironment), sDMSSchedulingEntity.pathString(systemEnvironment)));
                }
                SDMSDependencyStateTable.table.create(systemEnvironment, l, l3, string2);
            }
        }
        for (n = 0; n < vector2.size(); ++n) {
            sDMSDependencyState = (SDMSDependencyState)vector2.get(n);
            sDMSDependencyState.delete(systemEnvironment);
        }
    }

    private void diffChildren(SystemEnvironment systemEnvironment, SDMSSchedulingEntity sDMSSchedulingEntity, Vector vector) throws SDMSException {
        int n;
        SDMSSchedulingHierarchy sDMSSchedulingHierarchy;
        Long l = sDMSSchedulingEntity.getId(systemEnvironment);
        Vector vector2 = SDMSSchedulingHierarchyTable.idx_seParentId.getVector(systemEnvironment, l);
        if (vector != null) {
            for (WithHash withHash : vector) {
                Long l2;
                SDMSInterval sDMSInterval;
                SDMSExitStateTranslationProfile sDMSExitStateTranslationProfile;
                WithHash withHash2;
                Vector<Object> vector3;
                WithHash withHash3 = (WithHash)withHash.get("FULLNAME");
                if (withHash3 == null) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03112141753", "Missing Child Name"));
                }
                String string = (String)withHash3.get("NAME");
                Vector vector4 = (Vector)withHash3.get("PATH");
                SDMSSchedulingEntity sDMSSchedulingEntity2 = SDMSSchedulingEntityTable.get(systemEnvironment, vector4, string);
                Long l3 = sDMSSchedulingEntity2.getId(systemEnvironment);
                Boolean bl = (Boolean)withHash.get("STATIC");
                if (bl != null && bl.equals(Boolean.TRUE) && sDMSSchedulingEntity.getType(systemEnvironment) != 2 && sDMSSchedulingEntity.getType(systemEnvironment) != 1) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03406071443", "Only batches and jobs can have static children"));
                }
                Boolean bl2 = withHash.containsKey("ENABLE") ? Boolean.valueOf((Boolean)withHash.get("ENABLE") == false) : null;
                Integer n2 = (Integer)withHash.get("PRIORITY");
                Integer n3 = (Integer)withHash.get("SUSPEND");
                String string2 = null;
                Integer n4 = null;
                Integer n5 = null;
                Integer n6 = (Integer)withHash.get("MERGE_MODE");
                String string3 = (String)withHash.get("TRANSLATION");
                String string4 = (String)withHash.get("INTERVAL");
                Vector vector5 = (Vector)withHash.get("IGNORE");
                String string5 = (String)withHash.get("ALIAS");
                String string6 = this.canonizeCondition(systemEnvironment, (String)withHash.get("CONDITION"));
                Integer n7 = (Integer)withHash.get("MODE");
                if (n7 == null) {
                    n7 = 1;
                }
                Long l4 = null;
                sDMSSchedulingHierarchy = null;
                for (n = 0; n < vector2.size(); ++n) {
                    sDMSSchedulingHierarchy = (SDMSSchedulingHierarchy)vector2.get(n);
                    if (!l3.equals(sDMSSchedulingHierarchy.getSeChildId(systemEnvironment))) continue;
                    vector2.removeElementAt(n);
                    n = -1;
                    if (withHash.containsKey("ALIAS")) {
                        sDMSSchedulingHierarchy.setAliasName(systemEnvironment, string5);
                    }
                    if (withHash.containsKey("STATIC")) {
                        sDMSSchedulingHierarchy.setIsStatic(systemEnvironment, bl);
                    }
                    if (withHash.containsKey("ENABLE")) {
                        sDMSSchedulingHierarchy.setIsDisabled(systemEnvironment, bl2);
                    }
                    if (withHash.containsKey("PRIORITY")) {
                        sDMSSchedulingHierarchy.setPriority(systemEnvironment, n2);
                    }
                    if (withHash.containsKey("SUSPEND")) {
                        sDMSSchedulingHierarchy.setSuspend(systemEnvironment, n3);
                    }
                    if (withHash.containsKey("CONDITION")) {
                        sDMSSchedulingHierarchy.setEnableCondition(systemEnvironment, string6);
                    }
                    if (withHash.containsKey("MODE")) {
                        sDMSSchedulingHierarchy.setEnableMode(systemEnvironment, n7);
                    }
                    if ((n3 = sDMSSchedulingHierarchy.getSuspend(systemEnvironment)) == 3 && (vector3 = withHash.get("RESUME")) != null) {
                        if (vector3 instanceof String) {
                            string2 = (String)((Object)vector3);
                        } else {
                            withHash2 = (WithHash)((Object)vector3);
                            n4 = (Integer)withHash2.get("MULT");
                            n5 = (Integer)withHash2.get("INTERVAL");
                        }
                    }
                    if (withHash.containsKey("RESUME")) {
                        sDMSSchedulingHierarchy.setResumeAt(systemEnvironment, string2);
                        sDMSSchedulingHierarchy.setResumeIn(systemEnvironment, n4);
                        sDMSSchedulingHierarchy.setResumeBase(systemEnvironment, n5);
                    }
                    if (withHash.containsKey("MERGE_MODE")) {
                        sDMSSchedulingHierarchy.setMergeMode(systemEnvironment, n6);
                    }
                    if (withHash.containsKey("TRANSLATION")) {
                        if (string3 != null) {
                            systemEnvironment.checkFeatureAvailability("EXIT_STATE_TRANSLATION");
                            sDMSExitStateTranslationProfile = SDMSExitStateTranslationProfileTable.idx_name_getUnique(systemEnvironment, string3);
                            l4 = sDMSExitStateTranslationProfile.getId(systemEnvironment);
                        } else {
                            sDMSExitStateTranslationProfile = null;
                            l4 = null;
                        }
                        sDMSSchedulingHierarchy.setEstpId(systemEnvironment, l4);
                    } else {
                        l4 = sDMSSchedulingHierarchy.getEstpId(systemEnvironment);
                        sDMSExitStateTranslationProfile = l4 != null ? SDMSExitStateTranslationProfileTable.getObject(systemEnvironment, l4) : null;
                    }
                    this.checkTranslation(systemEnvironment, sDMSSchedulingEntity2, sDMSSchedulingEntity, sDMSExitStateTranslationProfile);
                    if (withHash.containsKey("INTERVAL")) {
                        if (string4 != null) {
                            try {
                                sDMSInterval = SDMSIntervalTable.idx_name_objId_getUnique(systemEnvironment, new SDMSKey((Comparable)((Object)string4), Integer.valueOf(0)));
                            }
                            catch (NotFoundException notFoundException) {
                                sDMSInterval = SDMSIntervalTable.idx_name_objId_getUnique(systemEnvironment, new SDMSKey((Comparable)((Object)string4), null));
                            }
                            l2 = sDMSInterval.getId(systemEnvironment);
                        } else {
                            l2 = null;
                        }
                        sDMSSchedulingHierarchy.setIntId(systemEnvironment, l2);
                        break;
                    }
                    l2 = sDMSSchedulingHierarchy.getIntId(systemEnvironment);
                    break;
                }
                if (n >= vector2.size()) {
                    if (bl == null) {
                        bl = sDMSSchedulingEntity.getType(systemEnvironment) != 2 ? Boolean.FALSE : Boolean.TRUE;
                    }
                    if (bl2 == null) {
                        bl2 = Boolean.FALSE;
                    }
                    if (n3 == null) {
                        n3 = SDMSConstants.SH_CHILDSUSPEND;
                    }
                    if (n3 == 3 && (vector3 = withHash.get("RESUME")) != null) {
                        if (vector3 instanceof String) {
                            string2 = (String)((Object)vector3);
                        } else {
                            withHash2 = (WithHash)((Object)vector3);
                            n4 = (Integer)withHash2.get("MULT");
                            n5 = (Integer)withHash2.get("INTERVAL");
                        }
                    }
                    if (n6 == null) {
                        n6 = SDMSConstants.SH_NOMERGE;
                    }
                    if (n2 != null) {
                        if (n2 > 100) {
                            n2 = SDMSConstants.ST_MIN_PRIORITY;
                        }
                        if (n2 < -100) {
                            n2 = SDMSConstants.ST_MIN_PRIORITY;
                        }
                    } else {
                        n2 = SDMSConstants.iZERO;
                    }
                    l4 = null;
                    if (string3 != null) {
                        sDMSExitStateTranslationProfile = SDMSExitStateTranslationProfileTable.idx_name_getUnique(systemEnvironment, string3);
                        l4 = sDMSExitStateTranslationProfile.getId(systemEnvironment);
                    } else {
                        sDMSExitStateTranslationProfile = null;
                    }
                    l2 = null;
                    if (string4 != null) {
                        try {
                            sDMSInterval = SDMSIntervalTable.idx_name_objId_getUnique(systemEnvironment, new SDMSKey((Comparable)((Object)string4), Integer.valueOf(0)));
                        }
                        catch (NotFoundException notFoundException) {
                            sDMSInterval = SDMSIntervalTable.idx_name_objId_getUnique(systemEnvironment, new SDMSKey((Comparable)((Object)string4), null));
                        }
                        l2 = sDMSInterval.getId(systemEnvironment);
                    } else {
                        sDMSInterval = null;
                    }
                    if (l.equals(l3)) {
                        throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03204292208", "A job or batch cannot have itself as child"));
                    }
                    sDMSSchedulingHierarchy = SDMSSchedulingHierarchyTable.table.create(systemEnvironment, l, l3, string5, bl, bl2, n2, n3, string2, n4, n5, n6, l4, l2, string6, n7);
                    this.checkTranslation(systemEnvironment, sDMSSchedulingEntity2, sDMSSchedulingEntity, sDMSExitStateTranslationProfile);
                }
                if (string5 != null && (vector3 = SDMSSchedulingHierarchyTable.idx_parentId_aliasName.getVector(systemEnvironment, new SDMSKey(l, (Comparable)((Object)string5)))).size() > 1) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03212051509", "Duplicate Aliasname $1", string5));
                }
                if (!withHash.containsKey("IGNORE")) continue;
                this.diffIgnoredDependencies(systemEnvironment, sDMSSchedulingHierarchy, vector5);
            }
        }
        for (n = 0; n < vector2.size(); ++n) {
            sDMSSchedulingHierarchy = (SDMSSchedulingHierarchy)vector2.get(n);
            sDMSSchedulingHierarchy.delete(systemEnvironment);
        }
    }

    private void diffIgnoredDependencies(SystemEnvironment systemEnvironment, SDMSSchedulingHierarchy sDMSSchedulingHierarchy, Vector vector) throws SDMSException {
        SDMSIgnoredDependency sDMSIgnoredDependency;
        int n;
        Long l = sDMSSchedulingHierarchy.getId(systemEnvironment);
        Vector vector2 = SDMSIgnoredDependencyTable.idx_shId.getVector(systemEnvironment, l);
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                String string = (String)vector.get(i);
                for (n = 0; n < vector2.size(); ++n) {
                    sDMSIgnoredDependency = (SDMSIgnoredDependency)vector2.get(n);
                    String string2 = sDMSIgnoredDependency.getDdName(systemEnvironment);
                    if (!string.equals(string2)) continue;
                    vector2.removeElementAt(n);
                    n = -1;
                    break;
                }
                if (n < vector2.size()) continue;
                SDMSIgnoredDependencyTable.table.create(systemEnvironment, l, string);
            }
        }
        for (n = 0; n < vector2.size(); ++n) {
            sDMSIgnoredDependency = (SDMSIgnoredDependency)vector2.get(n);
            sDMSIgnoredDependency.delete(systemEnvironment);
        }
    }

    private void diffParameters(SystemEnvironment systemEnvironment, Long l, WithHash withHash) throws SDMSException {
        SDMSParameterDefinition sDMSParameterDefinition;
        int n;
        Object object;
        Object object2;
        Object object3;
        SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, l);
        Vector vector = SDMSParameterDefinitionTable.idx_seId.getVector(systemEnvironment, l);
        if (withHash != null) {
            object3 = withHash.keySet();
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                Vector vector2 = (Vector)withHash.get(object);
                WithItem withItem = (WithItem)vector2.get(0);
                Object object4 = (String)vector2.get(1);
                Boolean bl = (Boolean)vector2.get(2);
                String string = (String)vector2.get(3);
                Long l2 = (Long)vector2.get(4);
                Integer n2 = withItem == null ? SDMSConstants.PD_PARAMETER : (Integer)withItem.key;
                Integer n3 = SDMSConstants.PD_NONE;
                Long l3 = null;
                switch (n2) {
                    case 40: 
                    case 50: 
                    case 70: 
                    case 71: {
                        if (object4 == null) break;
                        object4 = "=" + (String)object4;
                        break;
                    }
                    case 60: {
                        Vector vector3 = (Vector)withItem.value;
                        n3 = (Integer)vector3.get(0);
                        object4 = "=" + (String)vector3.get(1);
                        break;
                    }
                    case 30: {
                        object4 = "=" + (String)withItem.value;
                        break;
                    }
                    case 10: 
                    case 20: {
                        if (object4 != null) {
                            object4 = "=" + (String)object4;
                        }
                        PathVector pathVector = (PathVector)withItem.value;
                        String string2 = (String)pathVector.remove(pathVector.size() - 1);
                        Long l4 = SDMSSchedulingEntityTable.get(systemEnvironment, pathVector, null).getId(systemEnvironment);
                        SDMSParameterDefinition sDMSParameterDefinition2 = SDMSParameterDefinitionTable.idx_seId_Name_getUnique(systemEnvironment, new SDMSKey(l4, (Comparable)((Object)string2)));
                        if (!sDMSParameterDefinition2.getIsLocal(systemEnvironment).booleanValue()) {
                            l3 = sDMSParameterDefinition2.getId(systemEnvironment);
                            break;
                        }
                        throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03603061310", "Local parameters cannot be referenced"));
                    }
                    case 91: {
                        if (object4 != null) {
                            object4 = "=" + (String)object4;
                        }
                        PathVector pathVector = (PathVector)withItem.value;
                        String string2 = (String)pathVector.remove(pathVector.size() - 1);
                        Long l5 = SDMSNamedResourceTable.getNamedResource(systemEnvironment, pathVector).getId(systemEnvironment);
                        if (!this.checkResourceRequirement(systemEnvironment, l5, sDMSSchedulingEntity)) {
                            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03409290926", "Resource $2 for parameter $1 not required", object, pathVector));
                        }
                        l3 = SDMSParameterDefinitionTable.idx_seId_Name_getUnique(systemEnvironment, new SDMSKey(l5, (Comparable)((Object)string2))).getId(systemEnvironment);
                    }
                }
                for (n = 0; n < vector.size(); ++n) {
                    sDMSParameterDefinition = (SDMSParameterDefinition)vector.get(n);
                    String string3 = sDMSParameterDefinition.getName(systemEnvironment);
                    if (!string3.equals(object) && !sDMSParameterDefinition.getId(systemEnvironment).equals(l2)) continue;
                    if (!sDMSParameterDefinition.getId(systemEnvironment).equals(l2) && l2 != 0L) {
                        throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03303041550", "Parameter ID $1 does not point to the parameter with name $2", l2, object));
                    }
                    vector.removeElementAt(n);
                    n = -1;
                    if (!string3.equals(object)) {
                        sDMSParameterDefinition.setName(systemEnvironment, (String)object);
                    }
                    sDMSParameterDefinition.setType(systemEnvironment, n2);
                    sDMSParameterDefinition.setAggFunction(systemEnvironment, n3);
                    sDMSParameterDefinition.setDefaultValue(systemEnvironment, (String)object4);
                    sDMSParameterDefinition.setIsLocal(systemEnvironment, bl);
                    sDMSParameterDefinition.setLinkPdId(systemEnvironment, l3);
                    sDMSParameterDefinition.setExportName(systemEnvironment, string);
                    break;
                }
                if (n < vector.size()) continue;
                SDMSParameterDefinitionTable.table.create(systemEnvironment, l, (String)object, n2, n3, (String)object4, bl, l3, string);
            }
        }
        for (n = 0; n < vector.size(); ++n) {
            sDMSParameterDefinition = (SDMSParameterDefinition)vector.get(n);
            if (SDMSParameterDefinitionTable.idx_linkPdId.containsKey(systemEnvironment, sDMSParameterDefinition.getId(systemEnvironment))) {
                object = SDMSParameterDefinitionTable.idx_linkPdId.getVector(systemEnvironment, sDMSParameterDefinition.getId(systemEnvironment));
                object3 = (SDMSParameterDefinition)((Vector)object).get(0);
                object2 = SDMSSchedulingEntityTable.getObject(systemEnvironment, ((SDMSParameterDefinitionProxyGeneric)object3).getSeId(systemEnvironment));
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03208291546", "Parameter $1 is referenced by $2($3)", sDMSParameterDefinition.getName(systemEnvironment), ((SDMSSchedulingEntity)object2).pathString(systemEnvironment), ((SDMSParameterDefinitionProxyGeneric)object3).getName(systemEnvironment)));
            }
            sDMSParameterDefinition.delete(systemEnvironment);
        }
    }

    private void diffResources(SystemEnvironment systemEnvironment, Long l, Vector vector) throws SDMSException {
        int n;
        SDMSResourceRequirement sDMSResourceRequirement;
        Vector vector2 = SDMSResourceRequirementTable.idx_seId.getVector(systemEnvironment, l);
        if (vector != null) {
            for (WithHash withHash : vector) {
                Boolean bl;
                Integer n2;
                Integer n3;
                SDMSSchedulingEntity sDMSSchedulingEntity;
                String string;
                Long l2;
                PathVector pathVector;
                String string2;
                Boolean bl2;
                Long l3;
                Vector vector3 = (Vector)withHash.get("NAME");
                if (vector3 == null) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03204301100", "No resourcename specified"));
                }
                Long l4 = SDMSNamedResourceTable.pathToId(systemEnvironment, vector3);
                Integer n4 = (Integer)withHash.get("AMOUNT");
                Integer n5 = (Integer)withHash.get("LOCKMODE");
                String string3 = (String)withHash.get("MAP_STATUS");
                Integer n6 = (Integer)withHash.get("KEEP");
                WithHash withHash2 = (WithHash)withHash.get("STICKY");
                WithHash withHash3 = (WithHash)withHash.get("EXPIRED");
                Vector vector4 = (Vector)withHash.get("STATUS");
                String string4 = (String)withHash.get("CONDITION");
                if (string4 != null) {
                    string4 = this.canonizeCondition(systemEnvironment, string4);
                }
                sDMSResourceRequirement = null;
                for (n = 0; n < vector2.size(); ++n) {
                    sDMSResourceRequirement = (SDMSResourceRequirement)vector2.get(n);
                    Long l5 = sDMSResourceRequirement.getNrId(systemEnvironment);
                    if (!l5.equals(l4)) continue;
                    vector2.removeElementAt(n);
                    n = -1;
                    if (withHash.containsKey("AMOUNT")) {
                        sDMSResourceRequirement.setAmount(systemEnvironment, n4);
                    }
                    if (withHash.containsKey("LOCKMODE")) {
                        sDMSResourceRequirement.setLockmode(systemEnvironment, n5);
                    }
                    if (withHash.containsKey("MAP_STATUS")) {
                        l3 = string3 != null ? SDMSResourceStateMappingProfileTable.idx_name_getUnique(systemEnvironment, string3).getId(systemEnvironment) : null;
                        sDMSResourceRequirement.setRsmpId(systemEnvironment, l3);
                    }
                    if (withHash.containsKey("KEEP")) {
                        sDMSResourceRequirement.setKeepMode(systemEnvironment, n6);
                    }
                    if (withHash.containsKey("STICKY")) {
                        if (withHash2 != null) {
                            bl2 = Boolean.TRUE;
                            string2 = (String)withHash2.get("NAME");
                            pathVector = (PathVector)withHash2.get("JOB_DEFINITION");
                            if (pathVector == null) {
                                l2 = null;
                            } else {
                                string = (String)pathVector.remove(pathVector.size() - 1);
                                try {
                                    sDMSSchedulingEntity = SDMSSchedulingEntityTable.get(systemEnvironment, pathVector, string);
                                    if (!sDMSSchedulingEntity.checkPrivileges(systemEnvironment, 0x10000000L)) {
                                        throw new AccessViolationException(new SDMSMessage(systemEnvironment, "03309241513", "Insufficient privileges"));
                                    }
                                    l2 = sDMSSchedulingEntity.getId(systemEnvironment);
                                }
                                catch (NotFoundException notFoundException) {
                                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03309250927", "The specified sticky parent isn't a job definition"));
                                }
                            }
                        } else {
                            bl2 = Boolean.FALSE;
                            l2 = null;
                            string2 = null;
                        }
                        sDMSResourceRequirement.setIsSticky(systemEnvironment, bl2);
                        sDMSResourceRequirement.setStickyName(systemEnvironment, string2);
                        sDMSResourceRequirement.setStickyParent(systemEnvironment, l2);
                    }
                    if (withHash.containsKey("EXPIRED")) {
                        if (withHash3 != null) {
                            n3 = (Integer)withHash3.get("MULT");
                            if (n3 == null) {
                                n3 = SDMSConstants.iONE;
                            }
                            n2 = (Integer)withHash3.get("INTERVAL");
                            bl = (Boolean)withHash3.get("IGNORE");
                        } else {
                            n3 = null;
                            n2 = null;
                            bl = Boolean.FALSE;
                        }
                        sDMSResourceRequirement.setExpiredAmount(systemEnvironment, n3);
                        sDMSResourceRequirement.setExpiredBase(systemEnvironment, n2);
                        sDMSResourceRequirement.setIgnoreOnRerun(systemEnvironment, bl);
                    }
                    if (!withHash.containsKey("CONDITION")) break;
                    sDMSResourceRequirement.setCondition(systemEnvironment, string4);
                    break;
                }
                if (n >= vector2.size()) {
                    if (n4 == null) {
                        n4 = SDMSConstants.iZERO;
                    }
                    if (n5 == null) {
                        n5 = SDMSConstants.RR_N;
                    }
                    l3 = string3 == null ? null : SDMSResourceStateMappingProfileTable.idx_name_getUnique(systemEnvironment, string3).getId(systemEnvironment);
                    if (n6 == null) {
                        n6 = SDMSConstants.RR_NOKEEP;
                    }
                    if (withHash2 == null) {
                        bl2 = Boolean.FALSE;
                        string2 = null;
                        l2 = null;
                    } else {
                        bl2 = Boolean.TRUE;
                        string2 = (String)withHash2.get("NAME");
                        pathVector = (PathVector)withHash2.get("JOB_DEFINITION");
                        if (pathVector == null) {
                            l2 = null;
                        } else {
                            string = (String)pathVector.remove(pathVector.size() - 1);
                            try {
                                sDMSSchedulingEntity = SDMSSchedulingEntityTable.get(systemEnvironment, pathVector, string);
                                if (!sDMSSchedulingEntity.checkPrivileges(systemEnvironment, 0x10000000L)) {
                                    throw new AccessViolationException(new SDMSMessage(systemEnvironment, "03309241515", "Insufficient privileges"));
                                }
                                l2 = sDMSSchedulingEntity.getId(systemEnvironment);
                            }
                            catch (NotFoundException notFoundException) {
                                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03309250929", "The specified sticky parent isn't a job definition"));
                            }
                        }
                    }
                    if (withHash3 == null) {
                        n3 = null;
                        n2 = null;
                        bl = Boolean.FALSE;
                    } else {
                        n3 = (Integer)withHash3.get("MULT");
                        if (n3 == null) {
                            n3 = SDMSConstants.iONE;
                        }
                        n2 = (Integer)withHash3.get("INTERVAL");
                        bl = (Boolean)withHash3.get("IGNORE");
                    }
                    sDMSResourceRequirement = SDMSResourceRequirementTable.table.create(systemEnvironment, l4, l, n4, n6, bl2, string2, l2, l3, n3, n2, bl, n5, string4);
                }
                if (withHash.containsKey("STATUS")) {
                    this.diffRequiredStates(systemEnvironment, sDMSResourceRequirement, vector4);
                }
                sDMSResourceRequirement.check(systemEnvironment);
            }
        }
        for (n = 0; n < vector2.size(); ++n) {
            sDMSResourceRequirement = (SDMSResourceRequirement)vector2.get(n);
            sDMSResourceRequirement.delete(systemEnvironment);
        }
    }

    private void checkNonAfterFinalTrigger(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        Vector vector = SDMSTriggerTable.idx_fireId.getVector(systemEnvironment, l);
        for (int i = 0; i < vector.size(); ++i) {
            SDMSTrigger sDMSTrigger = (SDMSTrigger)vector.get(i);
            if (sDMSTrigger.getType(systemEnvironment) == 3 || sDMSTrigger.getAction(systemEnvironment) == 1 || sDMSTrigger.getIsMaster(systemEnvironment).booleanValue()) continue;
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03209201623", "Cannot change type to milestone, other than AFTER FINAL trigger exist"));
        }
    }

    private void diffRequiredStates(SystemEnvironment systemEnvironment, SDMSResourceRequirement sDMSResourceRequirement, Vector vector) throws SDMSException {
        SDMSResourceReqStates sDMSResourceReqStates;
        int n;
        Long l = sDMSResourceRequirement.getId(systemEnvironment);
        Vector vector2 = SDMSResourceReqStatesTable.idx_rrId.getVector(systemEnvironment, l);
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                SDMSResourceStateDefinition sDMSResourceStateDefinition;
                String string = (String)vector.get(i);
                for (n = 0; n < vector2.size(); ++n) {
                    sDMSResourceReqStates = (SDMSResourceReqStates)vector2.get(n);
                    sDMSResourceStateDefinition = SDMSResourceStateDefinitionTable.getObject(systemEnvironment, sDMSResourceReqStates.getRsdId(systemEnvironment));
                    if (!string.equals(sDMSResourceStateDefinition.getName(systemEnvironment))) continue;
                    vector2.removeElementAt(n);
                    n = -1;
                    break;
                }
                if (n < vector2.size()) continue;
                sDMSResourceStateDefinition = SDMSResourceStateDefinitionTable.idx_name_getUnique(systemEnvironment, string);
                Long l2 = sDMSResourceStateDefinition.getId(systemEnvironment);
                SDMSResourceReqStatesTable.table.create(systemEnvironment, l, l2);
            }
        }
        for (n = 0; n < vector2.size(); ++n) {
            sDMSResourceReqStates = (SDMSResourceReqStates)vector2.get(n);
            sDMSResourceReqStates.delete(systemEnvironment);
        }
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        Boolean bl;
        Comparable<Long> comparable2;
        Vector vector;
        boolean bl2 = false;
        this.evaluateWith(systemEnvironment);
        try {
            this.se = (SDMSSchedulingEntity)this.url.resolve(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            if (this.noerr) {
                this.result.setFeedback(new SDMSMessage(systemEnvironment, "03311130031", "No Job Definition altered"));
                return;
            }
            throw notFoundException;
        }
        Long l = this.se.getId(systemEnvironment);
        Integer n = this.se.getType(systemEnvironment);
        if (this.otype == null) {
            this.otype = n;
        }
        if (!this.withs.containsKey("RUN_PROGRAM")) {
            this.runProgram = this.se.getRunProgram(systemEnvironment);
        }
        if (!this.withs.containsKey("RERUN_PROGRAM")) {
            this.rerunProgram = this.se.getRerunProgram(systemEnvironment);
        }
        if (!this.withs.containsKey("KILL_PROGRAM")) {
            this.killProgram = this.se.getKillProgram(systemEnvironment);
        }
        if (!this.withs.containsKey("WORKDIR")) {
            this.workdir = this.se.getWorkdir(systemEnvironment);
        }
        if (!this.withs.containsKey("LOGFILE")) {
            this.logfile = this.se.getLogfile(systemEnvironment);
            this.truncLog = this.se.getTruncLog(systemEnvironment);
            if (this.logfile != null && this.truncLog == null) {
                this.truncLog = Boolean.FALSE;
            }
        }
        if (!this.withs.containsKey("ERRLOG")) {
            this.errlogfile = this.se.getErrlogfile(systemEnvironment);
            this.truncErrlog = this.se.getTruncErrlog(systemEnvironment);
            if (this.errlogfile != null && this.truncErrlog == null) {
                this.truncErrlog = Boolean.FALSE;
            }
        }
        if (!this.withs.containsKey("RUNTIME")) {
            this.expectedRuntime = this.se.getExpectedRuntime(systemEnvironment);
        }
        if (!this.withs.containsKey("FINAL")) {
            this.expectedFinaltime = this.se.getExpectedFinaltime(systemEnvironment);
        }
        if (!this.withs.containsKey("PRIORITY")) {
            this.priority = this.se.getPriority(systemEnvironment);
        }
        if (!this.withs.containsKey("MPRIORITY")) {
            this.minPriority = this.se.getMinPriority(systemEnvironment);
        } else if (this.withs.get("MPRIORITY") != null) {
            systemEnvironment.checkFeatureAvailability("JOB_LEVEL_AGING_CONTROL");
        }
        if (!this.withs.containsKey("AGING")) {
            this.agingAmount = this.se.getAgingAmount(systemEnvironment);
            this.agingBase = this.se.getAgingBase(systemEnvironment);
        } else if (this.withs.get("AGING") != null) {
            systemEnvironment.checkFeatureAvailability("JOB_LEVEL_AGING_CONTROL");
        }
        if (!this.withs.containsKey("SUSPEND")) {
            this.submitSuspended = this.se.getSubmitSuspended(systemEnvironment);
        }
        if (!(this.submitSuspended.booleanValue() || this.resumeAt == null && this.resumeIn == null)) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03108161050", "Resume option requires a suspend option"));
        }
        if (!this.withs.containsKey("MASTER")) {
            this.masterSubmittable = this.se.getMasterSubmittable(systemEnvironment);
        }
        this.gangSchedule = this.se.getGangSchedule(systemEnvironment);
        if (!this.withs.containsKey("DEPENDENCY_MODE")) {
            this.dependencyOperation = this.se.getDependencyOperation(systemEnvironment);
        }
        if (!this.withs.containsKey("MAPPING")) {
            this.esmpId = this.se.getEsmpId(systemEnvironment);
        }
        if (!this.withs.containsKey("PROFILE")) {
            this.espId = this.se.getEspId(systemEnvironment);
            this.esp = SDMSExitStateProfileTable.getObject(systemEnvironment, this.espId);
        } else {
            vector = SDMSTriggerTable.idx_seId.getVector(systemEnvironment, l);
            for (int i = 0; i < vector.size(); ++i) {
                SDMSTrigger sDMSTrigger = (SDMSTrigger)vector.get(i);
                comparable2 = sDMSTrigger.getLimitState(systemEnvironment);
                if (comparable2 == null || SDMSExitStateTable.idx_espId_esdId.containsKey(systemEnvironment, new SDMSKey(this.espId, comparable2))) continue;
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03310101634", "The new exit state profile doesn't contain the limit state of trigger " + sDMSTrigger.getName(systemEnvironment)));
            }
        }
        if (!this.withs.containsKey("ENVIRONMENT")) {
            this.neId = this.se.getNeId(systemEnvironment);
        }
        if (!this.withs.containsKey("FOOTPRINT")) {
            this.fpId = this.se.getFpId(systemEnvironment);
        }
        if (!this.withs.containsKey("TIMEOUT")) {
            this.to_mult = this.se.getTimeoutAmount(systemEnvironment);
            this.to_interval = this.se.getTimeoutBase(systemEnvironment);
            this.to_esdId = this.se.getTimeoutStateId(systemEnvironment);
            if (this.to_esdId != null && !SDMSExitStateTable.idx_espId_esdId.containsKey(systemEnvironment, new SDMSKey(this.espId, this.to_esdId))) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03311041003", "Timeoutstate $1 is not defined by the exit state profile $2", SDMSExitStateDefinitionTable.getObject(systemEnvironment, this.to_esdId).getName(systemEnvironment), this.esp.getName(systemEnvironment)));
            }
        }
        if (!this.withs.containsKey("GROUP")) {
            this.gId = this.se.getOwnerId(systemEnvironment);
        } else if (this.gId != this.se.getOwnerId(systemEnvironment)) {
            ChownChecker.check(systemEnvironment, this.gId, this.se.getOwnerId(systemEnvironment));
        }
        this.type = this.otype;
        switch (this.type) {
            case 1: {
                this.checkJob(systemEnvironment);
                break;
            }
            case 2: {
                this.checkBatch(systemEnvironment);
                break;
            }
            case 3: {
                systemEnvironment.checkFeatureAvailability("MILESTONES");
                this.checkMilestone(systemEnvironment);
                this.checkNonAfterFinalTrigger(systemEnvironment, l);
                break;
            }
            default: {
                throw new FatalException(new SDMSMessage(systemEnvironment, "03204291141", "Unknown Job Definition Type $1", this.otype));
            }
        }
        if (n == 1 && this.otype != 1) {
            this.checkDependents(systemEnvironment, l);
            vector = SDMSTriggerTable.idx_fireId.getVector(systemEnvironment, l);
            for (SDMSTrigger sDMSTrigger : vector) {
                if (sDMSTrigger.getAction(systemEnvironment) != 1) continue;
                sDMSTrigger.delete(systemEnvironment);
            }
        }
        if (this.withs.containsKey("INHERIT")) {
            this.inheritPrivs = (Long)this.withs.get("INHERIT");
            if (this.inheritPrivs == null) {
                this.inheritPrivs = SDMSConstants.lZERO;
            }
            long l2 = this.inheritPrivs;
            if ((this.se.getPrivilegeMask() & l2) != l2) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03202061133", "Incompatible grant"));
            }
        } else {
            this.inheritPrivs = null;
        }
        this.se.setType(systemEnvironment, this.otype);
        this.se.setRunProgram(systemEnvironment, this.runProgram);
        this.se.setRerunProgram(systemEnvironment, this.rerunProgram);
        this.se.setKillProgram(systemEnvironment, this.killProgram);
        this.se.setWorkdir(systemEnvironment, this.workdir);
        this.se.setLogfile(systemEnvironment, this.logfile);
        this.se.setTruncLog(systemEnvironment, this.truncLog);
        this.se.setErrlogfile(systemEnvironment, this.errlogfile);
        this.se.setTruncErrlog(systemEnvironment, this.truncErrlog);
        this.se.setExpectedRuntime(systemEnvironment, this.expectedRuntime);
        this.se.setExpectedFinaltime(systemEnvironment, this.expectedFinaltime);
        this.se.setGetExpectedRuntime(systemEnvironment, this.getExpectedRuntime);
        this.se.setPriority(systemEnvironment, this.priority);
        this.se.setMinPriority(systemEnvironment, this.minPriority);
        this.se.setAgingAmount(systemEnvironment, this.agingAmount);
        this.se.setAgingBase(systemEnvironment, this.agingBase);
        this.se.setSubmitSuspended(systemEnvironment, this.submitSuspended);
        if (this.withs.get("RESUME") != null || !this.submitSuspended.booleanValue() || this.isNoResume.booleanValue()) {
            this.se.setResumeAt(systemEnvironment, this.resumeAt);
            this.se.setResumeIn(systemEnvironment, this.resumeIn);
            this.se.setResumeBase(systemEnvironment, this.resumeBase);
        }
        this.se.setTimeoutAmount(systemEnvironment, this.to_mult);
        this.se.setTimeoutBase(systemEnvironment, this.to_interval);
        this.se.setTimeoutStateId(systemEnvironment, this.to_esdId);
        this.se.setSameNode(systemEnvironment, this.sameNode);
        this.se.setGangSchedule(systemEnvironment, this.gangSchedule);
        this.se.setDependencyOperation(systemEnvironment, this.dependencyOperation);
        this.se.setEsmpId(systemEnvironment, this.esmpId);
        this.se.setOwnerId(systemEnvironment, this.gId);
        if (this.inheritPrivs != null) {
            this.se.setInheritPrivs(systemEnvironment, this.inheritPrivs);
        }
        if ((bl = this.se.getMasterSubmittable(systemEnvironment)).booleanValue() && !this.masterSubmittable.booleanValue()) {
            int n2;
            if (SDMSEventTable.idx_seId.containsKey(systemEnvironment, l)) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02402181250", "Cannot change master submittable to false, because time scheduling events are defined on $1", this.se.pathString(systemEnvironment)));
            }
            Vector vector2 = SDMSTriggerTable.idx_seId.getVector(systemEnvironment, l);
            for (n2 = 0; n2 < vector2.size(); ++n2) {
                comparable2 = (SDMSTrigger)vector2.get(n2);
                if (!((SDMSTriggerProxyGeneric)comparable2).getIsMaster(systemEnvironment).booleanValue() || ((SDMSTriggerProxyGeneric)comparable2).getObjectType(systemEnvironment) == 3 && ((SDMSTriggerProxyGeneric)comparable2).getMainSeId(systemEnvironment) != null) continue;
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02402181251", "Cannot change master submittable to false, because master triggers are still defined using $1", this.se.pathString(systemEnvironment)));
            }
            vector2 = SDMSTriggerTable.idx_mainSeId.getVector(systemEnvironment, l);
            for (n2 = 0; n2 < vector2.size(); ++n2) {
                comparable2 = (SDMSTrigger)vector2.get(n2);
                if (!((SDMSTriggerProxyGeneric)comparable2).getIsMaster(systemEnvironment).booleanValue()) continue;
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03209191209", "Cannot change master submittable to false, because master triggers are still defined using $1", this.se.pathString(systemEnvironment)));
            }
        }
        this.se.setMasterSubmittable(systemEnvironment, this.masterSubmittable);
        if (!this.espId.equals(this.se.getEspId(systemEnvironment))) {
            this.se.setEspId(systemEnvironment, this.espId);
            bl2 = true;
        }
        this.se.setQaId(systemEnvironment, null);
        this.se.setNeId(systemEnvironment, this.neId);
        this.se.setFpId(systemEnvironment, this.fpId);
        if (this.withs.containsKey("REQUIRED")) {
            this.diffDependencies(systemEnvironment, l, this.dependencydeflist);
        }
        if (this.withs.containsKey("CHILDREN")) {
            this.diffChildren(systemEnvironment, this.se, this.childdeflist);
        }
        if (bl2) {
            SDMSExitStateTranslationProfile sDMSExitStateTranslationProfile;
            SDMSSchedulingEntity sDMSSchedulingEntity;
            Vector vector3 = SDMSSchedulingHierarchyTable.idx_seChildId.getVector(systemEnvironment, l);
            for (Comparable<Long> comparable2 : vector3) {
                sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, ((SDMSSchedulingHierarchyProxyGeneric)comparable2).getSeParentId(systemEnvironment));
                if (((SDMSSchedulingHierarchyProxyGeneric)comparable2).getEstpId(systemEnvironment) == null) continue;
                sDMSExitStateTranslationProfile = SDMSExitStateTranslationProfileTable.getObject(systemEnvironment, ((SDMSSchedulingHierarchyProxyGeneric)comparable2).getEstpId(systemEnvironment));
                this.checkTranslation(systemEnvironment, this.se, sDMSSchedulingEntity, sDMSExitStateTranslationProfile);
            }
            vector3 = SDMSSchedulingHierarchyTable.idx_seParentId.getVector(systemEnvironment, l);
            for (Comparable<Long> comparable2 : vector3) {
                sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, ((SDMSSchedulingHierarchyProxyGeneric)comparable2).getSeChildId(systemEnvironment));
                if (((SDMSSchedulingHierarchyProxyGeneric)comparable2).getEstpId(systemEnvironment) == null) continue;
                sDMSExitStateTranslationProfile = SDMSExitStateTranslationProfileTable.getObject(systemEnvironment, ((SDMSSchedulingHierarchyProxyGeneric)comparable2).getEstpId(systemEnvironment));
                this.checkTranslation(systemEnvironment, sDMSSchedulingEntity, this.se, sDMSExitStateTranslationProfile);
            }
        }
        if (this.withs.containsKey("RESOURCE") || n == 1 && this.otype != 1) {
            this.diffResources(systemEnvironment, l, this.resourcedeflist);
        }
        if (this.withs.containsKey("PARAMETERS")) {
            this.diffParameters(systemEnvironment, l, this.parameters);
        }
        this.checkParameterRI(systemEnvironment, l);
        if (this.priowarn) {
            this.result.setFeedback(new SDMSMessage(systemEnvironment, "03303251626", "Job Definition altered, WARNING: priority adjusted"));
        } else {
            this.result.setFeedback(new SDMSMessage(systemEnvironment, "03204041251", "Job Definition altered"));
        }
    }
}

