/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SDMSConstants;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.DuplicateKeyException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.AlterJobDefinition;
import de.independit.scheduler.server.parser.ManipJobDefinition;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.repository.SDMSFolderTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.util.PathVector;
import java.util.Collection;
import java.util.Vector;

public class CreateJobDefinition
extends ManipJobDefinition {
    private boolean replace;

    public CreateJobDefinition(Vector vector, String string, WithHash withHash, Boolean bl) {
        super(vector, string, withHash, Boolean.FALSE);
        this.replace = bl;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSSchedulingEntity sDMSSchedulingEntity;
        this.evaluateWith(systemEnvironment);
        this.type = this.otype == null ? 1 : this.otype;
        if (this.type == 1) {
            this.checkJob(systemEnvironment);
        } else if (this.type == 2) {
            this.checkBatch(systemEnvironment);
        } else {
            systemEnvironment.checkFeatureAvailability("MILESTONES");
            this.checkMilestone(systemEnvironment);
        }
        if (!(this.submitSuspended.booleanValue() || this.resumeAt == null && this.resumeIn == null)) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03108161106", "Resume option requires a suspend option"));
        }
        if (SDMSFolderTable.idx_parentId_name.containsKey(systemEnvironment, new SDMSKey(this.folderId, (Comparable)((Object)this.name)))) {
            throw new DuplicateKeyException(new SDMSMessage(systemEnvironment, "03201290918", "Object with name $1 already exists within $2", this.name, SDMSFolderTable.getObject(systemEnvironment, this.folderId).pathString(systemEnvironment)));
        }
        try {
            sDMSSchedulingEntity = SDMSSchedulingEntityTable.table.create(systemEnvironment, this.name, this.folderId, this.gId, this.type, this.runProgram, this.rerunProgram, this.killProgram, this.workdir, this.logfile, this.truncLog, this.errlogfile, this.truncErrlog, this.expectedRuntime, this.expectedFinaltime, this.getExpectedRuntime, this.priority, this.minPriority, this.agingAmount, this.agingBase, this.submitSuspended, this.resumeAt, this.resumeIn, this.resumeBase, this.masterSubmittable, this.to_mult, this.to_interval, this.to_esdId, this.sameNode, this.gangSchedule, this.dependencyOperation, this.esmpId, this.espId, null, this.neId, this.fpId, this.cancelLeadFlag, this.cancelApproval, this.rerunLeadFlag, this.rerunApproval, this.enableLeadFlag, this.enableApproval, this.setStateLeadFlag, this.setStateApproval, this.ignDepLeadFlag, this.ignDepApproval, this.ignRssLeadFlag, this.ignRssApproval, this.cloneLeadFlag, this.cloneApproval, this.editParmLeadFlag, this.editParmApproval, this.killLeadFlag, this.killApproval, this.setJobStateLeadFlag, this.setJobStateApproval, this.inheritPrivs);
        }
        catch (DuplicateKeyException duplicateKeyException) {
            if (this.replace) {
                PathVector pathVector = new PathVector((Collection)this.path);
                pathVector.addThis((Comparable)((Object)this.name));
                ObjectURL objectURL = new ObjectURL(SDMSConstants.PS_JOB_DEFINITION, pathVector);
                AlterJobDefinition alterJobDefinition = new AlterJobDefinition(objectURL, this.withs, Boolean.FALSE);
                alterJobDefinition.setEnv(this.env);
                alterJobDefinition.go(systemEnvironment);
                this.result = alterJobDefinition.result;
                return;
            }
            throw duplicateKeyException;
        }
        long l = this.inheritPrivs;
        if (!this.withs.containsKey("INHERIT")) {
            l = sDMSSchedulingEntity.getPrivilegeMask();
        }
        if ((sDMSSchedulingEntity.getPrivilegeMask() & l) != l) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03202061440", "Incompatible grant"));
        }
        sDMSSchedulingEntity.setInheritPrivs(systemEnvironment, l);
        if (this.dependencydeflist != null) {
            for (WithHash withHash : this.dependencydeflist) {
                super.addOrAlterRequirement(systemEnvironment, withHash, sDMSSchedulingEntity, true, false);
            }
        }
        if (this.childdeflist != null) {
            for (WithHash withHash : this.childdeflist) {
                super.addOrAlterChild(systemEnvironment, withHash, sDMSSchedulingEntity, true, false);
            }
        }
        if (this.resourcedeflist != null) {
            for (WithHash withHash : this.resourcedeflist) {
                super.addOrAlterResource(systemEnvironment, withHash, sDMSSchedulingEntity, true, false);
            }
        }
        if (this.parameters != null) {
            super.addOrAlterParameters(systemEnvironment, this.parameters, sDMSSchedulingEntity, true, false);
        }
        if (this.priowarn) {
            this.result.setFeedback(new SDMSMessage(systemEnvironment, "03303251625", "Job Definition created, WARNING: priority adjusted"));
        } else {
            this.result.setFeedback(new SDMSMessage(systemEnvironment, "02201170715", "Job Definition created"));
        }
    }
}

