/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SDMSConstants;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.DuplicateKeyException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.AlterSchedule;
import de.independit.scheduler.server.parser.IntervalUtil;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSIntervalTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSMemberTable;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSSchedule;
import de.independit.scheduler.server.repository.SDMSScheduleTable;
import de.independit.scheduler.server.repository.SDMSUser;
import de.independit.scheduler.server.repository.SDMSUserTable;
import java.util.TimeZone;
import java.util.Vector;

public class CreateSchedule
extends Node {
    public static final String __version = "@(#) $Id: CreateSchedule.java,v 2.12.2.1 2013/03/14 10:24:27 ronald Exp $";
    private final ObjectURL obj;
    private final WithHash with;
    private Boolean active;
    private final boolean replace;

    public CreateSchedule(ObjectURL objectURL, WithHash withHash, Boolean bl) {
        this.obj = objectURL;
        this.with = withHash == null ? new WithHash() : withHash;
        this.replace = bl;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        String string;
        long l;
        Object object;
        Long l2;
        Comparable<Long> comparable;
        Long l3;
        try {
            this.obj.resolve(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        Long l4 = this.obj.seId;
        Vector vector = new Vector(this.obj.path);
        String string2 = (String)vector.remove(vector.size() - 1);
        SDMSSchedule sDMSSchedule = SDMSScheduleTable.getSchedule(systemEnvironment, vector);
        Long l5 = sDMSSchedule.getId(systemEnvironment);
        if (SDMSScheduleTable.idx_parentId_name.containsKey(systemEnvironment, new SDMSKey(l5, (Comparable)((Object)string2)))) {
            if (this.replace) {
                AlterSchedule alterSchedule = new AlterSchedule(this.obj, this.with, Boolean.FALSE);
                alterSchedule.setEnv(this.env);
                alterSchedule.go(systemEnvironment);
                this.result = alterSchedule.result;
                return;
            }
            throw new DuplicateKeyException(new SDMSMessage(systemEnvironment, "04207251651", "Object with name $1 already exists within $2", string2, SDMSScheduleTable.getObject(systemEnvironment, l5).pathString(systemEnvironment)));
        }
        String string3 = (String)this.with.get("INTERVAL");
        if (string3 == null) {
            l3 = null;
        } else {
            comparable = SDMSIntervalTable.idx_name_objId_getUnique(systemEnvironment, new SDMSKey((Comparable)((Object)IntervalUtil.mapIdName(string3, l4)), null));
            l3 = ((SDMSProxy)comparable).getId(systemEnvironment);
        }
        comparable = this.env.uid();
        SDMSUser sDMSUser = SDMSUserTable.getObject(systemEnvironment, (Long)comparable);
        if (!this.with.containsKey("GROUP")) {
            l2 = sDMSUser.getDefaultGId(systemEnvironment);
        } else {
            object = (String)this.with.get("GROUP");
            l2 = SDMSGroupTable.idx_name_deleteVersion_getUnique(systemEnvironment, new SDMSKey((Comparable)object, SDMSConstants.lZERO)).getId(systemEnvironment);
            if (!SDMSMemberTable.idx_gId_uId.containsKey(systemEnvironment, new SDMSKey(l2, comparable)) && !SDMSMemberTable.idx_gId_uId.containsKey(systemEnvironment, new SDMSKey(SDMSObject.adminGId, comparable))) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03401151027", "User $1 does not belong to Group $2", sDMSUser.getName(systemEnvironment), object));
            }
        }
        if (this.with.containsKey("INHERIT")) {
            object = (Long)this.with.get("INHERIT");
            if (object == null) {
                object = SDMSConstants.lZERO;
            }
        } else {
            object = null;
        }
        long l6 = l = object == null ? sDMSSchedule.getPrivilegeMask() : ((Long)object).longValue();
        if ((sDMSSchedule.getPrivilegeMask() & l) != l) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03202061327", "Incompatible grant"));
        }
        object = l;
        this.active = !this.with.containsKey("ACTIVE") ? Boolean.TRUE : (Boolean)this.with.get("ACTIVE");
        String string4 = "";
        if (this.with.containsKey("TIME")) {
            TimeZone timeZone;
            string = (String)this.with.get("TIME");
            if (!string.equals((timeZone = TimeZone.getTimeZone(string)).getID())) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03207031504", "Time Zone " + string + " unknown"));
            }
        } else {
            TimeZone timeZone = TimeZone.getDefault();
            string = timeZone.getID();
        }
        SDMSScheduleTable.table.create(systemEnvironment, string2, l2, l3, l5, string, l4, this.active, (Long)object);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "04207251652", "Schedule created"));
    }
}

